/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.royale.utils.ITestAdapter;

public class MavenTestAdapter
implements ITestAdapter {
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final int BUFFER_MAX = 0x100000;

    @Override
    public String getTempDir() {
        File tempDir = new File("target/surefire-temp");
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new RuntimeException("Could not create temp dir at: " + tempDir.getAbsolutePath());
        }
        return tempDir.getPath();
    }

    @Override
    public List<File> getLibraries(boolean withRoyale) {
        ArrayList<File> libs = new ArrayList<File>();
        File pg = this.getPlayerglobal();
        if (pg != null) {
            libs.add(this.getPlayerglobal());
        }
        if (withRoyale) {
            String royaleVersion = System.getProperty("royaleVersion");
            libs.add(this.getDependency("org.apache.royale.framework", "framework", royaleVersion, "swc", null));
            libs.add(this.getDependency("org.apache.royale.framework", "rpc", royaleVersion, "swc", null));
            libs.add(this.getDependency("org.apache.royale.framework", "spark", royaleVersion, "swc", null));
        }
        return libs;
    }

    public boolean optionWithSwfEnabled() {
        return Boolean.valueOf(System.getProperty("optionWithSwfEnabled", "false"));
    }

    @Override
    public File getPlayerglobal() {
        if (!this.optionWithSwfEnabled()) {
            return null;
        }
        try {
            return this.getDependency("com.adobe.flash.framework", "playerglobal", System.getProperty("flashVersion"), "swc", null);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public File getFlashplayerDebugger() {
        if (!this.optionWithSwfEnabled()) {
            return null;
        }
        String FLASHPLAYER_DEBUGGER = System.getProperty("FLASHPLAYER_DEBUGGER", null);
        if (!(FLASHPLAYER_DEBUGGER != null && FLASHPLAYER_DEBUGGER.length() != 0 || (FLASHPLAYER_DEBUGGER = System.getenv("FLASHPLAYER_DEBUGGER")) != null && FLASHPLAYER_DEBUGGER.length() != 0)) {
            System.out.println("FLASHPLAYER_DEBUGGER not specified");
            return null;
        }
        System.out.println("Using Flash");
        return new File(FLASHPLAYER_DEBUGGER);
    }

    @Override
    public String getFlexManifestPath(String type) {
        File configsZip = this.getDependency("org.apache.flex.framework", "framework", System.getProperty("flexVersion"), "zip", "configs");
        File frameworkDir = configsZip.getParentFile();
        File unpackedConfigsDir = new File(frameworkDir, "configs_zip");
        if (!unpackedConfigsDir.exists()) {
            this.unpackFrameworkConfigs(configsZip, unpackedConfigsDir);
        }
        return new File(unpackedConfigsDir, type + "-manifest.xml").getPath();
    }

    @Override
    public File getFlexArtifact(String artifactName) {
        String flexVersion = System.getProperty("flexVersion");
        return this.getDependency("org.apache.flex.framework", artifactName, flexVersion, "swc", null);
    }

    @Override
    public File getFlexArtifactResourceBundle(String artifactName) {
        String flexVersion = System.getProperty("flexVersion");
        return this.getDependency("org.apache.flex.framework", artifactName, flexVersion, "rb.swc", "en_US");
    }

    @Override
    public String getRoyaleManifestPath(String type) {
        File configsZip = this.getDependency("org.apache.royale.framework", "framework", System.getProperty("royaleVersion"), "zip", "configs");
        File frameworkDir = configsZip.getParentFile();
        File unpackedConfigsDir = new File(frameworkDir, "configs_zip");
        if (!unpackedConfigsDir.exists()) {
            this.unpackFrameworkConfigs(configsZip, unpackedConfigsDir);
        }
        return new File(unpackedConfigsDir, type + "-manifest.xml").getPath();
    }

    @Override
    public File getRoyaleArtifact(String artifactName) {
        String royaleVersion = System.getProperty("royaleVersion");
        return this.getDependency("org.apache.royale.framework", artifactName, royaleVersion, "swc", null);
    }

    @Override
    public File getUnitTestBaseDir() {
        return new File(FilenameUtils.normalize((String)"target/test-classes"));
    }

    private File getDependency(String groupId, String artifactId, String version, String type, String classifier) {
        String dependencyPath = System.getProperty("mavenLocalRepoDir") + File.separator + groupId.replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + File.separator + artifactId + File.separator + version + File.separator + artifactId + "-" + version + (classifier != null ? "-" + classifier : "") + "." + type;
        File dependency = new File(dependencyPath);
        if (!dependency.exists()) {
            throw new RuntimeException("Could not read SWC dependency at " + dependency.getAbsolutePath());
        }
        return dependency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackFrameworkConfigs(File configZip, File outputDirectory) {
        byte[] data = new byte[0x100000];
        ArchiveInputStream archiveInputStream = null;
        try {
            ArchiveEntry entry;
            archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(configZip)));
            if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                throw new RuntimeException("Could not create output directory for config zip at " + outputDirectory.getPath());
            }
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDirectory, entry.getName());
                if (entry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new RuntimeException("Could not create output directory " + outputFile.getAbsolutePath());
                }
                FileOutputStream fos = new FileOutputStream(outputFile);
                BufferedOutputStream dest = null;
                try {
                    int count;
                    dest = new BufferedOutputStream(fos, 0x100000);
                    while ((count = archiveInputStream.read(data, 0, 0x100000)) != -1) {
                        dest.write(data, 0, count);
                    }
                }
                finally {
                    if (dest == null) continue;
                    dest.flush();
                    dest.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error unpacking resources", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error unpacking resources", e);
        }
        catch (ArchiveException e) {
            throw new RuntimeException("Error unpacking resources", e);
        }
        finally {
            if (archiveInputStream != null) {
                try {
                    archiveInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

