/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.royale.utils.FilenameNormalization;

public class EnvProperties {
    public String SDK;
    public String TLF;
    public String FPSDK;
    public String AIRSDK;
    public String FDBG;
    public String ASJS;
    public String GOOG;
    public String FPVER;
    private static EnvProperties env;

    public static EnvProperties initiate() {
        if (env == null) {
            env = new EnvProperties();
            env.setup();
        }
        return env;
    }

    private void setup() {
        String prefix = "";
        Properties p = new Properties();
        String envFileName = FilenameNormalization.normalize("../env.properties");
        System.out.println("looking for " + envFileName);
        try {
            File f = new File(envFileName);
            if (f.exists()) {
                p.load(new FileInputStream(f));
                prefix = "env.";
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(envFileName + " not found");
            try {
                File f = new File("unittest.properties");
                p.load(new FileInputStream(f));
            }
            catch (FileNotFoundException e1) {
                System.out.println("unittest.properties not found");
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.SDK = p.getProperty(prefix + "FLEX_HOME", System.getenv("FLEX_HOME"));
        System.out.println("environment property - FLEX_HOME = " + this.SDK);
        this.FPSDK = p.getProperty(prefix + "PLAYERGLOBAL_HOME", System.getenv("PLAYERGLOBAL_HOME"));
        System.out.println("environment property - PLAYERGLOBAL_HOME = " + this.FPSDK);
        this.FPVER = p.getProperty(prefix + "PLAYERGLOBAL_VERSION", System.getenv("PLAYERGLOBAL_VERSION"));
        if (this.FPVER == null) {
            this.FPVER = "11.1";
        }
        System.out.println("environment property - PLAYERGLOBAL_VERSION = " + this.FPVER);
        this.TLF = p.getProperty(prefix + "TLF_HOME", System.getenv("TLF_HOME"));
        System.out.println("environment property - TLF_HOME = " + this.TLF);
        this.AIRSDK = p.getProperty(prefix + "AIR_HOME", System.getenv("AIR_HOME"));
        System.out.println("environment property - AIR_HOME = " + this.AIRSDK);
        this.FDBG = p.getProperty(prefix + "FLASHPLAYER_DEBUGGER", System.getenv("FLASHPLAYER_DEBUGGER"));
        System.out.println("environment property - FLASHPLAYER_DEBUGGER = " + this.FDBG);
        this.ASJS = p.getProperty(prefix + "ASJS_HOME", System.getenv("ASJS_HOME"));
        if (this.ASJS == null) {
            this.ASJS = FilenameNormalization.normalize("../../royale-asjs");
        }
        System.out.println("environment property - ASJS_HOME = " + this.ASJS);
        this.GOOG = p.getProperty(prefix + "GOOG_HOME", System.getenv("GOOG_HOME"));
        System.out.println("environment property - GOOG_HOME = " + this.GOOG);
    }
}

