/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.royale.utils.EnvProperties;
import org.apache.royale.utils.FilenameNormalization;
import org.apache.royale.utils.ITestAdapter;
import org.junit.Assert;

public class AntTestAdapter
implements ITestAdapter {
    private static EnvProperties env = EnvProperties.initiate();
    private static File PLAYERGLOBAL_SWC;
    private static File FLASHPLAYER;
    private static File LIBS_ROOT;
    private static File RESOURCE_BUNDLES_ROOT;

    @Override
    public String getTempDir() {
        return FilenameNormalization.normalize("target/junit-temp");
    }

    @Override
    public List<File> getLibraries(boolean withFlex) {
        if (withFlex) {
            Assert.assertNotNull((String)"Environment variable FLEX_HOME is not set", (Object)AntTestAdapter.env.SDK);
            Assert.assertNotNull((String)"Environment variable PLAYERGLOBAL_HOME is not set", (Object)AntTestAdapter.env.FPSDK);
            LIBS_ROOT = new File(FilenameNormalization.normalize(AntTestAdapter.env.SDK + "\\frameworks\\libs"));
            RESOURCE_BUNDLES_ROOT = new File(FilenameNormalization.normalize(AntTestAdapter.env.SDK + "\\frameworks\\locale\\en_US"));
        }
        ArrayList<File> libraries = new ArrayList<File>();
        File pg = this.getPlayerglobal();
        if (pg != null) {
            libraries.add(this.getPlayerglobal());
        }
        if (withFlex) {
            libraries.add(this.getFlexArtifact("framework"));
            libraries.add(this.getFlexArtifact("rpc"));
            libraries.add(this.getFlexArtifact("spark"));
        }
        return libraries;
    }

    @Override
    public File getPlayerglobal() {
        if (PLAYERGLOBAL_SWC == null && AntTestAdapter.env.FPSDK != null) {
            PLAYERGLOBAL_SWC = new File(FilenameNormalization.normalize(AntTestAdapter.env.FPSDK + "\\" + AntTestAdapter.env.FPVER + "\\playerglobal.swc"));
        }
        return PLAYERGLOBAL_SWC;
    }

    @Override
    public File getFlashplayerDebugger() {
        if (FLASHPLAYER == null && AntTestAdapter.env.FDBG != null) {
            FLASHPLAYER = new File(FilenameNormalization.normalize(AntTestAdapter.env.FDBG));
        }
        return FLASHPLAYER;
    }

    @Override
    public String getFlexManifestPath(String type) {
        return FilenameNormalization.normalize(AntTestAdapter.env.SDK + "\\frameworks\\" + type + "-manifest.xml");
    }

    @Override
    public File getFlexArtifact(String artifactName) {
        return this.getLib(artifactName);
    }

    @Override
    public File getFlexArtifactResourceBundle(String artifactName) {
        return this.getResourceBundle(artifactName);
    }

    @Override
    public String getRoyaleManifestPath(String type) {
        return null;
    }

    @Override
    public File getRoyaleArtifact(String artifactName) {
        return null;
    }

    @Override
    public File getUnitTestBaseDir() {
        return new File("target/test-classes");
    }

    private File getLib(String artifactId) {
        if (LIBS_ROOT == null) {
            LIBS_ROOT = new File(FilenameNormalization.normalize(AntTestAdapter.env.SDK + "\\frameworks\\libs"));
        }
        return new File(LIBS_ROOT, artifactId + ".swc");
    }

    private File getResourceBundle(String artifactId) {
        if (RESOURCE_BUNDLES_ROOT == null) {
            RESOURCE_BUNDLES_ROOT = new File(FilenameNormalization.normalize(AntTestAdapter.env.SDK + "\\frameworks\\locale\\en_US"));
        }
        return new File(RESOURCE_BUNDLES_ROOT, artifactId + "_rb.swc");
    }
}

