/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.utils;

import java.util.ArrayList;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBlockNode;
import org.apache.royale.compiler.tree.as.IConditionalNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.ISwitchNode;
import org.apache.royale.compiler.tree.as.ITerminalNode;

public class ASNodeUtils {
    public static final IConditionalNode[] getCaseNodes(ISwitchNode node) {
        IBlockNode block = (IBlockNode)node.getChild(1);
        int childCount = block.getChildCount();
        ArrayList<IConditionalNode> retVal = new ArrayList<IConditionalNode>(childCount);
        for (int i = 0; i < childCount; ++i) {
            IASNode child = block.getChild(i);
            if (!(child instanceof IConditionalNode)) continue;
            retVal.add((IConditionalNode)child);
        }
        return retVal.toArray(new IConditionalNode[0]);
    }

    public static final ITerminalNode getDefaultNode(ISwitchNode node) {
        IBlockNode block = (IBlockNode)node.getChild(1);
        int childCount = block.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            IASNode child = block.getChild(i);
            if (!(child instanceof ITerminalNode)) continue;
            return (ITerminalNode)child;
        }
        return null;
    }

    public static boolean hasParenOpen(IOperatorNode node) {
        return node.hasParenthesis();
    }

    public static boolean hasParenClose(IOperatorNode node) {
        return node.hasParenthesis();
    }

    public static boolean isString(IExpressionNode node) {
        return node.getNodeID() == ASTNodeID.LiteralStringID;
    }
}

