/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.graph;

import com.google.common.io.Files;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.DependencyTypeSet;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.driver.js.JSCompilationUnit;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.projects.DependencyGraph;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.problems.FileNotFoundProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MainDefinitionQNameProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCFileEntry;

public class GoogDepsWriter {
    private ProblemQuery problems;
    private String moduleOutput;
    private String outputFolderPath;
    private String mainName;
    private List<String> otherPaths;
    private List<ISWC> swcs;
    private boolean removeCirculars = false;
    private boolean sourceMaps = false;
    private boolean verbose = false;
    private ArrayList<GoogDep> dps;
    private DependencyGraph graph;
    private CompilerProject project;
    private ArrayList<String> staticInitializers;
    private ArrayList<String> staticInitializerOwners;
    private HashMap<String, GoogDep> depMap = new HashMap();
    private HashMap<String, ICompilationUnit> requireMap = new HashMap();
    private HashMap<ICompilationUnit, String> requireMap2 = new HashMap();
    public boolean needCSS = false;
    private HashMap<String, GoogDep> visited = new HashMap();
    public ArrayList<String> additionalHTML = new ArrayList();

    public GoogDepsWriter(File outputFolder, String mainClassName, JSGoogConfiguration config, List<ISWC> swcs) {
        this.outputFolderPath = outputFolder.getAbsolutePath();
        this.moduleOutput = config.getModuleOutput();
        this.mainName = mainClassName;
        this.removeCirculars = config.getRemoveCirculars();
        this.sourceMaps = config.getSourceMap();
        this.otherPaths = config.getSDKJSLib();
        this.verbose = config.isVerbose();
        this.otherPaths.add(new File(outputFolder.getParent(), "royale/Royale/src").getPath());
        this.swcs = swcs;
        if (this.verbose) {
            for (ISWC swc : swcs) {
                System.out.println("using SWC: " + swc.getSWCFile().getAbsolutePath());
            }
        }
    }

    public ArrayList<String> getListOfFiles(CompilerProject project, List<String> sourceExternFiles, ProblemQuery problems) {
        this.project = project;
        this.problems = problems;
        if (this.dps == null) {
            if (!this.buildDB()) {
                return null;
            }
            this.dps = this.sort();
        }
        this.visited.clear();
        ArrayList<String> files = new ArrayList<String>();
        for (GoogDep gd : this.dps) {
            if (gd.fileInfo.isExtern) {
                sourceExternFiles.add(gd.filePath);
            } else {
                files.add(gd.filePath);
            }
            this.visited.put(gd.className, gd);
        }
        if (this.removeCirculars) {
            GoogDep mainDep = this.depMap.get(this.mainName);
            this.visited.put(this.mainName, mainDep);
            for (GoogDep gd : this.depMap.values()) {
                if (this.visited.containsKey(gd.className)) continue;
                if (gd.fileInfo.isExtern) {
                    sourceExternFiles.add(gd.filePath);
                    continue;
                }
                files.add(gd.filePath);
            }
            files.add(mainDep.filePath);
        }
        return files;
    }

    public String generateDeps(CompilerProject project, ProblemQuery problems) throws FileNotFoundException {
        this.project = project;
        this.problems = problems;
        if (this.dps == null) {
            if (!this.buildDB()) {
                return "";
            }
            this.dps = this.sort();
        }
        ArrayList<String> usedDeps = new ArrayList<String>();
        ArrayList<String> addedDeps = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int n = this.dps.size();
        for (int i = n - 1; i >= 0; --i) {
            GoogDep gd = this.dps.get(i);
            if (this.isGoogClass(gd.className)) continue;
            addedDeps.add(gd.filePath);
            if (this.removeCirculars) {
                ArrayList<String> deps = new ArrayList<String>();
                this.computeDeps(deps, gd, usedDeps);
                sb.append("goog.addDependency('").append(this.relativePath(gd.filePath)).append("', ['").append(gd.className).append("'], [");
                this.appendDependencies(deps, sb);
                sb.append("]);\n");
                continue;
            }
            sb.append("goog.addDependency('").append(this.relativePath(gd.filePath)).append("', ['").append(gd.className).append("'], [");
            this.appendDependencies(gd.deps, sb);
            sb.append("]);\n");
        }
        if (this.removeCirculars) {
            Collection deps;
            StringBuilder mainDeps = new StringBuilder();
            GoogDep mainDep = this.depMap.get(this.mainName);
            mainDeps.append("goog.addDependency('").append(this.relativePath(mainDep.filePath)).append("', ['").append(mainDep.className).append("'], [");
            ArrayList<String> restOfDeps = new ArrayList<String>();
            for (String dep : mainDep.deps) {
                if (!this.isGoogProvided(dep)) continue;
                restOfDeps.add(dep);
            }
            if (mainDep.fileInfo.impls != null) {
                for (String dep : mainDep.fileInfo.impls) {
                    if (!this.isGoogProvided(dep)) continue;
                    restOfDeps.add(dep);
                }
            }
            DependencyTypeSet dependencyTypes = DependencyTypeSet.allOf();
            for (GoogDep gd : this.depMap.values()) {
                if (usedDeps.contains(gd.className)) continue;
                if (gd.className.equals(this.mainName)) {
                    if (gd.fileInfo.impls == null) continue;
                    for (String d : gd.fileInfo.impls) {
                        if (restOfDeps.contains(d) || gd.fileInfo.isExtern || !this.isGoogProvided(d) || usedDeps.contains(d)) continue;
                        restOfDeps.add(d);
                    }
                    continue;
                }
                ICompilationUnit unit = this.requireMap.get(gd.className);
                if (unit == null) {
                    if (restOfDeps.contains(gd.className) || gd.fileInfo.isExtern || !this.isGoogProvided(gd.className) || usedDeps.contains(gd.className)) continue;
                    restOfDeps.add(gd.className);
                    continue;
                }
                deps = this.graph.getDirectReverseDependencies(unit, dependencyTypes);
                if (deps.size() != 0 || restOfDeps.contains(gd.className) || gd.fileInfo.isExtern || !this.isGoogProvided(gd.className) || usedDeps.contains(gd.className)) continue;
                restOfDeps.add(gd.className);
            }
            this.appendDependencies(restOfDeps, mainDeps);
            mainDeps.append("]);\n");
            sb.insert(0, mainDeps);
            sb.insert(0, "// generated by Royale\n");
            for (String dep : restOfDeps) {
                GoogDep gd = this.depMap.get(dep);
                if (gd == null) {
                    problems.add((ICompilerProblem)new FileNotFoundProblem(dep));
                    continue;
                }
                if (addedDeps.contains(gd.filePath)) continue;
                deps = new ArrayList();
                this.computeDeps((ArrayList<String>)deps, gd, usedDeps);
                sb.append("goog.addDependency('").append(this.relativePath(gd.filePath)).append("', ['").append(gd.className).append("'], [");
                this.appendDependencies((ArrayList<String>)deps, sb);
                sb.append("]);\n");
            }
            this.addRestOfDeps(mainDep, restOfDeps);
        }
        return sb.toString();
    }

    private void computeDeps(ArrayList<String> deps, GoogDep gd, ArrayList<String> usedDeps) {
        if (gd.fileInfo.impls != null) {
            for (String dep : gd.fileInfo.impls) {
                if (gd.fileInfo.provides != null && gd.fileInfo.provides.contains(dep)) continue;
                deps.add(dep);
                if (usedDeps.contains(dep)) continue;
                usedDeps.add(dep);
            }
        }
        if (gd.fileInfo.staticDeps != null) {
            for (String dep : gd.fileInfo.staticDeps) {
                if (!deps.contains(dep)) {
                    deps.add(dep);
                }
                if (usedDeps.contains(dep)) continue;
                usedDeps.add(dep);
            }
        }
    }

    private boolean isGoogClass(String className) {
        return className.startsWith("goog.");
    }

    private boolean buildDB() {
        this.staticInitializers = new ArrayList();
        this.staticInitializerOwners = new ArrayList();
        this.graph = new DependencyGraph();
        if (this.isGoogClass(this.mainName)) {
            this.problems.add((ICompilerProblem)new MainDefinitionQNameProblem("Google Closure Library", this.mainName));
            return false;
        }
        if (!this.isGoogProvided(this.mainName)) {
            this.problems.add((ICompilerProblem)new MainDefinitionQNameProblem("External Libraries", this.mainName));
            return false;
        }
        this.addDeps(this.mainName);
        return true;
    }

    private ArrayList<GoogDep> sort() {
        int n = this.staticInitializers.size();
        for (int i = 0; i < n; ++i) {
            String staticClass = this.staticInitializers.get(i);
            String staticOwner = this.staticInitializerOwners.get(i);
            GoogDep info = this.depMap.get(staticClass);
            GoogDep ownerInfo = this.depMap.get(staticOwner);
            if (info == null || info.fileInfo == null || info.fileInfo.deps == null || ownerInfo == null || ownerInfo.fileInfo == null) continue;
            if (ownerInfo.fileInfo.staticDeps == null) {
                ownerInfo.fileInfo.staticDeps = new ArrayList();
            }
            for (String dep : info.fileInfo.deps) {
                if (ownerInfo.fileInfo.staticDeps.contains(dep) || this.isGoogClass(dep) || dep.equals(staticOwner)) continue;
                ownerInfo.fileInfo.staticDeps.add(dep);
                if (!this.verbose) continue;
                System.out.println(staticClass + " used in static initializer of " + staticOwner + " so make " + dep + " a static dependency");
            }
        }
        ArrayList<GoogDep> arr = new ArrayList<GoogDep>();
        GoogDep current = this.depMap.get(this.mainName);
        this.sortFunction(current, arr);
        if (this.removeCirculars) {
            ICompilationUnit mainUnit = this.requireMap.get(this.mainName);
            ArrayList<ICompilationUnit> roots = new ArrayList<ICompilationUnit>();
            roots.add(mainUnit);
            this.requireMap.remove(this.mainName);
            if ((CompilerDiagnosticsConstants.diagnostics & 0x8000) == 32768) {
                Collection units = this.graph.getCompilationUnits();
                System.out.println("Contents of graph:");
                for (ICompilationUnit unit : units) {
                    try {
                        System.out.println(unit.getQualifiedNames().toString());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            List order = this.graph.topologicalSort(this.requireMap.values());
            if (this.graph.lastCircularDependencyException != null) {
                this.problems.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)this.graph.lastCircularDependencyException));
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x8000) == 32768) {
                System.out.println("Contents of graph in order:");
                for (ICompilationUnit unit : order) {
                    try {
                        System.out.println(unit.getQualifiedNames().toString());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            ArrayList<GoogDep> depsInOrder = new ArrayList<GoogDep>();
            for (ICompilationUnit unit : order) {
                String name = this.requireMap2.get(unit);
                if (this.isGoogClass(name)) continue;
                GoogDep dep = this.depMap.get(name);
                if (dep == null) {
                    if (!this.isGoogProvided(name)) continue;
                    System.out.println("No GoogDep for " + name);
                    this.problems.add((ICompilerProblem)new FileNotFoundProblem(name));
                    continue;
                }
                depsInOrder.add(dep);
            }
            return depsInOrder;
        }
        return arr;
    }

    private void sortFunction(GoogDep current, List<GoogDep> arr) {
        ArrayList<String> impls;
        this.visited.put(current.className, current);
        if (this.removeCirculars) {
            this.removeRequires(current);
        }
        if (this.verbose) {
            System.out.println("Dependencies calculated for '" + current.className + "'");
        }
        Object unit = null;
        if (this.removeCirculars) {
            unit = this.requireMap.get(current.className);
            if (unit == null) {
                unit = new JSCompilationUnit(this.project, current.filePath, DefinitionPriority.BasePriority.SOURCE_LIST, current.className);
                this.graph.addCompilationUnit(unit);
                this.requireMap.put(current.className, (ICompilationUnit)unit);
                this.requireMap2.put((ICompilationUnit)unit, current.className);
            }
            if (current.fileInfo.deps == null) {
                return;
            }
        }
        ArrayList<String> arrayList = impls = current.fileInfo.impls != null ? current.fileInfo.impls : null;
        if (impls != null) {
            for (String className : impls) {
                GoogDep gd;
                if (this.isGoogClass(className) || (gd = this.depMap.get(className)) == null) continue;
                if (this.removeCirculars) {
                    Object base = this.requireMap.get(className);
                    if (base == null) {
                        base = new JSCompilationUnit(this.project, className, DefinitionPriority.BasePriority.SOURCE_LIST, className);
                        this.graph.addCompilationUnit(base);
                        this.requireMap.put(className, (ICompilationUnit)base);
                        this.requireMap2.put((ICompilationUnit)base, className);
                    }
                    if (this.verbose) {
                        System.out.println(current.className + " depends on " + className);
                    }
                    this.graph.addDependency(unit, base, DependencyType.INHERITANCE);
                }
                if (this.visited.containsKey(className)) continue;
                this.sortFunction(gd, arr);
            }
        }
        if (this.removeCirculars && current.fileInfo.staticDeps != null && this.removeCirculars) {
            for (String staticDep : current.fileInfo.staticDeps) {
                Object base = this.requireMap.get(staticDep);
                if (base == null) {
                    base = new JSCompilationUnit(this.project, staticDep, DefinitionPriority.BasePriority.SOURCE_LIST, staticDep);
                    this.graph.addCompilationUnit(base);
                    this.requireMap.put(staticDep, (ICompilationUnit)base);
                    this.requireMap2.put((ICompilationUnit)base, staticDep);
                }
                if (this.verbose) {
                    System.out.println(current.className + " static initialization depends on " + staticDep);
                }
                this.graph.addDependency(unit, base, DependencyType.INHERITANCE);
            }
        }
        ArrayList<String> deps = current.deps;
        for (String className : deps) {
            if (this.isGoogClass(className) || !this.isGoogProvided(className)) continue;
            GoogDep gd = this.depMap.get(className);
            if (gd == null) {
                System.out.println("No GoogDep for " + className);
                throw new RuntimeException("Unable to find dependency information for class: " + className);
            }
            if (this.visited.containsKey(className)) continue;
            this.sortFunction(gd, arr);
        }
        arr.add(current);
    }

    private void addRestOfDeps(GoogDep main, List<String> restOfDeps) {
        try {
            int j;
            File mainFile = new File(main.filePath);
            List fileLines = Files.readLines((File)mainFile, (Charset)Charset.forName("utf8"));
            SourceMapConsumerV3 sourceMapConsumer = null;
            File sourceMapFile = null;
            if (this.sourceMaps && (sourceMapFile = new File(main.filePath + ".map")).exists()) {
                String sourceMapContents = FileUtils.readFileToString((File)sourceMapFile, (Charset)Charset.forName("utf8"));
                sourceMapConsumer = new SourceMapConsumerV3();
                try {
                    sourceMapConsumer.parse(sourceMapContents);
                }
                catch (SourceMapParseException e) {
                    sourceMapConsumer = null;
                }
            }
            for (j = main.fileInfo.googProvideLine + 1; j < fileLines.size() && !((String)fileLines.get(j)).contains(JSGoogEmitterTokens.GOOG_REQUIRE.getToken()); ++j) {
            }
            while (j < fileLines.size() && ((String)fileLines.get(j)).contains(JSGoogEmitterTokens.GOOG_REQUIRE.getToken())) {
                int c2;
                int c;
                String line = (String)fileLines.get(j);
                String s = line.substring((c = line.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken())) + 14, (c2 = line.indexOf(")")) - 1);
                if (!this.isGoogProvided(s)) {
                    fileLines.remove(j);
                    sourceMapConsumer = this.removeLineFromSourceMap(sourceMapConsumer, mainFile.getName(), j);
                    continue;
                }
                ++j;
            }
            int n = restOfDeps.size();
            for (int i = n - 1; i >= 0; --i) {
                String dep = restOfDeps.get(i);
                StringBuilder lineBuilder = new StringBuilder();
                lineBuilder.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken()).append("('").append(dep).append("');");
                fileLines.add(main.fileInfo.googProvideLine + 1, lineBuilder.toString());
                sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, mainFile.getName(), main.fileInfo.googProvideLine + 1);
            }
            FileUtils.writeLines((File)mainFile, (String)"utf8", (Collection)fileLines);
            if (sourceMapConsumer != null) {
                String newSourceMap = this.sourceMapConsumerToString(sourceMapConsumer, mainFile.getName());
                FileUtils.write((File)sourceMapFile, (CharSequence)newSourceMap, (String)"utf8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addDeps(String className) {
        if (this.depMap.containsKey(className) || this.isGoogClass(className) || !this.isGoogProvided(className)) {
            return;
        }
        GoogDep gd = new GoogDep();
        gd.className = className;
        gd.filePath = this.getFilePath(className);
        if (gd.filePath.isEmpty()) {
            throw new RuntimeException("Unable to find JavaScript filePath for class: " + className);
        }
        this.depMap.put(gd.className, gd);
        try {
            FileInfo fi;
            List fileLines = Files.readLines((File)new File(gd.filePath), (Charset)Charset.forName("utf8"));
            gd.fileInfo = fi = this.getFileInfo(fileLines, className);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (gd.fileInfo.impls != null) {
            for (String dep : gd.fileInfo.impls) {
                if (gd.fileInfo.provides != null && gd.fileInfo.provides.contains(dep)) continue;
                this.addDeps(dep);
            }
        }
        gd.deps = new ArrayList();
        if (gd.fileInfo.deps != null) {
            for (String dep : gd.fileInfo.deps) {
                gd.deps.add(dep);
                if (gd.fileInfo.provides != null && gd.fileInfo.provides.contains(dep)) continue;
                this.addDeps(dep);
            }
            if (gd.fileInfo.staticDeps != null) {
                for (String dep : gd.fileInfo.staticDeps) {
                    if (gd.deps.contains(dep)) continue;
                    gd.deps.add(dep);
                    if (gd.fileInfo.provides != null && gd.fileInfo.provides.contains(dep)) continue;
                    this.addDeps(dep);
                }
            }
        }
    }

    void removeRequires(GoogDep gd) {
        String className = gd.className;
        try {
            gd = this.depMap.get(className);
            File depFile = new File(gd.filePath);
            List fileLines = Files.readLines((File)depFile, (Charset)Charset.forName("utf8"));
            ArrayList<String> finalLines = new ArrayList<String>();
            SourceMapConsumerV3 sourceMapConsumer = null;
            File sourceMapFile = null;
            if (this.sourceMaps && (sourceMapFile = new File(gd.filePath + ".map")).exists()) {
                String sourceMapContents = FileUtils.readFileToString((File)sourceMapFile, (Charset)Charset.forName("utf8"));
                sourceMapConsumer = new SourceMapConsumerV3();
                try {
                    sourceMapConsumer.parse(sourceMapContents);
                }
                catch (SourceMapParseException e) {
                    sourceMapConsumer = null;
                }
            }
            boolean firstDependency = true;
            StringBuilder sb = new StringBuilder();
            sb.append(JSGoogEmitterTokens.ROYALE_DEPENDENCY_LIST.getToken());
            ArrayList<String> writtenRequires = new ArrayList<String>();
            int lastRequireLine = -1;
            FileInfo fi = gd.fileInfo;
            int i = 0;
            int stopLine = fi.constructorLine;
            if (fi.constructorLine == -1) {
                stopLine = fi.googProvideLine + 4;
            }
            for (String line : fileLines) {
                if (i < stopLine) {
                    int c = line.indexOf(JSGoogEmitterTokens.ROYALE_DEPENDENCY_LIST.getToken());
                    if (c > -1) {
                        return;
                    }
                    c = line.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                    if (c > -1) {
                        lastRequireLine = i;
                        int c2 = line.indexOf(")");
                        String s = line.substring(c + 14, c2 - 1);
                        if (!((gd.fileInfo.impls != null && gd.fileInfo.impls.contains(s) || gd.fileInfo.staticDeps != null && gd.fileInfo.staticDeps.contains(s)) && this.isGoogProvided(s))) {
                            if (this.verbose) {
                                System.out.println(gd.filePath + " removing require: " + s);
                            }
                            if (!firstDependency) {
                                sb.append(",");
                            }
                            sb.append(s);
                            firstDependency = false;
                            sourceMapConsumer = this.removeLineFromSourceMap(sourceMapConsumer, depFile.getName(), finalLines.size());
                            continue;
                        }
                        writtenRequires.add(s);
                    }
                }
                finalLines.add(line);
                ++i;
            }
            if (gd.fileInfo.staticDeps != null) {
                if (lastRequireLine == -1) {
                    lastRequireLine = gd.fileInfo.googProvideLine + 1;
                }
                for (String dep : gd.fileInfo.staticDeps) {
                    if (writtenRequires.contains(dep) || !this.isGoogProvided(dep)) continue;
                    StringBuilder lineBuilder = new StringBuilder();
                    lineBuilder.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken()).append("('").append(dep).append("');");
                    finalLines.add(lastRequireLine++, lineBuilder.toString());
                    sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, new File(gd.filePath).getName(), lastRequireLine);
                    if (!this.verbose) continue;
                    System.out.println("adding require for static dependency " + dep + " to " + className);
                }
            }
            if (fi.suppressLine > 0) {
                if (fi.suppressLine < fi.constructorLine || fi.constructorLine == -1) {
                    String line = (String)finalLines.get(fi.suppressLine);
                    int c = line.indexOf("@suppress {");
                    if (c > -1) {
                        if (!line.contains("missingRequire")) {
                            line = line.substring(0, c) + "@suppress {missingRequire|" + line.substring(c + 11);
                            finalLines.remove(fi.suppressLine);
                            finalLines.add(fi.suppressLine, line);
                        }
                    } else {
                        System.out.println("Confused by @suppress in " + className);
                    }
                } else if (fi.fileoverviewLine > -1) {
                    finalLines.add(fi.fileoverviewLine + 1, " *  @suppress {missingRequire}");
                    sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.fileoverviewLine + 1);
                } else if (fi.googProvideLine > -1) {
                    finalLines.add(fi.googProvideLine, " */");
                    finalLines.add(fi.googProvideLine, " *  @suppress {missingRequire}");
                    finalLines.add(fi.googProvideLine, " *  @fileoverview");
                    finalLines.add(fi.googProvideLine, "/**");
                    sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.googProvideLine);
                    sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.googProvideLine);
                    sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.googProvideLine);
                    sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.googProvideLine);
                } else {
                    System.out.println("Confused by @suppress in " + className);
                }
            } else if (fi.fileoverviewLine > -1) {
                finalLines.add(fi.fileoverviewLine + 1, " *  @suppress {missingRequire}");
                sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.fileoverviewLine + 1);
            } else if (fi.googProvideLine > -1) {
                finalLines.add(fi.googProvideLine, " */");
                finalLines.add(fi.googProvideLine, " *  @suppress {missingRequire}");
                finalLines.add(fi.googProvideLine, " *  @fileoverview");
                finalLines.add(fi.googProvideLine, "/**");
                sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.googProvideLine);
                sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.googProvideLine);
                sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.googProvideLine);
                sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), fi.googProvideLine);
            } else {
                System.out.println("Confused by @suppress in " + className);
            }
            sb.append("*/");
            finalLines.add(gd.fileInfo.googProvideLine + 1, sb.toString());
            sourceMapConsumer = this.addLineToSourceMap(sourceMapConsumer, depFile.getName(), gd.fileInfo.googProvideLine + 1);
            FileUtils.writeLines((File)depFile, (String)"utf8", finalLines);
            if (sourceMapConsumer != null) {
                String newSourceMap = this.sourceMapConsumerToString(sourceMapConsumer, depFile.getName());
                FileUtils.write((File)sourceMapFile, (CharSequence)newSourceMap, (String)"utf8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String sourceMapConsumerToString(SourceMapConsumerV3 consumer, String file) {
        SourceMapGeneratorV3 generator = this.sourceMapConsumerToGenerator(consumer);
        StringBuilder builder = new StringBuilder();
        try {
            generator.appendTo((Appendable)builder, file);
        }
        catch (IOException e) {
            return "";
        }
        return builder.toString();
    }

    private void appendExtraMappingToGenerator(SourceMapGeneratorV3 generator, String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
        FilePosition newEndPosition = new FilePosition(endPosition.getLine(), endPosition.getColumn() + 1);
        generator.addMapping(sourceName, null, sourceStartPosition, endPosition, newEndPosition);
    }

    private SourceMapGeneratorV3 sourceMapConsumerToGenerator(SourceMapConsumerV3 consumer) {
        final SourceMapGeneratorV3 generator = new SourceMapGeneratorV3();
        final SourceMapEntryCounter counter = new SourceMapEntryCounter();
        generator.setSourceRoot(consumer.getSourceRoot());
        consumer.visitMappings((SourceMapConsumerV3.EntryVisitor)counter);
        consumer.visitMappings(new SourceMapConsumerV3.EntryVisitor(){
            private int index = 0;

            public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
                generator.addMapping(sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                ++this.index;
                if (this.index == counter.count) {
                    GoogDepsWriter.this.appendExtraMappingToGenerator(generator, sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                }
            }
        });
        return generator;
    }

    SourceMapConsumerV3 sourceMapGeneratorToConsumer(SourceMapGeneratorV3 generator, String fileName) {
        StringBuilder builder = new StringBuilder();
        try {
            generator.appendTo((Appendable)builder, fileName);
        }
        catch (IOException e) {
            return null;
        }
        SourceMapConsumerV3 consumer = new SourceMapConsumerV3();
        try {
            consumer.parse(builder.toString());
        }
        catch (SourceMapParseException e) {
            return null;
        }
        return consumer;
    }

    SourceMapConsumerV3 addLineToSourceMap(SourceMapConsumerV3 consumer, String sourceFileName, final int lineToAdd) {
        if (consumer == null) {
            return null;
        }
        final SourceMapGeneratorV3 generator = new SourceMapGeneratorV3();
        final SourceMapEntryCounter counter = new SourceMapEntryCounter();
        generator.setSourceRoot(consumer.getSourceRoot());
        consumer.visitMappings((SourceMapConsumerV3.EntryVisitor)counter);
        consumer.visitMappings(new SourceMapConsumerV3.EntryVisitor(){
            private int index = 0;

            public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
                if (startPosition.getLine() >= lineToAdd) {
                    startPosition = new FilePosition(startPosition.getLine() + 1, startPosition.getColumn());
                    endPosition = new FilePosition(endPosition.getLine() + 1, endPosition.getColumn());
                }
                generator.addMapping(sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                ++this.index;
                if (this.index == counter.count) {
                    GoogDepsWriter.this.appendExtraMappingToGenerator(generator, sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                }
            }
        });
        return this.sourceMapGeneratorToConsumer(generator, sourceFileName);
    }

    SourceMapConsumerV3 removeLineFromSourceMap(SourceMapConsumerV3 consumer, String sourceFileName, final int lineToRemove) {
        if (consumer == null) {
            return null;
        }
        final SourceMapGeneratorV3 generator = new SourceMapGeneratorV3();
        final SourceMapEntryCounter counter = new SourceMapEntryCounter();
        generator.setSourceRoot(consumer.getSourceRoot());
        consumer.visitMappings((SourceMapConsumerV3.EntryVisitor)counter);
        consumer.visitMappings(new SourceMapConsumerV3.EntryVisitor(){
            private int index = 0;

            public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
                if (startPosition.getLine() == lineToRemove) {
                    return;
                }
                if (startPosition.getLine() > lineToRemove) {
                    startPosition = new FilePosition(startPosition.getLine() - 1, startPosition.getColumn());
                }
                if (endPosition.getLine() > lineToRemove) {
                    endPosition = new FilePosition(endPosition.getLine() - 1, endPosition.getColumn());
                }
                generator.addMapping(sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                ++this.index;
                if (this.index == counter.count) {
                    GoogDepsWriter.this.appendExtraMappingToGenerator(generator, sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                }
            }
        });
        return this.sourceMapGeneratorToConsumer(generator, sourceFileName);
    }

    FileInfo getFileInfo(List<String> lines, String className) {
        String line;
        int c;
        FileInfo fi = new FileInfo();
        int numProvides = 0;
        int constructorCount = 0;
        int n = lines.size();
        fi.constructorLine = -1;
        fi.suppressLine = -1;
        fi.fileoverviewLine = -1;
        fi.googProvideLine = -1;
        boolean inInjectHTML = false;
        for (int i = 0; i < n && ((c = (line = lines.get(i)).indexOf("*/")) <= -1 || constructorCount <= 0 || constructorCount != numProvides); ++i) {
            String impl;
            int c2;
            if (inInjectHTML) {
                if (line.indexOf("</inject_html>") > -1) {
                    inInjectHTML = false;
                    continue;
                }
                if ((line = line.trim()).startsWith("*")) {
                    line = line.substring(1);
                }
                this.additionalHTML.add(line);
                continue;
            }
            c = line.indexOf("<inject_html>");
            if (c > -1) {
                inInjectHTML = true;
            }
            if ((c = line.indexOf("@constructor")) > -1) {
                if (fi.constructorLine == -1) {
                    fi.constructorLine = i;
                }
                ++constructorCount;
                continue;
            }
            c = line.indexOf("@interface");
            if (c > -1) {
                fi.constructorLine = i;
                continue;
            }
            c = line.indexOf("@suppress");
            if (c > -1) {
                fi.suppressLine = i;
                continue;
            }
            c = line.indexOf("@fileoverview");
            if (c > -1) {
                fi.fileoverviewLine = i;
                continue;
            }
            c = line.indexOf("goog.provide");
            if (c > -1) {
                if (fi.googProvideLine == -1) {
                    fi.googProvideLine = i;
                }
                if (numProvides > 0) {
                    if (fi.provides == null) {
                        fi.provides = new ArrayList();
                    }
                    c2 = line.indexOf(")", c);
                    String provide = line.substring(c + 14, c2 - 1);
                    fi.provides.add(provide);
                }
                ++numProvides;
                continue;
            }
            c = line.indexOf("@implements");
            if (c > -1) {
                if (fi.impls == null) {
                    fi.impls = new ArrayList();
                }
                if (!fi.impls.contains(impl = line.substring(c + 13, c2 = line.indexOf("}", c))) && !impl.contentEquals(className)) {
                    fi.impls.add(impl);
                }
                if (!impl.equals("org.apache.royale.core.ICSSImpl")) continue;
                this.needCSS = true;
                continue;
            }
            c = line.indexOf("@extends");
            if (c > -1) {
                if (fi.impls == null) {
                    fi.impls = new ArrayList();
                }
                if (fi.impls.contains(impl = line.substring(c + 10, c2 = line.indexOf("}", c))) || impl.contentEquals(className)) continue;
                fi.impls.add(impl);
                continue;
            }
            String token = JSGoogEmitterTokens.ROYALE_STATIC_DEPENDENCY_LIST.getToken();
            c = line.indexOf(token);
            if (c > -1) {
                c2 = line.indexOf("*/");
                line = line.substring(c + token.length(), c2);
                List<String> staticDeps = Arrays.asList(line.split(","));
                fi.staticDeps = new ArrayList();
                fi.staticDeps.addAll(staticDeps);
                for (String staticDep : staticDeps) {
                    if (staticDep.equals(className)) continue;
                    this.staticInitializers.add(staticDep);
                    this.staticInitializerOwners.add(className);
                }
                continue;
            }
            c = line.indexOf("@externs");
            if (c > -1) {
                fi.isExtern = true;
                continue;
            }
            token = JSGoogEmitterTokens.ROYALE_DEPENDENCY_LIST.getToken();
            c = line.indexOf(token);
            if (c > -1) {
                c2 = line.indexOf("*/");
                line = line.substring(c + token.length(), c2);
                fi.deps = new ArrayList();
                if (line.length() <= 2) continue;
                fi.deps.addAll(Arrays.asList(line.split(",")));
                continue;
            }
            token = JSGoogEmitterTokens.GOOG_REQUIRE.getToken();
            c = line.indexOf(token);
            if (c <= -1) continue;
            c2 = line.indexOf(")");
            String s = line.substring(c + 14, c2 - 1);
            if (fi.deps == null) {
                fi.deps = new ArrayList();
            }
            fi.deps.add(s);
        }
        if (fi.deps != null) {
            Collections.sort(fi.deps);
        }
        if (fi.staticDeps != null) {
            Collections.sort(fi.staticDeps);
        }
        return fi;
    }

    String getFilePath(String className) {
        String classPath = className.replace(".", File.separator);
        String fn = this.outputFolderPath + File.separator + classPath + ".js";
        File f = new File(fn);
        if (f.exists()) {
            return fn;
        }
        for (String otherPath : this.otherPaths) {
            fn = otherPath + File.separator + classPath + ".js";
            f = new File(fn);
            if (!f.exists()) continue;
            fn = this.outputFolderPath + File.separator + classPath + ".js";
            File destFile = new File(fn);
            try {
                File assetsDir;
                FileUtils.copyFile((File)f, (File)destFile);
                if (className.contains("org.apache.royale") && (assetsDir = new File(f.getParentFile(), "assets")).exists()) {
                    String nameOfClass = className.substring(className.lastIndexOf(95) + 1);
                    File[] assetsList = assetsDir.listFiles();
                    assert (assetsList != null);
                    for (File assetFile : assetsList) {
                        String assetFileName = assetFile.getName();
                        if (!assetFile.isFile() || assetFileName.indexOf(nameOfClass) != 0) continue;
                        String pathOfClass = className.substring(0, className.lastIndexOf(95));
                        pathOfClass = pathOfClass.replace(".", File.separator);
                        destFile = new File(this.outputFolderPath + File.separator + pathOfClass + File.separator + "assets" + File.separator + assetFileName);
                        FileUtils.copyFile((File)assetFile, (File)destFile);
                        destFile = new File(this.outputFolderPath.replace("js-debug", "js-release") + File.separator + pathOfClass + File.separator + "assets" + File.separator + assetFileName);
                        FileUtils.copyFile((File)assetFile, (File)destFile);
                        if (!this.verbose) continue;
                        System.out.println("Copied assets of the '" + nameOfClass + "' class");
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Error copying file for class: " + className);
            }
            return fn;
        }
        for (ISWC swc : this.swcs) {
            ISWCFileEntry fileEntry = this.getFileEntry(swc, className);
            if (fileEntry == null) continue;
            fn = this.outputFolderPath + File.separator + classPath + ".js";
            File destFile = new File(fn);
            try {
                ISWCFileEntry sourceMapFileEntry;
                int bytes_read;
                InputStream inStream = fileEntry.createInputStream();
                FileOutputStream outStream = FileUtils.openOutputStream((File)destFile);
                byte[] b = new byte[0x100000];
                while ((bytes_read = inStream.read(b)) != -1) {
                    ((OutputStream)outStream).write(b, 0, bytes_read);
                }
                outStream.flush();
                ((OutputStream)outStream).close();
                inStream.close();
                if (this.sourceMaps && (sourceMapFileEntry = this.getFileEntry(swc, className, ".js.map")) != null) {
                    String sourceMapFn = this.outputFolderPath + File.separator + classPath + ".js.map";
                    File sourceMapDestFile = new File(sourceMapFn);
                    inStream = sourceMapFileEntry.createInputStream();
                    outStream = FileUtils.openOutputStream((File)sourceMapDestFile);
                    b = new byte[0x100000];
                    while ((bytes_read = inStream.read(b)) != -1) {
                        ((OutputStream)outStream).write(b, 0, bytes_read);
                    }
                    outStream.flush();
                    ((OutputStream)outStream).close();
                    inStream.close();
                }
                if (className.contains("org.apache.royale")) {
                    Map includedfiles = swc.getFiles();
                    Set includedList = includedfiles.keySet();
                    for (String included : includedList) {
                        if (!included.contains(".png") && !included.contains(".gif") && !included.contains(".jpg") && !included.contains(".jpeg") && !included.contains(".svg") && !included.contains(".json")) continue;
                        fileEntry = (ISWCFileEntry)includedfiles.get(included);
                        String assetName = this.outputFolderPath + File.separator + included;
                        File assetFile = new File(assetName);
                        inStream = fileEntry.createInputStream();
                        outStream = FileUtils.openOutputStream((File)assetFile);
                        b = new byte[inStream.available()];
                        inStream.read(b);
                        ((OutputStream)outStream).write(b);
                        inStream.close();
                        outStream.flush();
                        ((OutputStream)outStream).close();
                        if (!this.verbose) continue;
                        System.out.println("Copied asset " + assetName);
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Error copying file for class: " + className);
            }
            return fn;
        }
        System.out.println("Could not find file for class: " + className);
        this.problems.add((ICompilerProblem)new FileNotFoundProblem(className));
        return "";
    }

    private ISWCFileEntry getFileEntry(ISWC swc, String className) {
        return this.getFileEntry(swc, className, ".js");
    }

    private ISWCFileEntry getFileEntry(ISWC swc, String className, String extension) {
        String fwdClassPath = className.replace(".", "/");
        String bckClassPath = className.replace(".", "\\");
        ISWCFileEntry fileEntry = swc.getFile("js/src/" + fwdClassPath + extension);
        if (fileEntry == null) {
            fileEntry = swc.getFile("js/out/" + fwdClassPath + extension);
        }
        if (fileEntry == null) {
            fileEntry = swc.getFile("js/src/" + bckClassPath + extension);
        }
        if (fileEntry == null) {
            fileEntry = swc.getFile("js/out/" + bckClassPath + extension);
        }
        if (fileEntry == null) {
            fileEntry = swc.getFile("js\\src\\" + bckClassPath + extension);
        }
        if (fileEntry == null) {
            fileEntry = swc.getFile("js\\out\\" + bckClassPath + extension);
        }
        return fileEntry;
    }

    protected void otherScanning(String s) {
    }

    private void appendDependencies(ArrayList<String> deps, StringBuilder builder) {
        boolean hasDeps = false;
        for (String dep : deps) {
            if (hasDeps) {
                builder.append(", ");
            }
            builder.append("'");
            builder.append(dep);
            builder.append("'");
            hasDeps = true;
        }
    }

    String relativePath(String path) {
        String replacement = "../../..";
        if (path.indexOf(this.outputFolderPath) == 0) {
            if (this.moduleOutput != null && (replacement = replacement + this.moduleOutput).endsWith("/")) {
                replacement = replacement.substring(0, replacement.length() - 1);
            }
            path = path.replace(this.outputFolderPath, replacement);
        } else {
            for (String otherPath : this.otherPaths) {
                if (path.indexOf(otherPath) != 0) continue;
                path = path.replace(otherPath, "../../..");
            }
        }
        path = path.replace('\\', '/');
        return path;
    }

    boolean isGoogProvided(String className) {
        return ((RoyaleJSProject)this.project).isGoogProvided(className);
    }

    boolean isExternal(String className) {
        ICompilationUnit cu = this.project.resolveQNameToCompilationUnit(className);
        if (cu == null) {
            return false;
        }
        return ((RoyaleJSProject)this.project).isExternalLinkage(cu);
    }

    private class FileInfo {
        public ArrayList<String> impls;
        public ArrayList<String> deps;
        public ArrayList<String> staticDeps;
        public ArrayList<String> provides;
        public int constructorLine;
        public int suppressLine;
        public int fileoverviewLine;
        public int googProvideLine;
        public boolean isExtern;

        private FileInfo() {
        }
    }

    private class GoogDep {
        public String filePath;
        public String className;
        public ArrayList<String> deps;
        public FileInfo fileInfo;

        private GoogDep() {
        }
    }

    class SourceMapEntryCounter
    implements SourceMapConsumerV3.EntryVisitor {
        private int count = 0;

        SourceMapEntryCounter() {
        }

        public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
            ++this.count;
        }
    }
}

