/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.mxml.royale;

import com.google.common.io.Files;
import com.google.javascript.jscomp.SourceFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.codegen.js.goog.IJSGoogPublisher;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.css.ICSSPropertyValue;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogPublisher;
import org.apache.royale.compiler.internal.codegen.js.goog.JarSourceFile;
import org.apache.royale.compiler.internal.css.CSSArrayPropertyValue;
import org.apache.royale.compiler.internal.css.CSSFontFace;
import org.apache.royale.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.driver.js.royale.JSCSSCompilationSession;
import org.apache.royale.compiler.internal.graph.GoogDepsWriter;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.targets.ITargetAttributes;
import org.apache.royale.compiler.utils.JSClosureCompilerWrapper;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCFileEntry;
import org.apache.royale.swc.ISWCManager;

public class MXMLRoyalePublisher
extends JSGoogPublisher
implements IJSGoogPublisher {
    public static final String ROYALE_OUTPUT_DIR_NAME = "bin";
    public static final String ROYALE_INTERMEDIATE_DIR_NAME = "js-debug";
    public static final String ROYALE_RELEASE_DIR_NAME = "js-release";
    private static final String ROYALE_EXTERNS = "externs";
    private static final String ROYALE_THEME_ASSETS = "assets/";
    protected RoyaleJSProject project;
    private boolean isMarmotinniRun;
    private String outputPathParameter;
    private String moduleOutput;
    private boolean useStrictPublishing;
    private List<String> additionalHTML = new ArrayList<String>();
    private Set<String> closurePropertyNamesToKeep;

    public MXMLRoyalePublisher(RoyaleJSProject project, Configuration config) {
        super(project, config);
        this.isMarmotinniRun = this.googConfiguration.getMarmotinni() != null;
        this.outputPathParameter = this.configuration.getOutput();
        this.moduleOutput = this.googConfiguration.getModuleOutput();
        this.useStrictPublishing = this.googConfiguration.getStrictPublish();
        this.project = project;
    }

    private GoogDepsWriter getGoogDepsWriter(File intermediateDir, String mainClassQName, JSGoogConfiguration googConfiguration, List<ISWC> swcs) {
        return new GoogDepsWriter(intermediateDir, mainClassQName, googConfiguration, swcs);
    }

    @Override
    public File getOutputFolder() {
        if (this.isMarmotinniRun) {
            this.outputParentFolder = new File(this.googConfiguration.getMarmotinni());
        } else if (this.outputPathParameter != null) {
            if (this.outputPathParameter.contains(".swf")) {
                String rootFolder;
                if (this.outputParentFolder == null) {
                    this.outputParentFolder = new File(this.outputPathParameter);
                }
                this.outputParentFolder = this.moduleOutput != null && this.outputPathParameter.contains(this.moduleOutput) ? ((rootFolder = this.outputPathParameter.substring(0, this.outputPathParameter.indexOf(this.moduleOutput))).endsWith("src") ? new File(rootFolder).getParentFile() : (rootFolder.endsWith("src/main/royale") || rootFolder.endsWith("src\\main\\royale") ? new File(rootFolder).getParentFile().getParentFile().getParentFile() : new File(rootFolder).getParentFile())) : this.outputParentFolder.getParentFile().getParentFile();
            } else {
                this.outputParentFolder = new File(this.outputPathParameter);
            }
        } else {
            String mainClassFolder = this.configuration.getTargetFileDirectory();
            if (mainClassFolder.endsWith("src")) {
                this.outputParentFolder = new File(this.configuration.getTargetFileDirectory()).getParentFile();
            } else if (mainClassFolder.endsWith("src/main/royale") || mainClassFolder.endsWith("src\\main\\royale")) {
                this.outputParentFolder = new File(this.configuration.getTargetFileDirectory()).getParentFile().getParentFile().getParentFile();
            } else if (this.moduleOutput != null && mainClassFolder.endsWith(this.moduleOutput)) {
                String rootFolder = mainClassFolder.replace(mainClassFolder, "");
                if (rootFolder.endsWith("src")) {
                    this.outputParentFolder = new File(rootFolder).getParentFile();
                } else if (rootFolder.endsWith("src/main/royale") || rootFolder.endsWith("src\\main\\royale")) {
                    this.outputParentFolder = new File(rootFolder).getParentFile().getParentFile().getParentFile();
                }
            } else {
                this.outputParentFolder = new File(this.configuration.getTargetFileDirectory());
            }
        }
        this.outputParentFolder = new File(this.outputParentFolder, ROYALE_OUTPUT_DIR_NAME);
        this.outputFolder = new File(this.outputParentFolder, File.separator + ROYALE_INTERMEDIATE_DIR_NAME);
        if (this.moduleOutput != null) {
            this.outputFolder = new File(this.outputFolder, File.separator + this.moduleOutput);
        }
        if (!this.isMarmotinniRun && !this.googConfiguration.getSkipTranspile()) {
            this.setupOutputFolder();
        }
        return this.outputFolder;
    }

    @Override
    public void setClosurePropertyNamesToKeep(Set<String> propertyNames) {
        this.closurePropertyNamesToKeep = propertyNames;
    }

    @Override
    public boolean publish(ProblemQuery problems) throws IOException {
        ArrayList<String> sourceExternFiles;
        File closureLibraryJar;
        String factoryClassName;
        File intermediateDir = this.outputFolder;
        List sourcePaths = this.project.getSourcePath();
        String targetFile = this.configuration.getTargetFile().toLowerCase();
        if (this.googConfiguration.isVerbose()) {
            System.out.println("find project folder for " + targetFile);
        }
        File imageSrcDir = null;
        for (File sp : sourcePaths) {
            String lowercasePath;
            if (this.googConfiguration.isVerbose()) {
                System.out.println("checking source path " + sp.getAbsolutePath());
            }
            if (!targetFile.startsWith(lowercasePath = sp.getAbsolutePath().toLowerCase())) continue;
            imageSrcDir = sp;
        }
        if (imageSrcDir == null) {
            imageSrcDir = new File(this.configuration.getTargetFile()).getAbsoluteFile().getParentFile();
            if (this.googConfiguration.isVerbose()) {
                System.out.println("not found on source path, using parent file " + imageSrcDir.getAbsolutePath());
            }
        }
        String projectName = FilenameUtils.getBaseName((String)this.configuration.getTargetFile());
        String qName = null;
        try {
            qName = (String)this.project.mainCU.getQualifiedNames().get(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String mainClassQName = qName;
        ASProjectScope.DefinitionPromise cpromise = (ASProjectScope.DefinitionPromise)this.project.mainCU.getDefinitionPromises().get(0);
        IDefinition actualDef = cpromise.getActualDefinition();
        IClassDefinition baseDef = null;
        if (actualDef instanceof IClassDefinition) {
            IClassDefinition cdef = (IClassDefinition)cpromise.getActualDefinition();
            baseDef = (IClassDefinition)this.project.resolveQNameToDefinition(cdef.getBaseClassAsDisplayString());
        }
        if (baseDef != null && (factoryClassName = this.getFactoryClass(baseDef.getMetaTagByName("Frame"))) != null) {
            mainClassQName = this.generateFactoryClass(factoryClassName, projectName, mainClassQName, intermediateDir);
        }
        String outputFileName = projectName + "." + this.project.getBackend().getOutputExtension();
        File releaseDir = new File(this.outputParentFolder, ROYALE_RELEASE_DIR_NAME);
        if (this.moduleOutput != null) {
            releaseDir = new File(releaseDir, File.separator + this.moduleOutput);
        }
        IOFileFilter pngSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".png")});
        IOFileFilter gifSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".gif")});
        IOFileFilter jpgSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".jpg")});
        IOFileFilter jpegSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".jpeg")});
        IOFileFilter svgSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".svg")});
        IOFileFilter jsonSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".json")});
        IOFileFilter assetFiles = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{pngSuffixFilter, jpgSuffixFilter, jpegSuffixFilter, svgSuffixFilter, gifSuffixFilter, jsonSuffixFilter});
        IOFileFilter resourceFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{DirectoryFileFilter.DIRECTORY, assetFiles});
        FileUtils.copyDirectory((File)imageSrcDir, (File)intermediateDir, (FileFilter)resourceFilter);
        ISWCManager swcManager = this.project.getWorkspace().getSWCManager();
        ArrayList<ISWC> themeSWCs = new ArrayList<ISWC>();
        List themes = this.project.getThemeFiles();
        for (IFileSpecification themeFile : themes) {
            String string = FilenameUtils.getExtension((String)themeFile.getPath());
            if (!"swc".equalsIgnoreCase(string)) continue;
            ISWC swc = swcManager.get(new File(themeFile.getPath()));
            themeSWCs.add(swc);
            Map files = swc.getFiles();
            for (String key : files.keySet()) {
                ISWCFileEntry fileEntry;
                if (!key.startsWith(ROYALE_THEME_ASSETS) || (fileEntry = swc.getFile(key)) == null) continue;
                Iterator<String> is = fileEntry.createInputStream();
                int n = ((InputStream)((Object)is)).available();
                byte[] data = new byte[n];
                for (int total = 0; total < n; total += ((InputStream)((Object)is)).read(data, total, n - total)) {
                }
                FileUtils.writeByteArrayToFile((File)new File(intermediateDir, key), (byte[])data);
                if (!this.configuration.release()) continue;
                FileUtils.writeByteArrayToFile((File)new File(releaseDir, key), (byte[])data);
            }
        }
        if (this.configuration.release()) {
            FileUtils.copyDirectory((File)imageSrcDir, (File)releaseDir, (FileFilter)resourceFilter);
            this.clearEmptyDirectoryTrees(releaseDir);
        }
        List<SourceFile> closureSourceFiles = null;
        if (!this.googConfiguration.isClosureLibSet() && (closureLibraryJar = this.getJarThatContainsClasspathResources("goog/deps.js")) != null) {
            Properties properties = new Properties();
            properties.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("royale/closure-whitelist.properites"));
            closureSourceFiles = this.getClasspathResources(closureLibraryJar, properties);
        }
        if (closureSourceFiles == null) {
            File closureLibDir = new File(this.googConfiguration.getClosureLib());
            if (!closureLibDir.exists() || !closureLibDir.isDirectory()) {
                if (this.googConfiguration.isClosureLibSet()) {
                    throw new RuntimeException("Parameter 'closure-lib' doesn't point to a valid directory.");
                }
            } else {
                closureSourceFiles = this.getDirectoryResources(new File(closureLibDir, "closure"));
            }
        }
        if (closureSourceFiles == null || closureSourceFiles.size() == 0) {
            throw new RuntimeException("Parameter 'closure-lib' not specified and closure resources not available in classpath.");
        }
        for (SourceFile sourceFile : closureSourceFiles) {
            FileUtils.write((File)new File(new File(intermediateDir, "library/closure"), sourceFile.getName()), (CharSequence)sourceFile.getCode(), (Charset)Charset.forName("utf8"));
        }
        closureSourceFiles = this.closureFilesInOrder(intermediateDir + "/library/closure/", closureSourceFiles, "goog.events.EventTarget");
        JSClosureCompilerWrapper compilerWrapper = null;
        if (this.configuration.release()) {
            compilerWrapper = new JSClosureCompilerWrapper(this.googConfiguration.getJSCompilerOptions());
            compilerWrapper.setPropertyNamesToKeep(this.closurePropertyNamesToKeep);
        }
        if (compilerWrapper != null) {
            for (SourceFile closureSourceFile : closureSourceFiles) {
                compilerWrapper.addJSSourceFile(closureSourceFile);
            }
            this.writeExportedNames(compilerWrapper);
        }
        Set<ISWC> set = this.project.swcExterns;
        List swcs = this.project.getLibraries();
        ArrayList<ISWC> allswcs = new ArrayList<ISWC>();
        allswcs.addAll(swcs);
        allswcs.addAll(themeSWCs);
        for (ISWC swc : allswcs) {
            Map files = swc.getFiles();
            for (String key : files.keySet()) {
                ISWCFileEntry fileEntry;
                if (!key.startsWith(ROYALE_EXTERNS) || (fileEntry = swc.getFile(key)) == null) continue;
                InputStream is = fileEntry.createInputStream();
                String code = IOUtils.toString((InputStream)is, (String)"UTF-8");
                is.close();
                if (compilerWrapper != null) {
                    JarSourceFile externFile = new JarSourceFile(key, code, true);
                    if (this.googConfiguration.isVerbose()) {
                        System.out.println("using extern: " + key);
                    }
                    compilerWrapper.addJSExternsFile(externFile);
                }
                if (!set.contains(swc)) continue;
                List lines = IOUtils.readLines((Reader)new StringReader(code));
                this.collectAdditionalHTML(lines, swc.getSWCFile().getAbsolutePath() + ":" + key);
            }
        }
        GoogDepsWriter gdw = this.getGoogDepsWriter(intermediateDir, mainClassQName, this.googConfiguration, allswcs);
        ArrayList<String> fileList = gdw.getListOfFiles((CompilerProject)this.project, sourceExternFiles = new ArrayList<String>(), problems);
        if (fileList == null) {
            return false;
        }
        for (String sourceExtern : this.project.sourceExterns) {
            String sourceExternPath;
            String sourceExternFileName = sourceExtern.replace(".", "/") + ".js";
            File sourceExternFile = new File(intermediateDir, sourceExternFileName);
            if (!sourceExternFile.exists() || sourceExternFiles.contains(sourceExternPath = sourceExternFile.getAbsolutePath())) continue;
            sourceExternFiles.add(sourceExternPath);
        }
        if (compilerWrapper != null) {
            for (String file : fileList) {
                compilerWrapper.addJSSourceFile(file);
                if (!this.googConfiguration.isVerbose()) continue;
                System.out.println("using source file: " + file);
            }
        }
        for (String file : sourceExternFiles) {
            if (compilerWrapper != null) {
                compilerWrapper.addJSExternsFile(file);
                if (this.googConfiguration.isVerbose()) {
                    System.out.println("using extern file: " + file);
                }
            }
            this.collectFileAdditionalHTML(file);
        }
        this.additionalHTML.addAll(gdw.additionalHTML);
        String depsFileData = gdw.generateDeps((CompilerProject)this.project, problems);
        String moduleAdditionHTML = "";
        if (this.project.isModule(mainClassQName)) {
            for (String s : this.additionalHTML) {
                moduleAdditionHTML = moduleAdditionHTML + "document.head.innerHTML += '" + s.trim() + "';";
            }
            depsFileData = depsFileData + "\ngoog.require('" + mainClassQName + "');\n";
            this.writeFile(new File(intermediateDir, projectName + "__deps.js"), depsFileData + moduleAdditionHTML + "\n", false);
            gdw.needCSS = true;
            if (this.configuration.release()) {
                this.writeFile(new File(releaseDir, projectName + ".js"), moduleAdditionHTML, false);
            }
        } else {
            File template = ((JSGoogConfiguration)this.configuration).getHtmlTemplate();
            if (!((JSGoogConfiguration)this.configuration).getSkipTranspile()) {
                if (template != null) {
                    this.writeTemplate(template, "intermediate", projectName, mainClassQName, intermediateDir, depsFileData, this.additionalHTML);
                } else {
                    this.writeHTML("intermediate", projectName, mainClassQName, intermediateDir, depsFileData, this.additionalHTML);
                }
            }
            if (this.configuration.release()) {
                if (template != null) {
                    this.writeTemplate(template, "release", projectName, mainClassQName, releaseDir, depsFileData, this.additionalHTML);
                } else {
                    this.writeHTML("release", projectName, mainClassQName, releaseDir, null, this.additionalHTML);
                }
            }
        }
        this.project.needCSS = gdw.needCSS;
        if (this.project.needCSS || this.googConfiguration.getSkipTranspile()) {
            if (!this.googConfiguration.getSkipTranspile()) {
                this.writeCSS(projectName, intermediateDir, false);
            }
            if (this.project.needCSS && this.configuration.release()) {
                this.writeCSS(projectName, releaseDir, true);
            }
        }
        if (compilerWrapper != null) {
            boolean ok = true;
            File projectReleaseMainFile = new File(releaseDir, outputFileName);
            compilerWrapper.setOptions(projectReleaseMainFile.getCanonicalPath(), this.useStrictPublishing, !this.googConfiguration.getRemoveCirculars(), projectName);
            compilerWrapper.targetFilePath = projectReleaseMainFile.getCanonicalPath();
            compilerWrapper.setSourceMap(this.googConfiguration.getSourceMap());
            compilerWrapper.setVerbose(this.googConfiguration.isVerbose());
            ok = compilerWrapper.compile();
            if (this.project.isModule(mainClassQName)) {
                StringBuilder appendString = new StringBuilder();
                appendString.append(moduleAdditionHTML);
                this.writeFile(projectReleaseMainFile, appendString.toString(), true);
            }
            this.appendSourceMapLocation(projectReleaseMainFile, projectName);
            if (ok) {
                System.out.println("The project '" + projectName + "' has been successfully compiled and optimized.");
            }
        } else {
            System.out.println("The project '" + projectName + "' has been successfully compiled.");
        }
        return true;
    }

    protected List<SourceFile> closureFilesInOrder(String path, List<SourceFile> files, String entryPoint) {
        ArrayList<String> sortedFiles = new ArrayList<String>();
        HashMap<String, SourceFile> fileMap = new HashMap<String, SourceFile>();
        SourceFile depsFile = null;
        for (SourceFile sourceFile : files) {
            if ((sourceFile.getOriginalPath().endsWith("goog/deps.js") || sourceFile.getOriginalPath().endsWith("goog\\deps.js")) && !sourceFile.getOriginalPath().endsWith("third_party/goog/deps.js") && !sourceFile.getOriginalPath().endsWith("third_party\\goog\\deps.js")) {
                depsFile = sourceFile;
            }
            if (this.googConfiguration.isVerbose()) {
                System.out.println("originalPath: " + sourceFile.getOriginalPath());
            }
            fileMap.put(sourceFile.getOriginalPath(), sourceFile);
        }
        ArrayList<String> deps = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path + depsFile.getOriginalPath()), "UTF8"));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("//") || line.trim().length() == 0) continue;
                deps.add(line);
            }
            in.close();
        }
        catch (Exception in) {
            // empty catch block
        }
        this.sortClosureFile(deps, entryPoint, sortedFiles);
        ArrayList<SourceFile> list = new ArrayList<SourceFile>();
        ArrayList<String> seen = new ArrayList<String>();
        sortedFiles.add("deps.js");
        sortedFiles.add("base.js");
        sortedFiles.add("bootstrap/nodejs.js");
        int n = sortedFiles.size();
        for (int i = n - 1; i >= 0; --i) {
            String fileName = sortedFiles.get(i);
            if (this.googConfiguration.isVerbose()) {
                System.out.println("sorted filename: " + fileName);
            }
            if (seen.contains(fileName)) continue;
            seen.add(fileName);
            SourceFile sf = (SourceFile)fileMap.get("goog/" + fileName);
            if (sf == null) {
                System.out.println("got null for " + fileName);
            }
            list.add(sf);
        }
        return list;
    }

    private void collectFileAdditionalHTML(String filePath) {
        List fileLines;
        try {
            fileLines = Files.readLines((File)new File(filePath), (Charset)Charset.forName("utf8"));
        }
        catch (IOException e) {
            return;
        }
        this.collectAdditionalHTML(fileLines, filePath);
    }

    private void collectAdditionalHTML(List<String> lines, String key) {
        boolean inDocComment = false;
        boolean inConstructor = false;
        boolean inInjectHTML = false;
        for (int i = 0; i < lines.size(); ++i) {
            int c;
            String line = lines.get(i);
            if (inDocComment) {
                if (inInjectHTML) {
                    if (line.indexOf("</inject_html>") > -1) {
                        inInjectHTML = false;
                        continue;
                    }
                    if ((line = line.trim()).startsWith("*")) {
                        line = line.substring(1);
                    }
                    this.additionalHTML.add(line);
                    continue;
                }
                c = line.indexOf("<inject_html>");
                if (c != -1) {
                    inInjectHTML = true;
                    continue;
                }
                if (!inConstructor && (c = line.indexOf("@constructor")) != -1) {
                    inConstructor = true;
                    continue;
                }
                c = line.indexOf("*/");
                if (c == -1) continue;
                if (inConstructor) break;
                inInjectHTML = false;
                inDocComment = false;
                inConstructor = false;
                continue;
            }
            c = line.indexOf("/**");
            if (c == -1) continue;
            inDocComment = true;
        }
    }

    private void sortClosureFile(List<String> deps, String entryPoint, List<String> sortedFiles) {
        String provided = this.getProvidedFile(deps, entryPoint);
        sortedFiles.add(provided);
        List<String> reqs = this.getRequires(deps, entryPoint);
        if (reqs == null) {
            return;
        }
        for (String req : reqs) {
            this.sortClosureFile(deps, req, sortedFiles);
        }
    }

    private String getProvidedFile(List<String> deps, String name) {
        for (String dep : deps) {
            String[] parts;
            int open = dep.indexOf("[");
            int close = dep.indexOf("]", open + 1);
            String list = dep.substring(open + 1, close);
            for (String part : parts = list.split(",")) {
                if ((part = part.trim()).startsWith("'")) {
                    part = part.substring(1, part.length() - 1);
                }
                if (!part.equals(name)) continue;
                open = dep.indexOf("'");
                close = dep.indexOf("'", open + 1);
                return dep.substring(open + 1, close);
            }
        }
        return null;
    }

    private List<String> getRequires(List<String> deps, String name) {
        for (String dep : deps) {
            String[] parts;
            int open = dep.indexOf("[");
            int close = dep.indexOf("]", open + 1);
            String list = dep.substring(open + 1, close);
            for (String part : parts = list.split(",")) {
                if ((part = part.trim()).startsWith("'")) {
                    part = part.substring(1, part.length() - 1);
                }
                if (!part.equals(name)) continue;
                open = dep.indexOf("[", close + 1);
                if (open + 1 == (close = dep.indexOf("]", open + 1))) {
                    return null;
                }
                String list2 = dep.substring(open + 1, close);
                String[] parts2 = list2.split(",");
                ArrayList<String> reqs = new ArrayList<String>();
                for (String part2 : parts2) {
                    if ((part2 = part2.trim()).startsWith("'")) {
                        part2 = part2.substring(1, part2.length() - 1);
                    }
                    reqs.add(part2);
                }
                return reqs;
            }
        }
        return null;
    }

    protected String readCode(File file) {
        String code = "";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            String line = in.readLine();
            while (line != null) {
                code = code + line + "\n";
                line = in.readLine();
            }
            code = code.substring(0, code.length() - 1);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    protected void writeTemplate(File template, String type, String projectName, String mainClassQName, File targetDir, String deps, List<String> additionalHTML) throws IOException {
        if (!template.exists()) {
            throw new IOException("Template specified by 'html-template' does not exist: " + template.getPath());
        }
        String input = this.readCode(template);
        ITargetAttributes ta = this.project.computeTargetAttributes();
        Float width = null;
        Float height = null;
        String bgcolor = null;
        String pageTitle = null;
        if (ta != null) {
            width = ta.getWidth();
            height = ta.getHeight();
            bgcolor = ta.getBackgroundColor();
            pageTitle = ta.getPageTitle();
        }
        String result = null;
        result = type.equals("release") ? input.replaceAll("\\$\\{application\\}", projectName + ".min") : input.replaceAll("\\$\\{application\\}", projectName);
        if (bgcolor != null) {
            result = result.replaceAll("\\$\\{bgcolor\\}", bgcolor);
        }
        if (height != null) {
            result = result.replaceAll("\\$\\{height\\}", height.toString());
        }
        if (pageTitle != null) {
            result = result.replaceAll("\\$\\{title\\}", pageTitle);
        }
        if (width != null) {
            result = result.replaceAll("\\$\\{width\\}", width.toString());
        }
        StringBuilder addHTML = new StringBuilder();
        addHTML.append(this.getTemplateAdditionalHTML(additionalHTML));
        addHTML.append(this.getTemplateDependencies(type, projectName, mainClassQName, deps));
        result = result.replaceAll("\\$\\{head\\}", addHTML.toString());
        String templateBody = this.getTemplateBody("release".equals(type) ? projectName : mainClassQName);
        result = result.replaceAll("\\$\\{body\\}", templateBody);
        this.writeFile(new File(targetDir, this.googConfiguration.getHtmlOutputFileName()), result, false);
    }

    protected String getTemplateAdditionalHTML(List<String> additionalHTML) {
        StringBuilder htmlFile = new StringBuilder();
        for (String s : additionalHTML) {
            htmlFile.append(s).append("\n");
        }
        return htmlFile.toString();
    }

    protected String getTemplateDependencies(String type, String projectName, String mainClassQName, String deps) {
        StringBuilder depsHTML = new StringBuilder();
        if ("intermediate".equals(type)) {
            depsHTML.append("\t<script type=\"text/javascript\" src=\"./library/closure/goog/base.js\"></script>\n");
            depsHTML.append("\t<script type=\"text/javascript\">\n");
            depsHTML.append(deps);
            depsHTML.append("\t\tgoog.require(\"");
            depsHTML.append(mainClassQName);
            depsHTML.append("\");\n");
            depsHTML.append("\t</script>\n");
        } else {
            depsHTML.append("\t<script type=\"text/javascript\" src=\"./");
            depsHTML.append(projectName);
            depsHTML.append(".js\"></script>\n");
        }
        return depsHTML.toString();
    }

    protected String getTemplateBody(String mainClassQName) {
        StringBuilder bodyHTML = new StringBuilder();
        bodyHTML.append("\t<script type=\"text/javascript\">\n");
        bodyHTML.append("\t\tnew ");
        bodyHTML.append(mainClassQName);
        bodyHTML.append("()");
        bodyHTML.append(".start();\n");
        bodyHTML.append("\t</script>\n");
        return bodyHTML.toString();
    }

    protected void writeHTML(String type, String projectName, String mainClassQName, File targetDir, String deps, List<String> additionalHTML) throws IOException {
        StringBuilder htmlFile = new StringBuilder();
        htmlFile.append("<!DOCTYPE html>\n");
        htmlFile.append("<html>\n");
        htmlFile.append("<head>\n");
        htmlFile.append("\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n");
        htmlFile.append("\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
        if (type.equals("release")) {
            htmlFile.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(projectName).append(".min.css\">\n");
        } else {
            htmlFile.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(projectName).append(".css\">\n");
        }
        htmlFile.append(this.getTemplateAdditionalHTML(additionalHTML));
        htmlFile.append(this.getTemplateDependencies(type, projectName, mainClassQName, deps));
        htmlFile.append("</head>\n");
        htmlFile.append("<body>\n");
        htmlFile.append(this.getTemplateBody(mainClassQName));
        htmlFile.append("</body>\n");
        htmlFile.append("</html>");
        this.writeFile(new File(targetDir, this.googConfiguration.getHtmlOutputFileName()), htmlFile.toString(), false);
    }

    private void writeCSS(String projectName, File targetDir, Boolean minify) throws IOException {
        JSCSSCompilationSession cssSession = (JSCSSCompilationSession)this.project.getCSSCompilationSession();
        String cssString = cssSession.emitCSS();
        if (minify.booleanValue()) {
            this.writeFile(new File(targetDir, projectName + ".min.css"), JSCSSCompilationSession.minifyCSSString(cssString), false);
        } else {
            this.writeFile(new File(targetDir, projectName + ".css"), cssString, false);
        }
        for (CSSFontFace fontFace : cssSession.fontFaces) {
            String configdir = this.configuration.getLoadConfig();
            File dir = new File(configdir);
            dir = dir.getParentFile();
            for (ICSSPropertyValue prop : fontFace.getSources()) {
                if (prop instanceof CSSArrayPropertyValue) {
                    for (ICSSPropertyValue value : ((CSSArrayPropertyValue)prop).getElements()) {
                        this.copyFontFile((CSSFunctionCallPropertyValue)value, dir, targetDir);
                    }
                    continue;
                }
                if (!(prop instanceof CSSFunctionCallPropertyValue)) continue;
                this.copyFontFile((CSSFunctionCallPropertyValue)prop, dir, targetDir);
            }
        }
    }

    protected void copyFontFile(CSSFunctionCallPropertyValue fn, File sourceDir, File targetDir) throws IOException {
        int c;
        String fontPath = fn.rawArguments;
        if (fontPath.startsWith("'")) {
            fontPath = fontPath.substring(1, fontPath.length() - 1);
        }
        if (fontPath.startsWith("\"")) {
            fontPath = fontPath.substring(1, fontPath.length() - 1);
        }
        if ((c = fontPath.indexOf("?")) != -1) {
            fontPath = fontPath.substring(0, c);
        }
        File fontFile = new File(sourceDir, fontPath);
        File destFile = new File(targetDir, fontPath);
        if (fontFile.exists() && !destFile.exists()) {
            FileUtils.copyFile((File)fontFile, (File)destFile);
        }
    }

    protected File getJarThatContainsClasspathResources(String resourcePath) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        if (resource != null) {
            String resourceJarPath = resource.getFile();
            try {
                resourceJarPath = URLDecoder.decode(resourceJarPath, "UTF-8");
                if (resourceJarPath.contains(":")) {
                    resourceJarPath = resourceJarPath.substring(resourceJarPath.indexOf(":") + 1);
                }
                if (resourceJarPath.contains("!")) {
                    resourceJarPath = resourceJarPath.substring(0, resourceJarPath.indexOf("!"));
                }
                return new File(resourceJarPath);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void setupOutputFolder() {
        File releaseDir;
        super.setupOutputFolder();
        if (this.configuration.release() && !(releaseDir = new File(this.outputParentFolder, ROYALE_RELEASE_DIR_NAME)).exists() && !releaseDir.mkdirs()) {
            throw new RuntimeException("Unable to create release directory at " + releaseDir.getAbsolutePath());
        }
    }

    protected void clearEmptyDirectoryTrees(File baseDirectory) {
        File[] files = baseDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this.clearEmptyDirectoryTrees(file);
                if (!this.isEmptyDirectory(file)) continue;
                file.delete();
            }
        }
    }

    protected boolean isEmptyDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                return false;
            }
        }
        return true;
    }

    private void writeExportedNames(JSClosureCompilerWrapper compilerWrapper) {
        Set<String> exportedNames;
        if (!this.googConfiguration.getExportPublicSymbols() && (exportedNames = this.project.getExportedNames()).size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("/**\n");
            sb.append(" * generated by Apache Royale compiler\n");
            sb.append(" * @externs\n");
            sb.append(" */\n");
            for (String name : exportedNames) {
                sb.append("\n\n");
                sb.append("/**\n");
                sb.append(" * @export\n");
                sb.append(" */\n");
                sb.append("Object.prototype." + name + ";\n");
            }
            File exportsFile = new File(this.outputFolder, "dontrename.js");
            try {
                this.writeFile(exportsFile, sb.toString(), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            compilerWrapper.addJSExternsFile(exportsFile.getAbsolutePath());
        }
    }

    private String getFactoryClass(IMetaTag node) {
        if (node == null) {
            return null;
        }
        return node.getAttribute("factoryClass").getValue();
    }

    protected String generateFactoryClass(String factoryClassName, String projectName, String mainClassQName, File targetDir) throws IOException {
        String generatedName = projectName + "." + factoryClassName;
        generatedName = generatedName.replace(".", "_");
        StringBuilder factoryClass = new StringBuilder();
        factoryClass.append("/**\n");
        factoryClass.append(" * Generated by Apache Royale Compiler\n");
        factoryClass.append(" * " + generatedName + "\n");
        factoryClass.append(" *\n");
        factoryClass.append(" * @fileoverview\n");
        factoryClass.append(" *\n");
        factoryClass.append(" * @suppress {checkTypes|accessControls}\n");
        factoryClass.append(" */\n");
        factoryClass.append("\n");
        factoryClass.append("goog.provide('" + generatedName + "');\n");
        factoryClass.append("\n");
        factoryClass.append("goog.require('" + factoryClassName + "');\n");
        factoryClass.append("goog.require('" + mainClassQName + "');\n");
        factoryClass.append("\n");
        factoryClass.append("\n");
        factoryClass.append("\n");
        factoryClass.append("/**\n");
        factoryClass.append(" * @constructor\n");
        factoryClass.append(" * @extends {" + factoryClassName + "}\n");
        factoryClass.append(" */\n");
        factoryClass.append(generatedName + " = function() {\n");
        factoryClass.append("  " + generatedName + ".base(this, 'constructor');\n");
        factoryClass.append("   this.mainClassName = " + mainClassQName + ";\n");
        factoryClass.append("};\n");
        factoryClass.append("goog.inherits(" + generatedName + ", " + factoryClassName + ");\n");
        factoryClass.append("goog.exportSymbol('" + generatedName + "', " + generatedName + ");\n");
        factoryClass.append("/**\n");
        factoryClass.append(" * @type {Object.<string, Array.<Object>>}\n");
        factoryClass.append(" */\n");
        factoryClass.append(generatedName + ".prototype.ROYALE_CLASS_INFO = { names: [{ name: '" + generatedName + "', qName: '" + generatedName + "', kind: 'class' }]};\n");
        this.writeFile(new File(targetDir, generatedName + ".js"), factoryClass.toString(), false);
        return generatedName;
    }

    class DependencyLineComparator
    implements Comparator<DependencyRecord> {
        DependencyLineComparator() {
        }

        @Override
        public int compare(DependencyRecord o1, DependencyRecord o2) {
            return new Integer(o1.lineNumber).compareTo(o2.lineNumber);
        }
    }

    class DependencyRecord {
        String path;
        String deps;
        String line;
        int lineNumber;

        DependencyRecord() {
        }
    }
}

