/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;

public class ForLoopEmitter
extends JSSubEmitter
implements ISubEmitter<IForLoopNode> {
    public ForLoopEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IForLoopNode node) {
        IContainerNode xnode = (IContainerNode)node.getChild(1);
        this.startMapping((ISourceLocation)node);
        this.writeToken(ASEmitterTokens.FOR);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.endMapping((ISourceLocation)node);
        IContainerNode cnode = node.getConditionalsContainerNode();
        IASNode node0 = cnode.getChild(0);
        if (node0.getNodeID() == ASTNodeID.Op_InID) {
            this.getWalker().walk(cnode.getChild(0));
        } else {
            this.emitForStatements(cnode);
        }
        this.startMapping((ISourceLocation)node, (ISourceLocation)cnode);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (!EmitterUtils.isImplicit(xnode)) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk(node.getStatementContentsNode());
    }

    protected void emitForStatements(IContainerNode node) {
        IASNode node0 = node.getChild(0);
        IASNode node1 = node.getChild(1);
        IASNode node2 = node.getChild(2);
        int column = node.getColumn();
        if (node0 != null) {
            this.getWalker().walk(node0);
            if (node1.getNodeID() != ASTNodeID.NilID) {
                column += node0.getAbsoluteEnd() - node0.getAbsoluteStart();
            }
            this.startMapping((ISourceLocation)node, node.getLine(), column);
            this.write(ASEmitterTokens.SEMICOLON);
            ++column;
            if (node1.getNodeID() != ASTNodeID.NilID) {
                this.write(ASEmitterTokens.SPACE);
                ++column;
            }
            this.endMapping((ISourceLocation)node);
        }
        if (node1 != null) {
            this.getWalker().walk(node1);
            if (node1.getNodeID() != ASTNodeID.NilID) {
                column += node1.getAbsoluteEnd() - node1.getAbsoluteStart();
            }
            this.startMapping((ISourceLocation)node, node.getLine(), column);
            this.write(ASEmitterTokens.SEMICOLON);
            if (node2.getNodeID() != ASTNodeID.NilID) {
                this.write(ASEmitterTokens.SPACE);
            }
            this.endMapping((ISourceLocation)node);
        }
        if (node2 != null) {
            this.getWalker().walk(node2);
        }
    }
}

