/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.mxml;

import java.io.FilterWriter;
import org.apache.royale.compiler.codegen.mxml.IMXMLEmitter;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.internal.codegen.Emitter;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLArrayNode;
import org.apache.royale.compiler.tree.mxml.IMXMLBooleanNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassNode;
import org.apache.royale.compiler.tree.mxml.IMXMLComponentNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDeclarationsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;
import org.apache.royale.compiler.tree.mxml.IMXMLEmbedNode;
import org.apache.royale.compiler.tree.mxml.IMXMLEventSpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLFactoryNode;
import org.apache.royale.compiler.tree.mxml.IMXMLFileNode;
import org.apache.royale.compiler.tree.mxml.IMXMLImplementsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLIntNode;
import org.apache.royale.compiler.tree.mxml.IMXMLLiteralNode;
import org.apache.royale.compiler.tree.mxml.IMXMLMetadataNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNumberNode;
import org.apache.royale.compiler.tree.mxml.IMXMLObjectNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLRemoteObjectMethodNode;
import org.apache.royale.compiler.tree.mxml.IMXMLRemoteObjectNode;
import org.apache.royale.compiler.tree.mxml.IMXMLScriptNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStringNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStyleSpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLUintNode;
import org.apache.royale.compiler.tree.mxml.IMXMLVectorNode;
import org.apache.royale.compiler.visitor.IBlockWalker;
import org.apache.royale.compiler.visitor.mxml.IMXMLBlockWalker;

public class MXMLEmitter
extends Emitter
implements IMXMLEmitter {
    protected IMXMLBlockWalker walker;

    @Override
    public String postProcess(String output) {
        return output;
    }

    @Override
    public IBlockWalker getMXMLWalker() {
        return this.walker;
    }

    @Override
    public void setMXMLWalker(IBlockWalker value) {
        this.walker = (IMXMLBlockWalker)value;
    }

    public MXMLEmitter(FilterWriter out) {
        super(out);
    }

    @Override
    public void emitDeclarations(IMXMLDeclarationsNode node) {
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.getMXMLWalker().walk(node.getChild(i));
        }
    }

    @Override
    public void emitDocumentHeader(IMXMLFileNode node) {
        IMXMLDocumentNode dnode = node.getDocumentNode();
        IClassDefinition cdef = dnode.getClassReference(this.walker.getProject());
        this.write("<" + cdef.getBaseName());
        this.emitPropertySpecifiers(dnode.getPropertySpecifierNodes(), true);
        this.writeNewline(">", true);
    }

    @Override
    public void emitDocumentFooter(IMXMLFileNode node) {
        IMXMLDocumentNode dnode = node.getDocumentNode();
        IClassDefinition cdef = dnode.getClassReference(this.walker.getProject());
        this.writeNewline("", false);
        this.write("</" + cdef.getBaseName() + ">");
    }

    @Override
    public void emitClass(IMXMLClassDefinitionNode node) {
        IMXMLScriptNode[] snodes;
        IMXMLDeclarationsNode[] dnodes = node.getDeclarationsNodes();
        if (dnodes != null) {
            for (IMXMLDeclarationsNode dnode : dnodes) {
                this.getMXMLWalker().walk((IASNode)dnode);
            }
        }
        if ((snodes = node.getScriptNodes()) != null) {
            for (IMXMLScriptNode snode : snodes) {
                this.getMXMLWalker().walk((IASNode)snode);
            }
        }
        this.emitPropertySpecifiers(node.getPropertySpecifierNodes(), false);
    }

    @Override
    public void emitEventSpecifier(IMXMLEventSpecifierNode node) {
    }

    @Override
    public void emitInstance(IMXMLInstanceNode node) {
        IClassDefinition cdef = node.getClassReference(this.getMXMLWalker().getProject());
        String cname = cdef.getBaseName();
        this.write("<");
        this.write(cname);
        if (node.getID() != null && node.getID() != "") {
            this.write(ASEmitterTokens.SPACE);
            this.write("id");
            this.write(ASEmitterTokens.EQUAL);
            this.write("\"");
            this.write(node.getID());
            this.write("\"");
        }
        IMXMLPropertySpecifierNode[] pnodes = node.getPropertySpecifierNodes();
        this.emitPropertySpecifiers(pnodes, true);
        this.write(">");
        this.emitPropertySpecifiers(pnodes, false);
        this.write("<");
        this.write("/");
        this.write(cname);
        this.write(">");
    }

    @Override
    public void emitPropertySpecifier(IMXMLPropertySpecifierNode node) {
        if (!this.isMXMLContentNode((IMXMLNode)node)) {
            this.write(node.getName());
            this.write(ASEmitterTokens.EQUAL);
        }
        this.getMXMLWalker().walk((IASNode)node.getInstanceNode());
    }

    @Override
    public void emitStyleSpecifier(IMXMLStyleSpecifierNode node) {
        if (!this.isMXMLContentNode((IMXMLNode)node)) {
            this.write(node.getName());
            this.write(ASEmitterTokens.EQUAL);
        }
        this.getMXMLWalker().walk((IASNode)node.getInstanceNode());
    }

    @Override
    public void emitScript(IMXMLScriptNode node) {
        this.write("<script><![CDATA[");
        int len = node.getChildCount();
        if (len > 0) {
            this.writeNewline("", true);
            for (int i = 0; i < len; ++i) {
                this.getMXMLWalker().walk(node.getChild(i));
                if (i == len - 1) {
                    this.indentPop();
                }
                this.writeNewline(ASEmitterTokens.SEMICOLON);
            }
        }
        this.write("]]></script>");
    }

    @Override
    public void emitObject(IMXMLObjectNode node) {
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            IASNode child = node.getChild(i);
            this.getMXMLWalker().walk(child);
            if (!(child instanceof IMXMLInstanceNode) || i >= len - 1) continue;
            this.writeNewline();
        }
    }

    @Override
    public void emitArray(IMXMLArrayNode node) {
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            IASNode child = node.getChild(i);
            this.getMXMLWalker().walk(child);
            if (!(child instanceof IMXMLInstanceNode) || i >= len - 1) continue;
            this.writeNewline();
        }
    }

    @Override
    public void emitBoolean(IMXMLBooleanNode node) {
        this.emitAttributeValue((IASNode)node);
    }

    @Override
    public void emitInt(IMXMLIntNode node) {
        this.emitAttributeValue((IASNode)node);
    }

    @Override
    public void emitNumber(IMXMLNumberNode node) {
        this.emitAttributeValue((IASNode)node);
    }

    @Override
    public void emitString(IMXMLStringNode node) {
        this.emitAttributeValue((IASNode)node);
    }

    @Override
    public void emitUint(IMXMLUintNode node) {
        this.emitAttributeValue((IASNode)node);
    }

    @Override
    public void emitLiteral(IMXMLLiteralNode node) {
        this.write(node.getValue().toString());
    }

    @Override
    public void emitPropertySpecifiers(IMXMLPropertySpecifierNode[] nodes, boolean emitAttributes) {
        if (nodes != null) {
            for (IMXMLPropertySpecifierNode cnode : nodes) {
                if (!this.isMXMLContentNode((IMXMLNode)cnode) && emitAttributes) {
                    this.write(ASEmitterTokens.SPACE);
                    this.getMXMLWalker().walk((IASNode)cnode);
                    continue;
                }
                if (!this.isMXMLContentNode((IMXMLNode)cnode) || emitAttributes) continue;
                this.getMXMLWalker().walk((IASNode)cnode);
            }
        }
    }

    protected void emitAttributeValue(IASNode node) {
        IMXMLLiteralNode cnode = (IMXMLLiteralNode)node.getChild(0);
        if (cnode.getValue() != null) {
            this.write("\"");
            this.getMXMLWalker().walk((IASNode)cnode);
            this.write("\"");
        }
    }

    protected boolean isMXMLContentNode(IMXMLNode node) {
        return node.getName().equals("mxmlContentFactory") || node.getName().equals("mxmlContent");
    }

    @Override
    public void emitFactory(IMXMLFactoryNode node) {
        IASNode cnode = node.getChild(0);
        this.write("\"");
        if (cnode instanceof IMXMLClassNode) {
            this.write(((IMXMLClassNode)cnode).getValue(this.getMXMLWalker().getProject()).getQualifiedName());
        }
        this.write("\"");
    }

    @Override
    public void emitComponent(IMXMLComponentNode node) {
        IASNode cnode = node.getChild(0);
        this.write("<fx:Component>");
        if (cnode instanceof IMXMLClassNode) {
            this.getMXMLWalker().walk(cnode);
        }
        this.write("</fx:Component>");
    }

    @Override
    public void emitMetadata(IMXMLMetadataNode node) {
    }

    @Override
    public void emitEmbed(IMXMLEmbedNode node) {
    }

    @Override
    public void emitImplements(IMXMLImplementsNode node) {
    }

    @Override
    public void emitVector(IMXMLVectorNode node) {
    }

    @Override
    public void emitDatabinding(IMXMLDataBindingNode node) {
    }

    @Override
    public void emitRemoteObjectMethod(IMXMLRemoteObjectMethodNode node) {
    }

    @Override
    public void emitRemoteObject(IMXMLRemoteObjectNode node) {
    }
}

