/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IEmbedNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IVariableNode;

public class VarDeclarationEmitter
extends JSSubEmitter
implements ISubEmitter<IVariableNode> {
    public VarDeclarationEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IVariableNode node) {
        IExpressionNode variableTypeNode;
        boolean hasVariableType;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        this.getModel().getVars().add(node);
        if (!(node instanceof ChainedVariableNode) && !node.isConst()) {
            fjs.emitMemberKeyword((IDefinitionNode)node);
        }
        boolean bl = hasVariableType = (variableTypeNode = node.getVariableTypeNode()).getLine() >= 0;
        if (hasVariableType) {
            this.startMapping((ISourceLocation)variableTypeNode, variableTypeNode.getLine(), variableTypeNode.getColumn() - 1);
        } else {
            IExpressionNode nameExpressionNode = node.getNameExpressionNode();
            this.startMapping((ISourceLocation)variableTypeNode, nameExpressionNode.getLine(), nameExpressionNode.getColumn() + nameExpressionNode.getAbsoluteEnd() - nameExpressionNode.getAbsoluteStart());
        }
        IExpressionNode avnode = node.getAssignedValueNode();
        ITypeDefinition avdef = null;
        if (avnode != null) {
            avdef = avnode.resolveType(this.getWalker().getProject());
            String opcode = avnode.getNodeID().getParaphrase();
            if (opcode != "AnonymousFunction") {
                fjs.getDocEmitter().emitVarDoc(node, (IDefinition)avdef, this.getWalker().getProject());
            }
        } else {
            fjs.getDocEmitter().emitVarDoc(node, null, this.getWalker().getProject());
        }
        this.endMapping((ISourceLocation)variableTypeNode);
        if (!(node instanceof ChainedVariableNode) && node.isConst()) {
            fjs.emitMemberKeyword((IDefinitionNode)node);
        }
        fjs.emitDeclarationName((IDefinitionNode)node);
        if (avnode != null && !(avnode instanceof IEmbedNode)) {
            boolean valIsNumber;
            if (hasVariableType) {
                this.startMapping((ISourceLocation)node, (ISourceLocation)node.getVariableTypeNode());
            } else {
                this.startMapping((ISourceLocation)node, (ISourceLocation)node.getNameExpressionNode());
            }
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.endMapping((ISourceLocation)node);
            boolean varIsNumber = variableTypeNode.getNodeID() == ASTNodeID.IdentifierID && (((IdentifierNode)variableTypeNode).getName().equals("Number") || ((IdentifierNode)variableTypeNode).getName().equals("int") || ((IdentifierNode)variableTypeNode).getName().equals("uint"));
            boolean bl2 = valIsNumber = avdef != null && (avdef.getQualifiedName().equals("Number") || avdef.getQualifiedName().equals("int") || avdef.getQualifiedName().equals("uint"));
            if (!valIsNumber && avdef == null && avnode.getNodeID() == ASTNodeID.MemberAccessExpressionID && fjs.isDateProperty(avnode, false)) {
                valIsNumber = true;
            }
            if (varIsNumber && !valIsNumber && (avdef == null || avdef.getQualifiedName().equals("*"))) {
                if (avnode.getNodeID() == ASTNodeID.FunctionCallID) {
                    ExpressionNodeBase fnNameNode = ((FunctionCallNode)avnode).getNameNode();
                    if (fnNameNode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                        MemberAccessExpressionNode mae = (MemberAccessExpressionNode)fnNameNode;
                        IExpressionNode rightNode = mae.getRightOperandNode();
                        valIsNumber = rightNode.getNodeID() == ASTNodeID.IdentifierID && ((IdentifierNode)rightNode).getName().equals("length") && fjs.isXMLList(mae);
                    }
                } else if (avnode.getNodeID() == ASTNodeID.ArrayIndexExpressionID) {
                    DynamicAccessNode dyn = (DynamicAccessNode)avnode;
                    ITypeDefinition leftDef = dyn.getLeftOperandNode().resolveType(this.getProject());
                    ITypeDefinition rightDef = dyn.getRightOperandNode().resolveType(this.getProject());
                    if (rightDef.getQualifiedName().equals("Number")) {
                        IMetaTag[] metas;
                        for (IMetaTag meta : metas = leftDef.getAllMetaTags()) {
                            IMetaTagAttribute[] attrs;
                            if (!meta.getTagName().equals("ArrayElementType")) continue;
                            for (IMetaTagAttribute attr : attrs = meta.getAllAttributes()) {
                                String t = attr.getValue();
                                if (!t.equals("Number")) continue;
                                valIsNumber = true;
                            }
                        }
                    }
                }
            }
            String coercion = "";
            if (varIsNumber && !valIsNumber) {
                coercion = "Number(";
            }
            if (variableTypeNode.getNodeID() == ASTNodeID.IdentifierID && ((IdentifierNode)variableTypeNode).getName().equals("String") && (avdef == null || !avdef.getQualifiedName().equals("String") && !avdef.getQualifiedName().equals("Null"))) {
                coercion = "org.apache.royale.utils.Language.string(";
            }
            this.write(coercion);
            fjs.emitAssignedValue(avnode);
            if (coercion.length() > 0) {
                this.write(")");
            }
        }
        if (avnode == null) {
            ITypeDefinition typedef = null;
            IExpressionNode enode = node.getVariableTypeNode();
            if (enode != null) {
                typedef = enode.resolveType(this.getWalker().getProject());
            }
            if (typedef != null) {
                boolean defaultInitializers = false;
                ICompilerProject project = this.getProject();
                if (project instanceof RoyaleJSProject) {
                    RoyaleJSProject fjsProject = (RoyaleJSProject)project;
                    if (fjsProject.config != null) {
                        defaultInitializers = fjsProject.config.getJsDefaultInitializers();
                    }
                }
                if (node.getParent() != null && node.getParent().getParent() != null && node.getParent().getParent().getNodeID() != ASTNodeID.Op_InID) {
                    String defName = typedef.getQualifiedName();
                    if (defName.equals("int") || defName.equals("uint")) {
                        this.write(ASEmitterTokens.SPACE);
                        this.writeToken(ASEmitterTokens.EQUAL);
                        this.write("0");
                    } else if (defaultInitializers) {
                        if (defName.equals("Number")) {
                            this.write(ASEmitterTokens.SPACE);
                            this.writeToken(ASEmitterTokens.EQUAL);
                            this.write("NaN");
                        } else if (defName.equals("Boolean")) {
                            this.write(ASEmitterTokens.SPACE);
                            this.writeToken(ASEmitterTokens.EQUAL);
                            this.write("false");
                        } else if (!defName.equals("*")) {
                            this.write(ASEmitterTokens.SPACE);
                            this.writeToken(ASEmitterTokens.EQUAL);
                            this.write("null");
                        }
                    }
                }
            }
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.startMapping((ISourceLocation)node, (ISourceLocation)node.getChild(i - 1));
                this.writeToken(ASEmitterTokens.COMMA);
                this.endMapping((ISourceLocation)node);
                fjs.emitVarDeclaration((IVariableNode)child);
            }
        }
    }
}

