/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.goog.IJSGoogDocEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

public class FieldEmitter
extends JSSubEmitter
implements ISubEmitter<IVariableNode> {
    public boolean hasComplexStaticInitializers = false;

    public FieldEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IVariableNode node) {
        IExpressionNode vnode;
        boolean isPackageOrFileMember;
        IClassDefinition definition = EmitterUtils.getClassDefinition((IDefinitionNode)node);
        ITypeDefinition def = null;
        IExpressionNode enode = node.getVariableTypeNode();
        if (enode != null) {
            def = enode.resolveType(this.getProject());
        }
        if (this.getEmitter().getDocEmitter() instanceof IJSGoogDocEmitter) {
            ((IJSGoogDocEmitter)this.getEmitter().getDocEmitter()).emitFieldDoc(node, (IDefinition)def, this.getProject());
        }
        IDefinition ndef = node.getDefinition();
        String className = null;
        String root = "";
        IVariableDefinition.VariableClassification classification = node.getVariableClassification();
        boolean bl = isPackageOrFileMember = classification == IVariableDefinition.VariableClassification.PACKAGE_MEMBER || classification == IVariableDefinition.VariableClassification.FILE_MEMBER;
        if (isPackageOrFileMember) {
            className = this.getEmitter().formatQualifiedName(node.getQualifiedName());
            this.write(className);
        } else {
            ModifiersSet modifierSet = ndef.getModifiers();
            if (modifierSet != null && !modifierSet.hasModifier(ASModifier.STATIC)) {
                root = JSEmitterTokens.PROTOTYPE.getToken();
                root = root + ASEmitterTokens.MEMBER_ACCESS.getToken();
            }
            if (definition == null) {
                definition = ndef.getContainingScope().getDefinition();
            }
            this.startMapping((ISourceLocation)node.getNameExpressionNode());
            className = this.getEmitter().formatQualifiedName(definition.getQualifiedName());
            this.write(className + ASEmitterTokens.MEMBER_ACCESS.getToken() + root);
            String qname = node.getName();
            IDefinition nodeDef = node.getDefinition();
            if (nodeDef != null && nodeDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                qname = this.getEmitter().formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
            }
            this.write(qname);
            this.endMapping((ISourceLocation)node.getNameExpressionNode());
        }
        if (node.getNodeID() == ASTNodeID.BindableVariableID && !node.isConst()) {
            this.write("_");
        }
        if ((vnode = node.getAssignedValueNode()) != null) {
            FunctionDefinition fd;
            IDefinitionNode m;
            IDefinition d;
            FunctionCallNode fcn;
            this.getModel().inStaticInitializer = ndef.isStatic();
            String vnodeString = this.getEmitter().stringifyNode((IASNode)vnode);
            if (ndef.isStatic() && vnode instanceof FunctionCallNode && (fcn = (FunctionCallNode)vnode).getNameNode() instanceof IdentifierNode && (d = fcn.getNameNode().resolve(this.getProject())) instanceof FunctionDefinition && (m = (fd = (FunctionDefinition)d).getNode()) != null) {
                this.getEmitter().stringifyNode((IASNode)m);
            }
            this.getModel().inStaticInitializer = false;
            if (ndef.isStatic() && !EmitterUtils.needsStaticInitializer(vnodeString, className) || !ndef.isStatic() && EmitterUtils.isScalar(vnode) || isPackageOrFileMember) {
                IExpressionNode beforeNode = node.getVariableTypeNode();
                if (beforeNode.getAbsoluteStart() == -1) {
                    beforeNode = node.getNameExpressionNode();
                }
                this.startMapping((ISourceLocation)node, (ISourceLocation)beforeNode);
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.endMapping((ISourceLocation)node);
                this.startMapping((ISourceLocation)vnode);
                this.write(vnodeString);
                this.endMapping((ISourceLocation)vnode);
            } else if (ndef.isStatic() && EmitterUtils.needsStaticInitializer(vnodeString, className)) {
                this.hasComplexStaticInitializers = true;
            }
        }
        if (vnode == null && def != null) {
            String defName = def.getQualifiedName();
            if (defName.equals("int") || defName.equals("uint")) {
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write("0");
            } else {
                boolean defaultInitializers = false;
                ICompilerProject project = this.getProject();
                if (project instanceof RoyaleJSProject) {
                    RoyaleJSProject fjsProject = (RoyaleJSProject)project;
                    if (fjsProject.config != null) {
                        defaultInitializers = fjsProject.config.getJsDefaultInitializers();
                    }
                }
                if (defaultInitializers) {
                    if (defName.equals("Number")) {
                        this.write(ASEmitterTokens.SPACE);
                        this.writeToken(ASEmitterTokens.EQUAL);
                        this.write("NaN");
                    } else if (defName.equals("Boolean")) {
                        this.write(ASEmitterTokens.SPACE);
                        this.writeToken(ASEmitterTokens.EQUAL);
                        this.write("false");
                    } else if (!defName.equals("*")) {
                        this.write(ASEmitterTokens.SPACE);
                        this.writeToken(ASEmitterTokens.EQUAL);
                        this.write("null");
                    }
                }
            }
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.writeNewline();
                this.getEmitter().emitField((IVariableNode)child);
            }
        }
        if (node.getNodeID() == ASTNodeID.BindableVariableID && !node.isConst() && this.getModel().getBindableVars().get(node.getName()) == null) {
            IMetaTagNode[] tags;
            JSSessionModel.BindableVarInfo bindableVarInfo = new JSSessionModel.BindableVarInfo();
            bindableVarInfo.isStatic = node.hasModifier(ASModifier.STATIC);
            bindableVarInfo.namespace = node.getNamespace();
            bindableVarInfo.type = def.getQualifiedName();
            this.getModel().getBindableVars().put(node.getName(), bindableVarInfo);
            IMetaTagsNode metaTags = node.getMetaTags();
            if (metaTags != null && (tags = metaTags.getAllTags()).length > 0) {
                bindableVarInfo.metaTags = tags;
            }
        }
    }

    public boolean emitFieldInitializer(IVariableNode node) {
        IClassDefinition definition = EmitterUtils.getClassDefinition((IDefinitionNode)node);
        IDefinition ndef = node.getDefinition();
        String className = null;
        IVariableDefinition.VariableClassification classification = node.getVariableClassification();
        boolean isPackageOrFileMember = classification == IVariableDefinition.VariableClassification.PACKAGE_MEMBER || classification == IVariableDefinition.VariableClassification.FILE_MEMBER;
        IExpressionNode vnode = node.getAssignedValueNode();
        if (vnode != null) {
            String vnodeString = this.getEmitter().stringifyNode((IASNode)vnode);
            if (definition == null) {
                definition = ndef.getContainingScope().getDefinition();
            }
            className = this.getEmitter().formatQualifiedName(definition.getQualifiedName());
            if (ndef.isStatic() && EmitterUtils.needsStaticInitializer(vnodeString, className) && !isPackageOrFileMember) {
                this.writeNewline();
                this.write(className + ASEmitterTokens.MEMBER_ACCESS.getToken());
                this.write(node.getName());
                if (node.getNodeID() == ASTNodeID.BindableVariableID && !node.isConst()) {
                    this.write("_");
                }
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(vnodeString);
                this.write(ASEmitterTokens.SEMICOLON);
                return true;
            }
        }
        return false;
    }
}

