/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.DocEmitterUtils;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.IVariableNode;

public class ClassEmitter
extends JSSubEmitter
implements ISubEmitter<IClassNode> {
    public ClassEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IClassNode node) {
        IDefinitionNode[] dnodes;
        boolean keepASDoc = false;
        RoyaleJSProject project = (RoyaleJSProject)this.getEmitter().getWalker().getProject();
        keepASDoc = project.config != null && project.config.getKeepASDoc();
        this.getModel().pushClass(node.getDefinition());
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && keepASDoc) {
            DocEmitterUtils.loadImportIgnores(fjs, asDoc.commentNoEnd());
        }
        IClassDefinition definition = node.getDefinition();
        IFunctionDefinition ctorDefinition = definition.getConstructor();
        int childNodeCount = node.getChildCount();
        for (int i = 0; i < childNodeCount; ++i) {
            IASNode child = node.getChild(i);
            if (child.getNodeID() != ASTNodeID.BlockID) continue;
            int blockNodeCount = child.getChildCount();
            for (int j = 0; j < blockNodeCount - 1; ++j) {
                IDefinition def;
                IASNode afterChild;
                IASNode blockChild = child.getChild(j);
                if (blockChild.getNodeID() != ASTNodeID.ImportID || (afterChild = child.getChild(j + 1)).getNodeID() != ASTNodeID.IdentifierID || !((def = ((IdentifierNode)afterChild).resolve((ICompilerProject)project)) instanceof IClassDefinition)) continue;
                fjs.usedNames.add(def.getQualifiedName());
            }
            break;
        }
        if (ctorDefinition != null) {
            IFunctionNode ctorNode = (IFunctionNode)ctorDefinition.getNode();
            if (ctorNode != null) {
                this.getEmitter().emitMethod(ctorNode);
                this.write(ASEmitterTokens.SEMICOLON);
            } else {
                IDefinitionNode[] qname = definition.getQualifiedName();
                if (qname != null && !qname.equals("")) {
                    this.write(this.getEmitter().formatQualifiedName((String)qname));
                    this.write(ASEmitterTokens.SPACE);
                    this.writeToken(ASEmitterTokens.EQUAL);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.BLOCK_OPEN);
                    this.writeNewline();
                    fjs.emitComplexInitializers(node);
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.write(ASEmitterTokens.SEMICOLON);
                }
            }
        }
        if (!this.getEmitter().getModel().isExterns) {
            JSRoyaleDocEmitter doc = (JSRoyaleDocEmitter)this.getEmitter().getDocEmitter();
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            doc.begin();
            this.writeNewline(" * Prevent renaming of class. Needed for reflection.");
            doc.end();
            this.write(JSRoyaleEmitterTokens.GOOG_EXPORT_SYMBOL);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(this.getEmitter().formatQualifiedName(node.getQualifiedName()));
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write(this.getEmitter().formatQualifiedName(node.getQualifiedName()));
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
        for (IDefinitionNode dnode : dnodes = node.getAllMemberNodes()) {
            if (dnode.getNodeID() == ASTNodeID.VariableID) {
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.getEmitter().emitField((IVariableNode)dnode);
                this.startMapping((ISourceLocation)dnode, (ISourceLocation)dnode);
                this.write(ASEmitterTokens.SEMICOLON);
                this.endMapping((ISourceLocation)dnode);
                continue;
            }
            if (dnode.getNodeID() == ASTNodeID.FunctionID) {
                if (((IFunctionNode)dnode).isConstructor()) continue;
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.getEmitter().emitMethod((IFunctionNode)dnode);
                this.write(ASEmitterTokens.SEMICOLON);
                continue;
            }
            if (dnode.getNodeID() == ASTNodeID.GetterID || dnode.getNodeID() == ASTNodeID.SetterID) {
                fjs.emitAccessors((IAccessorNode)dnode);
                continue;
            }
            if (dnode.getNodeID() != ASTNodeID.BindableVariableID) continue;
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.getEmitter().emitField((IVariableNode)dnode);
            this.startMapping((ISourceLocation)dnode, (ISourceLocation)dnode);
            this.write(ASEmitterTokens.SEMICOLON);
            this.endMapping((ISourceLocation)dnode);
        }
        fjs.getBindableEmitter().emit(definition);
        fjs.getAccessorEmitter().emit(definition);
        if (fjs.getFieldEmitter().hasComplexStaticInitializers) {
            this.writeNewline();
            boolean complexInitOutput = false;
            for (IDefinitionNode dnode : dnodes) {
                if (dnode.getNodeID() == ASTNodeID.VariableID) {
                    complexInitOutput = fjs.getFieldEmitter().emitFieldInitializer((IVariableNode)dnode) || complexInitOutput;
                    continue;
                }
                if (dnode.getNodeID() != ASTNodeID.BindableVariableID) continue;
                complexInitOutput = fjs.getFieldEmitter().emitFieldInitializer((IVariableNode)dnode) || complexInitOutput;
            }
            if (complexInitOutput) {
                this.writeNewline();
                this.writeNewline();
            }
        }
        fjs.getPackageFooterEmitter().emitClassInfo((ITypeNode)node);
        this.getModel().popClass();
    }

    public void emitComplexInitializers(IClassNode node) {
        IDefinitionNode[] dnodes;
        boolean wroteOne = false;
        for (IDefinitionNode dnode : dnodes = node.getAllMemberNodes()) {
            IVariableNode varnode;
            IExpressionNode vnode;
            if (dnode.getNodeID() != ASTNodeID.VariableID && dnode.getNodeID() != ASTNodeID.BindableVariableID || (vnode = (varnode = (IVariableNode)dnode).getAssignedValueNode()) == null || dnode.getDefinition().isStatic() || EmitterUtils.isScalar(vnode)) continue;
            this.writeNewline();
            this.write(ASEmitterTokens.THIS);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            String dname = dnode.getName();
            IDefinition dDef = dnode.getDefinition();
            if (dDef != null && dDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                dname = this.getEmitter().formatPrivateName(dDef.getParent().getQualifiedName(), dname);
            }
            this.write(dname);
            if (dnode.getNodeID() == ASTNodeID.BindableVariableID) {
                this.write("_");
            }
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.getEmitter().getWalker().walk((IASNode)vnode);
            this.write(ASEmitterTokens.SEMICOLON);
            wroteOne = true;
        }
        if (wroteOne) {
            this.writeNewline();
        }
    }
}

