/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js;

import com.google.debugging.sourcemap.FilePosition;
import java.io.FilterWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.codegen.IEmitter;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.IMappingEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitter;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.jx.BlockCloseEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.BlockOpenEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.CatchEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.DoWhileLoopEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.DynamicAccessEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ForLoopEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.FunctionCallArgumentsEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.IfEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.IterationFlowEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.LanguageIdentifierEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.LiteralContainerEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.MemberKeywordEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.NumericLiteralEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ObjectLiteralValuePairEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ParameterEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ParametersEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ReturnEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.SourceMapDirectiveEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.StatementEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.SwitchEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.TernaryOperatorEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ThrowEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.TryEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.UnaryOperatorEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.WhileLoopEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.WithEmitter;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.ICatchNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.IIfNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IIterationFlowNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.ILiteralContainerNode;
import org.apache.royale.compiler.tree.as.INumericLiteralNode;
import org.apache.royale.compiler.tree.as.IObjectLiteralValuePairNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IReturnNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.ISwitchNode;
import org.apache.royale.compiler.tree.as.ITernaryOperatorNode;
import org.apache.royale.compiler.tree.as.IThrowNode;
import org.apache.royale.compiler.tree.as.ITryNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.ITypedExpressionNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IWhileLoopNode;
import org.apache.royale.compiler.tree.as.IWithNode;

public class JSEmitter
extends ASEmitter
implements IJSEmitter {
    private JSSessionModel model = new JSSessionModel();
    public ISubEmitter<IContainerNode> blockOpenEmitter;
    public ISubEmitter<IContainerNode> blockCloseEmitter;
    public ISubEmitter<INumericLiteralNode> numericLiteralEmitter;
    public ISubEmitter<IContainerNode> parametersEmitter;
    public ISubEmitter<IParameterNode> parameterEmitter;
    public ISubEmitter<IContainerNode> functionCallArgumentsEmitter;
    public ISubEmitter<ILiteralContainerNode> literalContainerEmitter;
    public ISubEmitter<IObjectLiteralValuePairNode> objectLiteralValuePairEmitter;
    public ISubEmitter<IReturnNode> returnEmitter;
    public ISubEmitter<IDynamicAccessNode> dynamicAccessEmitter;
    public ISubEmitter<IUnaryOperatorNode> unaryOperatorEmitter;
    public ISubEmitter<ITernaryOperatorNode> ternaryOperatorEmitter;
    public ISubEmitter<IDefinitionNode> memberKeywordEmitter;
    public ISubEmitter<IIfNode> ifEmitter;
    public ISubEmitter<ISwitchNode> switchEmitter;
    public ISubEmitter<IWhileLoopNode> whileLoopEmitter;
    public ISubEmitter<IWhileLoopNode> doWhileLoopEmitter;
    public ISubEmitter<IForLoopNode> forLoopEmitter;
    public ISubEmitter<IIterationFlowNode> interationFlowEmitter;
    public ISubEmitter<ITryNode> tryEmitter;
    public ISubEmitter<ICatchNode> catchEmitter;
    public ISubEmitter<IThrowNode> throwEmitter;
    public ISubEmitter<IWithNode> withEmitter;
    public ISubEmitter<IASNode> statementEmitter;
    public ISubEmitter<ILanguageIdentifierNode> languageIdentifierEmitter;
    public SourceMapDirectiveEmitter sourceMapDirectiveEmitter;
    private IMappingEmitter.SourceMapMapping lastMapping;
    private List<IMappingEmitter.SourceMapMapping> sourceMapMappings = new ArrayList<IMappingEmitter.SourceMapMapping>();

    @Override
    public JSSessionModel getModel() {
        return this.model;
    }

    @Override
    public List<IMappingEmitter.SourceMapMapping> getSourceMapMappings() {
        return this.sourceMapMappings;
    }

    public JSEmitter(FilterWriter out) {
        super(out);
        this.blockOpenEmitter = new BlockOpenEmitter(this);
        this.blockCloseEmitter = new BlockCloseEmitter(this);
        this.numericLiteralEmitter = new NumericLiteralEmitter(this);
        this.parametersEmitter = new ParametersEmitter(this);
        this.parameterEmitter = new ParameterEmitter(this);
        this.functionCallArgumentsEmitter = new FunctionCallArgumentsEmitter(this);
        this.literalContainerEmitter = new LiteralContainerEmitter(this);
        this.objectLiteralValuePairEmitter = new ObjectLiteralValuePairEmitter(this);
        this.returnEmitter = new ReturnEmitter(this);
        this.dynamicAccessEmitter = new DynamicAccessEmitter(this);
        this.unaryOperatorEmitter = new UnaryOperatorEmitter(this);
        this.ternaryOperatorEmitter = new TernaryOperatorEmitter(this);
        this.memberKeywordEmitter = new MemberKeywordEmitter(this);
        this.ifEmitter = new IfEmitter(this);
        this.switchEmitter = new SwitchEmitter(this);
        this.whileLoopEmitter = new WhileLoopEmitter(this);
        this.doWhileLoopEmitter = new DoWhileLoopEmitter(this);
        this.forLoopEmitter = new ForLoopEmitter(this);
        this.interationFlowEmitter = new IterationFlowEmitter(this);
        this.tryEmitter = new TryEmitter(this);
        this.catchEmitter = new CatchEmitter(this);
        this.throwEmitter = new ThrowEmitter(this);
        this.withEmitter = new WithEmitter(this);
        this.statementEmitter = new StatementEmitter(this);
        this.languageIdentifierEmitter = new LanguageIdentifierEmitter(this);
        this.sourceMapDirectiveEmitter = new SourceMapDirectiveEmitter(this);
    }

    @Override
    public String formatQualifiedName(String name) {
        return name;
    }

    @Override
    public void emitLocalNamedFunction(IFunctionNode node) {
        this.startMapping((ISourceLocation)node);
        FunctionNode fnode = (FunctionNode)node;
        this.write(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.SPACE);
        this.write(fnode.getName());
        this.endMapping((ISourceLocation)node);
        this.emitParameters((IContainerNode)fnode.getParametersContainerNode());
        this.emitFunctionScope((IScopedNode)fnode.getScopedNode());
    }

    @Override
    public void emitFunctionObject(IFunctionObjectNode node) {
        this.startMapping((ISourceLocation)node);
        FunctionNode fnode = node.getFunctionNode();
        this.write(ASEmitterTokens.FUNCTION);
        this.endMapping((ISourceLocation)node);
        this.emitParameters((IContainerNode)fnode.getParametersContainerNode());
        this.emitFunctionScope((IScopedNode)fnode.getScopedNode());
    }

    @Override
    public void emitClosureStart() {
    }

    @Override
    public void emitClosureEnd(IASNode node, IDefinition nodeDef) {
    }

    @Override
    public void emitSourceMapDirective(ITypeNode node) {
        this.sourceMapDirectiveEmitter.emit(node);
    }

    @Override
    public void emitParameters(IContainerNode node) {
        this.parametersEmitter.emit(node);
    }

    @Override
    public void emitParameter(IParameterNode node) {
        this.parameterEmitter.emit(node);
    }

    @Override
    public void emitArguments(IContainerNode node) {
        this.functionCallArgumentsEmitter.emit(node);
    }

    @Override
    public void emitNumericLiteral(INumericLiteralNode node) {
        this.numericLiteralEmitter.emit(node);
    }

    @Override
    public void emitLiteralContainer(ILiteralContainerNode node) {
        this.literalContainerEmitter.emit(node);
    }

    @Override
    public void emitObjectLiteralValuePair(IObjectLiteralValuePairNode node) {
        this.objectLiteralValuePairEmitter.emit(node);
    }

    @Override
    public void emitTry(ITryNode node) {
        this.tryEmitter.emit(node);
    }

    @Override
    public void emitCatch(ICatchNode node) {
        this.catchEmitter.emit(node);
    }

    @Override
    public void emitWith(IWithNode node) {
        this.withEmitter.emit(node);
    }

    @Override
    public void emitThrow(IThrowNode node) {
        this.throwEmitter.emit(node);
    }

    @Override
    public void emitReturn(IReturnNode node) {
        this.returnEmitter.emit(node);
    }

    @Override
    public void emitTypedExpression(ITypedExpressionNode node) {
        this.write(JSEmitterTokens.ARRAY);
    }

    @Override
    public void emitDynamicAccess(IDynamicAccessNode node) {
        this.dynamicAccessEmitter.emit(node);
    }

    @Override
    public void emitMemberKeyword(IDefinitionNode node) {
        this.memberKeywordEmitter.emit(node);
    }

    @Override
    public void emitUnaryOperator(IUnaryOperatorNode node) {
        this.unaryOperatorEmitter.emit(node);
    }

    @Override
    public void emitTernaryOperator(ITernaryOperatorNode node) {
        this.ternaryOperatorEmitter.emit(node);
    }

    @Override
    public void emitLanguageIdentifier(ILanguageIdentifierNode node) {
        this.languageIdentifierEmitter.emit(node);
    }

    @Override
    public void emitStatement(IASNode node) {
        this.statementEmitter.emit(node);
    }

    @Override
    public void emitIf(IIfNode node) {
        this.ifEmitter.emit(node);
    }

    @Override
    public void emitSwitch(ISwitchNode node) {
        this.switchEmitter.emit(node);
    }

    @Override
    public void emitImport(IImportNode node) {
    }

    @Override
    public void emitWhileLoop(IWhileLoopNode node) {
        this.whileLoopEmitter.emit(node);
    }

    @Override
    public void emitDoLoop(IWhileLoopNode node) {
        this.doWhileLoopEmitter.emit(node);
    }

    @Override
    public void emitForLoop(IForLoopNode node) {
        this.forLoopEmitter.emit(node);
    }

    @Override
    public void emitIterationFlow(IIterationFlowNode node) {
        this.interationFlowEmitter.emit(node);
    }

    @Override
    public void emitBlockOpen(IContainerNode node) {
        this.blockOpenEmitter.emit(node);
    }

    @Override
    public void emitBlockClose(IContainerNode node) {
        this.blockCloseEmitter.emit(node);
    }

    @Override
    public void startMapping(ISourceLocation node) {
        this.startMapping(node, node.getLine(), node.getColumn());
    }

    @Override
    public void startMapping(ISourceLocation node, int line, int column) {
        IASNode parentNode;
        if (this.isBufferWrite()) {
            return;
        }
        IEmitter parentEmitter = this.getParentEmitter();
        if (parentEmitter != null && parentEmitter instanceof IMappingEmitter) {
            IMappingEmitter mappingParent = (IMappingEmitter)((Object)parentEmitter);
            mappingParent.startMapping(node, line, column);
            return;
        }
        if (this.lastMapping != null) {
            FilePosition sourceStartPosition = this.lastMapping.sourceStartPosition;
            throw new IllegalStateException("Cannot start new mapping when another mapping is already started. Previous mapping at Line " + sourceStartPosition.getLine() + " and Column " + sourceStartPosition.getColumn() + " in file " + this.lastMapping.sourcePath);
        }
        String sourcePath = node.getSourcePath();
        if (sourcePath == null && node instanceof IASNode && (parentNode = ((IASNode)node).getParent()) != null) {
            this.startMapping((ISourceLocation)parentNode, line, column);
            return;
        }
        IMappingEmitter.SourceMapMapping mapping = new IMappingEmitter.SourceMapMapping();
        mapping.sourcePath = sourcePath;
        mapping.sourceStartPosition = new FilePosition(line, column);
        mapping.destStartPosition = new FilePosition(this.getCurrentLine(), this.getCurrentColumn());
        this.lastMapping = mapping;
    }

    @Override
    public void startMapping(ISourceLocation node, ISourceLocation afterNode) {
        this.startMapping(node, afterNode.getEndLine(), afterNode.getEndColumn());
    }

    @Override
    public void endMapping(ISourceLocation node) {
        if (this.isBufferWrite()) {
            return;
        }
        IEmitter parentEmitter = this.getParentEmitter();
        if (parentEmitter != null && parentEmitter instanceof IMappingEmitter) {
            IMappingEmitter mappingParent = (IMappingEmitter)((Object)parentEmitter);
            mappingParent.endMapping(node);
            return;
        }
        if (this.lastMapping == null) {
            throw new IllegalStateException("Cannot end mapping when a mapping has not been started");
        }
        this.lastMapping.destEndPosition = new FilePosition(this.getCurrentLine(), this.getCurrentColumn());
        this.sourceMapMappings.add(this.lastMapping);
        this.lastMapping = null;
    }

    protected void addLineToMappings(int lineIndex) {
        for (IMappingEmitter.SourceMapMapping mapping : this.sourceMapMappings) {
            FilePosition destStartPosition = mapping.destStartPosition;
            int startLine = destStartPosition.getLine();
            if (startLine <= lineIndex) continue;
            mapping.destStartPosition = new FilePosition(startLine + 1, destStartPosition.getColumn());
            FilePosition destEndPosition = mapping.destEndPosition;
            mapping.destEndPosition = new FilePosition(destEndPosition.getLine() + 1, destEndPosition.getColumn());
        }
    }

    protected void removeLineFromMappings(int lineIndex) {
        for (IMappingEmitter.SourceMapMapping mapping : this.sourceMapMappings) {
            FilePosition destStartPosition = mapping.destStartPosition;
            int startLine = destStartPosition.getLine();
            if (startLine <= lineIndex) continue;
            mapping.destStartPosition = new FilePosition(startLine - 1, destStartPosition.getColumn());
            FilePosition destEndPosition = mapping.destEndPosition;
            mapping.destEndPosition = new FilePosition(destEndPosition.getLine() - 1, destEndPosition.getColumn());
        }
    }

    @Override
    public String formatPrivateName(String className, String name) {
        return className.replace(".", "_") + "_" + name;
    }
}

