/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.projects;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.royale.compiler.clients.JSConfiguration;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.css.ICSSMediaQueryCondition;
import org.apache.royale.compiler.css.ICSSRule;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.driver.IBackend;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.driver.js.royale.JSCSSCompilationSession;
import org.apache.royale.compiler.internal.mxml.MXMLNamespaceMapping;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.targets.ITargetAttributes;
import org.apache.royale.compiler.internal.targets.LinkageChecker;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDocumentNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.royale.compiler.internal.units.SWCCompilationUnit;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.compiler.workspaces.IWorkspace;

public class RoyaleJSProject
extends RoyaleProject {
    private HashMap<ICompilationUnit, HashMap<String, String>> interfaces = new HashMap();
    private HashMap<ICompilationUnit, HashMap<String, DependencyType>> requires = new HashMap();
    private HashMap<ICompilationUnit, HashMap<String, DependencyType>> jsModules = new HashMap();
    public TreeSet<String> mixinClassNames;
    public HashMap<String, String> remoteClassAliasMap;
    public JSGoogConfiguration config;
    public Configurator configurator;
    private IBackend backend;
    public ICompilationUnit mainCU;
    public boolean needLanguage;
    public boolean needCSS;
    public boolean needXML;
    private LinkageChecker linkageChecker;
    private ITargetSettings ts;
    public Collection<String> unitTestExterns;
    JSCSSCompilationSession cssSession = new JSCSSCompilationSession();
    private HashMap<IASNode, String> astCache = new HashMap();
    private HashSet<String> exportedNames = new HashSet();

    public RoyaleJSProject(Workspace workspace, IBackend backend) {
        super(workspace);
        this.backend = backend;
    }

    public synchronized void addDependency(ICompilationUnit from, ICompilationUnit to, DependencyType dt, String qname) {
        boolean isInterface;
        List dp = to.getDefinitionPromises();
        if (dp.size() == 0) {
            return;
        }
        IDefinition def = (IDefinition)dp.get(0);
        IDefinition actualDef = ((ASProjectScope.DefinitionPromise)def).getActualDefinition();
        boolean bl = isInterface = actualDef instanceof InterfaceDefinition && dt == DependencyType.INHERITANCE;
        if (!isInterface) {
            if (from != to) {
                HashMap<Object, Object> reqs;
                if (this.requires.containsKey(from)) {
                    reqs = this.requires.get(from);
                } else {
                    reqs = new HashMap();
                    this.requires.put(from, reqs);
                }
                if (reqs.containsKey(qname)) {
                    if (reqs.get(qname) != DependencyType.INHERITANCE && !this.isExternalLinkage(to)) {
                        reqs.put(qname, dt);
                    }
                } else if (!this.isExternalLinkage(to) || qname.equals("Namespace")) {
                    if (qname.equals("XML")) {
                        this.needXML = true;
                    }
                    reqs.put(qname, dt);
                }
                if (this.jsModules.containsKey(from)) {
                    reqs = this.jsModules.get(from);
                } else {
                    reqs = new HashMap();
                    this.jsModules.put(from, reqs);
                }
                IMetaTag tag = this.getJSModuleMetadata(to);
                if (tag != null) {
                    IMetaTagAttribute nameAttribute = tag.getAttribute("name");
                    if (nameAttribute != null) {
                        reqs.put(nameAttribute.getValue(), dt);
                    } else {
                        reqs.put(qname, dt);
                    }
                }
            }
        } else if (from != to) {
            HashMap<Object, Object> interfacesArr;
            if (this.interfaces.containsKey(from)) {
                interfacesArr = this.interfaces.get(from);
            } else {
                interfacesArr = new HashMap();
                this.interfaces.put(from, interfacesArr);
            }
            if (!interfacesArr.containsKey(qname)) {
                interfacesArr.put(qname, qname);
            }
        }
        super.addDependency(from, to, dt, qname);
    }

    private IMetaTag getJSModuleMetadata(ICompilationUnit cu) {
        try {
            for (IDefinition def : ((IFileScopeRequestResult)cu.getFileScopeRequest().get()).getExternallyVisibleDefinitions()) {
                if (!def.hasMetaTagByName("JSModule")) continue;
                return def.getMetaTagByName("JSModule");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isExternalLinkage(ICompilationUnit cu) {
        if (this.linkageChecker == null) {
            this.ts = this.getTargetSettings();
            this.linkageChecker = new LinkageChecker((ICompilerProject)this, this.ts);
        }
        if (this.ts == null) {
            if (this.unitTestExterns != null) {
                try {
                    if (!(cu instanceof SWCCompilationUnit) && this.unitTestExterns.contains(cu.getQualifiedNames().get(0))) {
                        return true;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        try {
            List qnames = cu.getQualifiedNames();
            String qname = (String)qnames.get(0);
            if (qname.equals("QName") || qname.equals("XML") || qname.equals("XMLList")) {
                return false;
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            return this.linkageChecker.isExternal(cu);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ArrayList<String> getInterfaces(ICompilationUnit from) {
        if (this.interfaces.containsKey(from)) {
            HashMap<String, String> map = this.interfaces.get(from);
            ArrayList<String> arr = new ArrayList<String>();
            Set<String> cus = map.keySet();
            for (String s : cus) {
                arr.add(s);
            }
            return arr;
        }
        return null;
    }

    public ArrayList<String> getRequires(ICompilationUnit from) {
        if (this.requires.containsKey(from)) {
            HashMap<String, DependencyType> map = this.requires.get(from);
            ArrayList<String> arr = new ArrayList<String>();
            Set<String> cus = map.keySet();
            for (String s : cus) {
                arr.add(s);
            }
            return arr;
        }
        return null;
    }

    public ArrayList<String> getExternalRequires(ICompilationUnit from) {
        if (this.jsModules.containsKey(from)) {
            HashMap<String, DependencyType> map = this.jsModules.get(from);
            ArrayList<String> arr = new ArrayList<String>();
            Set<String> cus = map.keySet();
            for (String s : cus) {
                arr.add(s);
            }
            return arr;
        }
        return null;
    }

    public CSSCompilationSession getCSSCompilationSession() {
        return this.cssSession;
    }

    public void addToASTCache(IASNode ast) {
        this.astCache.put(ast, "");
    }

    public void setTargetSettings(ITargetSettings value) {
        super.setTargetSettings(value);
        this.ts = value;
        this.linkageChecker = new LinkageChecker((ICompilerProject)this, value);
        try {
            this.linkageChecker.initExterns();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getGeneratedIDBase() {
        return MXMLRoyaleEmitterTokens.ID_PREFIX.getToken();
    }

    public ITargetAttributes computeTargetAttributes() {
        try {
            List names = this.mainCU.getQualifiedNames();
            IDefinition def = this.resolveQNameToDefinition((String)names.get(0));
            IDefinitionNode node = def.getNode();
            if (node instanceof MXMLDocumentNode) {
                MXMLDocumentNode mxmlDoc = (MXMLDocumentNode)node;
                MXMLFileNode mxmlFile = (MXMLFileNode)mxmlDoc.getParent();
                return mxmlFile.getTargetAttributes((ICompilerProject)this);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IBackend getBackend() {
        return this.backend;
    }

    protected void overrideDefines(Map<String, String> defines) {
        if (defines.containsKey("COMPILE::SWF") && defines.get("COMPILE::SWF").equals("AUTO")) {
            defines.put("COMPILE::SWF", "false");
        }
        if (defines.containsKey("COMPILE::JS") && defines.get("COMPILE::JS").equals("AUTO")) {
            defines.put("COMPILE::JS", "true");
        }
    }

    public List<String> getCompilerExternalLibraryPath(Configuration config) {
        List<String> list = ((JSConfiguration)config).getCompilerJsExternalLibraryPath();
        if (list != null && list.size() > 0) {
            return list;
        }
        return config.getCompilerExternalLibraryPath();
    }

    public List<String> getCompilerLibraryPath(Configuration config) {
        List<String> list = ((JSConfiguration)config).getCompilerJsLibraryPath();
        if (list != null && list.size() > 0) {
            return list;
        }
        return config.getCompilerLibraryPath();
    }

    public List<MXMLNamespaceMapping> getCompilerNamespacesManifestMappings(Configuration config) {
        List<MXMLNamespaceMapping> list = ((JSConfiguration)config).getCompilerJsNamespacesManifestMappings();
        if (list != null && list.size() > 0) {
            return list;
        }
        return config.getCompilerNamespacesManifestMappings();
    }

    public boolean isPlatformRule(ICSSRule rule) {
        ImmutableList mqlist = rule.getMediaQueryConditions();
        int n = mqlist.size();
        return n <= 0 || !((ICSSMediaQueryCondition)mqlist.get(0)).toString().equals("-royale-swf");
    }

    public void addExportedName(String name) {
        this.exportedNames.add(name);
    }

    public Set<String> getExportedNames() {
        return this.exportedNames;
    }

    public boolean isModule(String mainClass) {
        IResolvedQualifiersReference iModuleRef = ReferenceFactory.packageQualifiedReference((IWorkspace)this.getWorkspace(), (String)"org.apache.royale.core.IModule");
        ITypeDefinition moddef = (ITypeDefinition)iModuleRef.resolve((ICompilerProject)this);
        IResolvedQualifiersReference mainRef = ReferenceFactory.packageQualifiedReference((IWorkspace)this.getWorkspace(), (String)mainClass);
        IDefinition maindef = mainRef.resolve((ICompilerProject)this);
        if (maindef instanceof ITypeDefinition) {
            ITypeDefinition type = (ITypeDefinition)maindef;
            return type.isInstanceOf(moddef, (ICompilerProject)this);
        }
        return false;
    }
}

