/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.graph;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.DependencyTypeSet;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.driver.js.JSCompilationUnit;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.projects.DependencyGraph;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.problems.FileNotFoundProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCFileEntry;

public class GoogDepsWriter {
    private ProblemQuery problems;
    private String outputFolderPath;
    private String mainName;
    private List<String> otherPaths;
    private List<ISWC> swcs;
    private boolean removeCirculars = false;
    private ArrayList<GoogDep> dps;
    private DependencyGraph graph;
    private CompilerProject project;
    private HashMap<String, GoogDep> depMap = new HashMap();
    private HashMap<String, ICompilationUnit> requireMap = new HashMap();
    private HashMap<ICompilationUnit, String> requireMap2 = new HashMap();
    public boolean needCSS = false;
    public ArrayList<String> additionalHTML = new ArrayList();
    private HashMap<String, GoogDep> visited = new HashMap();

    public GoogDepsWriter(File outputFolder, String mainClassName, JSGoogConfiguration config, List<ISWC> swcs) {
        this.outputFolderPath = outputFolder.getAbsolutePath();
        this.mainName = mainClassName;
        this.removeCirculars = config.getRemoveCirculars();
        this.otherPaths = config.getSDKJSLib();
        this.otherPaths.add(new File(outputFolder.getParent(), "royale/Royale/src").getPath());
        this.swcs = swcs;
        for (ISWC swc : swcs) {
            System.out.println("using SWC: " + swc.getSWCFile().getAbsolutePath());
        }
    }

    public ArrayList<String> getListOfFiles(CompilerProject project, ProblemQuery problems) {
        this.project = project;
        this.problems = problems;
        if (this.dps == null) {
            this.buildDB();
            this.dps = this.sort();
        }
        this.visited.clear();
        ArrayList<String> files = new ArrayList<String>();
        for (GoogDep gd : this.dps) {
            files.add(gd.filePath);
            this.visited.put(gd.className, gd);
        }
        if (this.removeCirculars) {
            GoogDep mainDep = this.depMap.get(this.mainName);
            this.visited.put(this.mainName, mainDep);
            for (GoogDep gd : this.depMap.values()) {
                if (this.visited.containsKey(gd.className)) continue;
                files.add(gd.filePath);
            }
            files.add(mainDep.filePath);
        }
        return files;
    }

    public String generateDeps(CompilerProject project, ProblemQuery problems) throws FileNotFoundException {
        this.project = project;
        this.problems = problems;
        if (this.dps == null) {
            this.buildDB();
            this.dps = this.sort();
        }
        StringBuilder sb = new StringBuilder();
        int n = this.dps.size();
        for (int i = n - 1; i >= 0; --i) {
            GoogDep gd = this.dps.get(i);
            if (this.isGoogClass(gd.className)) continue;
            if (this.removeCirculars) {
                sb.append("goog.addDependency('").append(this.relativePath(gd.filePath)).append("', ['").append(gd.className).append("'], [").append(gd.fileInfo.impls != null ? this.getDependencies(gd.fileInfo.impls) : "").append("]);\n");
                continue;
            }
            sb.append("goog.addDependency('").append(this.relativePath(gd.filePath)).append("', ['").append(gd.className).append("'], [").append(this.getDependencies(gd.deps)).append("]);\n");
        }
        if (this.removeCirculars) {
            StringBuilder mainDeps = new StringBuilder();
            GoogDep mainDep = this.depMap.get(this.mainName);
            mainDeps.append("goog.addDependency('").append(this.relativePath(mainDep.filePath)).append("', ['").append(mainDep.className).append("'], [");
            ArrayList<String> restOfDeps = new ArrayList<String>();
            DependencyTypeSet dependencyTypes = DependencyTypeSet.allOf();
            for (GoogDep gd : this.depMap.values()) {
                if (gd.className.equals(this.mainName)) {
                    if (gd.fileInfo.impls == null) continue;
                    for (String d : gd.fileInfo.impls) {
                        if (restOfDeps.contains(d)) continue;
                        restOfDeps.add(d);
                    }
                    continue;
                }
                ICompilationUnit unit = this.requireMap.get(gd.className);
                if (unit == null) {
                    if (restOfDeps.contains(gd.className)) continue;
                    restOfDeps.add(gd.className);
                    continue;
                }
                Set deps = this.graph.getDirectReverseDependencies(unit, dependencyTypes);
                if (deps.size() != 0 || restOfDeps.contains(gd.className)) continue;
                restOfDeps.add(gd.className);
            }
            mainDeps.append(this.getDependencies(restOfDeps)).append("]);\n");
            sb.insert(0, mainDeps);
            sb.insert(0, "// generated by Royale\n");
            for (String dep : restOfDeps) {
                GoogDep gd = this.depMap.get(dep);
                sb.append("goog.addDependency('").append(this.relativePath(gd.filePath)).append("', ['").append(gd.className).append("'], [").append(gd.fileInfo.impls != null ? this.getDependencies(gd.fileInfo.impls) : "").append("]);\n");
            }
            this.addRestOfDeps(mainDep, restOfDeps);
        }
        return sb.toString();
    }

    private boolean isGoogClass(String className) {
        return className.startsWith("goog.");
    }

    private void buildDB() {
        this.graph = new DependencyGraph();
        this.addDeps(this.mainName);
    }

    private ArrayList<GoogDep> sort() {
        ArrayList<GoogDep> arr = new ArrayList<GoogDep>();
        GoogDep current = this.depMap.get(this.mainName);
        this.sortFunction(current, arr);
        if (this.removeCirculars) {
            ICompilationUnit mainUnit = this.requireMap.get(this.mainName);
            ArrayList<ICompilationUnit> roots = new ArrayList<ICompilationUnit>();
            roots.add(mainUnit);
            this.requireMap.remove(this.mainName);
            List order = this.graph.topologicalSort(this.requireMap.values());
            ArrayList<GoogDep> depsInOrder = new ArrayList<GoogDep>();
            for (ICompilationUnit unit : order) {
                String name = this.requireMap2.get(unit);
                if (this.isGoogClass(name)) continue;
                GoogDep dep = this.depMap.get(name);
                if (dep == null) {
                    System.out.println("No GoogDep for " + name);
                }
                depsInOrder.add(dep);
            }
            return depsInOrder;
        }
        return arr;
    }

    private void sortFunction(GoogDep current, List<GoogDep> arr) {
        ArrayList<String> impls;
        this.visited.put(current.className, current);
        if (this.removeCirculars) {
            this.removeRequires(current);
        }
        System.out.println("Dependencies calculated for '" + current.className + "'");
        Object unit = null;
        if (this.removeCirculars && current.fileInfo.deps == null) {
            return;
        }
        if (this.removeCirculars) {
            unit = this.requireMap.get(current.className);
            if (unit == null) {
                unit = new JSCompilationUnit(this.project, current.filePath, DefinitionPriority.BasePriority.SOURCE_LIST, current.className);
                this.graph.addCompilationUnit(unit);
                this.requireMap.put(current.className, (ICompilationUnit)unit);
                this.requireMap2.put((ICompilationUnit)unit, current.className);
            }
            if (current.fileInfo.staticDeps != null && this.removeCirculars) {
                for (String string : current.fileInfo.staticDeps) {
                    Object base = this.requireMap.get(string);
                    if (base == null) {
                        base = new JSCompilationUnit(this.project, string, DefinitionPriority.BasePriority.SOURCE_LIST, string);
                        this.graph.addCompilationUnit(base);
                        this.requireMap.put(string, (ICompilationUnit)base);
                        this.requireMap2.put((ICompilationUnit)base, string);
                    }
                    System.out.println(current.className + " static initialization depends on " + string);
                    this.graph.addDependency(unit, base, DependencyType.INHERITANCE);
                }
            }
        }
        ArrayList<String> arrayList = impls = current.fileInfo.impls != null ? current.fileInfo.impls : null;
        if (impls != null) {
            for (String className : impls) {
                GoogDep gd;
                if (this.isGoogClass(className) || (gd = this.depMap.get(className)) == null) continue;
                if (this.removeCirculars) {
                    Object base = this.requireMap.get(className);
                    if (base == null) {
                        base = new JSCompilationUnit(this.project, className, DefinitionPriority.BasePriority.SOURCE_LIST, className);
                        this.graph.addCompilationUnit(base);
                        this.requireMap.put(className, (ICompilationUnit)base);
                        this.requireMap2.put((ICompilationUnit)base, className);
                    }
                    System.out.println(current.className + " depends on " + className);
                    this.graph.addDependency(unit, base, DependencyType.INHERITANCE);
                }
                if (this.visited.containsKey(className)) continue;
                this.sortFunction(gd, arr);
            }
        }
        ArrayList<String> arrayList2 = current.deps;
        for (String className : arrayList2) {
            if (this.isGoogClass(className)) continue;
            GoogDep gd = this.depMap.get(className);
            if (this.visited.containsKey(className)) continue;
            this.sortFunction(gd, arr);
        }
        arr.add(current);
    }

    private void addRestOfDeps(GoogDep main, List<String> restOfDeps) {
        try {
            List fileLines = Files.readLines((File)new File(main.filePath), (Charset)Charset.defaultCharset());
            int n = restOfDeps.size();
            for (int i = n - 1; i >= 0; --i) {
                String dep = restOfDeps.get(i);
                fileLines.add(main.fileInfo.googProvideLine + 1, JSGoogEmitterTokens.GOOG_REQUIRE.getToken() + "('" + dep + "');");
            }
            File file = new File(main.filePath);
            PrintWriter out = new PrintWriter(new FileWriter(file));
            for (String s : fileLines) {
                out.println(s);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addDeps(String className) {
        if (this.depMap.containsKey(className) || this.isGoogClass(className) || this.isExternal(className)) {
            return;
        }
        GoogDep gd = new GoogDep();
        gd.className = className;
        gd.filePath = this.getFilePath(className);
        if (gd.filePath.isEmpty()) {
            throw new RuntimeException("Unable to find JavaScript filePath for class: " + className);
        }
        this.depMap.put(gd.className, gd);
        try {
            FileInfo fi;
            List fileLines = Files.readLines((File)new File(gd.filePath), (Charset)Charset.defaultCharset());
            gd.fileInfo = fi = this.getFileInfo(fileLines, className);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (gd.fileInfo.impls != null) {
            for (String dep : gd.fileInfo.impls) {
                if (gd.fileInfo.provides != null && gd.fileInfo.provides.contains(dep)) continue;
                this.addDeps(dep);
            }
        }
        gd.deps = new ArrayList();
        if (gd.fileInfo.deps != null) {
            for (String dep : gd.fileInfo.deps) {
                gd.deps.add(dep);
                if (gd.fileInfo.provides != null && gd.fileInfo.provides.contains(dep)) continue;
                this.addDeps(dep);
            }
        }
    }

    void removeRequires(GoogDep gd) {
        String className = gd.className;
        try {
            gd = this.depMap.get(className);
            List fileLines = Files.readLines((File)new File(gd.filePath), (Charset)Charset.defaultCharset());
            ArrayList<String> finalLines = new ArrayList<String>();
            boolean firstDependency = true;
            StringBuilder sb = new StringBuilder();
            sb.append(JSGoogEmitterTokens.ROYALE_DEPENDENCY_LIST.getToken());
            FileInfo fi = gd.fileInfo;
            int suppressCount = 0;
            int i = 0;
            int stopLine = fi.constructorLine;
            if (fi.constructorLine == -1) {
                stopLine = fi.googProvideLine + 4;
            }
            for (String line : fileLines) {
                if (i < stopLine) {
                    int c = line.indexOf(JSGoogEmitterTokens.ROYALE_DEPENDENCY_LIST.getToken());
                    if (c > -1) {
                        return;
                    }
                    c = line.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                    if (c > -1) {
                        int c2 = line.indexOf(")");
                        String s = line.substring(c + 14, c2 - 1);
                        if (!(gd.fileInfo.impls != null && gd.fileInfo.impls.contains(s) || gd.fileInfo.staticDeps != null && gd.fileInfo.staticDeps.contains(s))) {
                            ++suppressCount;
                            System.out.println(gd.filePath + " removing require: " + s);
                            if (!firstDependency) {
                                sb.append(",");
                            }
                            sb.append(s);
                            firstDependency = false;
                            continue;
                        }
                    }
                }
                finalLines.add(line);
                ++i;
            }
            if (suppressCount > 0) {
                if (fi.suppressLine > 0) {
                    if (fi.suppressLine < fi.constructorLine) {
                        String line = (String)finalLines.get(fi.suppressLine);
                        int c = line.indexOf("@suppress {");
                        if (c > -1) {
                            if (!line.contains("missingRequire")) {
                                line = line.substring(0, c) + "@suppress {missingRequire|" + line.substring(c + 11);
                                finalLines.remove(fi.suppressLine);
                                finalLines.add(fi.suppressLine, line);
                            }
                        } else {
                            System.out.println("Confused by @suppress in " + className);
                        }
                    } else if (fi.fileoverviewLine > -1) {
                        finalLines.add(fi.fileoverviewLine + 1, " *  @suppress {missingRequire}");
                    } else if (fi.googProvideLine > -1) {
                        finalLines.add(fi.googProvideLine, " */");
                        finalLines.add(fi.googProvideLine, " *  @suppress {missingRequire}");
                        finalLines.add(fi.googProvideLine, " *  @fileoverview");
                        finalLines.add(fi.googProvideLine, "/**");
                    } else {
                        System.out.println("Confused by @suppress in " + className);
                    }
                } else if (fi.fileoverviewLine > -1) {
                    finalLines.add(fi.fileoverviewLine + 1, " *  @suppress {missingRequire}");
                } else if (fi.googProvideLine > -1) {
                    finalLines.add(fi.googProvideLine, " */");
                    finalLines.add(fi.googProvideLine, " *  @suppress {missingRequire}");
                    finalLines.add(fi.googProvideLine, " *  @fileoverview");
                    finalLines.add(fi.googProvideLine, "/**");
                } else {
                    System.out.println("Confused by @suppress in " + className);
                }
            }
            sb.append("*/");
            finalLines.add(gd.fileInfo.googProvideLine + 1, sb.toString());
            File file = new File(gd.filePath);
            PrintWriter out = new PrintWriter(new FileWriter(file));
            for (String s : finalLines) {
                out.println(s);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    FileInfo getFileInfo(List<String> lines, String className) {
        FileInfo fi = new FileInfo();
        int numProvides = 0;
        int constructorCount = 0;
        int n = lines.size();
        fi.constructorLine = -1;
        fi.suppressLine = -1;
        fi.fileoverviewLine = -1;
        fi.googProvideLine = -1;
        boolean inInjectHTML = false;
        for (int i = 0; i < n; ++i) {
            String impl;
            int c2;
            String line = lines.get(i);
            int c = line.indexOf("*/");
            if (c > -1 && constructorCount > 0 && constructorCount == numProvides) {
                return fi;
            }
            if (inInjectHTML) {
                if (line.indexOf("</inject_html>") > -1) {
                    inInjectHTML = false;
                    continue;
                }
                if ((line = line.trim()).startsWith("*")) {
                    line = line.substring(1);
                }
                this.additionalHTML.add(line);
                continue;
            }
            c = line.indexOf("<inject_html>");
            if (c > -1) {
                inInjectHTML = true;
            }
            if ((c = line.indexOf("@constructor")) > -1) {
                if (fi.constructorLine == -1) {
                    fi.constructorLine = i;
                }
                ++constructorCount;
                continue;
            }
            c = line.indexOf("@interface");
            if (c > -1) {
                fi.constructorLine = i;
                continue;
            }
            c = line.indexOf("@suppress");
            if (c > -1) {
                fi.suppressLine = i;
                continue;
            }
            c = line.indexOf("@fileoverview");
            if (c > -1) {
                fi.fileoverviewLine = i;
                continue;
            }
            c = line.indexOf("goog.provide");
            if (c > -1) {
                if (fi.googProvideLine == -1) {
                    fi.googProvideLine = i;
                }
                if (numProvides > 0) {
                    if (fi.provides == null) {
                        fi.provides = new ArrayList();
                    }
                    c2 = line.indexOf(")", c);
                    String provide = line.substring(c + 14, c2 - 1);
                    fi.provides.add(provide);
                }
                ++numProvides;
                continue;
            }
            c = line.indexOf("@implements");
            if (c > -1) {
                if (fi.impls == null) {
                    fi.impls = new ArrayList();
                }
                c2 = line.indexOf("}", c);
                impl = line.substring(c + 13, c2);
                fi.impls.add(impl);
                if (!impl.equals("org.apache.royale.core.ICSSImpl")) continue;
                this.needCSS = true;
                continue;
            }
            c = line.indexOf("@extends");
            if (c > -1) {
                if (fi.impls == null) {
                    fi.impls = new ArrayList();
                }
                c2 = line.indexOf("}", c);
                impl = line.substring(c + 10, c2);
                fi.impls.add(impl);
                continue;
            }
            String token = JSGoogEmitterTokens.ROYALE_STATIC_DEPENDENCY_LIST.getToken();
            c = line.indexOf(token);
            if (c > -1) {
                c2 = line.indexOf("*/");
                line = line.substring(c + token.length(), c2);
                fi.staticDeps = new ArrayList();
                fi.staticDeps.addAll(Arrays.asList(line.split(",")));
                continue;
            }
            token = JSGoogEmitterTokens.ROYALE_DEPENDENCY_LIST.getToken();
            c = line.indexOf(token);
            if (c > -1) {
                c2 = line.indexOf("*/");
                line = line.substring(c + token.length(), c2);
                fi.deps = new ArrayList();
                if (line.length() > 2) {
                    fi.deps.addAll(Arrays.asList(line.split(",")));
                }
                fi.depsLine = i;
                continue;
            }
            if (fi.depsLine != 0 || (c = line.indexOf(token = JSGoogEmitterTokens.GOOG_REQUIRE.getToken())) <= -1) continue;
            c2 = line.indexOf(")");
            String s = line.substring(c + 14, c2 - 1);
            if (fi.deps == null) {
                fi.deps = new ArrayList();
            }
            fi.deps.add(s);
        }
        return fi;
    }

    String getFilePath(String className) {
        String fn;
        File f;
        String classPath = className.replace(".", File.separator);
        if (className.equals(this.mainName)) {
            classPath = className;
        }
        if ((f = new File(fn = this.outputFolderPath + File.separator + classPath + ".js")).exists()) {
            return fn;
        }
        for (String otherPath : this.otherPaths) {
            fn = otherPath + File.separator + classPath + ".js";
            f = new File(fn);
            if (!f.exists()) continue;
            fn = this.outputFolderPath + File.separator + classPath + ".js";
            File destFile = new File(fn);
            try {
                File assetsDir;
                FileUtils.copyFile((File)f, (File)destFile);
                if (className.contains("org.apache.royale") && (assetsDir = new File(f.getParentFile(), "assets")).exists()) {
                    String nameOfClass = className.substring(className.lastIndexOf(95) + 1);
                    File[] assetsList = assetsDir.listFiles();
                    assert (assetsList != null);
                    for (File assetFile : assetsList) {
                        String assetFileName = assetFile.getName();
                        if (!assetFile.isFile() || assetFileName.indexOf(nameOfClass) != 0) continue;
                        String pathOfClass = className.substring(0, className.lastIndexOf(95));
                        pathOfClass = pathOfClass.replace(".", File.separator);
                        destFile = new File(this.outputFolderPath + File.separator + pathOfClass + File.separator + "assets" + File.separator + assetFileName);
                        FileUtils.copyFile((File)assetFile, (File)destFile);
                        destFile = new File(this.outputFolderPath.replace("js-debug", "js-release") + File.separator + pathOfClass + File.separator + "assets" + File.separator + assetFileName);
                        FileUtils.copyFile((File)assetFile, (File)destFile);
                        System.out.println("Copied assets of the '" + nameOfClass + "' class");
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Error copying file for class: " + className);
            }
            return fn;
        }
        String fwdClassPath = className.replace(".", "/");
        String bckClassPath = className.replace(".", "\\");
        for (ISWC swc : this.swcs) {
            ISWCFileEntry fileEntry = swc.getFile("js/src/" + fwdClassPath + ".js");
            if (fileEntry == null) {
                fileEntry = swc.getFile("js/out/" + fwdClassPath + ".js");
            }
            if (fileEntry == null) {
                fileEntry = swc.getFile("js/src/" + bckClassPath + ".js");
            }
            if (fileEntry == null) {
                fileEntry = swc.getFile("js/out/" + bckClassPath + ".js");
            }
            if (fileEntry == null) {
                fileEntry = swc.getFile("js\\src\\" + bckClassPath + ".js");
            }
            if (fileEntry == null) {
                fileEntry = swc.getFile("js\\out\\" + bckClassPath + ".js");
            }
            if (fileEntry == null) continue;
            fn = this.outputFolderPath + File.separator + classPath + ".js";
            File destFile = new File(fn);
            try {
                int bytes_read;
                InputStream inStream = fileEntry.createInputStream();
                FileOutputStream outStream = FileUtils.openOutputStream((File)destFile);
                byte[] b = new byte[0x100000];
                while ((bytes_read = inStream.read(b)) != -1) {
                    ((OutputStream)outStream).write(b, 0, bytes_read);
                }
                outStream.flush();
                ((OutputStream)outStream).close();
                inStream.close();
                if (className.contains("org.apache.royale")) {
                    Map includedfiles = swc.getFiles();
                    Set includedList = includedfiles.keySet();
                    for (String included : includedList) {
                        if (!included.contains(".png") && !included.contains(".gif") && !included.contains(".jpg") && !included.contains(".jpeg") && !included.contains(".svg") && !included.contains(".json")) continue;
                        fileEntry = (ISWCFileEntry)includedfiles.get(included);
                        String assetName = this.outputFolderPath + File.separator + included;
                        File assetFile = new File(assetName);
                        inStream = fileEntry.createInputStream();
                        outStream = FileUtils.openOutputStream((File)assetFile);
                        b = new byte[inStream.available()];
                        inStream.read(b);
                        ((OutputStream)outStream).write(b);
                        inStream.close();
                        outStream.flush();
                        ((OutputStream)outStream).close();
                        System.out.println("Copied asset " + assetName);
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Error copying file for class: " + className);
            }
            return fn;
        }
        System.out.println("Could not find file for class: " + className);
        this.problems.add((ICompilerProblem)new FileNotFoundProblem(className));
        return "";
    }

    protected void otherScanning(String s) {
    }

    private String getDependencies(ArrayList<String> deps) {
        String s = "";
        for (String dep : deps) {
            if (s.length() > 0) {
                s = s + ", ";
            }
            s = s + "'" + dep + "'";
        }
        return s;
    }

    String relativePath(String path) {
        if (path.indexOf(this.outputFolderPath) == 0) {
            path = path.replace(this.outputFolderPath, "../../..");
        } else {
            for (String otherPath : this.otherPaths) {
                if (path.indexOf(otherPath) != 0) continue;
                path = path.replace(otherPath, "../../..");
            }
        }
        path = path.replace('\\', '/');
        return path;
    }

    boolean isExternal(String className) {
        ICompilationUnit cu = this.project.resolveQNameToCompilationUnit(className);
        if (cu == null) {
            return false;
        }
        return ((RoyaleJSProject)this.project).isExternalLinkage(cu);
    }

    private class FileInfo {
        public ArrayList<String> impls;
        public ArrayList<String> deps;
        public ArrayList<String> staticDeps;
        public ArrayList<String> provides;
        public int constructorLine;
        public int depsLine;
        public int suppressLine;
        public int fileoverviewLine;
        public int googProvideLine;

        private FileInfo() {
        }
    }

    private class GoogDep {
        public String filePath;
        public String className;
        public ArrayList<String> deps;
        public FileInfo fileInfo;

        private GoogDep() {
        }
    }
}

