/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.driver.js.royale;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSMediaQueryCondition;
import org.apache.royale.compiler.css.ICSSProperty;
import org.apache.royale.compiler.css.ICSSPropertyValue;
import org.apache.royale.compiler.css.ICSSRule;
import org.apache.royale.compiler.css.ICSSSelector;
import org.apache.royale.compiler.css.ICSSSelectorCondition;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.css.CSSArrayPropertyValue;
import org.apache.royale.compiler.internal.css.CSSColorPropertyValue;
import org.apache.royale.compiler.internal.css.CSSFontFace;
import org.apache.royale.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.royale.compiler.internal.css.CSSKeywordPropertyValue;
import org.apache.royale.compiler.internal.css.CSSMultiValuePropertyValue;
import org.apache.royale.compiler.internal.css.CSSNumberPropertyValue;
import org.apache.royale.compiler.internal.css.CSSProperty;
import org.apache.royale.compiler.internal.css.CSSRgbColorPropertyValue;
import org.apache.royale.compiler.internal.css.CSSRgbaColorPropertyValue;
import org.apache.royale.compiler.internal.css.CSSStringPropertyValue;
import org.apache.royale.compiler.internal.css.CSSURLAndFormatPropertyValue;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;

public class JSCSSCompilationSession
extends CSSCompilationSession {
    private List<String> otherCSSFunctions = Arrays.asList("-moz-linear-gradient", "-webkit-linear-gradient", "linear-gradient", "progid:DXImageTransform.Microsoft.gradient", "translateX", "translateY", "translate");
    private ArrayList<String> requires;
    List<String> htmlElementNames = Arrays.asList("body", "button", "span");

    public String getEncodedCSS() {
        ICSSDocument css = this.synthesisNormalizedCSS();
        StringBuilder sb = new StringBuilder();
        this.requires = new ArrayList();
        this.encodeCSS(css, sb);
        if (sb.length() == 0) {
            return null;
        }
        sb.append("];\n");
        for (String r : this.requires) {
            sb.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken() + "('" + this.formatQualifiedName(r) + "');\n");
        }
        return sb.toString();
    }

    public String emitCSS() {
        ICSSDocument css = this.synthesisNormalizedCSS();
        StringBuilder sb = new StringBuilder();
        sb.append("/* Generated by Apache Royale Compiler */\n");
        this.walkCSS(css, sb);
        return sb.toString();
    }

    private String fontFaceToString(CSSFontFace fontFace) {
        StringBuilder result = new StringBuilder();
        result.append("@font-face {\n");
        result.append("    ");
        result.append("font-family: ");
        result.append(fontFace.getFontFamily() + ";\n");
        result.append("    ");
        result.append("font-style: ");
        result.append(fontFace.getFontStyle() + ";\n");
        result.append("    ");
        result.append("font-weight: ");
        result.append(fontFace.getFontStyle() + ";\n");
        result.append("    ");
        ArrayList sources = fontFace.getSources();
        for (ICSSPropertyValue src : sources) {
            result.append("src: ");
            result.append(src.toString() + ";\n");
        }
        result.append("}\n");
        return result.toString();
    }

    private String cssRuleToString(ICSSRule rule) {
        boolean hasMediaQuery;
        StringBuilder result = new StringBuilder();
        ImmutableList mqList = rule.getMediaQueryConditions();
        boolean bl = hasMediaQuery = !mqList.isEmpty();
        if (hasMediaQuery) {
            result.append("@media ");
            result.append(Joiner.on((String)" and ").join((Iterable)rule.getMediaQueryConditions()));
            result.append(" {\n");
            result.append("    ");
        }
        ImmutableList selectors = rule.getSelectorGroup();
        boolean firstOne = true;
        for (ICSSSelector selector : selectors) {
            String s = selector.toString();
            if (!(s.startsWith(".") || s.startsWith("*") || s.startsWith("#"))) {
                String condition = null;
                int colon = s.indexOf(":");
                if (colon != -1) {
                    condition = s.substring(colon);
                    s = s.substring(0, colon);
                }
                if (!this.htmlElementNames.contains(s.toLowerCase())) {
                    int pipe = s.indexOf("|");
                    if (pipe != -1) {
                        s = s.substring(pipe + 1);
                    }
                    s = "." + s;
                }
                if (condition != null) {
                    s = s + condition;
                }
            }
            if (!firstOne) {
                result.append(",\n");
            }
            result.append(s);
        }
        result.append(" {\n");
        for (ICSSProperty prop : rule.getProperties()) {
            String propString;
            if (!hasMediaQuery) {
                result.append("    ");
            }
            if ((propString = ((CSSProperty)prop).toCSSString()).contains("ClassReference")) continue;
            result.append("    ").append(propString).append("\n");
        }
        if (hasMediaQuery) {
            result.append("    }\n");
        }
        result.append("}\n");
        return result.toString();
    }

    private void walkCSS(ICSSDocument css, StringBuilder sb) {
        for (CSSFontFace fontFace : this.fontFaces) {
            sb.append(this.fontFaceToString(fontFace));
        }
        if (this.fontFaces.size() > 0) {
            sb.append("\n\n");
        }
        ImmutableList rules = css.getRules();
        for (ICSSRule rule : rules) {
            String s = this.cssRuleToString(rule);
            if (s.startsWith("@media -royale-swf")) continue;
            if (s.startsWith(".global {")) {
                s = s.replace(".global {", "* {");
            }
            sb.append(s);
            sb.append("\n\n");
        }
    }

    private void encodeCSS(ICSSDocument css, StringBuilder sb) {
        ImmutableList rules = css.getRules();
        boolean skipcomma = true;
        for (ICSSRule rule : rules) {
            String s = this.encodeRule(rule);
            if (s == null) continue;
            if (skipcomma) {
                skipcomma = false;
            } else {
                sb.append(",\n");
            }
            sb.append(s);
        }
    }

    private String encodeRule(ICSSRule rule) {
        StringBuilder result = new StringBuilder();
        ImmutableList mqlist = rule.getMediaQueryConditions();
        int n = mqlist.size();
        if (n > 0) {
            if (((ICSSMediaQueryCondition)mqlist.get(0)).toString().equals("-royale-swf")) {
                return null;
            }
            result.append(n);
            for (UnmodifiableIterator mqcond : mqlist) {
                result.append(",\n");
                result.append("\"" + mqcond.toString() + "\"");
            }
        } else {
            result.append(n);
        }
        result.append(",\n");
        ImmutableList slist = rule.getSelectorGroup();
        result.append(slist.size());
        for (ICSSSelector sel : slist) {
            result.append(",\n");
            String selName = (String)this.resolvedSelectors.get(sel);
            if (selName == null || selName.equals("null")) {
                result.append("\"" + sel.toString() + "\"");
                continue;
            }
            selName = this.formatQualifiedName(selName);
            ImmutableList conds = sel.getConditions();
            for (ICSSSelectorCondition cond : conds) {
                selName = selName + cond.toString();
            }
            result.append("\"" + selName + "\"");
        }
        result.append(",\n");
        result.append("function() {");
        ImmutableList plist = rule.getProperties();
        boolean firstProp = true;
        for (ICSSProperty prop : plist) {
            String keywordString;
            CSSKeywordPropertyValue keywordValue;
            ImmutableList values;
            if (!firstProp) {
                result.append(";\n");
            }
            firstProp = false;
            result.append("this[\"" + prop.getName() + "\"] = ");
            ICSSPropertyValue value = prop.getValue();
            if (value instanceof CSSArrayPropertyValue) {
                values = ((CSSArrayPropertyValue)value).getElements();
                result.append("[");
                boolean firstone = true;
                for (ICSSPropertyValue val : values) {
                    if (firstone) {
                        firstone = false;
                    } else {
                        result.append(", ");
                    }
                    if (val instanceof CSSStringPropertyValue) {
                        result.append("\"" + ((CSSStringPropertyValue)val).getValue() + "\"");
                        continue;
                    }
                    if (val instanceof CSSColorPropertyValue) {
                        result.append(new Integer(((CSSColorPropertyValue)val).getColorAsInt()));
                        continue;
                    }
                    if (val instanceof CSSRgbColorPropertyValue) {
                        result.append(new Integer(((CSSRgbColorPropertyValue)val).getColorAsInt()));
                        continue;
                    }
                    if (value instanceof CSSRgbaColorPropertyValue) {
                        result.append(new Integer(((CSSRgbaColorPropertyValue)value).getColorAsInt()));
                        continue;
                    }
                    if (val instanceof CSSKeywordPropertyValue) {
                        keywordValue = (CSSKeywordPropertyValue)val;
                        keywordString = keywordValue.getKeyword();
                        if ("true".equals(keywordString)) {
                            result.append("true");
                            continue;
                        }
                        if ("false".equals(keywordString)) {
                            result.append("false");
                            continue;
                        }
                        result.append("\"" + ((CSSKeywordPropertyValue)val).getKeyword() + "\"");
                        continue;
                    }
                    if (val instanceof CSSNumberPropertyValue) {
                        result.append(new Double(((CSSNumberPropertyValue)val).getNumber().doubleValue()));
                        continue;
                    }
                    if (val instanceof CSSURLAndFormatPropertyValue) {
                        result.append("\"" + ((CSSURLAndFormatPropertyValue)val).toString() + "\"");
                        continue;
                    }
                    if (val instanceof CSSMultiValuePropertyValue) {
                        result.append("\"" + ((CSSMultiValuePropertyValue)val).toString() + "\"");
                        continue;
                    }
                    result.append("unexpected value type: " + val.toString());
                }
                result.append("]");
                continue;
            }
            if (value instanceof CSSMultiValuePropertyValue) {
                values = ((CSSMultiValuePropertyValue)value).getElements();
                result.append("[");
                boolean firstone = true;
                for (ICSSPropertyValue val : values) {
                    if (firstone) {
                        firstone = false;
                    } else {
                        result.append(", ");
                    }
                    if (val instanceof CSSStringPropertyValue) {
                        result.append("\"" + ((CSSStringPropertyValue)val).getValue() + "\"");
                        continue;
                    }
                    if (val instanceof CSSColorPropertyValue) {
                        result.append(new Integer(((CSSColorPropertyValue)val).getColorAsInt()));
                        continue;
                    }
                    if (val instanceof CSSRgbColorPropertyValue) {
                        result.append(new Integer(((CSSRgbColorPropertyValue)val).getColorAsInt()));
                        continue;
                    }
                    if (value instanceof CSSRgbaColorPropertyValue) {
                        result.append(new Integer(((CSSRgbaColorPropertyValue)value).getColorAsInt()));
                        continue;
                    }
                    if (val instanceof CSSKeywordPropertyValue) {
                        keywordValue = (CSSKeywordPropertyValue)val;
                        keywordString = keywordValue.getKeyword();
                        if ("true".equals(keywordString)) {
                            result.append("true");
                            continue;
                        }
                        if ("false".equals(keywordString)) {
                            result.append("false");
                            continue;
                        }
                        result.append("\"" + ((CSSKeywordPropertyValue)val).getKeyword() + "\"");
                        continue;
                    }
                    if (val instanceof CSSNumberPropertyValue) {
                        result.append(new Double(((CSSNumberPropertyValue)val).getNumber().doubleValue()));
                        continue;
                    }
                    if (val instanceof CSSURLAndFormatPropertyValue) {
                        result.append("\"" + ((CSSURLAndFormatPropertyValue)val).toString() + "\"");
                        continue;
                    }
                    if (val instanceof CSSMultiValuePropertyValue) {
                        result.append("\"" + ((CSSMultiValuePropertyValue)val).toString() + "\"");
                        continue;
                    }
                    result.append("unexpected value type: " + val.toString());
                }
                result.append("]");
                continue;
            }
            if (value instanceof CSSStringPropertyValue) {
                result.append("\"" + ((CSSStringPropertyValue)value).getValue() + "\"");
                continue;
            }
            if (value instanceof CSSColorPropertyValue) {
                result.append(new Integer(((CSSColorPropertyValue)value).getColorAsInt()));
                continue;
            }
            if (value instanceof CSSRgbColorPropertyValue) {
                result.append(new Integer(((CSSRgbColorPropertyValue)value).getColorAsInt()));
                continue;
            }
            if (value instanceof CSSRgbaColorPropertyValue) {
                result.append(new Integer(((CSSRgbaColorPropertyValue)value).getColorAsInt()));
                continue;
            }
            if (value instanceof CSSKeywordPropertyValue) {
                CSSKeywordPropertyValue keywordValue2 = (CSSKeywordPropertyValue)value;
                String keywordString2 = keywordValue2.getKeyword();
                if ("true".equals(keywordString2)) {
                    result.append("true");
                    continue;
                }
                if ("false".equals(keywordString2)) {
                    result.append("false");
                    continue;
                }
                result.append("\"" + ((CSSKeywordPropertyValue)value).getKeyword() + "\"");
                continue;
            }
            if (value instanceof CSSNumberPropertyValue) {
                result.append(new Double(((CSSNumberPropertyValue)value).getNumber().doubleValue()));
                continue;
            }
            if (!(value instanceof CSSFunctionCallPropertyValue)) continue;
            CSSFunctionCallPropertyValue functionCall = (CSSFunctionCallPropertyValue)value;
            if ("ClassReference".equals(functionCall.name)) {
                String className = CSSFunctionCallPropertyValue.getSingleArgumentFromRaw((String)functionCall.rawArguments);
                if ("null".equals(className)) {
                    result.append("null");
                    continue;
                }
                result.append(this.formatQualifiedName(className));
                this.requires.add(className);
                continue;
            }
            if ("url".equals(functionCall.name)) {
                String urlString = CSSFunctionCallPropertyValue.getSingleArgumentFromRaw((String)functionCall.rawArguments);
                result.append("\"" + urlString + "\"");
                continue;
            }
            if ("PropertyReference".equals(functionCall.name)) continue;
            if ("calc".equals(functionCall.name)) {
                result.append("null");
                continue;
            }
            if ("Embed".equals(functionCall.name)) continue;
            if (this.otherCSSFunctions.contains(functionCall.name)) {
                result.append("null");
                continue;
            }
            assert (false) : "CSS parser bug: unexpected function call property value: " + functionCall;
            throw new IllegalStateException("Unexpected function call property value: " + functionCall);
        }
        result.append("}");
        return result.toString();
    }

    protected boolean keepRule(ICSSRule newRule) {
        if (super.keepRule(newRule)) {
            return true;
        }
        String sp = newRule.getSourcePath();
        return !sp.contains("defaults.css");
    }

    private String formatQualifiedName(String name) {
        return name;
    }
}

