/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.mxml.royale;

import com.google.common.base.Joiner;
import com.google.debugging.sourcemap.FilePosition;
import java.io.File;
import java.io.FilterWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.compiler.codegen.as.IASEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.IMappingEmitter;
import org.apache.royale.compiler.codegen.mxml.royale.IMXMLRoyaleEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.databinding.BindingDatabase;
import org.apache.royale.compiler.internal.codegen.databinding.BindingInfo;
import org.apache.royale.compiler.internal.codegen.databinding.FunctionWatcherInfo;
import org.apache.royale.compiler.internal.codegen.databinding.PropertyWatcherInfo;
import org.apache.royale.compiler.internal.codegen.databinding.StaticPropertyWatcherInfo;
import org.apache.royale.compiler.internal.codegen.databinding.WatcherInfoBase;
import org.apache.royale.compiler.internal.codegen.databinding.XMLWatcherInfo;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.PackageFooterEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.codegen.mxml.MXMLEmitter;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLDescriptorSpecifier;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLEventSpecifier;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.driver.js.royale.JSCSSCompilationSession;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.targets.ITargetAttributes;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDocumentNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLArrayNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassNode;
import org.apache.royale.compiler.tree.mxml.IMXMLComponentNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDeclarationsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;
import org.apache.royale.compiler.tree.mxml.IMXMLEventSpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLFactoryNode;
import org.apache.royale.compiler.tree.mxml.IMXMLImplementsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLLiteralNode;
import org.apache.royale.compiler.tree.mxml.IMXMLMetadataNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLObjectNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLScriptNode;
import org.apache.royale.compiler.tree.mxml.IMXMLSingleDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLSpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStateNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStringNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStyleSpecifierNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.utils.NativeUtils;
import org.apache.royale.compiler.visitor.mxml.IMXMLBlockWalker;
import org.apache.royale.swc.ISWC;

public class MXMLRoyaleEmitter
extends MXMLEmitter
implements IMXMLRoyaleEmitter,
IMappingEmitter {
    private ArrayList<MXMLDescriptorSpecifier> currentInstances;
    private ArrayList<MXMLDescriptorSpecifier> currentPropertySpecifiers;
    private ArrayList<MXMLDescriptorSpecifier> descriptorTree;
    private MXMLDescriptorSpecifier propertiesTree;
    private MXMLDescriptorSpecifier currentStateOverrides;
    private ArrayList<MXMLEventSpecifier> events;
    private ArrayList<MXMLDescriptorSpecifier> instances;
    private ArrayList<MXMLDescriptorSpecifier> allInstances = new ArrayList();
    private ArrayList<IMXMLScriptNode> scripts;
    private IClassDefinition classDefinition;
    private IClassDefinition documentDefinition;
    private ArrayList<String> usedNames = new ArrayList();
    private ArrayList<IMXMLMetadataNode> metadataNodes = new ArrayList();
    private int eventCounter;
    private int idCounter;
    private int bindingCounter;
    private boolean inMXMLContent;
    private boolean inStatesOverride;
    private boolean makingSimpleArray;
    private StringBuilder subDocuments = new StringBuilder();
    private ArrayList<String> subDocumentNames = new ArrayList();
    private String interfaceList;
    private boolean emitExports = true;
    protected Map<IMXMLNode, Integer> nodeToIndexMap;
    private IMappingEmitter.SourceMapMapping lastMapping;
    private List<IMappingEmitter.SourceMapMapping> sourceMapMappings;
    private HashMap<IMXMLEventSpecifierNode, String> eventHandlerNameMap = new HashMap();

    @Override
    public List<IMappingEmitter.SourceMapMapping> getSourceMapMappings() {
        return this.sourceMapMappings;
    }

    public MXMLRoyaleEmitter(FilterWriter out) {
        super(out);
        this.sourceMapMappings = new ArrayList<IMappingEmitter.SourceMapMapping>();
    }

    @Override
    public String postProcess(String output) {
        ICompilerProject project;
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        ArrayList<String> asEmitterUsedNames = ((JSRoyaleEmitter)asEmitter).usedNames;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        String currentClassName = fjs.getModel().getCurrentClass().getQualifiedName();
        ArrayList<String> removals = new ArrayList<String>();
        for (String usedName : asEmitterUsedNames) {
            if (!usedName.startsWith(currentClassName + ".") || !this.subDocumentNames.contains(usedName.substring(currentClassName.length() + 1))) continue;
            removals.add(usedName);
        }
        for (String usedName : removals) {
            asEmitterUsedNames.remove(usedName);
        }
        System.out.println(currentClassName + " as: " + asEmitterUsedNames.toString());
        System.out.println(currentClassName + " mxml: " + this.usedNames.toString());
        this.usedNames.addAll(asEmitterUsedNames);
        boolean foundXML = false;
        String[] lines = output.split("\n");
        ArrayList<String> finalLines = new ArrayList<String>();
        int endRequires = -1;
        boolean sawRequires = false;
        boolean stillSearching = true;
        ArrayList<String> namesToAdd = new ArrayList<String>();
        ArrayList<String> foundRequires = new ArrayList<String>();
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            String line = lines[i];
            if (stillSearching) {
                int c = line.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                if (c > -1) {
                    int c2 = line.indexOf(")");
                    String s = line.substring(c + 14, c2 - 1);
                    if (s.equals("XML")) {
                        foundXML = true;
                    }
                    sawRequires = true;
                    foundRequires.add(s);
                    if (!this.usedNames.contains(s)) {
                        this.removeLineFromMappings(i);
                        continue;
                    }
                } else if (sawRequires) {
                    ICompilerProject project2 = this.getMXMLWalker().getProject();
                    RoyaleJSProject royaleProject = null;
                    if (project2 instanceof RoyaleJSProject) {
                        royaleProject = (RoyaleJSProject)project2;
                    }
                    stillSearching = false;
                    for (String usedName : this.usedNames) {
                        if (foundRequires.contains(usedName) || usedName.equals(this.classDefinition.getQualifiedName()) || ((JSRoyaleEmitter)asEmitter).getModel().isInternalClass(usedName) || this.subDocumentNames.contains(usedName) || royaleProject != null && royaleProject.isExternalLinkage(royaleProject.resolveQNameToCompilationUnit(usedName))) continue;
                        namesToAdd.add(usedName);
                    }
                    for (String nameToAdd : namesToAdd) {
                        finalLines.add(this.createRequireLine(nameToAdd, false));
                        this.addLineToMappings(i);
                    }
                    endRequires = finalLines.size();
                }
            }
            finalLines.add(line);
        }
        boolean needXML = ((RoyaleJSProject)((IMXMLBlockWalker)this.getMXMLWalker()).getProject()).needXML;
        if (needXML && !foundXML) {
            StringBuilder appendString = new StringBuilder();
            appendString.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
            appendString.append(ASEmitterTokens.PAREN_OPEN.getToken());
            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
            appendString.append("XML");
            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
            appendString.append(ASEmitterTokens.PAREN_CLOSE.getToken());
            appendString.append(ASEmitterTokens.SEMICOLON.getToken());
            finalLines.add(endRequires, appendString.toString());
            this.addLineToMappings(endRequires);
            ++endRequires;
        }
        if ((project = this.getMXMLWalker().getProject()) instanceof RoyaleJSProject) {
            RoyaleJSProject royaleProject = (RoyaleJSProject)project;
            if (royaleProject.mainCU != null) {
                String mainDef = null;
                try {
                    mainDef = (String)royaleProject.mainCU.getQualifiedNames().get(0);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                String thisDef = this.documentDefinition.getQualifiedName();
                if (mainDef != null && mainDef.equals(thisDef)) {
                    int n;
                    ITargetAttributes attrs;
                    MXMLFileNode mxmlFile;
                    MXMLDocumentNode mXMLDocumentNode;
                    HashMap<String, String> aliases;
                    String infoInject = "\n\n" + thisDef + ".prototype.info = function() {\n  return { ";
                    String sep = "";
                    TreeSet<String> mixins = royaleProject.mixinClassNames;
                    if (mixins.size() > 0) {
                        String mixinInject = "mixins: [";
                        boolean firstOne = true;
                        for (String string : mixins) {
                            if (this.isExternal(string)) continue;
                            if (!firstOne) {
                                mixinInject = mixinInject + ", ";
                            }
                            mixinInject = mixinInject + string;
                            firstOne = false;
                            StringBuilder appendString = new StringBuilder();
                            appendString.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_OPEN.getToken());
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append(string);
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                            appendString.append(ASEmitterTokens.SEMICOLON.getToken());
                            finalLines.add(endRequires, appendString.toString());
                            this.addLineToMappings(endRequires);
                            ++endRequires;
                        }
                        mixinInject = mixinInject + "]";
                        infoInject = infoInject + mixinInject;
                        sep = ",\n";
                    }
                    if ((aliases = royaleProject.remoteClassAliasMap) != null && aliases.size() > 0) {
                        String aliasInject = "remoteClassAliases: {";
                        boolean firstOne = true;
                        for (String className : aliases.keySet()) {
                            if (this.isExternal(className)) continue;
                            if (!firstOne) {
                                aliasInject = aliasInject + ", ";
                            }
                            aliasInject = aliasInject + "\"" + className + "\": ";
                            String alias = (String)aliases.get(className);
                            aliasInject = aliasInject + "\"" + alias + "\"";
                            firstOne = false;
                        }
                        aliasInject = aliasInject + "}";
                        infoInject = infoInject + aliasInject;
                        sep = ",\n";
                    }
                    boolean isMX = false;
                    List swcs = royaleProject.getLibraries();
                    for (ISWC swc : swcs) {
                        if (!swc.getSWCFile().getName().equalsIgnoreCase("MX.swc")) continue;
                        isMX = true;
                        break;
                    }
                    if (isMX && (mXMLDocumentNode = (MXMLDocumentNode)this.documentDefinition.getNode()) != null && (mxmlFile = (MXMLFileNode)mXMLDocumentNode.getParent()) != null && (attrs = mxmlFile.getTargetAttributes((ICompilerProject)royaleProject)) != null && attrs.getUsePreloader() != null) {
                        String preloaderInject = sep + "usePreloader" + ": ";
                        preloaderInject = preloaderInject + (attrs.getUsePreloader() == Boolean.TRUE ? "true" : "false");
                        sep = ",\n";
                        infoInject = infoInject + preloaderInject;
                    }
                    infoInject = infoInject + "}};";
                    finalLines.add(infoInject);
                    boolean bl = false;
                    while ((n = infoInject.indexOf(10, n)) != -1) {
                        this.addLineToMappings(finalLines.size());
                        ++n;
                    }
                    String cssInject = "\n\n" + thisDef + ".prototype.cssData = [";
                    JSCSSCompilationSession cssSession = (JSCSSCompilationSession)royaleProject.getCSSCompilationSession();
                    String s = cssSession.getEncodedCSS();
                    if (s != null) {
                        int n2;
                        int reqidx = s.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                        if (reqidx != -1) {
                            String[] cssRequireLines;
                            String cssRequires = s.substring(reqidx);
                            s = s.substring(0, reqidx - 1);
                            for (String require : cssRequireLines = cssRequires.split("\n")) {
                                finalLines.add(endRequires, require);
                                this.addLineToMappings(endRequires);
                                ++endRequires;
                            }
                        }
                        cssInject = cssInject + s;
                        finalLines.add(cssInject);
                        boolean bl2 = false;
                        while ((n2 = cssInject.indexOf(10, n2)) != -1) {
                            this.addLineToMappings(finalLines.size());
                            ++n2;
                        }
                    }
                }
            }
        }
        return Joiner.on((String)"\n").join(finalLines);
    }

    @Override
    public void startMapping(ISourceLocation node) {
        this.startMapping(node, node.getLine(), node.getColumn());
    }

    @Override
    public void startMapping(ISourceLocation node, int line, int column) {
        IASNode parentNode;
        if (this.isBufferWrite()) {
            return;
        }
        if (this.lastMapping != null) {
            FilePosition sourceStartPosition = this.lastMapping.sourceStartPosition;
            throw new IllegalStateException("Cannot start new mapping when another mapping is already started. Previous mapping at Line " + sourceStartPosition.getLine() + " and Column " + sourceStartPosition.getColumn() + " in file " + this.lastMapping.sourcePath);
        }
        String sourcePath = node.getSourcePath();
        if (sourcePath == null && node instanceof IASNode && (parentNode = ((IASNode)node).getParent()) != null) {
            this.startMapping((ISourceLocation)parentNode, line, column);
            return;
        }
        IMappingEmitter.SourceMapMapping mapping = new IMappingEmitter.SourceMapMapping();
        mapping.sourcePath = sourcePath;
        mapping.sourceStartPosition = new FilePosition(line, column);
        mapping.destStartPosition = new FilePosition(this.getCurrentLine(), this.getCurrentColumn());
        this.lastMapping = mapping;
    }

    @Override
    public void startMapping(ISourceLocation node, ISourceLocation afterNode) {
        this.startMapping(node, afterNode.getEndLine(), afterNode.getEndColumn());
    }

    @Override
    public void endMapping(ISourceLocation node) {
        if (this.isBufferWrite()) {
            return;
        }
        if (this.lastMapping == null) {
            throw new IllegalStateException("Cannot end mapping when a mapping has not been started");
        }
        this.lastMapping.destEndPosition = new FilePosition(this.getCurrentLine(), this.getCurrentColumn());
        this.sourceMapMappings.add(this.lastMapping);
        this.lastMapping = null;
    }

    protected void addLineToMappings(int lineIndex) {
        for (IMappingEmitter.SourceMapMapping mapping : this.sourceMapMappings) {
            FilePosition destStartPosition = mapping.destStartPosition;
            int startLine = destStartPosition.getLine();
            if (startLine <= lineIndex) continue;
            mapping.destStartPosition = new FilePosition(startLine + 1, destStartPosition.getColumn());
            FilePosition destEndPosition = mapping.destEndPosition;
            mapping.destEndPosition = new FilePosition(destEndPosition.getLine() + 1, destEndPosition.getColumn());
        }
    }

    protected void removeLineFromMappings(int lineIndex) {
        for (IMappingEmitter.SourceMapMapping mapping : this.sourceMapMappings) {
            FilePosition destStartPosition = mapping.destStartPosition;
            int startLine = destStartPosition.getLine();
            if (startLine <= lineIndex) continue;
            mapping.destStartPosition = new FilePosition(startLine - 1, destStartPosition.getColumn());
            FilePosition destEndPosition = mapping.destEndPosition;
            mapping.destEndPosition = new FilePosition(destEndPosition.getLine() - 1, destEndPosition.getColumn());
        }
    }

    @Override
    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSRoyaleEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    @Override
    public void emitDeclarations(IMXMLDeclarationsNode node) {
        this.inMXMLContent = true;
        MXMLDescriptorSpecifier currentInstance = this.getCurrentDescriptor("i");
        MXMLDescriptorSpecifier currentPropertySpecifier = new MXMLDescriptorSpecifier();
        currentPropertySpecifier.isProperty = true;
        currentPropertySpecifier.name = "mxmlContent";
        currentPropertySpecifier.parent = currentInstance;
        this.descriptorTree.add(currentPropertySpecifier);
        this.moveDown(false, currentInstance, currentPropertySpecifier);
        super.emitDeclarations(node);
        this.moveUp(false, false);
        this.inMXMLContent = false;
    }

    @Override
    public void emitDocument(IMXMLDocumentNode node) {
        IClassDefinition cdef;
        RoyaleJSProject fjp = (RoyaleJSProject)this.getMXMLWalker().getProject();
        if (fjp.config != null) {
            this.emitExports = fjp.config.getExportPublicSymbols();
        }
        this.descriptorTree = new ArrayList();
        this.propertiesTree = new MXMLDescriptorSpecifier();
        this.events = new ArrayList();
        this.instances = new ArrayList();
        this.scripts = new ArrayList();
        this.currentInstances = new ArrayList();
        this.currentStateOverrides = new MXMLDescriptorSpecifier();
        this.currentPropertySpecifiers = new ArrayList();
        this.eventCounter = 0;
        this.idCounter = 0;
        this.bindingCounter = 0;
        this.classDefinition = cdef = node.getClassDefinition();
        this.documentDefinition = cdef;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        fjs.getModel().setCurrentClass(cdef);
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.getMXMLWalker().walk(node.getChild(i));
        }
        String cname = node.getFileNode().getName();
        this.emitHeader(node);
        this.emitClassDeclStart(cname, node.getBaseClassName(), false);
        this.emitComplexInitializers((IASNode)node);
        this.emitPropertyDecls();
        this.emitClassDeclEnd(cname, node.getBaseClassName());
        this.write(this.subDocuments.toString());
        this.writeNewline();
        this.emitScripts();
        fjs.getBindableEmitter().emit(cdef);
        fjs.getAccessorEmitter().emit(cdef);
        this.emitEvents(cname);
        this.emitComplexStaticInitializers((IASNode)node);
        this.emitPropertyGetterSetters(cname);
        this.emitMXMLDescriptorFuncs(cname);
        this.emitBindingData(cname, cdef);
        this.emitMetaData(cdef);
        this.emitSourceMapDirective((ITypeNode)node);
    }

    public void emitSubDocument(IMXMLComponentNode node) {
        IClassDefinition cdef;
        ArrayList<MXMLDescriptorSpecifier> oldDescriptorTree = this.descriptorTree;
        this.descriptorTree = new ArrayList();
        MXMLDescriptorSpecifier oldPropertiesTree = this.propertiesTree;
        this.propertiesTree = new MXMLDescriptorSpecifier();
        boolean oldInMXMLContent = this.inMXMLContent;
        this.inMXMLContent = false;
        ArrayList<MXMLEventSpecifier> oldEvents = this.events;
        this.events = new ArrayList();
        ArrayList<MXMLDescriptorSpecifier> oldInstances = this.instances;
        this.instances = new ArrayList();
        ArrayList<IMXMLScriptNode> oldScripts = this.scripts;
        this.scripts = new ArrayList();
        ArrayList<MXMLDescriptorSpecifier> oldCurrentInstances = this.currentInstances;
        this.currentInstances = new ArrayList();
        ArrayList<MXMLDescriptorSpecifier> oldCurrentPropertySpecifiers = this.currentPropertySpecifiers;
        this.currentPropertySpecifiers = new ArrayList();
        int oldEventCounter = this.eventCounter;
        this.eventCounter = 0;
        int oldIdCounter = this.idCounter;
        this.idCounter = 0;
        IClassDefinition oldClassDef = this.classDefinition;
        this.classDefinition = cdef = node.getContainedClassDefinition();
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        ((JSRoyaleEmitter)asEmitter).getModel().pushClass(cdef);
        IMXMLClassDefinitionNode classNode = node.getContainedClassDefinitionNode();
        String cname = cdef.getQualifiedName();
        String baseClassName = cdef.getBaseClassAsDisplayString();
        this.subDocumentNames.add(cname);
        int len = classNode.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.getMXMLWalker().walk(classNode.getChild(i));
        }
        ((JSRoyaleEmitter)asEmitter).mxmlEmitter = this;
        this.emitClassDeclStart(cname, baseClassName, false);
        this.emitComplexInitializers((IASNode)classNode);
        this.emitPropertyDecls();
        this.emitClassDeclEnd(cname, baseClassName);
        this.emitMetaData(cdef);
        this.emitScripts();
        this.emitEvents(cname);
        this.emitPropertyGetterSetters(cname);
        this.emitMXMLDescriptorFuncs(cname);
        this.emitBindingData(cname, cdef);
        this.write(((JSRoyaleEmitter)asEmitter).stringifyDefineProperties(cdef));
        this.descriptorTree = oldDescriptorTree;
        this.propertiesTree = oldPropertiesTree;
        this.events = oldEvents;
        this.scripts = oldScripts;
        this.currentInstances = oldCurrentInstances;
        this.allInstances.addAll(this.instances);
        this.instances = oldInstances;
        this.currentPropertySpecifiers = oldCurrentPropertySpecifiers;
        this.eventCounter = oldEventCounter;
        this.idCounter = oldIdCounter;
        this.inMXMLContent = oldInMXMLContent;
        this.classDefinition = oldClassDef;
        ((JSRoyaleEmitter)asEmitter).getModel().popClass();
        ((JSRoyaleEmitter)asEmitter).mxmlEmitter = null;
    }

    @Override
    public void emitMetadata(IMXMLMetadataNode node) {
        this.metadataNodes.add(node);
    }

    public void emitSourceMapDirective(ITypeNode node) {
        IMXMLBlockWalker walker = (IMXMLBlockWalker)this.getMXMLWalker();
        IJSEmitter jsEmitter = (IJSEmitter)walker.getASEmitter();
        jsEmitter.emitSourceMapDirective(node);
    }

    protected void emitClassDeclStart(String cname, String baseClassName, boolean indent) {
        this.writeNewline();
        this.writeNewline("/**");
        this.writeNewline(" * @constructor");
        this.writeNewline(" * @extends {" + this.formatQualifiedName(baseClassName) + "}");
        if (this.interfaceList != null && this.interfaceList.length() > 0) {
            String[] interfaces;
            for (String iface : interfaces = this.interfaceList.split(",")) {
                this.writeNewline(" * @implements {" + this.formatQualifiedName(iface.trim()) + "}");
            }
        }
        this.writeNewline(" */");
        this.writeToken(this.formatQualifiedName(cname));
        this.writeToken(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        if (indent) {
            this.indentPush();
        }
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
        this.write(this.formatQualifiedName(cname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSGoogEmitterTokens.GOOG_BASE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.THIS);
        this.writeToken(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(JSGoogEmitterTokens.GOOG_CONSTRUCTOR);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
    }

    protected void emitClassDeclEnd(String cname, String baseClassName) {
        MXMLDescriptorSpecifier root;
        this.writeNewline();
        this.writeNewline("/**");
        this.writeNewline(" * @private");
        this.writeNewline(" * @type {Array}");
        this.writeNewline(" */");
        this.writeNewline("this.mxmldd;");
        if (this.currentStateOverrides.propertySpecifiers.size() > 0) {
            root = this.currentStateOverrides;
            root.isTopNode = true;
            this.collectExportedNames(root);
            this.writeNewline("/**");
            if (this.emitExports) {
                this.writeNewline(" * @export");
            }
            this.writeNewline(" * @type {Array}");
            this.writeNewline(" */");
            this.writeNewline("this.mxmlsd = " + ASEmitterTokens.SQUARE_OPEN.getToken());
            this.indentPush();
            this.write(root.outputStateDescriptors());
            this.write("null");
            this.write(ASEmitterTokens.SQUARE_CLOSE);
            this.indentPop();
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
        this.writeNewline();
        this.writeNewline("/**");
        this.writeNewline(" * @private");
        this.writeNewline(" * @type {Array}");
        this.writeNewline(" */");
        this.indentPop();
        this.writeNewline("this.mxmldp;");
        if (this.propertiesTree.propertySpecifiers.size() > 0 || this.propertiesTree.eventSpecifiers.size() > 0) {
            this.indentPush();
            this.writeNewline();
            this.writeNewline("this.generateMXMLAttributes");
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.SQUARE_OPEN);
            root = this.propertiesTree;
            root.isTopNode = true;
            this.writeNewline(root.output(true));
            this.collectExportedNames(root);
            this.write(ASEmitterTokens.SQUARE_CLOSE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
            this.indentPop();
            this.writeNewline();
        }
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        this.write(JSGoogEmitterTokens.GOOG_INHERITS);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(this.formatQualifiedName(cname));
        this.writeToken(ASEmitterTokens.COMMA);
        this.write(this.formatQualifiedName(baseClassName));
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        this.writeNewline();
        this.writeNewline();
        this.writeNewline("/**");
        this.writeNewline(" * Prevent renaming of class. Needed for reflection.");
        this.writeNewline(" */");
        this.write(JSRoyaleEmitterTokens.GOOG_EXPORT_SYMBOL);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(this.formatQualifiedName(cname));
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SPACE);
        this.write(this.formatQualifiedName(cname));
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
    }

    protected void emitMetaData(IClassDefinition cdef) {
        String cname = cdef.getQualifiedName();
        this.writeNewline("/**");
        this.writeNewline(" * Metadata");
        this.writeNewline(" *");
        this.writeNewline(" * @type {Object.<string, Array.<Object>>}");
        this.writeNewline(" */");
        this.write(this.formatQualifiedName(cname) + ".prototype.ROYALE_CLASS_INFO = { names: [{ name: '");
        this.write(cdef.getBaseName());
        this.write("', qName: '");
        this.write(this.formatQualifiedName(cname));
        this.write("'");
        this.writeToken(ASEmitterTokens.COMMA);
        this.write(JSRoyaleEmitterTokens.ROYALE_CLASS_INFO_KIND);
        this.writeToken(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(JSRoyaleEmitterTokens.ROYALE_CLASS_INFO_CLASS_KIND);
        this.writeToken(ASEmitterTokens.SINGLE_QUOTE);
        this.write(" }]");
        if (this.interfaceList != null) {
            this.write(", interfaces: [");
            this.write(this.interfaceList);
            this.write("]");
        }
        this.write(" };");
        this.emitReflectionData(cdef);
        this.writeNewline();
        this.writeNewline();
    }

    private void emitReflectionData(IClassDefinition cdef) {
        Object data;
        JSRoyaleEmitter asEmitter = (JSRoyaleEmitter)((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        RoyaleJSProject fjs = (RoyaleJSProject)this.getMXMLWalker().getProject();
        ArrayList<String> exportProperties = new ArrayList<String>();
        ArrayList<String> exportSymbols = new ArrayList<String>();
        Set<Object> exportMetadata = Collections.emptySet();
        if (fjs.config != null) {
            exportMetadata = fjs.config.getCompilerKeepCodeWithMetadata();
        }
        ArrayList<PackageFooterEmitter.VariableData> varData = new ArrayList<PackageFooterEmitter.VariableData>();
        List<IVariableNode> vars = asEmitter.getModel().getVars();
        for (IVariableNode varNode : vars) {
            IMetaTagNode[] iMetaTagNodeArray;
            String qualifiedTypeName;
            String ns = varNode.getNamespace();
            if (ns != "public" || varNode.isConst()) continue;
            Iterator<MXMLDescriptorSpecifier> data3 = new PackageFooterEmitter.VariableData(asEmitter.packageFooterEmitter);
            varData.add((PackageFooterEmitter.VariableData)((Object)data3));
            ((PackageFooterEmitter.VariableData)((Object)data3)).name = varNode.getName();
            ((PackageFooterEmitter.VariableData)((Object)data3)).isStatic = varNode.hasModifier(ASModifier.STATIC);
            ((PackageFooterEmitter.VariableData)((Object)data3)).type = qualifiedTypeName = varNode.getVariableTypeNode().resolveType(this.getMXMLWalker().getProject()).getQualifiedName();
            IMetaTagsNode metaData = varNode.getMetaTags();
            if (metaData == null || (iMetaTagNodeArray = metaData.getAllTags()).length <= 0) continue;
            ((PackageFooterEmitter.VariableData)((Object)data3)).metaData = iMetaTagNodeArray;
            for (IMetaTagNode tag : iMetaTagNodeArray) {
                String tagName = tag.getTagName();
                if (!exportMetadata.contains(tagName)) continue;
                if (((PackageFooterEmitter.VariableData)((Object)data3)).isStatic.booleanValue()) {
                    exportSymbols.add(((PackageFooterEmitter.VariableData)((Object)data3)).name);
                    continue;
                }
                exportProperties.add(((PackageFooterEmitter.VariableData)((Object)data3)).name);
            }
        }
        ArrayList<PackageFooterEmitter.AccessorData> accessorData = new ArrayList<PackageFooterEmitter.AccessorData>();
        HashMap<String, JSSessionModel.PropertyNodes> accessors = asEmitter.getModel().getPropertyMap();
        this.collectAccessors(accessors, accessorData, cdef);
        accessors = asEmitter.getModel().getStaticPropertyMap();
        this.collectAccessors(accessors, accessorData, cdef);
        HashMap<String, JSSessionModel.BindableVarInfo> bindableVars = asEmitter.getModel().getBindableVars();
        for (String varName : bindableVars.keySet()) {
            JSSessionModel.BindableVarInfo bindableVarInfo = bindableVars.get(varName);
            String string = bindableVarInfo.namespace;
            if (string != "public") continue;
            PackageFooterEmitter.AccessorData data2 = new PackageFooterEmitter.AccessorData(asEmitter.packageFooterEmitter);
            accessorData.add(data2);
            data2.name = varName;
            data2.isStatic = bindableVarInfo.isStatic;
            data2.type = bindableVarInfo.type;
            data2.declaredBy = cdef.getQualifiedName();
            data2.access = "readwrite";
            if (bindableVarInfo.metaTags == null || bindableVarInfo.metaTags.length <= 0) continue;
            data2.metaData = bindableVarInfo.metaTags;
        }
        for (MXMLDescriptorSpecifier instance : this.instances) {
            if (instance.id == null) continue;
            data = new PackageFooterEmitter.AccessorData(asEmitter.packageFooterEmitter);
            accessorData.add((PackageFooterEmitter.AccessorData)data);
            ((PackageFooterEmitter.AccessorData)data).name = instance.id;
            ((PackageFooterEmitter.AccessorData)data).type = instance.name;
            ((PackageFooterEmitter.AccessorData)data).access = "readwrite";
            ((PackageFooterEmitter.AccessorData)data).declaredBy = cdef.getQualifiedName();
        }
        ArrayList<PackageFooterEmitter.MethodData> methodData = new ArrayList<PackageFooterEmitter.MethodData>();
        List<IFunctionNode> methods = asEmitter.getModel().getMethods();
        for (IFunctionNode iFunctionNode : methods) {
            IMetaTagNode[] tags;
            IMetaTagsNode metaData;
            String ns = iFunctionNode.getNamespace();
            if (ns != "public") continue;
            PackageFooterEmitter.MethodData data4 = new PackageFooterEmitter.MethodData(asEmitter.packageFooterEmitter);
            methodData.add(data4);
            data4.name = iFunctionNode.getName();
            String qualifiedTypeName = iFunctionNode.getReturnType();
            if (!qualifiedTypeName.equals("") && !qualifiedTypeName.equals("void")) {
                qualifiedTypeName = iFunctionNode.getReturnTypeNode().resolveType((ICompilerProject)fjs).getQualifiedName();
            }
            data4.type = qualifiedTypeName;
            data4.declaredBy = cdef.getQualifiedName();
            data4.isStatic = iFunctionNode.hasModifier(ASModifier.STATIC);
            IParameterNode[] paramNodes = iFunctionNode.getParameterNodes();
            if (paramNodes != null && paramNodes.length > 0) {
                data4.parameters = paramNodes;
            }
            if ((metaData = iFunctionNode.getMetaTags()) == null || (tags = metaData.getAllTags()).length <= 0) continue;
            data4.metaData = tags;
            for (IMetaTagNode tag : tags) {
                String tagName = tag.getTagName();
                if (!exportMetadata.contains(tagName)) continue;
                if (data4.isStatic.booleanValue()) {
                    exportSymbols.add(data4.name);
                    continue;
                }
                exportProperties.add(data4.name);
            }
        }
        if (cdef.getConstructor() == null) {
            data = new PackageFooterEmitter.MethodData(asEmitter.packageFooterEmitter);
            methodData.add((PackageFooterEmitter.MethodData)data);
            ((PackageFooterEmitter.MethodData)data).name = cdef.getBaseName();
            ((PackageFooterEmitter.MethodData)data).type = "";
            ((PackageFooterEmitter.MethodData)data).isStatic = false;
            ((PackageFooterEmitter.MethodData)data).declaredBy = cdef.getQualifiedName();
        }
        for (MXMLEventSpecifier mXMLEventSpecifier : this.events) {
            PackageFooterEmitter.MethodData data2 = new PackageFooterEmitter.MethodData(asEmitter.packageFooterEmitter);
            methodData.add(data2);
            data2.name = mXMLEventSpecifier.eventHandler;
            data2.type = ASEmitterTokens.VOID.getToken();
            data2.declaredBy = cdef.getQualifiedName();
        }
        ArrayList<IMetaTagNode> metadataTagNodes = new ArrayList<IMetaTagNode>();
        for (IMXMLMetadataNode metadataTag : this.metadataNodes) {
            IMetaTagNode[] tags;
            for (IMetaTagNode tag : tags = metadataTag.getMetaTagNodes()) {
                metadataTagNodes.add(tag);
            }
        }
        IMetaTagNode[] iMetaTagNodeArray = new IMetaTagNode[metadataTagNodes.size()];
        asEmitter.packageFooterEmitter.emitReflectionData(this.formatQualifiedName(cdef.getQualifiedName()), PackageFooterEmitter.ReflectionKind.CLASS, varData, accessorData, methodData, metadataTagNodes.toArray(iMetaTagNodeArray));
        asEmitter.packageFooterEmitter.emitExportProperties(this.formatQualifiedName(cdef.getQualifiedName()), exportProperties, exportSymbols);
    }

    private void collectAccessors(HashMap<String, JSSessionModel.PropertyNodes> accessors, ArrayList<PackageFooterEmitter.AccessorData> accessorData, IClassDefinition cdef) {
        JSRoyaleEmitter asEmitter = (JSRoyaleEmitter)((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        RoyaleJSProject fjs = (RoyaleJSProject)this.getMXMLWalker().getProject();
        for (String propName : accessors.keySet()) {
            IMetaTagNode[] tags;
            String ns;
            JSSessionModel.PropertyNodes p = accessors.get(propName);
            IGetterNode accessorNode = p.getter;
            if (accessorNode == null) {
                accessorNode = p.setter;
            }
            if ((ns = accessorNode.getNamespace()) != "public") continue;
            PackageFooterEmitter.AccessorData data = new PackageFooterEmitter.AccessorData(asEmitter.packageFooterEmitter);
            accessorData.add(data);
            data.name = accessorNode.getName();
            data.isStatic = accessorNode.hasModifier(ASModifier.STATIC);
            if (p.getter != null) {
                data.type = p.getter.getReturnTypeNode().resolveType((ICompilerProject)fjs).getQualifiedName();
                data.access = p.setter != null ? "readwrite" : "readonly";
            } else {
                data.type = p.setter.getVariableTypeNode().resolveType((ICompilerProject)fjs).getQualifiedName();
                data.access = "writeonly";
            }
            data.declaredBy = cdef.getQualifiedName();
            IMetaTagsNode metaData = accessorNode.getMetaTags();
            if (metaData == null || (tags = metaData.getAllTags()).length <= 0) continue;
            data.metaData = tags;
        }
    }

    protected void emitPropertyDecls() {
        for (MXMLDescriptorSpecifier instance : this.instances) {
            this.writeNewline();
            this.writeNewline("/**");
            this.writeNewline(" * @private");
            this.writeNewline(" * @type {" + instance.name + "}");
            this.writeNewline(" */");
            this.write(ASEmitterTokens.THIS);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write((instance.id != null ? instance.id : instance.effectiveId) + "_");
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
    }

    protected void emitBindingData(String cname, IClassDefinition cdef) {
        BindingDatabase bd = (BindingDatabase)BindingDatabase.bindingMap.get(cdef);
        if (bd == null) {
            return;
        }
        if (bd.getBindingInfo().isEmpty()) {
            return;
        }
        this.outputBindingInfoAsData(cname, bd);
    }

    private void outputBindingInfoAsData(String cname, BindingDatabase bindingDataBase) {
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        this.writeNewline("/**");
        this.writeNewline(" * @export");
        this.writeNewline(" */");
        this.writeNewline(this.formatQualifiedName(cname) + ".prototype._bindings = [");
        Set bindingInfo = bindingDataBase.getBindingInfo();
        this.writeNewline(bindingInfo.size() + ",");
        for (BindingInfo bi : bindingInfo) {
            String s;
            IMXMLNode node = bi.node;
            if (node instanceof IMXMLSingleDataBindingNode) {
                IMXMLSingleDataBindingNode sbdn = (IMXMLSingleDataBindingNode)node;
                RoyaleJSProject project = (RoyaleJSProject)this.getMXMLWalker().getProject();
                IDefinition bdef = sbdn.getExpressionNode().resolve((ICompilerProject)project);
                if (bdef != null) {
                    IDefinition cdef = bdef.getParent();
                    project.addExportedName(bdef.getBaseName());
                }
            }
            if ((s = bi.getSourceString()) == null && bi.isSourceSimplePublicProperty()) {
                s = this.getSourceStringFromGetter(bi.getExpressionNodesForGetter());
            }
            if (s == null || s.length() == 0) {
                List getterNodes = bi.getExpressionNodesForGetter();
                StringBuilder sb = new StringBuilder();
                sb.append("function() { return ");
                int n = getterNodes.size();
                for (int i = 0; i < n; ++i) {
                    IExpressionNode getterNode = (IExpressionNode)getterNodes.get(i);
                    if (getterNode.getNodeID() == ASTNodeID.LiteralStringID) {
                        sb.append(ASEmitterTokens.DOUBLE_QUOTE.getToken());
                        sb.append(asEmitter.stringifyNode((IASNode)getterNode));
                        sb.append(ASEmitterTokens.DOUBLE_QUOTE.getToken());
                    } else {
                        sb.append(asEmitter.stringifyNode((IASNode)getterNode));
                    }
                    if (i >= n - 1) continue;
                    sb.append(ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.PLUS.getToken() + ASEmitterTokens.SPACE.getToken());
                }
                sb.append("; },");
                this.writeNewline(sb.toString());
            } else if (s.contains(".")) {
                String part;
                String[] parts;
                if (bi.classDef != null) {
                    parts = s.split("\\.");
                    this.write(ASEmitterTokens.SQUARE_OPEN.getToken() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + bi.classDef.getQualifiedName() + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                    this.usedNames.add(bi.classDef.getQualifiedName());
                    int n = parts.length;
                    for (int i = 1; i < n; ++i) {
                        part = parts[i];
                        this.write(", " + ASEmitterTokens.DOUBLE_QUOTE.getToken() + part + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                    }
                    this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
                } else {
                    parts = s.split("\\.");
                    this.write(ASEmitterTokens.SQUARE_OPEN.getToken() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + parts[0] + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                    int n = parts.length;
                    for (int i = 1; i < n; ++i) {
                        part = parts[i];
                        this.write(", " + ASEmitterTokens.DOUBLE_QUOTE.getToken() + part + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                    }
                    this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
                }
            } else {
                this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + s + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
            }
            IExpressionNode destNode = bi.getExpressionNodeForDestination();
            if (destNode != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.generateSetterFunction(destNode));
                this.writeNewline(sb.toString() + ASEmitterTokens.COMMA.getToken());
            } else {
                this.writeNewline(ASEmitterTokens.NULL.getToken() + ASEmitterTokens.COMMA.getToken());
            }
            s = bi.getDestinationString();
            if (s == null) {
                this.writeNewline(ASEmitterTokens.NULL.getToken() + ASEmitterTokens.COMMA.getToken());
                continue;
            }
            if (s.contains(".")) {
                String[] parts = s.split("\\.");
                this.write(ASEmitterTokens.SQUARE_OPEN.getToken() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + parts[0] + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                int n = parts.length;
                for (int i = 1; i < n; ++i) {
                    String part = parts[i];
                    this.write(", " + ASEmitterTokens.DOUBLE_QUOTE.getToken() + part + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                }
                this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
                continue;
            }
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + s + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
        }
        Set watcherChains = bindingDataBase.getWatcherChains();
        if (watcherChains != null) {
            int count = watcherChains.size();
            for (Map.Entry entry : watcherChains) {
                WatcherInfoBase watcherInfoBase = (WatcherInfoBase)entry.getValue();
                this.encodeWatcher(watcherInfoBase);
                if (--count <= 0) continue;
                this.writeNewline(ASEmitterTokens.COMMA);
            }
        }
        this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.SEMICOLON.getToken());
    }

    private String generateSetterFunction(IExpressionNode destNode) {
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        String body = asEmitter.stringifyNode((IASNode)destNode);
        StringBuilder sb = new StringBuilder();
        sb.append("function (value) { ");
        int lastGet = body.lastIndexOf("get_");
        int lastDot = body.lastIndexOf(".");
        if (lastDot == lastGet - 1) {
            String object = body.substring(0, lastDot);
            String getter = body.substring(lastDot);
            String setter = getter.replace("get_", "set_");
            setter = setter.replace("()", "(value)");
            body = object + setter;
            sb.append(body);
        } else {
            sb.append(body);
            sb.append(" = value;");
        }
        sb.append(";}");
        return sb.toString();
    }

    private void encodeWatcher(WatcherInfoBase watcherInfoBase) {
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        this.writeNewline(watcherInfoBase.getIndex() + ASEmitterTokens.COMMA.getToken());
        WatcherInfoBase.WatcherType type = watcherInfoBase.getType();
        if (type == WatcherInfoBase.WatcherType.FUNCTION) {
            this.writeNewline("0" + ASEmitterTokens.COMMA.getToken());
            FunctionWatcherInfo functionWatcherInfo = (FunctionWatcherInfo)watcherInfoBase;
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + functionWatcherInfo.getFunctionName() + ASEmitterTokens.DOUBLE_QUOTE.getToken());
            IExpressionNode[] params = functionWatcherInfo.params;
            StringBuilder sb = new StringBuilder();
            sb.append("function() { return [");
            boolean firstone = true;
            for (IExpressionNode param : params) {
                if (firstone) {
                    firstone = false;
                }
                sb.append(ASEmitterTokens.COMMA.getToken());
                sb.append(asEmitter.stringifyNode((IASNode)param));
            }
            sb.append("]; },");
            this.outputEventNames(functionWatcherInfo.getEventNames());
            this.outputBindings(functionWatcherInfo.getBindings());
        } else if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY || type == WatcherInfoBase.WatcherType.PROPERTY) {
            this.writeNewline((type == WatcherInfoBase.WatcherType.STATIC_PROPERTY ? "1" : "2") + ASEmitterTokens.COMMA.getToken());
            PropertyWatcherInfo propertyWatcherInfo = (PropertyWatcherInfo)watcherInfoBase;
            boolean makeStaticWatcher = watcherInfoBase.getType() == WatcherInfoBase.WatcherType.STATIC_PROPERTY;
            Object propertyGetterFunction = null;
            if (watcherInfoBase.isRoot && !makeStaticWatcher || !watcherInfoBase.isRoot || makeStaticWatcher) {
                // empty if block
            }
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + propertyWatcherInfo.getPropertyName() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
            this.outputEventNames(propertyWatcherInfo.getEventNames());
            this.outputBindings(propertyWatcherInfo.getBindings());
            if (propertyGetterFunction == null) {
                this.writeNewline("null" + ASEmitterTokens.COMMA.getToken());
            }
            if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY) {
                StaticPropertyWatcherInfo pwinfo = (StaticPropertyWatcherInfo)watcherInfoBase;
                Name classMName = pwinfo.getContainingClass(this.getMXMLWalker().getProject());
                this.writeNewline(this.nameToString(classMName) + ASEmitterTokens.COMMA.getToken());
            }
        } else if (type == WatcherInfoBase.WatcherType.XML) {
            this.writeNewline("3" + ASEmitterTokens.COMMA.getToken());
            XMLWatcherInfo xmlWatcherInfo = (XMLWatcherInfo)watcherInfoBase;
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + xmlWatcherInfo.getPropertyName() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
            this.outputBindings(xmlWatcherInfo.getBindings());
        } else assert (false);
        Set children = watcherInfoBase.getChildren();
        if (children != null) {
            this.writeNewline(ASEmitterTokens.SQUARE_OPEN.getToken());
            for (Map.Entry ent : children) {
                this.encodeWatcher((WatcherInfoBase)ent.getValue());
                this.writeNewline(ASEmitterTokens.COMMA);
            }
            this.write("null" + ASEmitterTokens.SQUARE_CLOSE.getToken());
        } else {
            this.write("null");
        }
    }

    private String getSourceStringFromMemberAccessExpressionNode(MemberAccessExpressionNode node) {
        String s = "";
        IExpressionNode left = node.getLeftOperandNode();
        if (left instanceof FunctionCallNode) {
            IASNode child = ((FunctionCallNode)left).getArgumentsNode().getChild(0);
            if (child instanceof IdentifierNode) {
                s = this.getSourceStringFromIdentifierNode((IdentifierNode)child);
            } else if (child instanceof MemberAccessExpressionNode) {
                s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)child);
            }
        } else if (left instanceof MemberAccessExpressionNode) {
            s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)left);
        } else if (left instanceof IdentifierNode) {
            s = this.getSourceStringFromIdentifierNode((IdentifierNode)left);
        } else {
            System.out.println("expected binding member access left node" + node.toString());
        }
        s = s + ".";
        IExpressionNode right = node.getRightOperandNode();
        if (right instanceof FunctionCallNode) {
            IASNode child = ((FunctionCallNode)right).getArgumentsNode().getChild(0);
            if (child instanceof IdentifierNode) {
                s = s + this.getSourceStringFromIdentifierNode((IdentifierNode)child);
            } else if (child instanceof MemberAccessExpressionNode) {
                s = s + this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)child);
            }
        } else if (right instanceof MemberAccessExpressionNode) {
            s = s + this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)right);
        } else if (right instanceof IdentifierNode) {
            s = s + this.getSourceStringFromIdentifierNode((IdentifierNode)right);
        } else {
            System.out.println("expected binding member access right node" + node.toString());
        }
        return s;
    }

    private String getSourceStringFromIdentifierNode(IdentifierNode node) {
        return node.getName();
    }

    private String getSourceStringFromGetter(List<IExpressionNode> nodes) {
        String s = "";
        IExpressionNode node = nodes.get(0);
        if (node instanceof MemberAccessExpressionNode) {
            s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)node);
        } else if (node instanceof IdentifierNode) {
            s = ((IdentifierNode)node).getName();
        }
        return s;
    }

    private void outputEventNames(List<String> events) {
        if (events.size() > 1) {
            int n = events.size();
            this.write(ASEmitterTokens.SQUARE_OPEN.getToken() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + events.get(0) + ASEmitterTokens.DOUBLE_QUOTE.getToken());
            for (int i = 1; i < n; ++i) {
                String event = events.get(i);
                this.write(ASEmitterTokens.COMMA.getToken() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + event + ASEmitterTokens.DOUBLE_QUOTE.getToken());
            }
            this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
        } else if (events.size() == 1) {
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + events.get(0) + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
        } else {
            this.writeNewline("null" + ASEmitterTokens.COMMA.getToken());
        }
    }

    private void outputBindings(List<BindingInfo> bindings) {
        if (bindings.size() > 1) {
            int n = bindings.size();
            this.write(ASEmitterTokens.SQUARE_OPEN.getToken() + bindings.get(0).getIndex());
            for (int i = 1; i < n; ++i) {
                BindingInfo binding = bindings.get(i);
                this.write(ASEmitterTokens.COMMA.getToken() + binding.getIndex());
            }
            this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
        } else if (bindings.size() == 1) {
            this.writeNewline(bindings.get(0).getIndex() + ASEmitterTokens.COMMA.getToken());
        } else {
            this.writeNewline("null" + ASEmitterTokens.COMMA.getToken());
        }
    }

    protected void emitScripts() {
        for (IMXMLScriptNode node : this.scripts) {
            IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
            int len = node.getChildCount();
            if (len <= 0) continue;
            for (int i = 0; i < len; ++i) {
                IASNode cnode = node.getChild(i);
                if (cnode.getNodeID() == ASTNodeID.VariableID) {
                    ((JSRoyaleEmitter)asEmitter).getModel().getVars().add((IVariableNode)cnode);
                } else if (cnode.getNodeID() == ASTNodeID.BindableVariableID) {
                    IMetaTagNode[] tags;
                    IVariableNode variableNode = (IVariableNode)cnode;
                    JSSessionModel.BindableVarInfo bindableVarInfo = new JSSessionModel.BindableVarInfo();
                    bindableVarInfo.isStatic = variableNode.hasModifier(ASModifier.STATIC);
                    bindableVarInfo.namespace = variableNode.getNamespace();
                    IMetaTagsNode metaTags = variableNode.getMetaTags();
                    if (metaTags != null && (tags = metaTags.getAllTags()).length > 0) {
                        bindableVarInfo.metaTags = tags;
                    }
                    bindableVarInfo.type = variableNode.getVariableTypeNode().resolveType(this.getMXMLWalker().getProject()).getQualifiedName();
                    ((JSRoyaleEmitter)asEmitter).getModel().getBindableVars().put(variableNode.getName(), bindableVarInfo);
                }
                if (cnode instanceof IImportNode) continue;
                asEmitter.getWalker().walk(cnode);
                this.write(ASEmitterTokens.SEMICOLON.getToken());
                if (i == len - 1) {
                    this.indentPop();
                }
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
            }
        }
    }

    protected void emitEvents(String cname) {
        for (MXMLEventSpecifier event : this.events) {
            this.writeNewline("/**");
            if (this.emitExports) {
                this.writeNewline(" * @export");
            }
            this.writeNewline(" * @param {" + this.formatQualifiedName(event.type) + "} event");
            this.writeNewline(" */");
            this.writeNewline(this.formatQualifiedName(cname) + ".prototype." + event.eventHandler + " = function(event)");
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
            IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
            IMXMLEventSpecifierNode node = event.node;
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.writeNewline();
                }
                IASNode cnode = node.getChild(i);
                asEmitter.getWalker().walk(cnode);
                this.write(ASEmitterTokens.SEMICOLON);
            }
            this.indentPop();
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
            this.writeNewline();
            this.writeNewline();
        }
    }

    protected void emitPropertyGetterSetters(String cname) {
        int n = 0;
        for (MXMLDescriptorSpecifier instance : this.instances) {
            if (instance.id == null) continue;
            ++n;
        }
        if (n == 0 && this.descriptorTree.size() == 0) {
            return;
        }
        String formattedCName = this.formatQualifiedName(cname);
        this.write("Object.defineProperties(");
        this.write(formattedCName);
        this.writeNewline(".prototype, /** @lends {" + formattedCName + ".prototype} */ {");
        this.indentPush();
        int i = 0;
        for (MXMLDescriptorSpecifier instance : this.instances) {
            if (instance.id == null) continue;
            this.indentPush();
            this.writeNewline("/** @export */");
            this.writeNewline(instance.id + ": {");
            this.writeNewline("/** @this {" + formattedCName + "} */");
            this.indentPush();
            this.writeNewline("get: function() {");
            this.indentPop();
            this.writeNewline("return this." + instance.id + "_;");
            this.writeNewline("},");
            this.writeNewline("/** @this {" + formattedCName + "} */");
            this.indentPush();
            this.writeNewline("set: function(value) {");
            this.indentPush();
            this.writeNewline("if (value != this." + instance.id + "_) {");
            this.writeNewline("this." + instance.id + "_ = value;");
            this.write("this.dispatchEvent(org.apache.royale.events.ValueChangeEvent.createUpdateEvent(this, '");
            this.indentPop();
            this.writeNewline(instance.id + "', null, value));");
            this.indentPop();
            this.writeNewline("}");
            this.indentPop();
            this.writeNewline("}");
            if (i < n - 1 || this.descriptorTree.size() > 0) {
                this.writeNewline("},");
            } else {
                this.indentPop();
                this.writeNewline("}");
            }
            ++i;
        }
        if (this.descriptorTree.size() == 0) {
            this.writeNewline("});");
        }
    }

    protected void emitMXMLDescriptorFuncs(String cname) {
        if (this.descriptorTree.size() > 0) {
            RoyaleJSProject project = (RoyaleJSProject)this.getMXMLWalker().getProject();
            project.needLanguage = true;
            MXMLDescriptorSpecifier root = this.descriptorTree.get(0);
            root.isTopNode = false;
            this.collectExportedNames(root);
            this.indentPush();
            this.writeNewline("'MXMLDescriptor': {");
            this.writeNewline("/** @this {" + this.formatQualifiedName(cname) + "} */");
            this.indentPush();
            this.writeNewline("get: function() {");
            this.indentPush();
            this.writeNewline("{");
            this.writeNewline("if (this.mxmldd == undefined)");
            this.indentPush();
            this.writeNewline("{");
            this.writeNewline("/** @type {Array} */");
            this.writeNewline("var arr = " + this.formatQualifiedName(cname) + ".superClass_.get__MXMLDescriptor.apply(this);");
            this.writeNewline("/** @type {Array} */");
            this.indentPop();
            this.indentPop();
            this.writeNewline("var data = [");
            this.writeNewline(root.output(true));
            this.indentPush();
            this.writeNewline("];");
            this.indentPush();
            this.writeNewline("");
            this.indentPush();
            this.writeNewline("if (arr)");
            this.indentPop();
            this.writeNewline("this.mxmldd = arr.concat(data);");
            this.indentPush();
            this.writeNewline("else");
            this.indentPop();
            this.indentPop();
            this.writeNewline("this.mxmldd = data;");
            this.writeNewline("}");
            this.indentPop();
            this.writeNewline("return this.mxmldd;");
            this.writeNewline("}");
            this.indentPop();
            this.writeNewline("}");
            this.indentPop();
            this.writeNewline("}");
            this.writeNewline("});");
        }
    }

    private void collectExportedNames(MXMLDescriptorSpecifier descriptor) {
        ICompilerProject project = this.getMXMLWalker().getProject();
        RoyaleJSProject royaleProject = null;
        if (project instanceof RoyaleJSProject) {
            royaleProject = (RoyaleJSProject)project;
            String name = descriptor.name;
            if (name == null) {
                name = this.classDefinition.getQualifiedName();
            }
            for (MXMLDescriptorSpecifier prop : descriptor.propertySpecifiers) {
                String propName = prop.name;
                royaleProject.addExportedName(propName);
                if (prop.propertySpecifiers.size() <= 0) continue;
                this.collectExportedNames(prop.propertySpecifiers.get(0));
            }
            if (descriptor.childrenSpecifier != null) {
                for (MXMLDescriptorSpecifier prop : descriptor.childrenSpecifier.propertySpecifiers) {
                    this.collectExportedNames(prop);
                }
            }
        }
    }

    @Override
    public void emitEventSpecifier(IMXMLEventSpecifierNode node) {
        if (this.isStateDependent((IASNode)node) && !this.inStatesOverride) {
            return;
        }
        IDefinition cdef = node.getDefinition();
        MXMLDescriptorSpecifier currentDescriptor = this.getCurrentDescriptor("i");
        MXMLEventSpecifier eventSpecifier = new MXMLEventSpecifier();
        eventSpecifier.eventHandler = MXMLRoyaleEmitterTokens.EVENT_PREFIX.getToken() + this.eventCounter++;
        eventSpecifier.name = cdef.getBaseName();
        eventSpecifier.type = node.getEventParameterDefinition().getTypeAsDisplayString();
        this.eventHandlerNameMap.put(node, eventSpecifier.eventHandler);
        eventSpecifier.node = node;
        if (currentDescriptor != null) {
            currentDescriptor.eventSpecifiers.add(eventSpecifier);
        } else if (!this.inStatesOverride) {
            this.propertiesTree.eventSpecifiers.add(eventSpecifier);
        }
        this.events.add(eventSpecifier);
    }

    @Override
    public void emitInstance(IMXMLInstanceNode node) {
        if (this.isStateDependent((IASNode)node) && !this.inStatesOverride) {
            return;
        }
        IClassDefinition cdef = node.getClassReference(this.getMXMLWalker().getProject());
        MXMLDescriptorSpecifier currentPropertySpecifier = this.getCurrentDescriptor("ps");
        String effectiveId = null;
        String id = node.getID();
        if (id == null && (effectiveId = node.getEffectiveID()) == null) {
            effectiveId = MXMLRoyaleEmitterTokens.ID_PREFIX.getToken() + this.idCounter++;
        }
        MXMLDescriptorSpecifier currentInstance = new MXMLDescriptorSpecifier();
        currentInstance.isProperty = false;
        currentInstance.id = id;
        currentInstance.effectiveId = effectiveId;
        currentInstance.name = this.formatQualifiedName(cdef.getQualifiedName());
        currentInstance.parent = currentPropertySpecifier;
        if (currentPropertySpecifier != null) {
            currentPropertySpecifier.propertySpecifiers.add(currentInstance);
        } else if (this.inMXMLContent) {
            this.descriptorTree.add(currentInstance);
        } else {
            currentInstance.parent = this.propertiesTree;
            this.propertiesTree.propertySpecifiers.add(currentInstance);
        }
        this.instances.add(currentInstance);
        IMXMLPropertySpecifierNode[] pnodes = node.getPropertySpecifierNodes();
        if (pnodes != null) {
            this.moveDown(false, currentInstance, null);
            for (IMXMLPropertySpecifierNode pnode : pnodes) {
                this.getMXMLWalker().walk((IASNode)pnode);
            }
            this.moveUp(false, true);
        } else if (node instanceof IMXMLStateNode) {
            IMXMLStateNode stateNode = (IMXMLStateNode)node;
            String name = stateNode.getStateName();
            if (name != null) {
                MXMLDescriptorSpecifier stateName = new MXMLDescriptorSpecifier();
                stateName.isProperty = true;
                stateName.id = id;
                stateName.name = "name";
                stateName.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + name + ASEmitterTokens.SINGLE_QUOTE.getToken();
                stateName.parent = currentInstance;
                currentInstance.propertySpecifiers.add(stateName);
            }
            MXMLDescriptorSpecifier overrides = new MXMLDescriptorSpecifier();
            overrides.isProperty = true;
            overrides.hasArray = true;
            overrides.id = id;
            overrides.name = "overrides";
            overrides.parent = currentInstance;
            currentInstance.propertySpecifiers.add(overrides);
            this.moveDown(false, null, overrides);
            IMXMLClassDefinitionNode classDefinitionNode = stateNode.getClassDefinitionNode();
            List snodes = classDefinitionNode.getNodesDependentOnState(stateNode.getStateName());
            if (snodes != null) {
                for (int i = snodes.size() - 1; i >= 0; --i) {
                    IMXMLNode inode = (IMXMLNode)snodes.get(i);
                    if (inode.getNodeID() != ASTNodeID.MXMLInstanceID) continue;
                    this.emitInstanceOverride((IMXMLInstanceNode)inode);
                }
                for (IMXMLNode anode : snodes) {
                    switch (anode.getNodeID()) {
                        case MXMLPropertySpecifierID: {
                            this.emitPropertyOverride((IMXMLPropertySpecifierNode)anode);
                            break;
                        }
                        case MXMLStyleSpecifierID: {
                            this.emitStyleOverride((IMXMLStyleSpecifierNode)anode);
                            break;
                        }
                        case MXMLEventSpecifierID: {
                            this.emitEventOverride((IMXMLEventSpecifierNode)anode);
                            break;
                        }
                    }
                }
            }
            this.moveUp(false, false);
        }
        IMXMLEventSpecifierNode[] enodes = node.getEventSpecifierNodes();
        if (enodes != null) {
            this.moveDown(false, currentInstance, null);
            for (IMXMLEventSpecifierNode enode : enodes) {
                this.getMXMLWalker().walk((IASNode)enode);
            }
            this.moveUp(false, true);
        }
    }

    public void emitPropertyOverride(IMXMLPropertySpecifierNode propertyNode) {
        RoyaleProject project = (RoyaleProject)this.getMXMLWalker().getProject();
        Name propertyOverride = project.getPropertyOverrideClassName();
        this.emitPropertyOrStyleOverride(propertyOverride, propertyNode);
    }

    void emitStyleOverride(IMXMLStyleSpecifierNode styleNode) {
        RoyaleProject project = (RoyaleProject)this.getMXMLWalker().getProject();
        Name styleOverride = project.getStyleOverrideClassName();
        this.emitPropertyOrStyleOverride(styleOverride, (IMXMLPropertySpecifierNode)styleNode);
    }

    void emitPropertyOrStyleOverride(Name overrideName, IMXMLPropertySpecifierNode propertyOrStyleNode) {
        MXMLDescriptorSpecifier currentInstance = this.getCurrentDescriptor("ps");
        IASNode parentNode = propertyOrStyleNode.getParent();
        String id = parentNode instanceof IMXMLInstanceNode ? ((IMXMLInstanceNode)parentNode).getEffectiveID() : null;
        String name = propertyOrStyleNode.getName();
        boolean valueIsDataBound = MXMLRoyaleEmitter.isDataBindingNode(propertyOrStyleNode.getChild(0));
        IMXMLInstanceNode propertyOrStyleValueNode = propertyOrStyleNode.getInstanceNode();
        MXMLDescriptorSpecifier setProp = new MXMLDescriptorSpecifier();
        setProp.isProperty = false;
        setProp.name = this.formatQualifiedName(this.nameToString(overrideName));
        setProp.parent = currentInstance;
        currentInstance.propertySpecifiers.add(setProp);
        if (id != null) {
            MXMLDescriptorSpecifier target = new MXMLDescriptorSpecifier();
            target.isProperty = true;
            target.name = "target";
            target.parent = setProp;
            target.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + id + ASEmitterTokens.SINGLE_QUOTE.getToken();
            setProp.propertySpecifiers.add(target);
        }
        MXMLDescriptorSpecifier pname = new MXMLDescriptorSpecifier();
        pname.isProperty = true;
        pname.name = "name";
        pname.parent = setProp;
        pname.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + name + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setProp.propertySpecifiers.add(pname);
        if (!valueIsDataBound) {
            MXMLDescriptorSpecifier value = new MXMLDescriptorSpecifier();
            value.isProperty = true;
            value.name = "value";
            value.parent = setProp;
            setProp.propertySpecifiers.add(value);
            this.moveDown(false, null, value);
            this.getMXMLWalker().walk((IASNode)propertyOrStyleValueNode);
            this.moveUp(false, false);
        } else {
            String overrideID;
            setProp.id = overrideID = MXMLRoyaleEmitterTokens.BINDING_PREFIX.getToken() + this.bindingCounter++;
            this.instances.add(setProp);
            BindingDatabase bd = (BindingDatabase)BindingDatabase.bindingMap.get(this.classDefinition);
            Set bindingInfo = bd.getBindingInfo();
            IMXMLDataBindingNode bindingNode = (IMXMLDataBindingNode)propertyOrStyleNode.getChild(0);
            for (BindingInfo bi : bindingInfo) {
                if (bi.node != bindingNode) continue;
                bi.setDestinationString(overrideID + ".value");
                break;
            }
        }
    }

    void emitEventOverride(IMXMLEventSpecifierNode eventNode) {
        this.inStatesOverride = true;
        MXMLDescriptorSpecifier currentInstance = this.getCurrentDescriptor("ps");
        RoyaleProject project = (RoyaleProject)this.getMXMLWalker().getProject();
        Name eventOverride = project.getEventOverrideClassName();
        IASNode parentNode = eventNode.getParent();
        String id = parentNode instanceof IMXMLInstanceNode ? ((IMXMLInstanceNode)parentNode).getEffectiveID() : "";
        String name = MXMLEventSpecifier.getJSEventName(eventNode.getName());
        String eventHandler = this.eventHandlerNameMap.get(eventNode);
        if (eventHandler == null) {
            this.emitEventSpecifier(eventNode);
            eventHandler = this.eventHandlerNameMap.get(eventNode);
        }
        MXMLDescriptorSpecifier setEvent = new MXMLDescriptorSpecifier();
        setEvent.isProperty = false;
        setEvent.name = this.formatQualifiedName(this.nameToString(eventOverride));
        setEvent.parent = currentInstance;
        currentInstance.propertySpecifiers.add(setEvent);
        MXMLDescriptorSpecifier target = new MXMLDescriptorSpecifier();
        target.isProperty = true;
        target.name = "target";
        target.parent = setEvent;
        target.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + id + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setEvent.propertySpecifiers.add(target);
        MXMLDescriptorSpecifier pname = new MXMLDescriptorSpecifier();
        pname.isProperty = true;
        pname.name = "name";
        pname.parent = setEvent;
        pname.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + name + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setEvent.propertySpecifiers.add(pname);
        MXMLDescriptorSpecifier handler = new MXMLDescriptorSpecifier();
        handler.isProperty = true;
        handler.name = "handlerFunction";
        handler.parent = setEvent;
        handler.value = JSRoyaleEmitterTokens.CLOSURE_FUNCTION_NAME.getToken() + ASEmitterTokens.PAREN_OPEN.getToken() + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + eventHandler + ASEmitterTokens.COMMA.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.COMMA.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.SINGLE_QUOTE.getToken() + eventHandler + ASEmitterTokens.SINGLE_QUOTE.getToken() + ASEmitterTokens.PAREN_CLOSE.getToken();
        setEvent.propertySpecifiers.add(handler);
        this.inStatesOverride = false;
    }

    public void emitInstanceOverride(IMXMLInstanceNode instanceNode) {
        this.inStatesOverride = true;
        MXMLDescriptorSpecifier currentInstance = this.getCurrentDescriptor("ps");
        RoyaleProject project = (RoyaleProject)this.getMXMLWalker().getProject();
        Name instanceOverrideName = project.getInstanceOverrideClassName();
        MXMLDescriptorSpecifier overrideInstances = this.getCurrentDescriptor("so");
        int index = overrideInstances.propertySpecifiers.size();
        if (this.nodeToIndexMap == null) {
            this.nodeToIndexMap = new HashMap<IMXMLNode, Integer>();
        }
        if (this.nodeToIndexMap.containsKey(instanceNode)) {
            index = this.nodeToIndexMap.get(instanceNode);
        } else {
            this.nodeToIndexMap.put((IMXMLNode)instanceNode, index);
            MXMLDescriptorSpecifier itemsDesc = new MXMLDescriptorSpecifier();
            itemsDesc.isProperty = true;
            itemsDesc.hasArray = true;
            itemsDesc.name = "itemsDescriptor";
            itemsDesc.parent = overrideInstances;
            overrideInstances.propertySpecifiers.add(itemsDesc);
            boolean oldInMXMLContent = this.inMXMLContent;
            this.moveDown(false, null, itemsDesc);
            this.inMXMLContent = true;
            this.getMXMLWalker().walk((IASNode)instanceNode);
            this.inMXMLContent = oldInMXMLContent;
            this.moveUp(false, false);
        }
        MXMLDescriptorSpecifier addItems = new MXMLDescriptorSpecifier();
        addItems.isProperty = false;
        addItems.name = this.formatQualifiedName(this.nameToString(instanceOverrideName));
        addItems.parent = currentInstance;
        currentInstance.propertySpecifiers.add(addItems);
        MXMLDescriptorSpecifier itemsDescIndex = new MXMLDescriptorSpecifier();
        itemsDescIndex.isProperty = true;
        itemsDescIndex.hasArray = true;
        itemsDescIndex.name = "itemsDescriptorIndex";
        itemsDescIndex.parent = addItems;
        itemsDescIndex.value = Integer.toString(index);
        addItems.propertySpecifiers.add(itemsDescIndex);
        IMXMLPropertySpecifierNode propertySpecifier = (IMXMLPropertySpecifierNode)instanceNode.getAncestorOfType(IMXMLPropertySpecifierNode.class);
        if (propertySpecifier == null) {
            assert (false);
        } else {
            IASNode parent = propertySpecifier.getParent();
            if (parent instanceof IMXMLInstanceNode) {
                IMXMLInstanceNode parentInstance = (IMXMLInstanceNode)parent;
                String parentId = parentInstance.getEffectiveID();
                assert (parentId != null);
                String propName = propertySpecifier.getName();
                MXMLDescriptorSpecifier dest = new MXMLDescriptorSpecifier();
                dest.isProperty = true;
                dest.name = "destination";
                dest.parent = addItems;
                dest.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + parentId + ASEmitterTokens.SINGLE_QUOTE.getToken();
                addItems.propertySpecifiers.add(dest);
                MXMLDescriptorSpecifier prop = new MXMLDescriptorSpecifier();
                prop.isProperty = true;
                prop.name = "propertyName";
                prop.parent = addItems;
                prop.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + propName + ASEmitterTokens.SINGLE_QUOTE.getToken();
                addItems.propertySpecifiers.add(prop);
            }
        }
        String positionPropertyValue = null;
        String relativeToPropertyValue = null;
        IASNode instanceParent = instanceNode.getParent();
        IASNode prevStatelessSibling = null;
        for (int i = 0; i < instanceParent.getChildCount(); ++i) {
            IASNode sib = instanceParent.getChild(i);
            assert (sib instanceof IMXMLInstanceNode);
            if (sib == instanceNode) break;
            if (!(sib instanceof IMXMLInstanceNode) || this.isStateDependent(sib)) continue;
            prevStatelessSibling = sib;
        }
        if (prevStatelessSibling == null) {
            positionPropertyValue = "first";
        } else {
            positionPropertyValue = "after";
            relativeToPropertyValue = ((IMXMLInstanceNode)prevStatelessSibling).getEffectiveID();
        }
        MXMLDescriptorSpecifier pos = new MXMLDescriptorSpecifier();
        pos.isProperty = true;
        pos.name = "position";
        pos.parent = addItems;
        pos.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + positionPropertyValue + ASEmitterTokens.SINGLE_QUOTE.getToken();
        addItems.propertySpecifiers.add(pos);
        if (relativeToPropertyValue != null) {
            MXMLDescriptorSpecifier rel = new MXMLDescriptorSpecifier();
            rel.isProperty = true;
            rel.name = "relativeTo";
            rel.parent = addItems;
            rel.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + relativeToPropertyValue + ASEmitterTokens.SINGLE_QUOTE.getToken();
            addItems.propertySpecifiers.add(rel);
        }
        this.inStatesOverride = false;
    }

    private String nameToString(Name name) {
        Namespace ns = name.getSingleQualifier();
        String s = ns.getName();
        s = s != "" ? s + ASEmitterTokens.MEMBER_ACCESS.getToken() + name.getBaseName() : name.getBaseName();
        return s;
    }

    protected boolean isStateDependent(IASNode node) {
        if (node instanceof IMXMLSpecifierNode) {
            String suffix = ((IMXMLSpecifierNode)node).getSuffix();
            return suffix != null && suffix.length() > 0;
        }
        return this.isStateDependentInstance(node);
    }

    protected boolean isStateDependentInstance(IASNode node) {
        if (node instanceof IMXMLInstanceNode) {
            String[] includeIn = ((IMXMLInstanceNode)node).getIncludeIn();
            String[] excludeFrom = ((IMXMLInstanceNode)node).getExcludeFrom();
            return includeIn != null || excludeFrom != null;
        }
        return false;
    }

    public static boolean isDataBindingNode(IASNode node) {
        return node instanceof IMXMLDataBindingNode;
    }

    protected static boolean isDataboundProp(IMXMLPropertySpecifierNode propertyNode) {
        boolean ret = propertyNode.getChildCount() > 0 && MXMLRoyaleEmitter.isDataBindingNode((IASNode)propertyNode.getInstanceNode());
        int n = propertyNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            boolean db = MXMLRoyaleEmitter.isDataBindingNode(propertyNode.getChild(i));
            assert (db == ret);
        }
        return ret;
    }

    @Override
    public void emitPropertySpecifier(IMXMLPropertySpecifierNode node) {
        if (MXMLRoyaleEmitter.isDataboundProp(node)) {
            return;
        }
        if (this.isStateDependent((IASNode)node)) {
            return;
        }
        IDefinition cdef = node.getDefinition();
        IASNode cnode = node.getChild(0);
        MXMLDescriptorSpecifier currentInstance = this.getCurrentDescriptor("i");
        MXMLDescriptorSpecifier currentPropertySpecifier = new MXMLDescriptorSpecifier();
        currentPropertySpecifier.isProperty = true;
        currentPropertySpecifier.name = cdef != null ? cdef.getQualifiedName() : node.getName();
        currentPropertySpecifier.parent = currentInstance;
        boolean oldInMXMLContent = this.inMXMLContent;
        boolean reusingDescriptor = false;
        if (currentPropertySpecifier.name.equals("mxmlContent")) {
            this.inMXMLContent = true;
            ArrayList<MXMLDescriptorSpecifier> specList = currentInstance == null ? this.descriptorTree : currentInstance.propertySpecifiers;
            for (MXMLDescriptorSpecifier ds : specList) {
                if (!ds.name.equals("mxmlContent")) continue;
                currentPropertySpecifier = ds;
                reusingDescriptor = true;
                break;
            }
        }
        if (currentInstance != null) {
            if (!reusingDescriptor) {
                currentInstance.propertySpecifiers.add(currentPropertySpecifier);
            }
        } else if (this.inMXMLContent) {
            if (!reusingDescriptor) {
                this.descriptorTree.add(currentPropertySpecifier);
            }
        } else {
            currentPropertySpecifier.parent = this.propertiesTree;
            this.propertiesTree.propertySpecifiers.add(currentPropertySpecifier);
        }
        boolean valueIsArray = cnode != null && cnode instanceof IMXMLArrayNode;
        boolean valueIsObject = cnode != null && cnode instanceof IMXMLObjectNode;
        currentPropertySpecifier.hasArray = valueIsArray;
        currentPropertySpecifier.hasObject = valueIsObject;
        this.moveDown(valueIsArray || valueIsObject, null, currentPropertySpecifier);
        this.getMXMLWalker().walk(cnode);
        this.moveUp(valueIsArray || valueIsObject, false);
        this.inMXMLContent = oldInMXMLContent;
    }

    @Override
    public void emitScript(IMXMLScriptNode node) {
        this.scripts.add(node);
    }

    @Override
    public void emitStyleSpecifier(IMXMLStyleSpecifierNode node) {
    }

    @Override
    public void emitObject(IMXMLObjectNode node) {
        int len = node.getChildCount();
        if (!this.makingSimpleArray) {
            MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
            if (ps.hasObject) {
                this.emitInstance((IMXMLInstanceNode)node);
                return;
            }
            for (int i = 0; i < len; ++i) {
                this.getMXMLWalker().walk(node.getChild(i));
            }
        } else {
            MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
            if (ps.value == null) {
                ps.value = "";
            }
            ps.value = ps.value + "{";
            for (int i = 0; i < len; ++i) {
                IMXMLPropertySpecifierNode propName = (IMXMLPropertySpecifierNode)node.getChild(i);
                ps.value = ps.value + propName.getName() + ": ";
                this.getMXMLWalker().walk(propName.getChild(0));
                if (i >= len - 1) continue;
                ps.value = ps.value + ", ";
            }
            ps.value = ps.value + "}";
        }
    }

    @Override
    public void emitArray(IMXMLArrayNode node) {
        this.moveDown(false, null, null);
        boolean isSimple = true;
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            IASNode child = node.getChild(i);
            ASTNodeID nodeID = child.getNodeID();
            if (nodeID != ASTNodeID.MXMLArrayID && nodeID != ASTNodeID.MXMLInstanceID && nodeID != ASTNodeID.MXMLStateID) continue;
            isSimple = false;
            break;
        }
        boolean oldMakingSimpleArray = this.makingSimpleArray;
        MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        if (isSimple) {
            this.makingSimpleArray = true;
            ps.value = ASEmitterTokens.SQUARE_OPEN.getToken();
        }
        for (int i = 0; i < len; ++i) {
            this.getMXMLWalker().walk(node.getChild(i));
            if (!isSimple || i >= len - 1) continue;
            ps.value = ps.value + ASEmitterTokens.COMMA.getToken();
        }
        if (isSimple) {
            ps.value = ps.value + ASEmitterTokens.SQUARE_CLOSE.getToken();
        }
        this.makingSimpleArray = oldMakingSimpleArray;
        this.moveUp(false, false);
    }

    @Override
    public void emitString(IMXMLStringNode node) {
        this.getCurrentDescriptor((String)"ps").valueNeedsQuotes = true;
        this.emitAttributeValue((IASNode)node);
    }

    @Override
    public void emitLiteral(IMXMLLiteralNode node) {
        MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        if (ps.value == null) {
            ps.value = "";
        }
        if (ps.valueNeedsQuotes) {
            ps.value = ps.value + ASEmitterTokens.SINGLE_QUOTE.getToken();
        }
        String s = node.getValue().toString();
        if (ps.valueNeedsQuotes) {
            s = s.replace(ASEmitterTokens.SINGLE_QUOTE.getToken(), "\\" + ASEmitterTokens.SINGLE_QUOTE.getToken());
        }
        s = s.replace("\r\n", "\\n");
        s = s.replace("\n", "\\n");
        ps.value = ps.value + s;
        if (ps.valueNeedsQuotes) {
            ps.value = ps.value + ASEmitterTokens.SINGLE_QUOTE.getToken();
        }
    }

    @Override
    public void emitFactory(IMXMLFactoryNode node) {
        MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        ps.value = "new " + this.formatQualifiedName("org.apache.royale.core.ClassFactory") + "(";
        IASNode cnode = node.getChild(0);
        if (cnode instanceof IMXMLClassNode) {
            ps.value = ps.value + this.formatQualifiedName(((IMXMLClassNode)cnode).getValue(this.getMXMLWalker().getProject()).getQualifiedName());
        }
        ps.value = ps.value + ")";
    }

    @Override
    public void emitComponent(IMXMLComponentNode node) {
        MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        ps.value = "new " + this.formatQualifiedName("org.apache.royale.core.ClassFactory") + "(";
        ps.value = ps.value + this.formatQualifiedName(this.documentDefinition.getQualifiedName()) + ".";
        ps.value = ps.value + this.formatQualifiedName(node.getName());
        ps.value = ps.value + ")";
        this.setBufferWrite(true);
        this.emitSubDocument(node);
        this.subDocuments.append(this.getBuilder().toString());
        this.getBuilder().setLength(0);
        this.setBufferWrite(false);
    }

    @Override
    protected void setBufferWrite(boolean value) {
        super.setBufferWrite(value);
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        ((JSRoyaleEmitter)asEmitter).setBufferWrite(value);
    }

    private void emitHeader(IMXMLDocumentNode node) {
        String cname = node.getFileNode().getName();
        String bcname = node.getBaseClassName();
        RoyaleJSProject project = (RoyaleJSProject)this.getMXMLWalker().getProject();
        List sourcePaths = project.getSourcePath();
        String sourceName = node.getSourcePath();
        for (Object sourcePath : sourcePaths) {
            if (!sourceName.startsWith(((File)sourcePath).getAbsolutePath())) continue;
            sourceName = sourceName.substring(((File)sourcePath).getAbsolutePath().length() + 1);
        }
        this.writeNewline("/**");
        this.writeNewline(" * Generated by Apache Royale Compiler from " + sourceName);
        this.writeNewline(" * " + cname);
        this.writeNewline(" *");
        this.writeNewline(" * @fileoverview");
        this.writeNewline(" *");
        this.writeNewline(" * @suppress {checkTypes|accessControls}");
        this.writeNewline(" */");
        this.writeNewline();
        ArrayList<String> writtenInstances = new ArrayList<String>();
        this.emitHeaderLine(cname, true);
        for (String subDocumentName : this.subDocumentNames) {
            this.emitHeaderLine(subDocumentName, true);
            writtenInstances.add(this.formatQualifiedName(subDocumentName));
        }
        this.writeNewline();
        this.emitHeaderLine(bcname);
        writtenInstances.add(this.formatQualifiedName(cname));
        writtenInstances.add(this.formatQualifiedName(bcname));
        this.allInstances.addAll(0, this.instances);
        for (MXMLDescriptorSpecifier instance : this.allInstances) {
            String name = instance.name;
            if (writtenInstances.indexOf(name) != -1) continue;
            this.emitHeaderLine(name);
            writtenInstances.add(name);
        }
        ASProjectScope projectScope = project.getScope();
        IClassDefinition cdef = node.getDefinition();
        ICompilationUnit cu = projectScope.getCompilationUnitForDefinition((IDefinition)cdef);
        ArrayList<String> deps = project.getRequires(cu);
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        if (fjs.getModel().hasStaticBindableVars()) {
            if (deps.indexOf(BindableEmitter.DISPATCHER_CLASS_QNAME) == -1) {
                deps.add(BindableEmitter.DISPATCHER_CLASS_QNAME);
            }
            if (this.usedNames.indexOf(BindableEmitter.DISPATCHER_CLASS_QNAME) == -1) {
                this.usedNames.add(BindableEmitter.DISPATCHER_CLASS_QNAME);
            }
        }
        if (this.interfaceList != null) {
            String[] interfaces;
            for (String iface : interfaces = this.interfaceList.split(", ")) {
                deps.add(iface);
                this.usedNames.add(iface);
            }
        }
        if (deps != null) {
            Collections.sort(deps);
            for (String imp : deps) {
                String formatted;
                if (imp.indexOf(JSGoogEmitterTokens.AS3.getToken()) != -1 || imp.equals(cname) || imp.equals("mx.binding.Binding") || imp.equals("mx.binding.BindingManager") || imp.equals("mx.binding.FunctionReturnWatcher") || imp.equals("mx.binding.PropertyWatcher") || imp.equals("mx.binding.StaticPropertyWatcher") || imp.equals("mx.binding.XMLWatcher") || imp.equals("mx.events.PropertyChangeEvent") || imp.equals("mx.events.PropertyChangeEventKind") || imp.equals("mx.core.DeferredInstanceFromFunction") || NativeUtils.isNative(imp) || writtenInstances.indexOf(formatted = this.formatQualifiedName(imp, false)) != -1) continue;
                this.emitHeaderLine(imp);
                writtenInstances.add(formatted);
            }
        }
        if (project.mainCU != null && cu.getName().equals(project.mainCU.getName()) && project instanceof RoyaleJSProject && project.needLanguage) {
            this.emitHeaderLine(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken());
        }
        this.writeNewline();
        this.writeNewline();
    }

    private void emitHeaderLine(String qname) {
        this.emitHeaderLine(qname, false);
    }

    private void emitHeaderLine(String qname, boolean isProvide) {
        this.write(isProvide ? JSGoogEmitterTokens.GOOG_PROVIDE : JSGoogEmitterTokens.GOOG_REQUIRE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(this.formatQualifiedName(qname, false));
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
    }

    private String createRequireLine(String qname, boolean isProvide) {
        StringBuilder createHeader = new StringBuilder();
        createHeader.append(isProvide ? JSGoogEmitterTokens.GOOG_PROVIDE.getToken() : JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
        createHeader.append(ASEmitterTokens.PAREN_OPEN.getToken());
        createHeader.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
        createHeader.append(qname);
        createHeader.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
        createHeader.append(ASEmitterTokens.PAREN_CLOSE.getToken());
        createHeader.append(ASEmitterTokens.SEMICOLON.getToken());
        return createHeader.toString();
    }

    @Override
    protected void emitAttributeValue(IASNode node) {
        IMXMLLiteralNode cnode = (IMXMLLiteralNode)node.getChild(0);
        if (cnode.getValue() != null) {
            this.getMXMLWalker().walk((IASNode)cnode);
        }
    }

    private MXMLDescriptorSpecifier getCurrentDescriptor(String type) {
        MXMLDescriptorSpecifier currentDescriptor = null;
        if (type.equals("i")) {
            int index = this.currentInstances.size() - 1;
            if (index > -1) {
                currentDescriptor = this.currentInstances.get(index);
            }
        } else {
            if (type.equals("so")) {
                return this.currentStateOverrides;
            }
            int index = this.currentPropertySpecifiers.size() - 1;
            if (index > -1) {
                currentDescriptor = this.currentPropertySpecifiers.get(index);
            }
        }
        return currentDescriptor;
    }

    protected void moveDown(boolean byPass, MXMLDescriptorSpecifier currentInstance, MXMLDescriptorSpecifier currentPropertySpecifier) {
        if (!byPass && currentInstance != null) {
            this.currentInstances.add(currentInstance);
        }
        if (currentPropertySpecifier != null) {
            this.currentPropertySpecifiers.add(currentPropertySpecifier);
        }
    }

    protected void moveUp(boolean byPass, boolean isInstance) {
        if (!byPass) {
            if (isInstance) {
                int index = this.currentInstances.size() - 1;
                if (index > -1) {
                    this.currentInstances.remove(index);
                }
            } else {
                int index = this.currentPropertySpecifiers.size() - 1;
                if (index > -1) {
                    this.currentPropertySpecifiers.remove(index);
                }
            }
        }
    }

    public String formatQualifiedName(String name) {
        return this.formatQualifiedName(name, true);
    }

    protected String formatQualifiedName(String name, boolean useName) {
        if (this.subDocumentNames.contains(name)) {
            return this.documentDefinition.getQualifiedName() + "." + name;
        }
        if (NativeUtils.isJSNative(name)) {
            return name;
        }
        if (useName && !this.usedNames.contains(name) && !this.isExternal(name)) {
            this.usedNames.add(name);
        }
        return name;
    }

    private void emitComplexInitializers(IASNode node) {
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            IASNode child = node.getChild(i);
            if (child.getNodeID() != ASTNodeID.MXMLScriptID) continue;
            int m = child.getChildCount();
            for (int j = 0; j < m; ++j) {
                IVariableNode varnode;
                IExpressionNode vnode;
                IASNode schild = child.getChild(j);
                ASTNodeID schildID = schild.getNodeID();
                if (schildID != ASTNodeID.VariableID && schildID != ASTNodeID.BindableVariableID || (vnode = (varnode = (IVariableNode)schild).getAssignedValueNode()) == null || EmitterUtils.isScalar(vnode)) continue;
                this.writeNewline();
                this.write(ASEmitterTokens.THIS);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(varnode.getName());
                if (schildID == ASTNodeID.BindableVariableID && !varnode.isConst()) {
                    this.write("_");
                }
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                JSRoyaleEmitter fjs = (JSRoyaleEmitter)((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
                fjs.getWalker().walk((IASNode)vnode);
                this.write(ASEmitterTokens.SEMICOLON);
            }
        }
    }

    public void emitComplexStaticInitializers(IASNode node) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        if (!fjs.getFieldEmitter().hasComplexStaticInitializers) {
            return;
        }
        int n = node.getChildCount();
        boolean sawOutput = false;
        for (int i = 0; i < n; ++i) {
            IASNode child = node.getChild(i);
            if (child.getNodeID() != ASTNodeID.MXMLScriptID) continue;
            int m = child.getChildCount();
            for (int j = 0; j < m; ++j) {
                IASNode schild = child.getChild(j);
                ASTNodeID schildID = schild.getNodeID();
                if (schildID != ASTNodeID.VariableID && schildID != ASTNodeID.BindableVariableID) continue;
                sawOutput = fjs.getFieldEmitter().emitFieldInitializer((IVariableNode)schild) || sawOutput;
            }
        }
        if (sawOutput) {
            this.writeNewline();
            this.writeNewline();
        }
    }

    @Override
    public void emitImplements(IMXMLImplementsNode node) {
        IIdentifierNode[] interfaces;
        StringBuilder list = new StringBuilder();
        boolean needsComma = false;
        for (IIdentifierNode iface : interfaces = node.getInterfaceNodes()) {
            if (needsComma) {
                list.append(", ");
            }
            list.append(iface.getName());
            needsComma = true;
        }
        this.interfaceList = list.toString();
    }

    boolean isExternal(String className) {
        ICompilerProject project = this.getMXMLWalker().getProject();
        ICompilationUnit cu = project.resolveQNameToCompilationUnit(className);
        if (cu == null) {
            return false;
        }
        return ((RoyaleJSProject)project).isExternalLinkage(cu);
    }
}

