/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.mxml.royale;

import java.io.FilterWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.compiler.codegen.as.IASEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.mxml.royale.IMXMLRoyaleEmitter;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.databinding.BindingDatabase;
import org.apache.royale.compiler.internal.codegen.databinding.BindingInfo;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleASDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.codegen.mxml.MXMLEmitter;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLDescriptorSpecifier;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLEventSpecifier;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLScriptSpecifier;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.mxml.IMXMLArrayNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassNode;
import org.apache.royale.compiler.tree.mxml.IMXMLComponentNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDeclarationsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;
import org.apache.royale.compiler.tree.mxml.IMXMLEventSpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLFactoryNode;
import org.apache.royale.compiler.tree.mxml.IMXMLImplementsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLLiteralNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLObjectNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLScriptNode;
import org.apache.royale.compiler.tree.mxml.IMXMLSpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStateNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStringNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStyleSpecifierNode;
import org.apache.royale.compiler.utils.NativeUtils;
import org.apache.royale.compiler.visitor.mxml.IMXMLBlockWalker;

public class MXMLRoyaleASDocEmitter
extends MXMLEmitter
implements IMXMLRoyaleEmitter {
    private ArrayList<MXMLDescriptorSpecifier> currentInstances;
    private ArrayList<MXMLDescriptorSpecifier> currentPropertySpecifiers;
    private ArrayList<MXMLDescriptorSpecifier> descriptorTree;
    private MXMLDescriptorSpecifier propertiesTree;
    private MXMLDescriptorSpecifier currentStateOverrides;
    private ArrayList<MXMLEventSpecifier> events;
    private ArrayList<MXMLDescriptorSpecifier> instances;
    private ArrayList<MXMLScriptSpecifier> scripts;
    private IClassDefinition classDefinition;
    private IClassDefinition documentDefinition;
    private ArrayList<String> usedNames = new ArrayList();
    private int eventCounter;
    private int idCounter;
    private int bindingCounter;
    private boolean inMXMLContent;
    private boolean inStatesOverride;
    private boolean makingSimpleArray;
    private StringBuilder subDocuments = new StringBuilder();
    private ArrayList<String> subDocumentNames = new ArrayList();
    protected Map<IMXMLNode, Integer> nodeToIndexMap;
    private HashMap<IMXMLEventSpecifierNode, String> eventHandlerNameMap = new HashMap();

    public MXMLRoyaleASDocEmitter(FilterWriter out) {
        super(out);
    }

    @Override
    public String postProcess(String output) {
        return output;
    }

    @Override
    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSRoyaleEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    @Override
    public void emitDeclarations(IMXMLDeclarationsNode node) {
        super.emitDeclarations(node);
    }

    @Override
    public void emitDocument(IMXMLDocumentNode node) {
        IClassDefinition cdef;
        this.classDefinition = cdef = node.getClassDefinition();
        this.documentDefinition = cdef;
        IJSEmitter fjs = (IJSEmitter)((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        fjs.getModel().setCurrentClass(cdef);
        this.scripts = new ArrayList();
        String cname = node.getFileNode().getName();
        this.emitClassDeclStart(cname, node.getBaseClassName(), false);
        this.emitScripts();
        this.emitClassDeclEnd(cname, node.getBaseClassName());
        this.writeNewline();
    }

    public void emitSubDocument(IMXMLComponentNode node) {
        IClassDefinition cdef;
        this.classDefinition = cdef = node.getContainedClassDefinition();
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        ((JSRoyaleASDocEmitter)asEmitter).getModel().pushClass(cdef);
        IMXMLClassDefinitionNode classNode = node.getContainedClassDefinitionNode();
        String cname = cdef.getQualifiedName();
        String baseClassName = cdef.getBaseClassAsDisplayString();
        this.subDocumentNames.add(cname);
        int len = classNode.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.getMXMLWalker().walk(classNode.getChild(i));
        }
        ((JSRoyaleASDocEmitter)asEmitter).mxmlEmitter = this;
        this.emitClassDeclStart(cname, baseClassName, false);
        this.emitComplexInitializers((IASNode)classNode);
        this.emitClassDeclEnd(cname, baseClassName);
        this.emitScripts();
        this.emitEvents(cname);
        this.emitPropertyGetterSetters(cname);
    }

    protected void emitClassDeclStart(String cname, String baseClassName, boolean indent) {
        this.write("<");
        this.writeToken(this.formatQualifiedName(cname));
        this.write(">");
        if (indent) {
            this.indentPush();
        }
    }

    protected void emitClassDeclEnd(String cname, String baseClassName) {
        this.indentPop();
        this.writeNewline();
        this.writeNewline();
        this.write("</");
        this.writeToken(this.formatQualifiedName(cname));
        this.write(">");
    }

    protected void emitScripts() {
        for (MXMLScriptSpecifier script : this.scripts) {
            String output = script.output();
            if (output.equals("")) continue;
            this.writeNewline(output);
        }
    }

    protected void emitEvents(String cname) {
        for (MXMLEventSpecifier event : this.events) {
            this.writeNewline("/**");
            this.writeNewline(" * @export");
            this.writeNewline(" * @param {" + this.formatQualifiedName(event.type) + "} event");
            this.writeNewline(" */");
            this.writeNewline(this.formatQualifiedName(cname) + ".prototype." + event.eventHandler + " = function(event)");
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
            this.writeNewline(event.value + ASEmitterTokens.SEMICOLON.getToken(), false);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.writeNewline(";");
            this.writeNewline();
            this.writeNewline();
        }
    }

    protected void emitPropertyGetterSetters(String cname) {
        int n = 0;
        for (MXMLDescriptorSpecifier instance : this.instances) {
            if (instance.id.startsWith(MXMLRoyaleEmitterTokens.ID_PREFIX.getToken())) continue;
            ++n;
        }
        if (n == 0 && this.descriptorTree.size() == 0) {
            return;
        }
        String formattedCName = this.formatQualifiedName(cname);
        this.write("Object.defineProperties(");
        this.write(formattedCName);
        this.writeNewline(".prototype, /** @lends {" + formattedCName + ".prototype} */ {");
        this.indentPush();
        int i = 0;
        for (MXMLDescriptorSpecifier instance : this.instances) {
            if (instance.id.startsWith(MXMLRoyaleEmitterTokens.ID_PREFIX.getToken())) continue;
            this.indentPush();
            this.writeNewline("/** @export */");
            this.writeNewline(instance.id + ": {");
            this.writeNewline("/** @this {" + formattedCName + "} */");
            this.indentPush();
            this.writeNewline("get: function() {");
            this.indentPop();
            this.writeNewline("return this." + instance.id + "_;");
            this.writeNewline("},");
            this.writeNewline("/** @this {" + formattedCName + "} */");
            this.indentPush();
            this.writeNewline("set: function(value) {");
            this.indentPush();
            this.writeNewline("if (value != this." + instance.id + "_) {");
            this.writeNewline("this." + instance.id + "_ = value;");
            this.write("this.dispatchEvent(org.apache.royale.events.ValueChangeEvent.createUpdateEvent(this, '");
            this.indentPop();
            this.writeNewline(instance.id + "', null, value));");
            this.indentPop();
            this.writeNewline("}");
            this.indentPop();
            this.writeNewline("}");
            if (i < n - 1 || this.descriptorTree.size() > 0) {
                this.writeNewline("},");
            } else {
                this.indentPop();
                this.writeNewline("}");
            }
            ++i;
        }
        if (this.descriptorTree.size() == 0) {
            this.writeNewline("});");
        }
    }

    @Override
    public void emitEventSpecifier(IMXMLEventSpecifierNode node) {
        if (this.isStateDependent((IASNode)node) && !this.inStatesOverride) {
            return;
        }
        IDefinition cdef = node.getDefinition();
        MXMLDescriptorSpecifier currentDescriptor = this.getCurrentDescriptor("i");
        MXMLEventSpecifier eventSpecifier = new MXMLEventSpecifier();
        eventSpecifier.eventHandler = MXMLRoyaleEmitterTokens.EVENT_PREFIX.getToken() + this.eventCounter++;
        eventSpecifier.name = cdef.getBaseName();
        eventSpecifier.type = node.getEventParameterDefinition().getTypeAsDisplayString();
        this.eventHandlerNameMap.put(node, eventSpecifier.eventHandler);
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        StringBuilder sb = null;
        int len = node.getChildCount();
        if (len > 0) {
            sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                sb.append(this.getIndent(i > 0 ? 1 : 0) + asEmitter.stringifyNode(node.getChild(i)));
                if (i >= len - 1) continue;
                sb.append(ASEmitterTokens.SEMICOLON.getToken());
                sb.append(ASEmitterTokens.NEW_LINE.getToken());
            }
        }
        eventSpecifier.value = sb.toString();
        if (currentDescriptor != null) {
            currentDescriptor.eventSpecifiers.add(eventSpecifier);
        } else if (!this.inStatesOverride) {
            this.propertiesTree.eventSpecifiers.add(eventSpecifier);
        }
        this.events.add(eventSpecifier);
    }

    @Override
    public void emitInstance(IMXMLInstanceNode node) {
        if (this.isStateDependent((IASNode)node) && !this.inStatesOverride) {
            return;
        }
        IClassDefinition cdef = node.getClassReference(this.getMXMLWalker().getProject());
        MXMLDescriptorSpecifier currentPropertySpecifier = this.getCurrentDescriptor("ps");
        String id = node.getID();
        if (id == null) {
            id = node.getEffectiveID();
        }
        if (id == null) {
            id = MXMLRoyaleEmitterTokens.ID_PREFIX.getToken() + this.idCounter++;
        }
        MXMLDescriptorSpecifier currentInstance = new MXMLDescriptorSpecifier();
        currentInstance.isProperty = false;
        currentInstance.id = id;
        currentInstance.name = this.formatQualifiedName(cdef.getQualifiedName());
        currentInstance.parent = currentPropertySpecifier;
        if (currentPropertySpecifier != null) {
            currentPropertySpecifier.propertySpecifiers.add(currentInstance);
        } else if (this.inMXMLContent) {
            this.descriptorTree.add(currentInstance);
        } else {
            currentInstance.parent = this.propertiesTree;
            this.propertiesTree.propertySpecifiers.add(currentInstance);
        }
        this.instances.add(currentInstance);
        IMXMLPropertySpecifierNode[] pnodes = node.getPropertySpecifierNodes();
        if (pnodes != null) {
            this.moveDown(false, currentInstance, null);
            for (IMXMLPropertySpecifierNode pnode : pnodes) {
                this.getMXMLWalker().walk((IASNode)pnode);
            }
            this.moveUp(false, true);
        } else if (node instanceof IMXMLStateNode) {
            IMXMLStateNode stateNode = (IMXMLStateNode)node;
            String name = stateNode.getStateName();
            if (name != null) {
                MXMLDescriptorSpecifier stateName = new MXMLDescriptorSpecifier();
                stateName.isProperty = true;
                stateName.id = id;
                stateName.name = "name";
                stateName.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + name + ASEmitterTokens.SINGLE_QUOTE.getToken();
                stateName.parent = currentInstance;
                currentInstance.propertySpecifiers.add(stateName);
            }
            MXMLDescriptorSpecifier overrides = new MXMLDescriptorSpecifier();
            overrides.isProperty = true;
            overrides.hasArray = true;
            overrides.id = id;
            overrides.name = "overrides";
            overrides.parent = currentInstance;
            currentInstance.propertySpecifiers.add(overrides);
            this.moveDown(false, null, overrides);
            IMXMLClassDefinitionNode classDefinitionNode = stateNode.getClassDefinitionNode();
            List snodes = classDefinitionNode.getNodesDependentOnState(stateNode.getStateName());
            if (snodes != null) {
                for (int i = snodes.size() - 1; i >= 0; --i) {
                    IMXMLNode inode = (IMXMLNode)snodes.get(i);
                    if (inode.getNodeID() != ASTNodeID.MXMLInstanceID) continue;
                    this.emitInstanceOverride((IMXMLInstanceNode)inode);
                }
                for (IMXMLNode anode : snodes) {
                    switch (anode.getNodeID()) {
                        case MXMLPropertySpecifierID: {
                            this.emitPropertyOverride((IMXMLPropertySpecifierNode)anode);
                            break;
                        }
                        case MXMLStyleSpecifierID: {
                            this.emitStyleOverride((IMXMLStyleSpecifierNode)anode);
                            break;
                        }
                        case MXMLEventSpecifierID: {
                            this.emitEventOverride((IMXMLEventSpecifierNode)anode);
                            break;
                        }
                    }
                }
            }
            this.moveUp(false, false);
        }
        IMXMLEventSpecifierNode[] enodes = node.getEventSpecifierNodes();
        if (enodes != null) {
            this.moveDown(false, currentInstance, null);
            for (IMXMLEventSpecifierNode enode : enodes) {
                this.getMXMLWalker().walk((IASNode)enode);
            }
            this.moveUp(false, true);
        }
    }

    public void emitPropertyOverride(IMXMLPropertySpecifierNode propertyNode) {
        RoyaleProject project = (RoyaleProject)this.getMXMLWalker().getProject();
        Name propertyOverride = project.getPropertyOverrideClassName();
        this.emitPropertyOrStyleOverride(propertyOverride, propertyNode);
    }

    void emitStyleOverride(IMXMLStyleSpecifierNode styleNode) {
        RoyaleProject project = (RoyaleProject)this.getMXMLWalker().getProject();
        Name styleOverride = project.getStyleOverrideClassName();
        this.emitPropertyOrStyleOverride(styleOverride, (IMXMLPropertySpecifierNode)styleNode);
    }

    void emitPropertyOrStyleOverride(Name overrideName, IMXMLPropertySpecifierNode propertyOrStyleNode) {
        MXMLDescriptorSpecifier currentInstance = this.getCurrentDescriptor("ps");
        IASNode parentNode = propertyOrStyleNode.getParent();
        String id = parentNode instanceof IMXMLInstanceNode ? ((IMXMLInstanceNode)parentNode).getEffectiveID() : null;
        String name = propertyOrStyleNode.getName();
        boolean valueIsDataBound = MXMLRoyaleASDocEmitter.isDataBindingNode(propertyOrStyleNode.getChild(0));
        IMXMLInstanceNode propertyOrStyleValueNode = propertyOrStyleNode.getInstanceNode();
        MXMLDescriptorSpecifier setProp = new MXMLDescriptorSpecifier();
        setProp.isProperty = false;
        setProp.name = this.formatQualifiedName(this.nameToString(overrideName));
        setProp.parent = currentInstance;
        currentInstance.propertySpecifiers.add(setProp);
        if (id != null) {
            MXMLDescriptorSpecifier target = new MXMLDescriptorSpecifier();
            target.isProperty = true;
            target.name = "target";
            target.parent = setProp;
            target.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + id + ASEmitterTokens.SINGLE_QUOTE.getToken();
            setProp.propertySpecifiers.add(target);
        }
        MXMLDescriptorSpecifier pname = new MXMLDescriptorSpecifier();
        pname.isProperty = true;
        pname.name = "name";
        pname.parent = setProp;
        pname.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + name + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setProp.propertySpecifiers.add(pname);
        if (!valueIsDataBound) {
            MXMLDescriptorSpecifier value = new MXMLDescriptorSpecifier();
            value.isProperty = true;
            value.name = "value";
            value.parent = setProp;
            setProp.propertySpecifiers.add(value);
            this.moveDown(false, null, value);
            this.getMXMLWalker().walk((IASNode)propertyOrStyleValueNode);
            this.moveUp(false, false);
        } else {
            String overrideID;
            setProp.id = overrideID = MXMLRoyaleEmitterTokens.BINDING_PREFIX.getToken() + this.bindingCounter++;
            this.instances.add(setProp);
            BindingDatabase bd = (BindingDatabase)BindingDatabase.bindingMap.get(this.classDefinition);
            Set bindingInfo = bd.getBindingInfo();
            IMXMLDataBindingNode bindingNode = (IMXMLDataBindingNode)propertyOrStyleNode.getChild(0);
            for (BindingInfo bi : bindingInfo) {
                if (bi.node != bindingNode) continue;
                bi.setDestinationString(overrideID + ".value");
                break;
            }
        }
    }

    void emitEventOverride(IMXMLEventSpecifierNode eventNode) {
        this.inStatesOverride = true;
        MXMLDescriptorSpecifier currentInstance = this.getCurrentDescriptor("ps");
        RoyaleProject project = (RoyaleProject)this.getMXMLWalker().getProject();
        Name eventOverride = project.getEventOverrideClassName();
        IASNode parentNode = eventNode.getParent();
        String id = parentNode instanceof IMXMLInstanceNode ? ((IMXMLInstanceNode)parentNode).getEffectiveID() : "";
        String name = MXMLEventSpecifier.getJSEventName(eventNode.getName());
        String eventHandler = this.eventHandlerNameMap.get(eventNode);
        if (eventHandler == null) {
            this.emitEventSpecifier(eventNode);
            eventHandler = this.eventHandlerNameMap.get(eventNode);
        }
        MXMLDescriptorSpecifier setEvent = new MXMLDescriptorSpecifier();
        setEvent.isProperty = false;
        setEvent.name = this.formatQualifiedName(this.nameToString(eventOverride));
        setEvent.parent = currentInstance;
        currentInstance.propertySpecifiers.add(setEvent);
        MXMLDescriptorSpecifier target = new MXMLDescriptorSpecifier();
        target.isProperty = true;
        target.name = "target";
        target.parent = setEvent;
        target.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + id + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setEvent.propertySpecifiers.add(target);
        MXMLDescriptorSpecifier pname = new MXMLDescriptorSpecifier();
        pname.isProperty = true;
        pname.name = "name";
        pname.parent = setEvent;
        pname.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + name + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setEvent.propertySpecifiers.add(pname);
        MXMLDescriptorSpecifier handler = new MXMLDescriptorSpecifier();
        handler.isProperty = true;
        handler.name = "handlerFunction";
        handler.parent = setEvent;
        handler.value = JSRoyaleEmitterTokens.CLOSURE_FUNCTION_NAME.getToken() + ASEmitterTokens.PAREN_OPEN.getToken() + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + eventHandler + ASEmitterTokens.COMMA.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.COMMA.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.SINGLE_QUOTE.getToken() + eventHandler + ASEmitterTokens.SINGLE_QUOTE.getToken() + ASEmitterTokens.PAREN_CLOSE.getToken();
        setEvent.propertySpecifiers.add(handler);
        this.inStatesOverride = false;
    }

    public void emitInstanceOverride(IMXMLInstanceNode instanceNode) {
        this.inStatesOverride = true;
        MXMLDescriptorSpecifier currentInstance = this.getCurrentDescriptor("ps");
        RoyaleProject project = (RoyaleProject)this.getMXMLWalker().getProject();
        Name instanceOverrideName = project.getInstanceOverrideClassName();
        MXMLDescriptorSpecifier overrideInstances = this.getCurrentDescriptor("so");
        int index = overrideInstances.propertySpecifiers.size();
        if (this.nodeToIndexMap == null) {
            this.nodeToIndexMap = new HashMap<IMXMLNode, Integer>();
        }
        if (this.nodeToIndexMap.containsKey(instanceNode)) {
            index = this.nodeToIndexMap.get(instanceNode);
        } else {
            this.nodeToIndexMap.put((IMXMLNode)instanceNode, index);
            MXMLDescriptorSpecifier itemsDesc = new MXMLDescriptorSpecifier();
            itemsDesc.isProperty = true;
            itemsDesc.hasArray = true;
            itemsDesc.name = "itemsDescriptor";
            itemsDesc.parent = overrideInstances;
            overrideInstances.propertySpecifiers.add(itemsDesc);
            boolean oldInMXMLContent = this.inMXMLContent;
            this.moveDown(false, null, itemsDesc);
            this.inMXMLContent = true;
            this.getMXMLWalker().walk((IASNode)instanceNode);
            this.inMXMLContent = oldInMXMLContent;
            this.moveUp(false, false);
        }
        MXMLDescriptorSpecifier addItems = new MXMLDescriptorSpecifier();
        addItems.isProperty = false;
        addItems.name = this.formatQualifiedName(this.nameToString(instanceOverrideName));
        addItems.parent = currentInstance;
        currentInstance.propertySpecifiers.add(addItems);
        MXMLDescriptorSpecifier itemsDescIndex = new MXMLDescriptorSpecifier();
        itemsDescIndex.isProperty = true;
        itemsDescIndex.hasArray = true;
        itemsDescIndex.name = "itemsDescriptorIndex";
        itemsDescIndex.parent = addItems;
        itemsDescIndex.value = Integer.toString(index);
        addItems.propertySpecifiers.add(itemsDescIndex);
        IMXMLPropertySpecifierNode propertySpecifier = (IMXMLPropertySpecifierNode)instanceNode.getAncestorOfType(IMXMLPropertySpecifierNode.class);
        if (propertySpecifier == null) {
            assert (false);
        } else {
            IASNode parent = propertySpecifier.getParent();
            if (parent instanceof IMXMLInstanceNode) {
                IMXMLInstanceNode parentInstance = (IMXMLInstanceNode)parent;
                String parentId = parentInstance.getEffectiveID();
                assert (parentId != null);
                String propName = propertySpecifier.getName();
                MXMLDescriptorSpecifier dest = new MXMLDescriptorSpecifier();
                dest.isProperty = true;
                dest.name = "destination";
                dest.parent = addItems;
                dest.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + parentId + ASEmitterTokens.SINGLE_QUOTE.getToken();
                addItems.propertySpecifiers.add(dest);
                MXMLDescriptorSpecifier prop = new MXMLDescriptorSpecifier();
                prop.isProperty = true;
                prop.name = "propertyName";
                prop.parent = addItems;
                prop.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + propName + ASEmitterTokens.SINGLE_QUOTE.getToken();
                addItems.propertySpecifiers.add(prop);
            }
        }
        String positionPropertyValue = null;
        String relativeToPropertyValue = null;
        IASNode instanceParent = instanceNode.getParent();
        IASNode prevStatelessSibling = null;
        for (int i = 0; i < instanceParent.getChildCount(); ++i) {
            IASNode sib = instanceParent.getChild(i);
            assert (sib instanceof IMXMLInstanceNode);
            if (sib == instanceNode) break;
            if (!(sib instanceof IMXMLInstanceNode) || this.isStateDependent(sib)) continue;
            prevStatelessSibling = sib;
        }
        if (prevStatelessSibling == null) {
            positionPropertyValue = "first";
        } else {
            positionPropertyValue = "after";
            relativeToPropertyValue = ((IMXMLInstanceNode)prevStatelessSibling).getEffectiveID();
        }
        MXMLDescriptorSpecifier pos = new MXMLDescriptorSpecifier();
        pos.isProperty = true;
        pos.name = "position";
        pos.parent = addItems;
        pos.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + positionPropertyValue + ASEmitterTokens.SINGLE_QUOTE.getToken();
        addItems.propertySpecifiers.add(pos);
        if (relativeToPropertyValue != null) {
            MXMLDescriptorSpecifier rel = new MXMLDescriptorSpecifier();
            rel.isProperty = true;
            rel.name = "relativeTo";
            rel.parent = addItems;
            rel.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + relativeToPropertyValue + ASEmitterTokens.SINGLE_QUOTE.getToken();
            addItems.propertySpecifiers.add(rel);
        }
        this.inStatesOverride = false;
    }

    private String nameToString(Name name) {
        Namespace ns = name.getSingleQualifier();
        String s = ns.getName();
        s = s != "" ? s + ASEmitterTokens.MEMBER_ACCESS.getToken() + name.getBaseName() : name.getBaseName();
        return s;
    }

    protected boolean isStateDependent(IASNode node) {
        if (node instanceof IMXMLSpecifierNode) {
            String suffix = ((IMXMLSpecifierNode)node).getSuffix();
            return suffix != null && suffix.length() > 0;
        }
        return this.isStateDependentInstance(node);
    }

    protected boolean isStateDependentInstance(IASNode node) {
        if (node instanceof IMXMLInstanceNode) {
            String[] includeIn = ((IMXMLInstanceNode)node).getIncludeIn();
            String[] excludeFrom = ((IMXMLInstanceNode)node).getExcludeFrom();
            return includeIn != null || excludeFrom != null;
        }
        return false;
    }

    public static boolean isDataBindingNode(IASNode node) {
        return node instanceof IMXMLDataBindingNode;
    }

    protected static boolean isDataboundProp(IMXMLPropertySpecifierNode propertyNode) {
        boolean ret = propertyNode.getChildCount() > 0 && MXMLRoyaleASDocEmitter.isDataBindingNode((IASNode)propertyNode.getInstanceNode());
        int n = propertyNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            boolean db = MXMLRoyaleASDocEmitter.isDataBindingNode(propertyNode.getChild(i));
            assert (db == ret);
        }
        return ret;
    }

    @Override
    public void emitPropertySpecifier(IMXMLPropertySpecifierNode node) {
        if (MXMLRoyaleASDocEmitter.isDataboundProp(node)) {
            return;
        }
        if (this.isStateDependent((IASNode)node)) {
            return;
        }
        IDefinition cdef = node.getDefinition();
        IASNode cnode = node.getChild(0);
        MXMLDescriptorSpecifier currentInstance = this.getCurrentDescriptor("i");
        MXMLDescriptorSpecifier currentPropertySpecifier = new MXMLDescriptorSpecifier();
        currentPropertySpecifier.isProperty = true;
        currentPropertySpecifier.name = cdef.getQualifiedName();
        currentPropertySpecifier.parent = currentInstance;
        boolean oldInMXMLContent = this.inMXMLContent;
        boolean reusingDescriptor = false;
        if (currentPropertySpecifier.name.equals("mxmlContent")) {
            this.inMXMLContent = true;
            ArrayList<MXMLDescriptorSpecifier> specList = currentInstance == null ? this.descriptorTree : currentInstance.propertySpecifiers;
            for (MXMLDescriptorSpecifier ds : specList) {
                if (!ds.name.equals("mxmlContent")) continue;
                currentPropertySpecifier = ds;
                reusingDescriptor = true;
                break;
            }
        }
        if (currentInstance != null) {
            if (!reusingDescriptor) {
                currentInstance.propertySpecifiers.add(currentPropertySpecifier);
            }
        } else if (this.inMXMLContent) {
            if (!reusingDescriptor) {
                this.descriptorTree.add(currentPropertySpecifier);
            }
        } else {
            currentPropertySpecifier.parent = this.propertiesTree;
            this.propertiesTree.propertySpecifiers.add(currentPropertySpecifier);
        }
        boolean valueIsArray = cnode != null && cnode instanceof IMXMLArrayNode;
        boolean valueIsObject = cnode != null && cnode instanceof IMXMLObjectNode;
        currentPropertySpecifier.hasArray = valueIsArray;
        currentPropertySpecifier.hasObject = valueIsObject;
        this.moveDown(valueIsArray || valueIsObject, null, currentPropertySpecifier);
        this.getMXMLWalker().walk(cnode);
        this.moveUp(valueIsArray || valueIsObject, false);
        this.inMXMLContent = oldInMXMLContent;
    }

    @Override
    public void emitScript(IMXMLScriptNode node) {
        int len = node.getChildCount();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                IASNode cnode = node.getChild(i);
                this.getMXMLWalker().walk(cnode);
            }
        }
    }

    @Override
    public void emitStyleSpecifier(IMXMLStyleSpecifierNode node) {
    }

    @Override
    public void emitObject(IMXMLObjectNode node) {
        int len = node.getChildCount();
        if (!this.makingSimpleArray) {
            for (int i = 0; i < len; ++i) {
                this.getMXMLWalker().walk(node.getChild(i));
            }
        } else {
            MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
            if (ps.value == null) {
                ps.value = "";
            }
            ps.value = ps.value + "{";
            for (int i = 0; i < len; ++i) {
                IMXMLPropertySpecifierNode propName = (IMXMLPropertySpecifierNode)node.getChild(i);
                ps.value = ps.value + propName.getName() + ": ";
                this.getMXMLWalker().walk(propName.getChild(0));
                if (i >= len - 1) continue;
                ps.value = ps.value + ", ";
            }
            ps.value = ps.value + "}";
        }
    }

    @Override
    public void emitArray(IMXMLArrayNode node) {
        this.moveDown(false, null, null);
        boolean isSimple = true;
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            IASNode child = node.getChild(i);
            ASTNodeID nodeID = child.getNodeID();
            if (nodeID != ASTNodeID.MXMLArrayID && nodeID != ASTNodeID.MXMLInstanceID && nodeID != ASTNodeID.MXMLStateID) continue;
            isSimple = false;
            break;
        }
        boolean oldMakingSimpleArray = this.makingSimpleArray;
        MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        if (isSimple) {
            this.makingSimpleArray = true;
            ps.value = ASEmitterTokens.SQUARE_OPEN.getToken();
        }
        for (int i = 0; i < len; ++i) {
            this.getMXMLWalker().walk(node.getChild(i));
            if (!isSimple || i >= len - 1) continue;
            ps.value = ps.value + ASEmitterTokens.COMMA.getToken();
        }
        if (isSimple) {
            ps.value = ps.value + ASEmitterTokens.SQUARE_CLOSE.getToken();
        }
        this.makingSimpleArray = oldMakingSimpleArray;
        this.moveUp(false, false);
    }

    @Override
    public void emitString(IMXMLStringNode node) {
        this.getCurrentDescriptor((String)"ps").valueNeedsQuotes = true;
        this.emitAttributeValue((IASNode)node);
    }

    @Override
    public void emitLiteral(IMXMLLiteralNode node) {
        MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        if (ps.value == null) {
            ps.value = "";
        }
        if (ps.valueNeedsQuotes) {
            ps.value = ps.value + ASEmitterTokens.SINGLE_QUOTE.getToken();
        }
        String s = node.getValue().toString();
        if (ps.valueNeedsQuotes) {
            s = s.replace(ASEmitterTokens.SINGLE_QUOTE.getToken(), "\\" + ASEmitterTokens.SINGLE_QUOTE.getToken());
        }
        ps.value = ps.value + s;
        if (ps.valueNeedsQuotes) {
            ps.value = ps.value + ASEmitterTokens.SINGLE_QUOTE.getToken();
        }
    }

    @Override
    public void emitFactory(IMXMLFactoryNode node) {
        MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        ps.value = "new " + this.formatQualifiedName("org.apache.royale.core.ClassFactory") + "(";
        IASNode cnode = node.getChild(0);
        if (cnode instanceof IMXMLClassNode) {
            ps.value = ps.value + this.formatQualifiedName(((IMXMLClassNode)cnode).getValue(this.getMXMLWalker().getProject()).getQualifiedName());
        }
        ps.value = ps.value + ")";
    }

    @Override
    public void emitComponent(IMXMLComponentNode node) {
        MXMLDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        ps.value = "new " + this.formatQualifiedName("org.apache.royale.core.ClassFactory") + "(";
        ps.value = ps.value + this.formatQualifiedName(this.documentDefinition.getQualifiedName()) + ".";
        ps.value = ps.value + this.formatQualifiedName(node.getName());
        ps.value = ps.value + ")";
        this.setBufferWrite(true);
        this.emitSubDocument(node);
        this.subDocuments.append(this.getBuilder().toString());
        this.getBuilder().setLength(0);
        this.setBufferWrite(false);
    }

    @Override
    protected void setBufferWrite(boolean value) {
        super.setBufferWrite(value);
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        ((JSRoyaleASDocEmitter)asEmitter).setBufferWrite(value);
    }

    @Override
    protected void emitAttributeValue(IASNode node) {
        IMXMLLiteralNode cnode = (IMXMLLiteralNode)node.getChild(0);
        if (cnode.getValue() != null) {
            this.getMXMLWalker().walk((IASNode)cnode);
        }
    }

    private MXMLDescriptorSpecifier getCurrentDescriptor(String type) {
        MXMLDescriptorSpecifier currentDescriptor = null;
        if (type.equals("i")) {
            int index = this.currentInstances.size() - 1;
            if (index > -1) {
                currentDescriptor = this.currentInstances.get(index);
            }
        } else {
            if (type.equals("so")) {
                return this.currentStateOverrides;
            }
            int index = this.currentPropertySpecifiers.size() - 1;
            if (index > -1) {
                currentDescriptor = this.currentPropertySpecifiers.get(index);
            }
        }
        return currentDescriptor;
    }

    protected void moveDown(boolean byPass, MXMLDescriptorSpecifier currentInstance, MXMLDescriptorSpecifier currentPropertySpecifier) {
        if (!byPass && currentInstance != null) {
            this.currentInstances.add(currentInstance);
        }
        if (currentPropertySpecifier != null) {
            this.currentPropertySpecifiers.add(currentPropertySpecifier);
        }
    }

    protected void moveUp(boolean byPass, boolean isInstance) {
        if (!byPass) {
            if (isInstance) {
                int index = this.currentInstances.size() - 1;
                if (index > -1) {
                    this.currentInstances.remove(index);
                }
            } else {
                int index = this.currentPropertySpecifiers.size() - 1;
                if (index > -1) {
                    this.currentPropertySpecifiers.remove(index);
                }
            }
        }
    }

    public String formatQualifiedName(String name) {
        return this.formatQualifiedName(name, true);
    }

    protected String formatQualifiedName(String name, boolean useName) {
        if (this.subDocumentNames.contains(name)) {
            return this.documentDefinition.getQualifiedName() + "." + name;
        }
        if (NativeUtils.isJSNative(name)) {
            return name;
        }
        if (useName && !this.usedNames.contains(name)) {
            this.usedNames.add(name);
        }
        return name;
    }

    private void emitComplexInitializers(IASNode node) {
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            IASNode child = node.getChild(i);
            if (child.getNodeID() != ASTNodeID.MXMLScriptID) continue;
            int m = child.getChildCount();
            for (int j = 0; j < m; ++j) {
                IVariableNode varnode;
                IExpressionNode vnode;
                IASNode schild = child.getChild(j);
                ASTNodeID schildID = schild.getNodeID();
                if (schildID != ASTNodeID.VariableID && schildID != ASTNodeID.BindableVariableID || (vnode = (varnode = (IVariableNode)schild).getAssignedValueNode()) == null || varnode.isConst() || EmitterUtils.isScalar(vnode)) continue;
                this.writeNewline();
                this.write(ASEmitterTokens.THIS);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(varnode.getName());
                if (schildID == ASTNodeID.BindableVariableID) {
                    this.write("_");
                }
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                JSRoyaleASDocEmitter fjs = (JSRoyaleASDocEmitter)((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
                fjs.getWalker().walk((IASNode)vnode);
                this.write(ASEmitterTokens.SEMICOLON);
            }
        }
    }

    @Override
    public void emitImplements(IMXMLImplementsNode node) {
        IIdentifierNode[] interfaces;
        StringBuilder list = new StringBuilder();
        boolean needsComma = false;
        for (IIdentifierNode iface : interfaces = node.getInterfaceNodes()) {
            if (needsComma) {
                list.append(", ");
            }
            list.append(iface.getName());
            needsComma = true;
        }
    }
}

