/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.mxml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.royale.compiler.codegen.ISourceMapEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.IMappingEmitter;
import org.apache.royale.compiler.codegen.mxml.IMXMLEmitter;
import org.apache.royale.compiler.driver.js.IJSBackend;
import org.apache.royale.compiler.internal.codegen.js.JSFilterWriter;
import org.apache.royale.compiler.internal.codegen.js.JSWriter;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.visitor.as.IASBlockWalker;
import org.apache.royale.compiler.visitor.mxml.IMXMLBlockWalker;

public class MXMLWriter
extends JSWriter {
    public MXMLWriter(RoyaleJSProject project, List<ICompilerProblem> problems, ICompilationUnit compilationUnit, boolean enableDebug) {
        super(project, problems, compilationUnit, enableDebug);
    }

    @Override
    public void writeTo(OutputStream out, File sourceMapOut) {
        IJSBackend backend = (IJSBackend)this.project.getBackend();
        JSFilterWriter writer = (JSFilterWriter)backend.createWriterBuffer(this.project);
        IJSEmitter asEmitter = (IJSEmitter)backend.createEmitter(writer);
        IASBlockWalker asBlockWalker = backend.createWalker(this.project, this.problems, asEmitter);
        IMXMLEmitter mxmlEmitter = backend.createMXMLEmitter(writer);
        IMXMLBlockWalker mxmlBlockWalker = backend.createMXMLWalker(this.project, this.problems, mxmlEmitter, asEmitter, asBlockWalker);
        asEmitter.setParentEmitter(mxmlEmitter);
        mxmlBlockWalker.visitCompilationUnit(this.compilationUnit);
        try {
            out.write(mxmlEmitter.postProcess(writer.toString()).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sourceMapOut != null) {
            this.convertMappingSourcePathsToRelative((IMappingEmitter)((Object)mxmlEmitter), sourceMapOut);
            File compilationUnitFile = new File(this.compilationUnit.getAbsoluteFilename());
            ISourceMapEmitter sourceMapEmitter = backend.createSourceMapEmitter((IMappingEmitter)((Object)mxmlEmitter));
            try {
                String fileName = compilationUnitFile.getName();
                fileName = fileName.replace(".mxml", ".js");
                String sourceMap = sourceMapEmitter.emitSourceMap(fileName, sourceMapOut.getAbsolutePath(), null);
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(sourceMapOut));
                outStream.write(sourceMap.getBytes());
                outStream.flush();
                outStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

