/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;
import org.apache.royale.compiler.visitor.IBlockWalker;

public class SourceMapDirectiveEmitter
extends JSSubEmitter
implements ISubEmitter<ITypeNode> {
    private static final String SOURCE_MAP_PREFIX = "//# sourceMappingURL=./";
    private static final String EXTENSION_JS = ".js";
    private static final String EXTENSION_MAP = ".map";

    public SourceMapDirectiveEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(ITypeNode node) {
        JSGoogConfiguration config;
        boolean sourceMap = false;
        IBlockWalker walker = this.getWalker();
        RoyaleJSProject project = (RoyaleJSProject)walker.getProject();
        if (project != null && (config = project.config) != null) {
            sourceMap = config.getSourceMap();
        }
        if (sourceMap) {
            String name = node.getName() + EXTENSION_JS;
            if (node instanceof IMXMLDocumentNode) {
                IMXMLDocumentNode mxmlNode = (IMXMLDocumentNode)node;
                name = mxmlNode.getFileNode().getName() + EXTENSION_JS;
            }
            this.writeNewline();
            this.write(SOURCE_MAP_PREFIX + name + EXTENSION_MAP);
        }
    }
}

