/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IConditionalNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IIfNode;
import org.apache.royale.compiler.tree.as.ITerminalNode;

public class IfEmitter
extends JSSubEmitter
implements ISubEmitter<IIfNode> {
    public IfEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IIfNode node) {
        ITerminalNode elseNode;
        IConditionalNode conditional = (IConditionalNode)node.getChild(0);
        this.emitConditional(conditional, false);
        IConditionalNode[] nodes = node.getElseIfNodes();
        if (nodes.length > 0) {
            for (int i = 0; i < nodes.length; ++i) {
                IConditionalNode enode = nodes[i];
                IContainerNode snode = (IContainerNode)enode.getStatementContentsNode();
                boolean isImplicit = EmitterUtils.isImplicit(snode);
                if (isImplicit) {
                    this.writeNewline();
                } else {
                    this.write(ASEmitterTokens.SPACE);
                }
                this.emitConditional(enode, true);
            }
        }
        if ((elseNode = node.getElseNode()) != null) {
            this.emitElse(elseNode);
        }
    }

    protected void emitConditional(IConditionalNode node, boolean isElseIf) {
        this.startMapping((ISourceLocation)node);
        if (isElseIf) {
            this.writeToken(ASEmitterTokens.ELSE);
        }
        this.writeToken(ASEmitterTokens.IF);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.endMapping((ISourceLocation)node);
        IASNode conditionalExpression = node.getChild(0);
        this.getWalker().walk(conditionalExpression);
        this.startMapping((ISourceLocation)node, (ISourceLocation)conditionalExpression);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        IContainerNode xnode = (IContainerNode)node.getStatementContentsNode();
        if (!EmitterUtils.isImplicit(xnode)) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk(node.getChild(1));
    }

    protected void emitElse(ITerminalNode node) {
        IContainerNode cnode = (IContainerNode)node.getChild(0);
        boolean isImplicit = EmitterUtils.isImplicit(cnode);
        if (isImplicit) {
            this.writeNewline();
        } else {
            this.write(ASEmitterTokens.SPACE);
        }
        this.startMapping((ISourceLocation)node);
        this.write(ASEmitterTokens.ELSE);
        if (!isImplicit) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk((IASNode)node);
    }
}

