/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.goog;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.deps.DepsGenerator;
import com.google.javascript.jscomp.deps.ModuleLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.codegen.js.IJSPublisher;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.internal.codegen.js.JSPublisher;
import org.apache.royale.compiler.internal.codegen.js.goog.JarSourceFile;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.utils.JSClosureCompilerUtil;

public class JSGoogPublisher
extends JSPublisher
implements IJSPublisher {
    public static final String GOOG_INTERMEDIATE_DIR_NAME = "js-intermediate";
    public static final String GOOG_RELEASE_DIR_NAME = "js-release";
    protected JSGoogConfiguration googConfiguration;

    public JSGoogPublisher(RoyaleJSProject project, Configuration config) {
        super(project, config);
        this.googConfiguration = (JSGoogConfiguration)config;
    }

    @Override
    public File getOutputFolder() {
        this.outputParentFolder = new File(this.configuration.getTargetFileDirectory()).getParentFile();
        this.outputFolder = new File(this.outputParentFolder, GOOG_INTERMEDIATE_DIR_NAME);
        this.setupOutputFolder();
        return this.outputFolder;
    }

    @Override
    public boolean publish(ProblemQuery problems) throws IOException {
        String intermediateDirPath = this.getOutputFolder().getPath();
        String projectName = FilenameUtils.getBaseName((String)this.configuration.getTargetFile());
        String outputFileName = projectName + "." + this.project.getBackend().getOutputExtension();
        File releaseDir = new File(new File(intermediateDirPath).getParentFile(), GOOG_RELEASE_DIR_NAME);
        String releaseDirPath = releaseDir.getPath();
        if (releaseDir.exists()) {
            FileUtils.deleteQuietly((File)releaseDir);
        }
        releaseDir.mkdir();
        File closureLibDir = new File(this.googConfiguration.getClosureLib());
        File closureGoogSrcLibDir = new File(closureLibDir, "/closure/goog/");
        File closureGoogTgtLibDir = new File(intermediateDirPath, "/library/closure/goog");
        File closureTPSrcLibDir = new File(closureLibDir, "/third_party/closure/goog/");
        File closureTPTgtLibDir = new File(intermediateDirPath, "/library/third_party/closure/goog");
        File depsSrcFile = new File(intermediateDirPath, "/library/closure/goog/deps.js");
        File depsTgtFile = new File(intermediateDirPath, "/deps.js");
        File projectIntermediateJSFile = new File(intermediateDirPath, outputFileName);
        File projectReleaseJSFile = new File(releaseDirPath, outputFileName);
        this.appendExportSymbol(projectIntermediateJSFile, projectName);
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>();
        Collection files = FileUtils.listFiles((File)new File(intermediateDirPath), (IOFileFilter)new RegexFileFilter("^.*(\\.js)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        for (File file : files) {
            inputs.add(SourceFile.fromFile((File)file));
        }
        this.copyFile(closureGoogSrcLibDir, closureGoogTgtLibDir);
        this.copyFile(closureTPSrcLibDir, closureTPTgtLibDir);
        ArrayList<SourceFile> deps = new ArrayList<SourceFile>();
        deps.add(SourceFile.fromFile((File)depsSrcFile));
        JSGoogErrorManager errorManager = new JSGoogErrorManager();
        DepsGenerator depsGenerator = new DepsGenerator(deps, inputs, DepsGenerator.InclusionStrategy.ALWAYS, closureGoogTgtLibDir.getCanonicalPath(), (ErrorManager)errorManager, ModuleLoader.EMPTY);
        this.writeFile(depsTgtFile, depsGenerator.computeDependencyCalls(), false);
        FileUtils.deleteQuietly((File)depsSrcFile);
        FileUtils.moveFile((File)depsTgtFile, (File)depsSrcFile);
        this.writeHTML("intermediate", projectName, intermediateDirPath);
        this.writeHTML("release", projectName, releaseDirPath);
        ArrayList<String> optionList = new ArrayList<String>();
        files = FileUtils.listFiles((File)new File(intermediateDirPath), (IOFileFilter)new RegexFileFilter("^.*(\\.js)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        for (File file : files) {
            optionList.add("--js=" + file.getCanonicalPath());
        }
        optionList.add("--closure_entry_point=" + projectName);
        optionList.add("--only_closure_dependencies");
        optionList.add("--compilation_level=ADVANCED_OPTIMIZATIONS");
        optionList.add("--js_output_file=" + projectReleaseJSFile);
        optionList.add("--output_manifest=" + releaseDirPath + File.separator + "manifest.txt");
        optionList.add("--create_source_map=" + projectReleaseJSFile + ".map");
        optionList.add("--source_map_format=" + SourceMap.Format.V3);
        String[] options = optionList.toArray(new String[0]);
        JSClosureCompilerUtil.run(options);
        this.appendSourceMapLocation(projectReleaseJSFile, projectName);
        System.out.println("The project '" + projectName + "' has been successfully compiled and optimized.");
        return true;
    }

    private void appendExportSymbol(File targetFile, String projectName) throws IOException {
        StringBuilder appendString = new StringBuilder();
        appendString.append("\n\n// Ensures the symbol will be visible after compiler renaming.\n");
        appendString.append("goog.exportSymbol('");
        appendString.append(projectName);
        appendString.append("', ");
        appendString.append(projectName);
        appendString.append(");\n");
        this.writeFile(targetFile, appendString.toString(), true);
    }

    protected void appendSourceMapLocation(File path, String projectName) throws IOException {
        StringBuilder appendString = new StringBuilder();
        appendString.append("\n//# sourceMappingURL=./" + projectName + ".js.map");
        this.writeFile(path, appendString.toString(), true);
    }

    protected void copyFile(File source, File target) throws IOException {
        if (source.isDirectory()) {
            FileUtils.copyDirectory((File)source, (File)target);
        } else {
            FileUtils.copyFile((File)source, (File)target);
        }
    }

    protected void writeHTML(String type, String projectName, String dirPath) throws IOException {
        StringBuilder htmlFile = new StringBuilder();
        htmlFile.append("<!DOCTYPE html>\n");
        htmlFile.append("<html>\n");
        htmlFile.append("<head>\n");
        htmlFile.append("\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n");
        htmlFile.append("\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
        if ("intermediate".equals(type)) {
            htmlFile.append("\t<script type=\"text/javascript\" src=\"./library/closure/goog/base.js\"></script>\n");
            htmlFile.append("\t<script type=\"text/javascript\">\n");
            htmlFile.append("\t\tgoog.require(\"");
            htmlFile.append(projectName);
            htmlFile.append("\");\n");
            htmlFile.append("\t</script>\n");
        } else {
            htmlFile.append("\t<script type=\"text/javascript\" src=\"./");
            htmlFile.append(projectName);
            htmlFile.append(".js\"></script>\n");
        }
        htmlFile.append("</head>\n");
        htmlFile.append("<body>\n");
        htmlFile.append("\t<script type=\"text/javascript\">\n");
        htmlFile.append("\t\tnew ");
        htmlFile.append(projectName);
        htmlFile.append("();\n");
        htmlFile.append("\t</script>\n");
        htmlFile.append("</body>\n");
        htmlFile.append("</html>");
        this.writeFile(new File(dirPath, "index.html"), htmlFile.toString(), false);
    }

    protected void writeFile(File target, String content, boolean append) throws IOException {
        if (!target.exists()) {
            target.createNewFile();
        }
        FileWriter fw = new FileWriter(target, append);
        fw.write(content);
        fw.close();
    }

    protected List<SourceFile> getClasspathResources(File jarFile) throws IOException {
        return this.getClasspathResources(jarFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFile> getClasspathResources(File jarFile, Properties whiteList) throws IOException {
        LinkedList<SourceFile> sourceFiles = new LinkedList<SourceFile>();
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> jarEntries = jar.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String fileName = jarEntry.getName();
                if (!fileName.endsWith(".js") || whiteList != null && !whiteList.containsKey(fileName)) continue;
                InputStream is = jar.getInputStream(jarEntry);
                String code = IOUtils.toString((InputStream)is, (String)"UTF-8");
                JarSourceFile sourceFile = new JarSourceFile(jarEntry.getName(), code, false);
                is.close();
                sourceFiles.add(sourceFile);
            }
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        return sourceFiles;
    }

    protected List<SourceFile> getDirectoryResources(File directory) throws IOException {
        LinkedList<SourceFile> sourceFiles = new LinkedList<SourceFile>();
        Collection files = FileUtils.listFiles((File)directory, (IOFileFilter)new RegexFileFilter("^.*(\\.js)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        for (File file : files) {
            String relative = directory.toURI().relativize(file.toURI()).getPath();
            String code = FileUtils.readFileToString((File)file, (String)"UTF-8");
            JarSourceFile sourceFile = new JarSourceFile(relative, code, false);
            sourceFiles.add(sourceFile);
        }
        return sourceFiles;
    }

    protected void dumpJar(File jarFile, File outputDir) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.getName().endsWith("/")) continue;
            File file = new File(outputDir, jarEntry.getName());
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Unable to create directory " + dir.getAbsolutePath());
            }
            InputStream is = jar.getInputStream(jarEntry);
            FileOutputStream fos = new FileOutputStream(file);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
        jar.close();
    }

    public class JSGoogErrorManager
    implements ErrorManager {
        public void setTypedPercent(double arg0) {
        }

        public void report(CheckLevel arg0, JSError arg1) {
        }

        public JSError[] getWarnings() {
            return null;
        }

        public int getWarningCount() {
            return 0;
        }

        public double getTypedPercent() {
            return 0.0;
        }

        public JSError[] getErrors() {
            return null;
        }

        public int getErrorCount() {
            return 0;
        }

        public void generateReport() {
        }
    }
}

