/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import com.google.javascript.jscomp.Result;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSType;
import java.io.File;
import java.io.IOException;
import org.apache.royale.compiler.clients.EXTERNC;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.MethodReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;
import org.apache.royale.utils.TestAdapterFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class TypedefsTestBase {
    private static File unitTestBaseDir = new File(TestAdapterFactory.getTestAdapter().getUnitTestBaseDir(), "typedefs/unit_tests");
    protected ExternCConfiguration config;
    protected EXTERNC client;
    protected ReferenceModel model;

    @Before
    public void setUp() throws IOException {
        this.config = new ExternCConfiguration();
        this.configure(this.config);
        Assert.assertFalse((this.config.getConfigurationProblems().size() > 0 ? 1 : 0) != 0);
        this.client = new EXTERNC(this.config);
        this.model = this.client.getModel();
        this.model.problems = new ProblemQuery();
    }

    protected abstract void configure(ExternCConfiguration var1) throws IOException;

    @After
    public void tearDown() {
        this.model = null;
    }

    protected Result compile(String fileName) throws IOException {
        return this.compile(new File(unitTestBaseDir, fileName));
    }

    protected Result compile(File file) throws IOException {
        this.config.addTypedef(file);
        return this.compile();
    }

    protected Result compile() throws IOException {
        Result result = this.client.compile();
        Assert.assertTrue((boolean)result.success);
        return result;
    }

    protected JSType evaluateParam(MethodReference method, String paramName) {
        JSType jsType = method.getComment().getParameterType(paramName).evaluate(null, (TypeIRegistry)this.client.getCompiler().getJSCompiler().getTypeRegistry());
        return jsType;
    }

    protected void assertCompileTestFileSuccess(String relativeTestDir) throws IOException {
        if (this.config.getAsRoot() != null) {
            this.client.cleanOutput();
        }
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        String methodName = ste[2].getMethodName();
        Result result = this.compile(relativeTestDir + methodName + ".js");
        Assert.assertTrue((boolean)result.success);
    }
}

