/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.jstype.JSType;
import java.io.IOException;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestBase;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.BaseReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.MethodReference;
import org.apache.royale.compiler.internal.codegen.typedefs.utils.JSTypeUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestTypeTypedefs
extends TypedefsTestBase {
    @Test
    public void test_constructor() throws IOException {
        this.compile("constructor_members.js");
        ClassReference reference = this.model.getClassReference("Foo");
        Assert.assertTrue((boolean)reference.hasInstanceField("bar"));
        Assert.assertFalse((boolean)reference.hasInstanceField("foo"));
        Assert.assertTrue((boolean)reference.hasInstanceMethod("method1"));
        Assert.assertTrue((boolean)reference.hasInstanceMethod("method2"));
        Assert.assertTrue((boolean)this.model.hasConstant("bar"));
    }

    @Test
    public void test_types() throws IOException {
        this.compile("types_param.js");
        ClassReference reference = this.model.getClassReference("Foo");
        JSType jsType1 = this.getJSType("test1", true, "arg1");
        JSType jsType2 = this.getJSType("test2", true, "arg1");
        JSType jsType3 = this.getJSType("test3", true, "arg1");
        JSType jsType4 = this.getJSType("test4", true, "arg1");
        JSType jsType5 = this.getJSType("test5", true, "arg1");
        JSType jsType6 = this.getJSType("test6", true, "arg1");
        Assert.assertTrue((boolean)jsType1.isString());
        Assert.assertTrue((boolean)jsType2.isUnionType());
        Assert.assertTrue((boolean)jsType3.isRecordType());
        Assert.assertTrue((boolean)jsType4.isUnionType());
        Assert.assertTrue((boolean)jsType5.isInstanceType());
        Assert.assertTrue((boolean)jsType6.isFunctionType());
        Assert.assertEquals((Object)"String", (Object)JSTypeUtils.toParamTypeString((BaseReference)reference.getStaticMethod("test1"), (String)"arg1"));
        Assert.assertEquals((Object)"foo.bar.Baz", (Object)JSTypeUtils.toParamTypeString((BaseReference)reference.getStaticMethod("test2"), (String)"arg1"));
        Assert.assertEquals((Object)"Object /* {myNum: number, myObject: ?} */", (Object)JSTypeUtils.toParamTypeString((BaseReference)reference.getStaticMethod("test3"), (String)"arg1"));
        Assert.assertEquals((Object)"Number", (Object)JSTypeUtils.toParamTypeString((BaseReference)reference.getStaticMethod("test4"), (String)"arg1"));
        Assert.assertEquals((Object)"Object", (Object)JSTypeUtils.toParamTypeString((BaseReference)reference.getStaticMethod("test5"), (String)"arg1"));
        Assert.assertEquals((Object)"Function /* function (string, boolean): ? */", (Object)JSTypeUtils.toParamTypeString((BaseReference)reference.getStaticMethod("test6"), (String)"arg1"));
    }

    private JSType getJSType(String methodName, boolean isStatic, String paramName) {
        MethodReference method = null;
        method = isStatic ? this.model.getClassReference("Foo").getStaticMethod(methodName) : this.model.getClassReference("Foo").getInstanceMethod(methodName);
        JSDocInfo comment = method.getComment();
        JSTypeExpression parameterType = comment.getParameterType(paramName);
        JSType jsType = this.model.evaluate(parameterType);
        return jsType;
    }

    @Override
    protected void configure(ExternCConfiguration config) throws IOException {
    }
}

