/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import java.io.IOException;
import java.util.List;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestBase;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.BaseReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.junit.Assert;
import org.junit.Test;

public class TestTypeInheritence
extends TypedefsTestBase {
    @Test
    public void test_superclasses() throws Exception {
        this.compile("type_inheritence.js");
        ClassReference EventTarget = this.model.getInterfaceReference("EventTarget");
        ClassReference Object2 = this.model.getClassReference("Object");
        ClassReference Foo = this.model.getClassReference("Foo");
        ClassReference Bar = this.model.getClassReference("Bar");
        ClassReference Baz = this.model.getClassReference("Baz");
        Assert.assertNotNull((Object)Object2);
        Assert.assertNotNull((Object)EventTarget);
        Assert.assertNotNull((Object)Foo);
        Assert.assertNotNull((Object)Bar);
        Assert.assertNotNull((Object)Baz);
        Assert.assertSame((Object)EventTarget, Foo.getImplementedInterfaces().get(0));
        Assert.assertSame((Object)Object2, (Object)Foo.getSuperClass());
        Assert.assertSame((Object)Foo, (Object)Bar.getSuperClass());
        Assert.assertSame((Object)Bar, (Object)Baz.getSuperClass());
        List superClasses = Baz.getSuperClasses();
        Assert.assertEquals((long)3L, (long)superClasses.size());
        Assert.assertSame((Object)Bar, superClasses.get(0));
        Assert.assertSame((Object)Foo, superClasses.get(1));
        Assert.assertSame((Object)Object2, superClasses.get(2));
        Assert.assertTrue((boolean)Foo.hasInstanceMethod("addEventListener"));
        String result = this.client.getEmitter().emit((BaseReference)Foo.getInstanceMethod("addEventListener"));
        Assert.assertEquals((Object)"    /**\n     * @param opt_useCapture [(boolean|undefined)] \n     * @see [type_inheritence]\n     */\n    public function addEventListener(type:String, listener:Object, useCapture:Boolean):Object /* undefined */ {  return null; }\n", (Object)result);
    }

    @Override
    protected void configure(ExternCConfiguration config) throws IOException {
        TypedefsTestUtils.init();
        config.setASRoot(TypedefsTestUtils.AS_ROOT_DIR);
    }
}

