/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import com.google.javascript.jscomp.Result;
import java.io.IOException;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestBase;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.junit.Assert;
import org.junit.Test;

public class TestExternNode
extends TypedefsTestBase {
    @Test
    public void test_classes() throws IOException {
        Result result = this.compile();
        Assert.assertTrue((String)"Compile Node.js externs not successful", (boolean)result.success);
        ClassReference child_process_ChildProcess = this.model.getClassReference("child_process.ChildProcess");
        Assert.assertNotNull((String)"child_process.ChildProcess not found in Node.js externs", (Object)child_process_ChildProcess);
        StringBuilder sb = new StringBuilder();
        child_process_ChildProcess.emit(sb);
        String r = sb.toString();
        Assert.assertTrue((String)"child_process.ChildProcess must contain [JSModule(name=\"child_process\")] named module metadata", (boolean)r.contains("[JSModule(name=\"child_process\")]"));
    }

    @Override
    protected void configure(ExternCConfiguration config) throws IOException {
        TypedefsTestUtils.init();
        config.setASRoot(TypedefsTestUtils.AS_ROOT_DIR);
        config.addNamedModule("assert");
        config.addNamedModule("buffer");
        config.addNamedModule("child_process");
        config.addNamedModule("cluster");
        config.addNamedModule("crypto");
        config.addNamedModule("dgram");
        config.addNamedModule("dns");
        config.addNamedModule("domain");
        config.addNamedModule("events");
        config.addNamedModule("fs");
        config.addNamedModule("globals");
        config.addNamedModule("http");
        config.addNamedModule("https");
        config.addNamedModule("net");
        config.addNamedModule("os");
        config.addNamedModule("path");
        config.addNamedModule("punycode");
        config.addNamedModule("querystring");
        config.addNamedModule("readline");
        config.addNamedModule("repl");
        config.addNamedModule("stream");
        config.addNamedModule("string_decoder");
        config.addNamedModule("tls");
        config.addNamedModule("tty");
        config.addNamedModule("url");
        config.addNamedModule("util");
        config.addNamedModule("vm");
        config.addNamedModule("zlib");
        config.addExclude("Buffer", "toJSON");
        config.addExclude("osNetworkInterfacesInfo", "internal");
        String coreRoot = TypedefsTestUtils.EXTERNAL_NODE_DIR.getAbsolutePath();
        config.addTypedef(coreRoot + "/assert.js");
        config.addTypedef(coreRoot + "/buffer.js");
        config.addTypedef(coreRoot + "/child_process.js");
        config.addTypedef(coreRoot + "/cluster.js");
        config.addTypedef(coreRoot + "/crypto.js");
        config.addTypedef(coreRoot + "/dgram.js");
        config.addTypedef(coreRoot + "/dns.js");
        config.addTypedef(coreRoot + "/domain.js");
        config.addTypedef(coreRoot + "/events.js");
        config.addTypedef(coreRoot + "/fs.js");
        config.addTypedef(coreRoot + "/globals.js");
        config.addTypedef(coreRoot + "/http.js");
        config.addTypedef(coreRoot + "/https.js");
        config.addTypedef(coreRoot + "/net.js");
        config.addTypedef(coreRoot + "/os.js");
        config.addTypedef(coreRoot + "/path.js");
        config.addTypedef(coreRoot + "/punycode.js");
        config.addTypedef(coreRoot + "/querystring.js");
        config.addTypedef(coreRoot + "/readline.js");
        config.addTypedef(coreRoot + "/repl.js");
        config.addTypedef(coreRoot + "/stream.js");
        config.addTypedef(coreRoot + "/string_decoder.js");
        config.addTypedef(coreRoot + "/tls.js");
        config.addTypedef(coreRoot + "/tty.js");
        config.addTypedef(coreRoot + "/url.js");
        config.addTypedef(coreRoot + "/util.js");
        config.addTypedef(coreRoot + "/vm.js");
        config.addTypedef(coreRoot + "/zlib.js");
    }
}

