/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import com.google.javascript.jscomp.Result;
import java.io.IOException;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestBase;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.junit.Assert;
import org.junit.Test;

public class TestExternJasmine
extends TypedefsTestBase {
    @Test
    public void test_classes() throws IOException {
        this.client.cleanOutput();
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        String[] classes = new String[]{"jasmine", "jasmine.Clock"};
        Assert.assertEquals((long)9L, (long)this.model.getClasses().size());
        for (String className : classes) {
            Assert.assertTrue((boolean)this.model.hasClass(className));
        }
        this.client.emit();
    }

    @Test
    public void test_members() throws IOException {
        this.client.cleanOutput();
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        ClassReference jasmine = this.model.getClassReference("jasmine");
        Assert.assertNotNull((Object)jasmine);
        Assert.assertTrue((boolean)jasmine.hasStaticMethod("clock"));
        Assert.assertEquals((Object)"jasmine.Clock", (Object)jasmine.getStaticMethod("clock").toReturnTypeAnnotationString());
        Assert.assertTrue((boolean)jasmine.hasImport("jasmine.Clock"));
        ClassReference Clock = this.model.getClassReference("jasmine.Clock");
        Assert.assertNotNull((Object)Clock);
    }

    @Override
    protected void configure(ExternCConfiguration install) throws IOException {
        TypedefsTestUtils.init();
        this.config.setASRoot(TypedefsTestUtils.AS_ROOT_DIR);
        String coreRoot = TypedefsTestUtils.EXTERNAL_JASMINE_DIR.getAbsolutePath();
        this.config.addTypedef(coreRoot + "/jasmine-2.0.js");
    }
}

