/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import com.google.javascript.jscomp.Result;
import java.io.IOException;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestBase;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.junit.Assert;
import org.junit.Test;

public class TestExternJSMissing
extends TypedefsTestBase {
    @Test
    public void test_classes() throws IOException {
        String[] classes;
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        for (String className : classes = new String[]{"int", "uint", "Class"}) {
            Assert.assertTrue((boolean)this.model.hasClass(className));
        }
    }

    @Test
    public void test_functions() throws IOException {
        String[] functions;
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        for (String functionName : functions = new String[]{"trace"}) {
            Assert.assertTrue((boolean)this.model.hasFunction(functionName));
        }
    }

    @Test
    public void test_Class() throws IOException {
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        ClassReference ClassClass = this.model.getClassReference("Class");
        Assert.assertNotNull((Object)ClassClass);
        Assert.assertTrue((boolean)ClassClass.isDynamic());
    }

    @Test
    public void test_int() throws IOException {
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        ClassReference intClass = this.model.getClassReference("int");
        Assert.assertNotNull((Object)intClass);
        Assert.assertTrue((boolean)intClass.hasStaticField("MIN_VALUE"));
        Assert.assertTrue((boolean)intClass.hasStaticField("MAX_VALUE"));
    }

    @Test
    public void test_uint() throws IOException {
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        ClassReference uintClass = this.model.getClassReference("uint");
        Assert.assertNotNull((Object)uintClass);
        Assert.assertTrue((boolean)uintClass.hasStaticField("MIN_VALUE"));
        Assert.assertTrue((boolean)uintClass.hasStaticField("MAX_VALUE"));
    }

    @Override
    protected void configure(ExternCConfiguration config) throws IOException {
        TypedefsTestUtils.init();
        config.setASRoot(TypedefsTestUtils.AS_ROOT_DIR);
        String coreRoot = TypedefsTestUtils.TYPEDEFS_JS_DIR.getAbsolutePath();
        System.out.println(coreRoot);
        config.addTypedef(coreRoot + "/es3.js");
        config.addTypedef(TypedefsTestUtils.MISSING_JS_FILE);
    }
}

