/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import com.google.javascript.jscomp.Result;
import java.io.IOException;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestBase;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.MethodReference;
import org.junit.Assert;
import org.junit.Test;

public class TestExternES3
extends TypedefsTestBase {
    @Test
    public void test_classes() throws IOException {
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        String[] classes = new String[]{"Arguments", "Object", "Function", "Array", "Boolean", "Number", "Date", "String", "RegExp", "Error", "EvalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError", "Math"};
        Assert.assertEquals((long)23L, (long)this.model.getClasses().size());
        for (String className : classes) {
            Assert.assertTrue((boolean)this.model.hasClass(className));
        }
    }

    @Test
    public void test_Object() throws IOException {
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        ClassReference Object2 = this.model.getClassReference("Object");
        Assert.assertNotNull((Object)Object2);
        Assert.assertTrue((boolean)Object2.isDynamic());
    }

    @Test
    public void test_Array() throws IOException {
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        ClassReference Array = this.model.getClassReference("Array");
        Assert.assertNotNull((Object)Array);
        MethodReference constructor = Array.getConstructor();
        StringBuilder sb = new StringBuilder();
        constructor.emitCode(sb);
        String emit = sb.toString();
        Assert.assertEquals((Object)"    public function Array(...var_args):Array {  return null; }\n", (Object)emit);
    }

    @Test
    public void test_Array_indexOf() throws IOException {
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        ClassReference Array = this.model.getClassReference("Array");
        Assert.assertNotNull((Object)Array);
        MethodReference indexOf = Array.getInstanceMethod("indexOf");
        StringBuilder sb = new StringBuilder();
        indexOf.emitCode(sb);
        String emit = sb.toString();
        Assert.assertEquals((Object)"    public function indexOf(obj:Object, opt_fromIndex:Number = 0):Number { return 0; }\n", (Object)emit);
    }

    @Override
    protected void configure(ExternCConfiguration config) throws IOException {
        TypedefsTestUtils.init();
        config.setASRoot(TypedefsTestUtils.AS_ROOT_DIR);
        String coreRoot = TypedefsTestUtils.TYPEDEFS_JS_DIR.getAbsolutePath();
        config.addTypedef(coreRoot + "/es3.js");
    }
}

