/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import com.google.javascript.jscomp.Result;
import java.io.IOException;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestBase;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.junit.Assert;
import org.junit.Test;

public class TestExternChrome
extends TypedefsTestBase {
    @Test
    public void test_classes() throws IOException {
        this.client.cleanOutput();
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        if (this.model.problems.getProblems().size() > 0) {
            for (ICompilerProblem problem : this.model.problems.getProblems()) {
                System.out.println(problem.toString() + " " + problem.getSourcePath() + " " + problem.getLine());
            }
        }
        Assert.assertEquals((long)0L, (long)this.model.problems.getProblems().size());
        String[] classes = new String[]{"chrome", "chrome.app", "chrome.webstore", "chrome.runtime", "chrome.runtime.lastError", "Port", "ChromeEvent", "ChromeStringEvent", "ChromeBooleanEvent", "ChromeNumberEvent", "ChromeObjectEvent", "ChromeStringArrayEvent", "ChromeStringStringEvent", "MessageSender", "Tab", "ChromeLoadTimes", "ChromeCsiInfo"};
        Assert.assertEquals((long)322L, (long)this.model.getClasses().size());
        for (String className : classes) {
            Assert.assertTrue((boolean)this.model.hasClass(className));
        }
        this.client.emit();
    }

    @Test
    public void test_members() throws IOException {
        this.client.cleanOutput();
        Result result = this.compile();
        Assert.assertTrue((boolean)result.success);
        if (this.model.problems.getProblems().size() > 0) {
            for (ICompilerProblem problem : this.model.problems.getProblems()) {
                System.out.println(problem.toString() + " " + problem.getSourcePath() + " " + problem.getLine());
            }
        }
        Assert.assertEquals((long)0L, (long)this.model.problems.getProblems().size());
        ClassReference Port = this.model.getClassReference("Port");
        Assert.assertNotNull((Object)Port);
        Assert.assertTrue((boolean)Port.hasInstanceField("name"));
        Assert.assertTrue((boolean)Port.hasInstanceField("onDisconnect"));
        Assert.assertTrue((boolean)Port.hasInstanceField("onMessage"));
        Assert.assertTrue((boolean)Port.hasInstanceField("sender"));
        Assert.assertTrue((boolean)Port.hasInstanceMethod("postMessage"));
        Assert.assertTrue((boolean)Port.hasInstanceMethod("disconnect"));
        Assert.assertEquals((Object)"string", (Object)Port.getInstanceField("name").toTypeAnnotationString());
        Assert.assertEquals((Object)"ChromeEvent", (Object)Port.getInstanceField("onDisconnect").toTypeAnnotationString());
        Assert.assertEquals((Object)"ChromeEvent", (Object)Port.getInstanceField("onMessage").toTypeAnnotationString());
        Assert.assertEquals((Object)"(MessageSender|undefined)", (Object)Port.getInstanceField("sender").toTypeAnnotationString());
        ClassReference chrome = this.model.getClassReference("chrome");
        Assert.assertNotNull((Object)chrome);
        Assert.assertTrue((boolean)chrome.hasStaticMethod("loadTimes"));
        Assert.assertTrue((boolean)chrome.hasStaticMethod("csi"));
        Assert.assertEquals((Object)"ChromeLoadTimes", (Object)chrome.getStaticMethod("loadTimes").toReturnTypeAnnotationString());
        Assert.assertEquals((Object)"ChromeCsiInfo", (Object)chrome.getStaticMethod("csi").toReturnTypeAnnotationString());
        ClassReference chrome_app = this.model.getClassReference("chrome.app");
        Assert.assertNotNull((Object)chrome_app);
        Assert.assertTrue((boolean)chrome_app.hasStaticField("isInstalled"));
        Assert.assertEquals((Object)"boolean", (Object)chrome_app.getStaticField("isInstalled").toTypeAnnotationString());
        ClassReference chrome_runtime = this.model.getClassReference("chrome.runtime");
        Assert.assertNotNull((Object)chrome_runtime);
        Assert.assertTrue((boolean)chrome_runtime.hasStaticMethod("connect"));
        Assert.assertTrue((boolean)chrome_runtime.hasStaticMethod("sendMessage"));
        ClassReference chrome_runtime_lastError = this.model.getClassReference("chrome.runtime.lastError");
        Assert.assertNotNull((Object)chrome_runtime_lastError);
        Assert.assertTrue((boolean)chrome_runtime_lastError.hasStaticField("message"));
        Assert.assertEquals((Object)"(string|undefined)", (Object)chrome_runtime_lastError.getStaticField("message").toTypeAnnotationString());
        ClassReference chrome_webstore = this.model.getClassReference("chrome.webstore");
        Assert.assertNotNull((Object)chrome_webstore);
        Assert.assertTrue((boolean)chrome_webstore.hasStaticField("onInstallStageChanged"));
        Assert.assertTrue((boolean)chrome_webstore.hasStaticField("onDownloadProgress"));
        Assert.assertTrue((boolean)chrome_webstore.hasStaticMethod("install"));
        Assert.assertTrue((boolean)chrome.hasStaticField("app"));
        Assert.assertTrue((boolean)chrome.hasStaticField("runtime"));
        Assert.assertTrue((boolean)chrome.hasStaticField("webstore"));
        Assert.assertTrue((boolean)chrome_runtime.hasInstanceField("lastError"));
    }

    @Override
    protected void configure(ExternCConfiguration install) throws IOException {
        TypedefsTestUtils.init();
        this.config.setASRoot(TypedefsTestUtils.AS_ROOT_DIR);
        String coreRoot = TypedefsTestUtils.TYPEDEFS_JS_DIR.getAbsolutePath();
        this.config.addTypedef(coreRoot + "/es3.js");
        this.config.addTypedef(coreRoot + "/es6.js");
        this.config.addTypedef(coreRoot + "/browser/chrome.js");
        this.config.addTypedef(coreRoot + "/browser/html5.js");
        this.config.addTypedef(coreRoot + "/browser/ie_dom.js");
        this.config.addTypedef(coreRoot + "/browser/gecko_dom.js");
        this.config.addTypedef(coreRoot + "/browser/w3c_css.js");
        this.config.addTypedef(coreRoot + "/browser/w3c_event.js");
        this.config.addTypedef(coreRoot + "/browser/w3c_range.js");
        this.config.addTypedef(coreRoot + "/browser/w3c_dom1.js");
        this.config.addTypedef(coreRoot + "/browser/w3c_dom2.js");
        this.config.addTypedef(coreRoot + "/browser/w3c_dom3.js");
        this.config.addTypedef(coreRoot + "/browser/w3c_xml.js");
    }
}

