/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import java.io.IOException;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestBase;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.junit.Assert;
import org.junit.Test;

public class TestConstructor
extends TypedefsTestBase {
    @Test
    public void test_const_object_literal() throws IOException {
        this.compile("constructor_params.js");
        Assert.assertTrue((boolean)this.model.hasClass("FinalClass"));
        Assert.assertTrue((boolean)this.model.getClassReference("FinalClass").hasStaticMethod("bar"));
        Assert.assertTrue((boolean)this.model.getClassReference("FinalClass").getStaticMethod("bar").isStatic());
    }

    @Test
    public void test_constructor_args() throws IOException {
        this.compile("constructor_params.js");
        ClassReference FooNoArgs = this.model.getClassReference("FooNoArgs");
        ClassReference FooOptArgs = this.model.getClassReference("FooOptArgs");
        ClassReference FooVarArgs = this.model.getClassReference("FooVarArgs");
        ClassReference FooOptVarArgs = this.model.getClassReference("FooOptVarArgs");
        Assert.assertNotNull((Object)FooNoArgs.getConstructor());
        Assert.assertNotNull((Object)FooOptArgs.getConstructor());
        Assert.assertNotNull((Object)FooVarArgs.getConstructor());
        Assert.assertNotNull((Object)FooOptVarArgs.getConstructor());
        Assert.assertEquals((long)0L, (long)FooNoArgs.getConstructor().getParameterNames().size());
        Assert.assertEquals((long)2L, (long)FooOptArgs.getConstructor().getParameterNames().size());
        Assert.assertEquals((long)2L, (long)FooVarArgs.getConstructor().getParameterNames().size());
        Assert.assertEquals((long)3L, (long)FooOptVarArgs.getConstructor().getParameterNames().size());
        Assert.assertFalse((boolean)FooOptArgs.getConstructor().getComment().getParameterType("arg1").isOptionalArg());
        Assert.assertTrue((boolean)FooOptArgs.getConstructor().getComment().getParameterType("opt_arg2").isOptionalArg());
        Assert.assertFalse((boolean)FooVarArgs.getConstructor().getComment().getParameterType("arg1").isVarArgs());
        Assert.assertTrue((boolean)FooVarArgs.getConstructor().getComment().getParameterType("var_args").isVarArgs());
        Assert.assertTrue((boolean)FooOptVarArgs.getConstructor().getComment().getParameterType("opt_arg2").isOptionalArg());
        Assert.assertTrue((boolean)FooOptVarArgs.getConstructor().getComment().getParameterType("var_args").isVarArgs());
        Assert.assertEquals((Object)"number", (Object)this.evaluateParam(FooOptVarArgs.getConstructor(), "arg1").toAnnotationString());
        Assert.assertEquals((Object)"*", (Object)this.evaluateParam(FooOptVarArgs.getConstructor(), "opt_arg2").toAnnotationString());
        Assert.assertEquals((Object)"*", (Object)this.evaluateParam(FooOptVarArgs.getConstructor(), "var_args").toAnnotationString());
    }

    @Test
    public void test_constructor_comment() throws IOException {
        this.compile("constructor_params.js");
        StringBuilder sb = new StringBuilder();
        ClassReference FooOptVarArgs = this.model.getClassReference("FooOptVarArgs");
        FooOptVarArgs.getConstructor().emit(sb);
        String string = sb.toString();
        Assert.assertEquals((Object)"    /**\n     * A constructor with arg, opt arg and var args.\n     *\n     * @param arg1 [number] The arg 1.\n     * @param opt_arg2 [*] The arg  that is wrapped by another line in the comment.\n     * @param var_args [*] A var agr param.\n     * @see http://foo.bar.com \n     * @see [constructor_params]\n     * @returns {(FooVarArgs|null)} Another instance.\n     */\n    public function FooOptVarArgs(arg1:Number, opt_arg2:* = null, ...var_args) {\n        super();\n    }\n", (Object)string);
    }

    @Override
    protected void configure(ExternCConfiguration config) throws IOException {
    }
}

