/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.TypedefsTestBase;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.FunctionReference;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestCollectImports
extends TypedefsTestBase {
    private static final String IMPORTS_TEST_DIR = "imports/";
    private Boolean excludeClass;

    @Parameterized.Parameters
    public static Collection<Object[]> excludeClassYesNo() {
        return Arrays.asList({true}, {false});
    }

    public TestCollectImports(Boolean excludeClass) {
        this.excludeClass = excludeClass;
    }

    @Test
    public void import_constructor_signatures() throws Exception {
        if (this.excludeClass.booleanValue()) {
            this.config.addClassExclude("foo.Baz");
        }
        this.assertCompileTestFileSuccess(IMPORTS_TEST_DIR);
        ClassReference importConstructorSignature = this.model.getClassReference("ImportConstructorSignature");
        Assert.assertNotNull((Object)importConstructorSignature);
        Assert.assertFalse((boolean)importConstructorSignature.hasImport("Number"));
        Assert.assertFalse((boolean)importConstructorSignature.hasImport("foo.Qux"));
        Assert.assertTrue((boolean)importConstructorSignature.hasImport("foo.Bar"));
        if (this.excludeClass.booleanValue()) {
            Assert.assertFalse((boolean)importConstructorSignature.hasImport("foo.Baz"));
        } else {
            Assert.assertTrue((boolean)importConstructorSignature.hasImport("foo.Baz"));
        }
    }

    @Test
    public void import_method_signatures() throws Exception {
        if (this.excludeClass.booleanValue()) {
            this.config.addClassExclude("foo.Qux");
        }
        this.assertCompileTestFileSuccess(IMPORTS_TEST_DIR);
        ClassReference importMethodSignature = this.model.getClassReference("ImportMethodSignature");
        Assert.assertNotNull((Object)importMethodSignature);
        Assert.assertFalse((boolean)importMethodSignature.hasImport("Number"));
        Assert.assertFalse((boolean)importMethodSignature.hasImport("foo.Quux"));
        Assert.assertFalse((boolean)importMethodSignature.hasImport("foo.Quuux"));
        Assert.assertTrue((boolean)importMethodSignature.hasImport("foo.Bar"));
        Assert.assertTrue((boolean)importMethodSignature.hasImport("foo.Baz"));
        if (this.excludeClass.booleanValue()) {
            Assert.assertFalse((boolean)importMethodSignature.hasImport("foo.Qux"));
        } else {
            Assert.assertTrue((boolean)importMethodSignature.hasImport("foo.Qux"));
        }
    }

    @Test
    public void import_interfaces() throws Exception {
        if (this.excludeClass.booleanValue()) {
            this.config.addClassExclude("API.foo.Baz");
        }
        this.assertCompileTestFileSuccess(IMPORTS_TEST_DIR);
        ClassReference importInterfaces = this.model.getClassReference("ImportInterfaces");
        Assert.assertNotNull((Object)importInterfaces);
        Assert.assertFalse((boolean)importInterfaces.hasImport("qux"));
        Assert.assertTrue((boolean)importInterfaces.hasImport("API.Foo"));
        ClassReference apiFoo = this.model.getClassReference("API.Foo");
        Assert.assertNotNull((Object)apiFoo);
        Assert.assertFalse((boolean)apiFoo.hasImport("qux"));
        Assert.assertFalse((boolean)apiFoo.hasImport("API.Bar"));
        if (this.excludeClass.booleanValue()) {
            Assert.assertFalse((boolean)apiFoo.hasImport("API.foo.Baz"));
        } else {
            Assert.assertTrue((boolean)apiFoo.hasImport("API.foo.Baz"));
        }
    }

    @Test
    public void import_superclasses() throws Exception {
        if (this.excludeClass.booleanValue()) {
            this.config.addClassExclude("BASE.Foo");
        }
        this.assertCompileTestFileSuccess(IMPORTS_TEST_DIR);
        ClassReference importSuperClass1 = this.model.getClassReference("ImportSuperClass1");
        Assert.assertNotNull((Object)importSuperClass1);
        Assert.assertFalse((boolean)importSuperClass1.hasImport("qux"));
        ClassReference importSuperClass2 = this.model.getClassReference("ImportSuperClass2");
        Assert.assertNotNull((Object)importSuperClass2);
        if (this.excludeClass.booleanValue()) {
            Assert.assertFalse((boolean)importSuperClass2.hasImport("BASE.Foo"));
        } else {
            Assert.assertTrue((boolean)importSuperClass2.hasImport("BASE.Foo"));
        }
        ClassReference foo = this.model.getClassReference("BASE.Foo");
        Assert.assertNotNull((Object)foo);
        Assert.assertFalse((boolean)foo.hasImport("BASE.Bar"));
    }

    @Test
    public void import_functions() throws Exception {
        if (this.excludeClass.booleanValue()) {
            this.config.addClassExclude("foo.Qux");
        }
        this.assertCompileTestFileSuccess(IMPORTS_TEST_DIR);
        FunctionReference importFunction = (FunctionReference)this.model.getFunctions().toArray()[0];
        Assert.assertNotNull((Object)importFunction);
        Assert.assertTrue((boolean)importFunction.getQualifiedName().equals("ImportFunction"));
        Assert.assertFalse((boolean)importFunction.hasImport("Quux"));
        Assert.assertTrue((boolean)importFunction.hasImport("foo.Bar"));
        Assert.assertTrue((boolean)importFunction.hasImport("foo.Baz"));
        if (this.excludeClass.booleanValue()) {
            Assert.assertFalse((boolean)importFunction.hasImport("foo.Qux"));
        } else {
            Assert.assertTrue((boolean)importFunction.hasImport("foo.Qux"));
        }
    }

    @Override
    protected void configure(ExternCConfiguration config) throws IOException {
    }
}

