/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs;

import java.util.ArrayList;
import java.util.List;

public class CompilerArguments {
    private List<String> bundles = new ArrayList<String>();
    private List<String> libraries = new ArrayList<String>();
    private List<String> sources = new ArrayList<String>();
    private List<String> includes = new ArrayList<String>();
    private String sdkPath = "";
    private String appName = "";
    private String output;
    private String jsLibraryPath = "";
    private String jsBasePath = "";
    private Boolean jsOutputAsFiles = null;
    private List<String> metadatas = new ArrayList<String>();
    private List<String> docMembers = new ArrayList<String>();
    private List<String> docNamespace = new ArrayList<String>();
    private String mainTitle;
    private String footer;

    public void addBundlePath(String path) {
        if (this.bundles.contains(path)) {
            return;
        }
        this.bundles.add(path);
    }

    public void addLibraryPath(String path) {
        if (this.libraries.contains(path)) {
            return;
        }
        this.libraries.add(path);
    }

    public void addSourcepath(String path) {
        if (this.sources.contains(path)) {
            return;
        }
        this.sources.add(path);
    }

    public void addIncludedSources(String path) {
        if (this.includes.contains(path)) {
            return;
        }
        this.includes.add(path);
    }

    public List<String> getBundles() {
        return this.bundles;
    }

    public List<String> getLibraries() {
        return this.libraries;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public String getSDKPath() {
        return this.sdkPath;
    }

    public void setSDKPath(String value) {
        this.sdkPath = value;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String value) {
        this.appName = value;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String path) {
        this.output = path;
    }

    public String getJsLibraryPath() {
        return this.jsLibraryPath;
    }

    public void setJsLibraryPath(String jsLibraryPath) {
        this.jsLibraryPath = jsLibraryPath;
    }

    public String getJsBasePath() {
        return this.jsBasePath;
    }

    public void setJsBasePath(String jsBasePath) {
        this.jsBasePath = jsBasePath;
    }

    public Boolean isJsOutputAsFiles() {
        return this.jsOutputAsFiles;
    }

    public void setJsOutputAsFiles(Boolean jsOutputAsFiles) {
        this.jsOutputAsFiles = jsOutputAsFiles;
    }

    public List<String> getKeepMetadata() {
        return this.metadatas;
    }

    public void addKeepMetadata(String metadata) {
        if (this.metadatas.contains(metadata)) {
            return;
        }
        this.metadatas.add(metadata);
    }

    public String getMainTitle() {
        return this.mainTitle;
    }

    public void setMainTitle(String value) {
        this.mainTitle = value;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String value) {
        this.footer = value;
    }

    public void addDocMember(String member) {
        if (this.docMembers.contains(member)) {
            return;
        }
        this.docMembers.add(member);
    }

    public void addDocNamespace(String namespace) {
        if (this.docNamespace.contains(namespace)) {
            return;
        }
        this.docNamespace.add(namespace);
    }

    public void clear() {
        this.jsBasePath = "";
        this.jsLibraryPath = "";
        this.jsOutputAsFiles = false;
        this.output = "";
        this.clearLibraries();
        this.clearSourcePaths();
        this.includes.clear();
    }

    public void clearSourcePaths() {
        this.sources = new ArrayList<String>();
    }

    public void clearBundles() {
        this.bundles = new ArrayList<String>();
    }

    public void clearLibraries() {
        this.libraries = new ArrayList<String>();
    }

    public List<String> toArguments() {
        String library;
        String base;
        String name;
        String sdk;
        ArrayList<String> result = new ArrayList<String>();
        for (String arg : this.bundles) {
            result.add("-bundle-path=" + arg);
        }
        for (String arg : this.libraries) {
            result.add("-library-path=" + arg);
        }
        for (String arg : this.sources) {
            result.add("-source-path=" + arg);
        }
        if (this.includes.size() > 0) {
            result.add("-include-sources=" + this.join(this.includes, ","));
        }
        if (this.metadatas.size() > 0) {
            result.add("-keep-as3-metadata=" + this.join(this.metadatas, ","));
        }
        if ((sdk = this.getSDKPath()) != null && !sdk.equals("")) {
            result.add("-sdk-path=" + sdk);
        }
        if ((name = this.getAppName()) != null && !name.equals("")) {
            result.add("-app-name=" + name);
        }
        if (!(base = this.getJsBasePath()).equals("")) {
            result.add("-js-base-path=" + base);
        }
        if (!(library = this.getJsLibraryPath()).equals("")) {
            result.add("-js-library-path=" + library);
        }
        if (this.isJsOutputAsFiles() != null) {
            result.add("-js-classes-as-files=" + (this.isJsOutputAsFiles() != false ? "true" : "false"));
        }
        result.add("-output=" + this.getOutput());
        this.addArguments(result);
        return result;
    }

    protected void addArguments(List<String> arguments) {
        String mainTitle = this.getMainTitle();
        if (mainTitle != null && !mainTitle.equals("")) {
            arguments.add("-main-title=" + mainTitle);
        }
        if (this.footer != null && !this.footer.equals("")) {
            arguments.add("-footer=" + this.footer);
        }
        if (this.docMembers.size() > 0) {
            arguments.add("-doc-member=" + this.join(this.docMembers, ","));
        }
        if (this.docNamespace.size() > 0) {
            arguments.add("-doc-namespace=" + this.join(this.docNamespace, ","));
        }
    }

    private String join(List<String> items, String separator) {
        StringBuilder sb = new StringBuilder();
        int len = items.size();
        int index = 0;
        for (String item : items) {
            sb.append(item);
            if (index < len) {
                sb.append(separator);
            }
            ++index;
        }
        return sb.toString();
    }

    public String toString() {
        return this.join(this.toArguments(), " ");
    }

    public static class CompilerArgument {
        private String name;
        private String value;

        CompilerArgument(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public static CompilerArgument create(String name, String value) {
            return new CompilerArgument(name, value);
        }
    }
}

