/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.tools.annotate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class AnnotateClass {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processFile(File file, String annotation, String dateStart, String dateEnd) throws AnnotateClassDeleteException, AnnotateClassRenameException {
        if (!file.exists()) {
            System.out.println("Missing file: " + file.getPath());
            return;
        }
        String comment = "";
        if (dateStart.length() > 0) {
            int c = dateStart.indexOf("***");
            if (c > -1) {
                comment = dateStart.substring(0, c);
                dateStart = dateStart.substring(c + 3);
            }
            System.out.println("searching for generated date line starting with: '" + dateStart + "'");
            if (comment.length() > 0) {
                System.out.println("and comment starting with: '" + comment + "'");
            }
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            File tmpOutputFile = new File(file.getParentFile(), file.getName() + ".tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(tmpOutputFile);
            PrintStream outputStream = new PrintStream(fileOutputStream);
            try {
                String line;
                boolean alreadyAnnotated = false;
                while ((line = bufferedReader.readLine()) != null) {
                    int c;
                    if (dateStart.length() > 0 && (comment.length() > 0 && line.startsWith(comment) || comment.length() == 0) && (c = line.indexOf(dateStart)) > -1) {
                        if (dateEnd.length() > 0) {
                            int c1 = line.lastIndexOf(dateEnd);
                            if (c1 > 0) {
                                line = comment + dateStart + line.substring(c1);
                            }
                        } else {
                            line = comment + dateStart;
                        }
                    }
                    if (line.contains(annotation)) {
                        alreadyAnnotated = true;
                        System.out.println("Annotation " + annotation + " already added to class: " + file.getPath());
                    }
                    if (!alreadyAnnotated && (line.startsWith("public class") || line.startsWith("public interface"))) {
                        System.out.println("Adding " + annotation + " to class: " + file.getPath());
                        outputStream.println(annotation);
                    }
                    outputStream.println(line);
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception line) {}
                try {
                    outputStream.close();
                }
                catch (Exception line) {}
                try {
                    fileOutputStream.close();
                }
                catch (Exception line) {}
                try {
                    inputStreamReader.close();
                }
                catch (Exception line) {}
                try {
                    fileInputStream.close();
                }
                catch (Exception line) {}
            }
            if (!file.delete() && file.exists()) {
                for (int i = 0; i < 6; ++i) {
                    Thread.sleep(500L);
                    System.gc();
                    if (file.delete()) break;
                }
                if (file.exists()) {
                    throw new AnnotateClassDeleteException("Error deleting original file at: " + file.getPath());
                }
            }
            if (!tmpOutputFile.renameTo(file)) {
                throw new AnnotateClassRenameException("Error renaming the temp file from: " + tmpOutputFile.getPath() + " to: " + file.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        String annotation = args[1];
        String dateStart = args[2];
        String dateEnd = args[3];
        try {
            AnnotateClass.processFile(f, annotation, dateStart, dateEnd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class AnnotateClassRenameException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AnnotateClassRenameException(String s) {
            super(s);
        }
    }

    public static class AnnotateClassDeleteException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AnnotateClassDeleteException(String s) {
            super(s);
        }
    }
}

