/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.tools.problems;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.royale.compiler.tools.problems.BaseProblemGeneratorMojo;

@Mojo(name="generate-problems-resource-bundle", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ProblemResourceBundleGeneratorMojo
extends BaseProblemGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/main/java/org/apache/royale/compiler/problems", property="inputDir", required=true)
    private File inputDirectory;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/royale/compiler", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="messages_en.properties", property="outputFile", required=true)
    private String outputFile;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    @Override
    protected File getInputDirectory() {
        return this.inputDirectory;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected String getOutputFile() {
        return this.outputFile;
    }

    @Override
    protected void printEntry(PrintWriter writer, File source, boolean last) {
        writer.println(this.getProblemName(source) + "=" + this.getProblemDescription(source));
    }

    private String getProblemName(File sourceFile) {
        String fileName = sourceFile.getName();
        return fileName.substring(0, fileName.length() - "class".length());
    }

    private String getProblemDescription(File sourceFile) {
        try {
            String line;
            BufferedReader sourceFileReader = new BufferedReader(new FileReader(sourceFile));
            StringBuilder sb = null;
            while ((line = sourceFileReader.readLine()) != null) {
                if (line.contains("DESCRIPTION")) {
                    sb = new StringBuilder();
                }
                if (sb == null) continue;
                sb.append(line);
                if (!line.trim().endsWith(";")) continue;
            }
            if (sb != null) {
                line = sb.toString();
                return line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    protected void clean(File outputFile) throws MojoExecutionException {
    }
}

