/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.tools.annotate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class AnnotateClass {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processFile(File file, String annotation) throws AnnotateClassDeleteException, AnnotateClassRenameException {
        if (!file.exists()) {
            System.out.println("Missing file: " + file.getPath());
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            File tmpOutputFile = new File(file.getParentFile(), file.getName() + ".tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(tmpOutputFile);
            PrintStream outputStream = new PrintStream(fileOutputStream);
            try {
                String line;
                boolean alreadyAnnotated = false;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.contains(annotation)) {
                        alreadyAnnotated = true;
                        System.out.println("Annotation " + annotation + " already added to class: " + file.getPath());
                    }
                    if (!alreadyAnnotated && (line.startsWith("public class") || line.startsWith("public interface"))) {
                        System.out.println("Adding " + annotation + " to class: " + file.getPath());
                        outputStream.println(annotation);
                    }
                    outputStream.println(line);
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (!file.delete()) {
                throw new AnnotateClassDeleteException("Error deleting original file at: " + file.getPath());
            }
            if (!tmpOutputFile.renameTo(file)) {
                throw new AnnotateClassRenameException("Error renaming the temp file from: " + tmpOutputFile.getPath() + " to: " + file.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        String annotation = args[1];
        try {
            AnnotateClass.processFile(f, annotation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class AnnotateClassRenameException
    extends Exception {
        public AnnotateClassRenameException(String s) {
            super(s);
        }
    }

    public static class AnnotateClassDeleteException
    extends Exception {
        public AnnotateClassDeleteException(String s) {
            super(s);
        }
    }
}

