/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.tls;

import java.util.Collection;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.MQWait;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TlsIT
extends BaseConf {
    private RMQNormalProducer producer;
    private RMQNormalConsumer consumer;
    private String topic;

    @Before
    public void setUp() {
        this.topic = TlsIT.initTopic();
        this.producer = TlsIT.getProducer(NAMESRV_ADDR, this.topic, true);
        this.consumer = TlsIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQNormalListener(), true);
    }

    @After
    public void tearDown() {
        TlsIT.shutdown();
    }

    @Test
    public void testSendAndReceiveMessageOverTLS() {
        int numberOfMessagesToSend = 16;
        this.producer.send((long)numberOfMessagesToSend);
        boolean consumedAll = MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{this.consumer.getListener()});
        Assertions.assertThat((boolean)consumedAll).isEqualTo(true);
    }
}

