/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.statictopic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.admin.ConsumeStats;
import org.apache.rocketmq.remoting.protocol.admin.OffsetWrapper;
import org.apache.rocketmq.remoting.protocol.admin.TopicOffset;
import org.apache.rocketmq.remoting.protocol.admin.TopicStatsTable;
import org.apache.rocketmq.remoting.protocol.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingOne;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.remoting.rpc.ClientMetadata;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.MQAdminTestUtils;
import org.apache.rocketmq.test.util.MQRandomUtils;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;

@FixMethodOrder
public class StaticTopicIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(StaticTopicIT.class);
    private DefaultMQAdminExt defaultMQAdminExt;

    @Before
    public void setUp() throws Exception {
        System.setProperty("rocketmq.client.rebalance.waitInterval", "500");
        this.defaultMQAdminExt = StaticTopicIT.getAdmin(NAMESRV_ADDR);
        StaticTopicIT.waitBrokerRegistered(NAMESRV_ADDR, CLUSTER_NAME, 3);
        this.defaultMQAdminExt.start();
    }

    @Test
    public void testCommandsWithCluster() throws Exception {
        String topic = "static" + MQRandomUtils.getRandomTopic();
        RMQNormalProducer producer = StaticTopicIT.getProducer(NAMESRV_ADDR, topic);
        RMQNormalConsumer consumer = StaticTopicIT.getConsumer(NAMESRV_ADDR, topic, "*", (AbstractListener)new RMQNormalListener());
        int queueNum = 10;
        int msgEachQueue = 100;
        MQAdminTestUtils.createStaticTopicWithCommand((String)topic, (int)queueNum, null, (String)CLUSTER_NAME, (String)NAMESRV_ADDR);
        this.sendMessagesAndCheck(producer, StaticTopicIT.getBrokers(), topic, queueNum, msgEachQueue, 0L);
        this.consumeMessagesAndCheck(producer, consumer, topic, queueNum, msgEachQueue, 0, 1);
        MQAdminTestUtils.remappingStaticTopicWithCommand((String)topic, null, (String)CLUSTER_NAME, (String)NAMESRV_ADDR);
        this.awaitRefreshStaticTopicMetadata(3000L, topic, producer.getProducer(), consumer.getConsumer(), this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, StaticTopicIT.getBrokers(), topic, queueNum, msgEachQueue, msgEachQueue);
    }

    @Test
    public void testCommandsWithBrokers() throws Exception {
        String topic = "static" + MQRandomUtils.getRandomTopic();
        RMQNormalProducer producer = StaticTopicIT.getProducer(NAMESRV_ADDR, topic);
        RMQNormalConsumer consumer = StaticTopicIT.getConsumer(NAMESRV_ADDR, topic, "*", (AbstractListener)new RMQNormalListener());
        int queueNum = 10;
        int msgEachQueue = 10;
        ImmutableSet brokers = ImmutableSet.of((Object)BROKER1_NAME);
        MQAdminTestUtils.createStaticTopicWithCommand((String)topic, (int)queueNum, (Set)brokers, null, (String)NAMESRV_ADDR);
        this.sendMessagesAndCheck(producer, (Set<String>)brokers, topic, queueNum, msgEachQueue, 0L);
        this.consumeMessagesAndCheck(producer, consumer, topic, queueNum, msgEachQueue, 0, 1);
        brokers = ImmutableSet.of((Object)BROKER2_NAME);
        MQAdminTestUtils.remappingStaticTopicWithCommand((String)topic, (Set)brokers, null, (String)NAMESRV_ADDR);
        this.awaitRefreshStaticTopicMetadata(3000L, topic, producer.getProducer(), consumer.getConsumer(), this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, (Set<String>)brokers, topic, queueNum, msgEachQueue, 10000L);
        this.consumeMessagesAndCheck(producer, consumer, topic, queueNum, msgEachQueue, 0, 2);
    }

    @Test
    public void testNoTargetBrokers() throws Exception {
        String topic = "static" + MQRandomUtils.getRandomTopic();
        int queueNum = 10;
        HashSet<String> targetBrokers = new HashSet<String>();
        targetBrokers.add(BROKER1_NAME);
        MQAdminTestUtils.createStaticTopic((String)topic, (int)queueNum, targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        Map remoteBrokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)this.defaultMQAdminExt);
        Assert.assertEquals((long)3L, (long)remoteBrokerConfigMap.size());
        TopicQueueMappingUtils.checkNameEpochNumConsistence((String)topic, (Map)remoteBrokerConfigMap);
        Map globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems(new ArrayList(TopicQueueMappingUtils.getMappingDetailFromConfig(remoteBrokerConfigMap.values())), (boolean)false, (boolean)true);
        Assert.assertEquals((long)queueNum, (long)globalIdMap.size());
        TopicConfigAndQueueMapping configMapping = (TopicConfigAndQueueMapping)remoteBrokerConfigMap.get(BROKER2_NAME);
        Assert.assertEquals((long)0L, (long)configMapping.getWriteQueueNums());
        Assert.assertEquals((long)0L, (long)configMapping.getReadQueueNums());
        Assert.assertEquals((long)0L, (long)configMapping.getMappingDetail().getHostedQueues().size());
        targetBrokers = new HashSet();
        targetBrokers.add(BROKER2_NAME);
        MQAdminTestUtils.remappingStaticTopic((String)topic, targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        remoteBrokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)this.defaultMQAdminExt);
        Assert.assertEquals((long)3L, (long)remoteBrokerConfigMap.size());
        TopicQueueMappingUtils.checkNameEpochNumConsistence((String)topic, (Map)remoteBrokerConfigMap);
        globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems(new ArrayList(TopicQueueMappingUtils.getMappingDetailFromConfig(remoteBrokerConfigMap.values())), (boolean)false, (boolean)true);
        Assert.assertEquals((long)queueNum, (long)globalIdMap.size());
    }

    private void sendMessagesAndCheck(RMQNormalProducer producer, Set<String> targetBrokers, String topic, int queueNum, int msgEachQueue, long baseOffset) throws Exception {
        ClientMetadata clientMetadata = MQAdminUtils.getBrokerAndTopicMetadata((String)topic, (DefaultMQAdminExt)this.defaultMQAdminExt);
        List messageQueueList = producer.getMessageQueue();
        Assert.assertEquals((long)queueNum, (long)messageQueueList.size());
        for (int i = 0; i < queueNum; ++i) {
            MessageQueue messageQueue = (MessageQueue)messageQueueList.get(i);
            Assert.assertEquals((Object)topic, (Object)messageQueue.getTopic());
            Assert.assertEquals((Object)TopicQueueMappingUtils.getMockBrokerName((String)"__global__"), (Object)messageQueue.getBrokerName());
            Assert.assertEquals((long)i, (long)messageQueue.getQueueId());
            String destBrokerName = clientMetadata.getBrokerNameFromMessageQueue(messageQueue);
            Assert.assertTrue((boolean)targetBrokers.contains(destBrokerName));
        }
        for (MessageQueue messageQueue : messageQueueList) {
            producer.send(msgEachQueue, messageQueue);
        }
        Assert.assertEquals((long)0L, (long)producer.getSendErrorMsg().size());
        Assert.assertTrue((boolean)this.awaitDispatchMs(500L));
        for (MessageQueue messageQueue : messageQueueList) {
            Assert.assertEquals((long)0L, (long)this.defaultMQAdminExt.minOffset(messageQueue));
            Assert.assertEquals((long)((long)msgEachQueue + baseOffset), (long)this.defaultMQAdminExt.maxOffset(messageQueue));
        }
        TopicStatsTable topicStatsTable = this.defaultMQAdminExt.examineTopicStats(topic);
        for (MessageQueue messageQueue : messageQueueList) {
            Assert.assertEquals((long)0L, (long)((TopicOffset)topicStatsTable.getOffsetTable().get(messageQueue)).getMinOffset());
            Assert.assertEquals((long)((long)msgEachQueue + baseOffset), (long)((TopicOffset)topicStatsTable.getOffsetTable().get(messageQueue)).getMaxOffset());
        }
    }

    private Map<Integer, List<MessageExt>> computeMessageByQueue(Collection<Object> msgs) {
        HashMap<Integer, List<MessageExt>> messagesByQueue = new HashMap<Integer, List<MessageExt>>();
        for (Object object : msgs) {
            MessageExt messageExt = (MessageExt)object;
            if (!messagesByQueue.containsKey(messageExt.getQueueId())) {
                messagesByQueue.put(messageExt.getQueueId(), new ArrayList());
            }
            ((List)messagesByQueue.get(messageExt.getQueueId())).add(messageExt);
        }
        for (List msgEachQueue : messagesByQueue.values()) {
            msgEachQueue.sort((o1, o2) -> (int)(o1.getQueueOffset() - o2.getQueueOffset()));
        }
        return messagesByQueue;
    }

    private void consumeMessagesAndCheck(RMQNormalProducer producer, RMQNormalConsumer consumer, String topic, int queueNum, int msgEachQueue, int startGen, int genNum) {
        consumer.getListener().waitForMessageConsume(producer.getAllMsgBody(), 60000);
        Assert.assertEquals((long)producer.getAllMsgBody().size(), (long)consumer.getListener().getAllMsgBody().size());
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)producer.getAllMsgBody());
        Map<Integer, List<MessageExt>> messagesByQueue = this.computeMessageByQueue(consumer.getListener().getAllOriginMsg());
        Assert.assertEquals((long)queueNum, (long)messagesByQueue.size());
        for (int i = 0; i < queueNum; ++i) {
            List<MessageExt> messageExts = messagesByQueue.get(i);
            int totalEachQueue = msgEachQueue * genNum;
            Assert.assertEquals((long)totalEachQueue, (long)messageExts.size());
            for (int j = 0; j < totalEachQueue; ++j) {
                MessageExt messageExt = messageExts.get(j);
                int currGen = startGen + j / msgEachQueue;
                Assert.assertEquals((Object)topic, (Object)messageExt.getTopic());
                Assert.assertEquals((Object)TopicQueueMappingUtils.getMockBrokerName((String)"__global__"), (Object)messageExt.getBrokerName());
                Assert.assertEquals((long)i, (long)messageExt.getQueueId());
                Assert.assertEquals((long)(j % msgEachQueue + currGen * 10000), (long)messageExt.getQueueOffset());
            }
        }
    }

    @Test
    public void testCreateProduceConsumeStaticTopic() throws Exception {
        String topic = "static" + MQRandomUtils.getRandomTopic();
        RMQNormalProducer producer = StaticTopicIT.getProducer(NAMESRV_ADDR, topic);
        RMQNormalConsumer consumer = StaticTopicIT.getConsumer(NAMESRV_ADDR, topic, "*", (AbstractListener)new RMQNormalListener());
        int queueNum = 10;
        int msgEachQueue = 10;
        Map localBrokerConfigMap = MQAdminTestUtils.createStaticTopic((String)topic, (int)queueNum, StaticTopicIT.getBrokers(), (DefaultMQAdminExt)this.defaultMQAdminExt);
        Map remoteBrokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)this.defaultMQAdminExt);
        Assert.assertEquals((long)3L, (long)remoteBrokerConfigMap.size());
        for (Map.Entry entry : remoteBrokerConfigMap.entrySet()) {
            String broker = (String)entry.getKey();
            TopicConfigAndQueueMapping configMapping = (TopicConfigAndQueueMapping)entry.getValue();
            TopicConfigAndQueueMapping localConfigMapping = (TopicConfigAndQueueMapping)localBrokerConfigMap.get(broker);
            Assert.assertNotNull((Object)localConfigMapping);
            Assert.assertEquals((Object)configMapping, (Object)localConfigMapping);
        }
        TopicQueueMappingUtils.checkNameEpochNumConsistence((String)topic, (Map)remoteBrokerConfigMap);
        Map globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems(new ArrayList(TopicQueueMappingUtils.getMappingDetailFromConfig(remoteBrokerConfigMap.values())), (boolean)false, (boolean)true);
        Assert.assertEquals((long)queueNum, (long)globalIdMap.size());
        this.sendMessagesAndCheck(producer, StaticTopicIT.getBrokers(), topic, queueNum, msgEachQueue, 0L);
        this.consumeMessagesAndCheck(producer, consumer, topic, queueNum, msgEachQueue, 0, 1);
    }

    @Test
    public void testRemappingProduceConsumeStaticTopic() throws Exception {
        String topic = "static" + MQRandomUtils.getRandomTopic();
        RMQNormalProducer producer = StaticTopicIT.getProducer(NAMESRV_ADDR, topic);
        RMQNormalConsumer consumer = StaticTopicIT.getConsumer(NAMESRV_ADDR, topic, "*", (AbstractListener)new RMQNormalListener());
        int queueNum = 1;
        int msgEachQueue = 10;
        ImmutableSet targetBrokers = ImmutableSet.of((Object)BROKER1_NAME);
        MQAdminTestUtils.createStaticTopic((String)topic, (int)queueNum, (Set)targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, (Set<String>)targetBrokers, topic, queueNum, msgEachQueue, 0L);
        this.consumeMessagesAndCheck(producer, consumer, topic, queueNum, msgEachQueue, 0, 1);
        targetBrokers = ImmutableSet.of((Object)BROKER2_NAME);
        MQAdminTestUtils.remappingStaticTopic((String)topic, (Set)targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        Map remoteBrokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)this.defaultMQAdminExt);
        TopicQueueMappingUtils.checkNameEpochNumConsistence((String)topic, (Map)remoteBrokerConfigMap);
        Map globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems(new ArrayList(TopicQueueMappingUtils.getMappingDetailFromConfig(remoteBrokerConfigMap.values())), (boolean)false, (boolean)true);
        Assert.assertEquals((long)queueNum, (long)globalIdMap.size());
        for (TopicQueueMappingOne mappingOne : globalIdMap.values()) {
            Assert.assertEquals((Object)BROKER2_NAME, (Object)mappingOne.getBname());
            Assert.assertEquals((long)10000L, (long)((LogicQueueMappingItem)mappingOne.getItems().get(mappingOne.getItems().size() - 1)).getLogicOffset());
        }
        this.awaitRefreshStaticTopicMetadata(3000L, topic, producer.getProducer(), consumer.getConsumer(), this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, (Set<String>)targetBrokers, topic, queueNum, msgEachQueue, 10000L);
        this.consumeMessagesAndCheck(producer, consumer, topic, queueNum, msgEachQueue, 0, 2);
    }

    public boolean awaitRefreshStaticTopicMetadata(long timeMs, String topic, DefaultMQProducer producer, DefaultMQPushConsumer consumer, DefaultMQAdminExt adminExt) throws Exception {
        long start = System.currentTimeMillis();
        MQClientInstance currentInstance = null;
        while (System.currentTimeMillis() - start <= timeMs) {
            boolean allOk = true;
            if (producer != null) {
                currentInstance = producer.getDefaultMQProducerImpl().getmQClientFactory();
                currentInstance.updateTopicRouteInfoFromNameServer(topic);
                if (!MQAdminTestUtils.checkStaticTopic((String)topic, (DefaultMQAdminExt)adminExt, (MQClientInstance)currentInstance)) {
                    allOk = false;
                }
            }
            if (consumer != null) {
                currentInstance = consumer.getDefaultMQPushConsumerImpl().getmQClientFactory();
                currentInstance.updateTopicRouteInfoFromNameServer(topic);
                if (!MQAdminTestUtils.checkStaticTopic((String)topic, (DefaultMQAdminExt)adminExt, (MQClientInstance)currentInstance)) {
                    allOk = false;
                }
            }
            if (adminExt != null) {
                currentInstance = adminExt.getDefaultMQAdminExtImpl().getMqClientInstance();
                currentInstance.updateTopicRouteInfoFromNameServer(topic);
                if (!MQAdminTestUtils.checkStaticTopic((String)topic, (DefaultMQAdminExt)adminExt, (MQClientInstance)currentInstance)) {
                    allOk = false;
                }
            }
            if (allOk) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    @Test
    public void testDoubleReadCheckConsumerOffset() throws Exception {
        String topic = "static" + MQRandomUtils.getRandomTopic();
        String group = StaticTopicIT.initConsumerGroup();
        RMQNormalProducer producer = StaticTopicIT.getProducer(NAMESRV_ADDR, topic);
        RMQNormalConsumer consumer = StaticTopicIT.getConsumer(NAMESRV_ADDR, group, topic, "*", (AbstractListener)new RMQNormalListener());
        long start = System.currentTimeMillis();
        int queueNum = 5;
        int msgEachQueue = 10;
        ImmutableSet targetBrokers = ImmutableSet.of((Object)BROKER1_NAME);
        MQAdminTestUtils.createStaticTopic((String)topic, (int)queueNum, (Set)targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, (Set<String>)targetBrokers, topic, queueNum, msgEachQueue, 0L);
        this.consumeMessagesAndCheck(producer, consumer, topic, queueNum, msgEachQueue, 0, 1);
        producer.shutdown();
        consumer.shutdown();
        producer = StaticTopicIT.getProducer(NAMESRV_ADDR, topic);
        ConsumeStats consumeStats = this.defaultMQAdminExt.examineConsumeStats(group);
        List messageQueues = producer.getMessageQueue();
        for (MessageQueue queue : messageQueues) {
            OffsetWrapper wrapper = (OffsetWrapper)consumeStats.getOffsetTable().get(queue);
            Assert.assertNotNull((Object)wrapper);
            Assert.assertEquals((long)msgEachQueue, (long)wrapper.getBrokerOffset());
            Assert.assertEquals((long)msgEachQueue, (long)wrapper.getConsumerOffset());
            Assert.assertTrue((wrapper.getLastTimestamp() > start ? 1 : 0) != 0);
        }
        ImmutableList brokers = ImmutableList.of((Object)BROKER2_NAME, (Object)BROKER3_NAME, (Object)BROKER1_NAME);
        for (int i = 0; i < brokers.size(); ++i) {
            ImmutableSet targetBrokers2 = ImmutableSet.of(brokers.get(i));
            MQAdminTestUtils.remappingStaticTopic((String)topic, (Set)targetBrokers2, (DefaultMQAdminExt)this.defaultMQAdminExt);
            this.awaitRefreshStaticTopicMetadata(3000L, topic, producer.getProducer(), null, this.defaultMQAdminExt);
            this.sendMessagesAndCheck(producer, (Set<String>)targetBrokers2, topic, queueNum, msgEachQueue, (i + 1) * 10000);
        }
        TestUtils.waitForSeconds((long)1L);
        consumeStats = this.defaultMQAdminExt.examineConsumeStats(group);
        messageQueues = producer.getMessageQueue();
        for (MessageQueue queue : messageQueues) {
            OffsetWrapper wrapper = (OffsetWrapper)consumeStats.getOffsetTable().get(queue);
            Assert.assertNotNull((Object)wrapper);
            Assert.assertEquals((long)(msgEachQueue + brokers.size() * 10000), (long)wrapper.getBrokerOffset());
            Assert.assertEquals((long)msgEachQueue, (long)wrapper.getConsumerOffset());
            Assert.assertTrue((wrapper.getLastTimestamp() > start ? 1 : 0) != 0);
        }
        consumer = StaticTopicIT.getConsumer(NAMESRV_ADDR, group, topic, "*", (AbstractListener)new RMQNormalListener());
        this.consumeMessagesAndCheck(producer, consumer, topic, queueNum, msgEachQueue, 1, brokers.size());
    }

    @Test
    public void testRemappingAndClear() throws Exception {
        String topic = "static" + MQRandomUtils.getRandomTopic();
        RMQNormalProducer producer = StaticTopicIT.getProducer(NAMESRV_ADDR, topic);
        int queueNum = 10;
        int msgEachQueue = 100;
        ImmutableSet targetBrokers = ImmutableSet.of((Object)BROKER1_NAME);
        MQAdminTestUtils.createStaticTopic((String)topic, (int)queueNum, (Set)targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        this.awaitRefreshStaticTopicMetadata(3000L, topic, producer.getProducer(), null, this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, (Set<String>)targetBrokers, topic, queueNum, msgEachQueue, 0L);
        targetBrokers = ImmutableSet.of((Object)BROKER2_NAME);
        MQAdminTestUtils.remappingStaticTopic((String)topic, (Set)targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        this.awaitRefreshStaticTopicMetadata(3000L, topic, producer.getProducer(), null, this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, (Set<String>)targetBrokers, topic, queueNum, msgEachQueue, 10000L);
        targetBrokers = ImmutableSet.of((Object)BROKER3_NAME);
        MQAdminTestUtils.remappingStaticTopic((String)topic, (Set)targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        this.awaitRefreshStaticTopicMetadata(3000L, topic, producer.getProducer(), null, this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, (Set<String>)targetBrokers, topic, queueNum, msgEachQueue, 20000L);
        for (int i = 0; i < 10; ++i) {
            for (BrokerController brokerController : brokerControllerList) {
                brokerController.getTopicQueueMappingCleanService().wakeup();
            }
            Thread.sleep(100L);
        }
        Map brokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)this.defaultMQAdminExt);
        Assert.assertEquals((long)3L, (long)brokerConfigMap.size());
        TopicConfigAndQueueMapping config1 = (TopicConfigAndQueueMapping)brokerConfigMap.get(BROKER1_NAME);
        TopicConfigAndQueueMapping config2 = (TopicConfigAndQueueMapping)brokerConfigMap.get(BROKER2_NAME);
        TopicConfigAndQueueMapping config3 = (TopicConfigAndQueueMapping)brokerConfigMap.get(BROKER3_NAME);
        Assert.assertEquals((long)0L, (long)config1.getMappingDetail().getHostedQueues().size());
        Assert.assertEquals((long)queueNum, (long)config2.getMappingDetail().getHostedQueues().size());
        Assert.assertEquals((long)queueNum, (long)config3.getMappingDetail().getHostedQueues().size());
        HashSet topics = new HashSet(brokerController1.getTopicConfigManager().getTopicConfigTable().keySet());
        topics.remove(topic);
        brokerController1.getMessageStore().cleanUnusedTopic(topics);
        brokerController2.getMessageStore().cleanUnusedTopic(topics);
        for (int i = 0; i < 10; ++i) {
            for (BrokerController brokerController : brokerControllerList) {
                brokerController.getTopicQueueMappingCleanService().wakeup();
            }
            Thread.sleep(100L);
        }
        Map brokerConfigMap2 = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)this.defaultMQAdminExt);
        Assert.assertEquals((long)3L, (long)brokerConfigMap2.size());
        TopicConfigAndQueueMapping config12 = (TopicConfigAndQueueMapping)brokerConfigMap2.get(BROKER1_NAME);
        TopicConfigAndQueueMapping config22 = (TopicConfigAndQueueMapping)brokerConfigMap2.get(BROKER2_NAME);
        TopicConfigAndQueueMapping config32 = (TopicConfigAndQueueMapping)brokerConfigMap2.get(BROKER3_NAME);
        Assert.assertEquals((long)0L, (long)config12.getMappingDetail().getHostedQueues().size());
        Assert.assertEquals((long)queueNum, (long)config22.getMappingDetail().getHostedQueues().size());
        Assert.assertEquals((long)queueNum, (long)config32.getMappingDetail().getHostedQueues().size());
        for (List items : config12.getMappingDetail().getHostedQueues().values()) {
            Assert.assertEquals((long)3L, (long)items.size());
        }
        for (List items : config32.getMappingDetail().getHostedQueues().values()) {
            Assert.assertEquals((long)1L, (long)items.size());
        }
    }

    @Test
    public void testRemappingWithNegativeLogicOffset() throws Exception {
        String topic = "static" + MQRandomUtils.getRandomTopic();
        RMQNormalProducer producer = StaticTopicIT.getProducer(NAMESRV_ADDR, topic);
        int queueNum = 10;
        int msgEachQueue = 100;
        ImmutableSet targetBrokers = ImmutableSet.of((Object)BROKER1_NAME);
        MQAdminTestUtils.createStaticTopic((String)topic, (int)queueNum, (Set)targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, (Set<String>)targetBrokers, topic, queueNum, msgEachQueue, 0L);
        targetBrokers = ImmutableSet.of((Object)BROKER2_NAME);
        MQAdminTestUtils.remappingStaticTopicWithNegativeLogicOffset((String)topic, (Set)targetBrokers, (DefaultMQAdminExt)this.defaultMQAdminExt);
        Map remoteBrokerConfigMap = MQAdminUtils.examineTopicConfigAll((String)topic, (DefaultMQAdminExt)this.defaultMQAdminExt);
        TopicQueueMappingUtils.checkNameEpochNumConsistence((String)topic, (Map)remoteBrokerConfigMap);
        Map globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems(new ArrayList(TopicQueueMappingUtils.getMappingDetailFromConfig(remoteBrokerConfigMap.values())), (boolean)false, (boolean)true);
        Assert.assertEquals((long)queueNum, (long)globalIdMap.size());
        for (TopicQueueMappingOne mappingOne : globalIdMap.values()) {
            Assert.assertEquals((Object)BROKER2_NAME, (Object)mappingOne.getBname());
            Assert.assertEquals((long)-1L, (long)((LogicQueueMappingItem)mappingOne.getItems().get(mappingOne.getItems().size() - 1)).getLogicOffset());
        }
        this.awaitRefreshStaticTopicMetadata(3000L, topic, producer.getProducer(), null, this.defaultMQAdminExt);
        this.sendMessagesAndCheck(producer, (Set<String>)targetBrokers, topic, queueNum, msgEachQueue, 0L);
    }

    @After
    public void tearDown() {
        System.setProperty("rocketmq.client.rebalance.waitInterval", "20000");
        BaseConf.shutdown();
    }
}

