/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.schema;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.rocketmq.test.schema.SchemaDefiner;
import org.apache.rocketmq.test.schema.SchemaTools;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SchemaTest {
    private static final String BASE_SCHEMA_PATH = "src/test/resources/schema";
    private static final String ADD = "ADD";
    private static final String DELETE = "DELETE";
    private static final String CHANGE = "CHANGE";

    public void generate() throws Exception {
        SchemaDefiner.doLoad();
        SchemaTools.write((Map)SchemaTools.generate((List)SchemaDefiner.API_CLASS_LIST), (String)BASE_SCHEMA_PATH, (String)"api");
        SchemaTools.write((Map)SchemaTools.generate((List)SchemaDefiner.PROTOCOL_CLASS_LIST), (String)BASE_SCHEMA_PATH, (String)"protocol");
    }

    @Test
    @Ignore
    public void checkSchema() throws Exception {
        SchemaDefiner.doLoad();
        HashMap<String, Map> schemaFromFile = new HashMap<String, Map>();
        schemaFromFile.putAll(SchemaTools.load((String)BASE_SCHEMA_PATH, (String)"api"));
        schemaFromFile.putAll(SchemaTools.load((String)BASE_SCHEMA_PATH, (String)"protocol"));
        HashMap schemaFromCode = new HashMap();
        schemaFromCode.putAll(SchemaTools.generate((List)SchemaDefiner.API_CLASS_LIST));
        schemaFromCode.putAll(SchemaTools.generate((List)SchemaDefiner.PROTOCOL_CLASS_LIST));
        TreeMap<String, String> fileChanges = new TreeMap<String, String>();
        schemaFromFile.keySet().forEach(x -> {
            if (!schemaFromCode.containsKey(x)) {
                fileChanges.put((String)x, DELETE);
            }
        });
        schemaFromCode.keySet().forEach(x -> {
            if (!schemaFromFile.containsKey(x)) {
                fileChanges.put((String)x, ADD);
            }
        });
        HashMap<String, Map> changesByFile = new HashMap<String, Map>();
        schemaFromFile.forEach((file, oldSchema) -> {
            Map newSchema = (Map)schemaFromCode.get(file);
            TreeMap schemaChanges = new TreeMap();
            oldSchema.forEach((k, v) -> {
                if (!newSchema.containsKey(k)) {
                    schemaChanges.put(k, DELETE);
                } else if (!((String)newSchema.get(k)).equals(v)) {
                    schemaChanges.put(k, CHANGE);
                }
            });
            newSchema.forEach((k, v) -> {
                if (!oldSchema.containsKey(k)) {
                    schemaChanges.put(k, ADD);
                }
            });
            if (!schemaChanges.isEmpty()) {
                changesByFile.put((String)file, schemaChanges);
            }
        });
        fileChanges.forEach((k, v) -> System.out.printf("%s file %s\n", v, k));
        changesByFile.forEach((k, v) -> {
            System.out.printf("%s file %s:\n", CHANGE, k);
            v.forEach((kk, vv) -> System.out.printf("\t%s %s\n", vv, kk));
        });
        String message = "The schema test failed, which means you have changed the API or Protocol defined in org.apache.rocketmq.test.schema.SchemaDefiner.\nPlease submit a pr only contains the API/Protocol changes and request at least one PMC Member's review.\nFor original motivation of this test, please refer to https://github.com/apache/rocketmq/pull/4565 .";
        Assert.assertTrue((String)message, (fileChanges.isEmpty() && changesByFile.isEmpty() ? 1 : 0) != 0);
    }
}

