/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.route;

import java.util.List;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.util.MQAdminTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CreateAndUpdateTopicIT
extends BaseConf {
    @Test
    public void testCreateOrUpdateTopic_EnableSingleTopicRegistration() {
        String topic = "test-topic-without-broker-registration";
        brokerController1.getBrokerConfig().setEnableSingleTopicRegister(true);
        brokerController2.getBrokerConfig().setEnableSingleTopicRegister(true);
        brokerController3.getBrokerConfig().setEnableSingleTopicRegister(true);
        boolean createResult = MQAdminTestUtils.createTopic((String)NAMESRV_ADDR, (String)CLUSTER_NAME, (String)topic, (int)8, null);
        Assertions.assertThat((boolean)createResult).isTrue();
        TopicRouteData route = MQAdminTestUtils.examineTopicRouteInfo((String)NAMESRV_ADDR, (String)topic);
        Assertions.assertThat((List)route.getBrokerDatas()).hasSize(3);
        Assertions.assertThat((List)route.getQueueDatas()).hasSize(3);
        brokerController1.getBrokerConfig().setEnableSingleTopicRegister(false);
        brokerController2.getBrokerConfig().setEnableSingleTopicRegister(false);
        brokerController3.getBrokerConfig().setEnableSingleTopicRegister(false);
    }

    @Test
    public void testDeleteTopicFromNameSrvWithBrokerRegistration() {
        namesrvController.getNamesrvConfig().setDeleteTopicWithBrokerRegistration(true);
        brokerController1.getBrokerConfig().setEnableSingleTopicRegister(true);
        brokerController2.getBrokerConfig().setEnableSingleTopicRegister(true);
        brokerController3.getBrokerConfig().setEnableSingleTopicRegister(true);
        String testTopic1 = "test-topic-keep-route";
        String testTopic2 = "test-topic-delete-route";
        boolean createResult = MQAdminTestUtils.createTopic((String)NAMESRV_ADDR, (String)CLUSTER_NAME, (String)testTopic1, (int)8, null);
        Assertions.assertThat((boolean)createResult).isTrue();
        createResult = MQAdminTestUtils.createTopic((String)NAMESRV_ADDR, (String)CLUSTER_NAME, (String)testTopic2, (int)8, null);
        Assertions.assertThat((boolean)createResult).isTrue();
        TopicRouteData route = MQAdminTestUtils.examineTopicRouteInfo((String)NAMESRV_ADDR, (String)testTopic2);
        Assertions.assertThat((List)route.getBrokerDatas()).hasSize(3);
        MQAdminTestUtils.deleteTopicFromBrokerOnly((String)NAMESRV_ADDR, (String)BROKER1_NAME, (String)testTopic2);
        brokerController1.registerBrokerAll(false, false, true);
        route = MQAdminTestUtils.examineTopicRouteInfo((String)NAMESRV_ADDR, (String)testTopic2);
        Assertions.assertThat((List)route.getBrokerDatas()).hasSize(2);
        Assertions.assertThat((String)((QueueData)route.getQueueDatas().get(0)).getBrokerName()).isEqualTo(BROKER2_NAME);
        Assertions.assertThat((String)((QueueData)route.getQueueDatas().get(1)).getBrokerName()).isEqualTo(BROKER3_NAME);
        brokerController1.getBrokerConfig().setEnableSingleTopicRegister(false);
        brokerController2.getBrokerConfig().setEnableSingleTopicRegister(false);
        brokerController3.getBrokerConfig().setEnableSingleTopicRegister(false);
        namesrvController.getNamesrvConfig().setDeleteTopicWithBrokerRegistration(false);
    }

    @Test
    public void testStaticTopicNotAffected() throws Exception {
        namesrvController.getNamesrvConfig().setDeleteTopicWithBrokerRegistration(true);
        brokerController1.getBrokerConfig().setEnableSingleTopicRegister(true);
        brokerController2.getBrokerConfig().setEnableSingleTopicRegister(true);
        brokerController3.getBrokerConfig().setEnableSingleTopicRegister(true);
        String testTopic = "test-topic-not-affected";
        String testStaticTopic = "test-static-topic";
        boolean createResult = MQAdminTestUtils.createTopic((String)NAMESRV_ADDR, (String)CLUSTER_NAME, (String)testTopic, (int)8, null);
        Assertions.assertThat((boolean)createResult).isTrue();
        TopicRouteData route = MQAdminTestUtils.examineTopicRouteInfo((String)NAMESRV_ADDR, (String)testTopic);
        Assertions.assertThat((List)route.getBrokerDatas()).hasSize(3);
        Assertions.assertThat((List)route.getQueueDatas()).hasSize(3);
        MQAdminTestUtils.createStaticTopicWithCommand((String)testStaticTopic, (int)10, null, (String)CLUSTER_NAME, (String)NAMESRV_ADDR);
        Assertions.assertThat((List)route.getBrokerDatas()).hasSize(3);
        Assertions.assertThat((List)route.getQueueDatas()).hasSize(3);
        brokerController1.getBrokerConfig().setEnableSingleTopicRegister(false);
        brokerController2.getBrokerConfig().setEnableSingleTopicRegister(false);
        brokerController3.getBrokerConfig().setEnableSingleTopicRegister(false);
        namesrvController.getNamesrvConfig().setDeleteTopicWithBrokerRegistration(false);
    }

    @Test
    public void testCreateOrUpdateTopic_EnableSplitRegistration() {
        int i;
        brokerController1.getBrokerConfig().setEnableSplitRegistration(true);
        brokerController2.getBrokerConfig().setEnableSplitRegistration(true);
        brokerController3.getBrokerConfig().setEnableSplitRegistration(true);
        String testTopic = "test-topic-";
        for (i = 0; i < 10; ++i) {
            TopicConfig topicConfig = new TopicConfig(testTopic + i, 8, 8);
            brokerController1.getTopicConfigManager().updateTopicConfig(topicConfig);
            brokerController2.getTopicConfigManager().updateTopicConfig(topicConfig);
            brokerController3.getTopicConfigManager().updateTopicConfig(topicConfig);
        }
        brokerController1.registerBrokerAll(false, true, true);
        brokerController2.registerBrokerAll(false, true, true);
        brokerController3.registerBrokerAll(false, true, true);
        for (i = 0; i < 10; ++i) {
            TopicRouteData route = MQAdminTestUtils.examineTopicRouteInfo((String)NAMESRV_ADDR, (String)(testTopic + i));
            Assertions.assertThat((List)route.getBrokerDatas()).hasSize(3);
            Assertions.assertThat((List)route.getQueueDatas()).hasSize(3);
        }
        brokerController1.getBrokerConfig().setEnableSplitRegistration(false);
        brokerController2.getBrokerConfig().setEnableSplitRegistration(false);
        brokerController3.getBrokerConfig().setEnableSplitRegistration(false);
    }
}

