/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.lmq;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.PullCallback;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.MQClientAPIImpl;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPullConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.RebalanceImpl;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;
import org.apache.rocketmq.test.lmq.benchmark.BenchLmqStore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestBenchLmqStore {
    @Test
    public void test() throws MQBrokerException, RemotingException, InterruptedException, MQClientException {
        System.setProperty("sendThreadNum", "1");
        System.setProperty("pullConsumerNum", "1");
        System.setProperty("consumerThreadNum", "1");
        BenchLmqStore.defaultMQProducer = (DefaultMQProducer)Mockito.mock(DefaultMQProducer.class);
        SendResult sendResult = new SendResult();
        Mockito.when((Object)BenchLmqStore.defaultMQProducer.send((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)sendResult);
        BenchLmqStore.doSend();
        Thread.sleep(100L);
        BenchLmqStore.defaultMQPullConsumers = new DefaultMQPullConsumer[1];
        BenchLmqStore.defaultMQPullConsumers[0] = (DefaultMQPullConsumer)Mockito.mock(DefaultMQPullConsumer.class);
        BenchLmqStore.doPull(new ConcurrentHashMap(), (MessageQueue)new MessageQueue(), (Long)1L);
        ((DefaultMQPullConsumer)Mockito.verify((Object)BenchLmqStore.defaultMQPullConsumers[0], (VerificationMode)Mockito.atLeastOnce())).pullBlockIfNotFound((MessageQueue)ArgumentMatchers.any(MessageQueue.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), (PullCallback)ArgumentMatchers.any(PullCallback.class));
    }

    @Test
    public void testOffset() throws RemotingException, InterruptedException, MQClientException, MQBrokerException, IllegalAccessException {
        System.setProperty("sendThreadNum", "1");
        DefaultMQPullConsumer defaultMQPullConsumer = (DefaultMQPullConsumer)Mockito.mock(DefaultMQPullConsumer.class);
        BenchLmqStore.defaultMQPullConsumers = new DefaultMQPullConsumer[1];
        BenchLmqStore.defaultMQPullConsumers[0] = defaultMQPullConsumer;
        DefaultMQPullConsumerImpl defaultMQPullConsumerImpl = (DefaultMQPullConsumerImpl)Mockito.mock(DefaultMQPullConsumerImpl.class);
        Mockito.when((Object)defaultMQPullConsumer.getDefaultMQPullConsumerImpl()).thenReturn((Object)defaultMQPullConsumerImpl);
        RebalanceImpl rebalanceImpl = (RebalanceImpl)Mockito.mock(RebalanceImpl.class);
        Mockito.when((Object)defaultMQPullConsumerImpl.getRebalanceImpl()).thenReturn((Object)rebalanceImpl);
        MQClientInstance mqClientInstance = (MQClientInstance)Mockito.mock(MQClientInstance.class);
        Mockito.when((Object)rebalanceImpl.getmQClientFactory()).thenReturn((Object)mqClientInstance);
        MQClientAPIImpl mqClientAPI = (MQClientAPIImpl)Mockito.mock(MQClientAPIImpl.class);
        Mockito.when((Object)mqClientInstance.getMQClientAPIImpl()).thenReturn((Object)mqClientAPI);
        TopicRouteData topicRouteData = new TopicRouteData();
        HashMap<Long, String> brokerAddrs = new HashMap<Long, String>();
        brokerAddrs.put(0L, "test");
        List<BrokerData> brokerData = Collections.singletonList(new BrokerData("test", "test", brokerAddrs));
        topicRouteData.setBrokerDatas(brokerData);
        FieldUtils.writeStaticField(BenchLmqStore.class, (String)"lmqTopic", (Object)"test", (boolean)true);
        Mockito.when((Object)mqClientAPI.getTopicRouteInfoFromNameServer(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong())).thenReturn((Object)topicRouteData);
        BenchLmqStore.doBenchOffset();
        Thread.sleep(100L);
        ((MQClientAPIImpl)Mockito.verify((Object)mqClientAPI, (VerificationMode)Mockito.atLeastOnce())).queryConsumerOffset(ArgumentMatchers.anyString(), (QueryConsumerOffsetRequestHeader)ArgumentMatchers.any(QueryConsumerOffsetRequestHeader.class), ArgumentMatchers.anyLong());
        ((MQClientAPIImpl)Mockito.verify((Object)mqClientAPI, (VerificationMode)Mockito.atLeastOnce())).updateConsumerOffset(ArgumentMatchers.anyString(), (UpdateConsumerOffsetRequestHeader)ArgumentMatchers.any(UpdateConsumerOffsetRequestHeader.class), ArgumentMatchers.anyLong());
    }
}

