/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.grpc.v2;

import apache.rocketmq.v2.MessagingServiceGrpc;
import apache.rocketmq.v2.QueryRouteResponse;
import java.time.Duration;
import java.util.Map;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.grpc.v2.GrpcMessagingApplication;
import org.apache.rocketmq.proxy.processor.DefaultMessagingProcessor;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.test.grpc.v2.GrpcBaseIT;
import org.apache.rocketmq.test.util.MQAdminTestUtils;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ClusterGrpcIT
extends GrpcBaseIT {
    private MessagingProcessor messagingProcessor;
    private GrpcMessagingApplication grpcMessagingApplication;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ConfigurationManager.getProxyConfig().setTransactionHeartbeatPeriodSecond(3);
        this.messagingProcessor = DefaultMessagingProcessor.createForClusterMode();
        this.messagingProcessor.start();
        this.grpcMessagingApplication = GrpcMessagingApplication.create((MessagingProcessor)this.messagingProcessor);
        this.grpcMessagingApplication.start();
        this.setUpServer((MessagingServiceGrpc.MessagingServiceImplBase)this.grpcMessagingApplication, 0, true);
        Awaitility.await().atMost(Duration.ofSeconds(40L)).until(() -> {
            Map brokerDataMap = MQAdminTestUtils.getCluster((String)NAMESRV_ADDR).getBrokerAddrTable();
            return brokerDataMap.size() == 3;
        });
    }

    @After
    public void tearDown() throws Exception {
        this.messagingProcessor.shutdown();
        this.grpcMessagingApplication.shutdown();
        ClusterGrpcIT.shutdown();
    }

    @Test
    public void testQueryRoute() throws Exception {
        String topic = ClusterGrpcIT.initTopic();
        QueryRouteResponse response = this.blockingStub.queryRoute(this.buildQueryRouteRequest(topic));
        this.assertQueryRoute(response, 24);
    }

    @Override
    @Test
    public void testQueryAssignment() throws Exception {
        super.testQueryAssignment();
    }

    @Override
    @Test
    public void testQueryFifoAssignment() throws Exception {
        super.testQueryFifoAssignment();
    }

    @Override
    @Test
    public void testTransactionCheckThenCommit() {
        super.testTransactionCheckThenCommit();
    }

    @Override
    @Test
    public void testSimpleConsumerSendAndRecvDelayMessage() throws Exception {
        super.testSimpleConsumerSendAndRecvDelayMessage();
    }

    @Override
    @Test
    public void testSimpleConsumerSendAndRecvBigMessage() throws Exception {
        super.testSimpleConsumerSendAndRecvBigMessage();
    }

    @Override
    @Test
    public void testSimpleConsumerSendAndRecv() throws Exception {
        super.testSimpleConsumerSendAndRecv();
    }

    @Override
    @Test
    public void testSimpleConsumerToDLQ() throws Exception {
        super.testSimpleConsumerToDLQ();
    }

    @Override
    @Test
    public void testConsumeOrderly() throws Exception {
        super.testConsumeOrderly();
    }
}

