/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.container;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.remoting.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.test.container.ContainerIntegrationTestBase;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class SlaveBrokerIT
extends ContainerIntegrationTestBase {
    @Test
    public void reAddSlaveBroker() throws Exception {
        Awaitility.await().atMost(Duration.ofMinutes(1L)).until(() -> {
            ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
            if (((Set)clusterInfo.getClusterAddrTable().get(master1With3Replicas.getBrokerConfig().getBrokerClusterName())).size() != 3) {
                return false;
            }
            if (((BrokerData)clusterInfo.getBrokerAddrTable().get(master1With3Replicas.getBrokerConfig().getBrokerName())).getBrokerAddrs().size() != 3) {
                return false;
            }
            if (((BrokerData)clusterInfo.getBrokerAddrTable().get(master2With3Replicas.getBrokerConfig().getBrokerName())).getBrokerAddrs().size() != 3) {
                return false;
            }
            if (((BrokerData)clusterInfo.getBrokerAddrTable().get(master3With3Replicas.getBrokerConfig().getBrokerName())).getBrokerAddrs().size() != 3) {
                return false;
            }
            return true;
        });
        SlaveBrokerIT.removeSlaveBroker(1, brokerContainer1, master3With3Replicas);
        SlaveBrokerIT.removeSlaveBroker(1, brokerContainer2, master1With3Replicas);
        SlaveBrokerIT.removeSlaveBroker(1, brokerContainer3, master2With3Replicas);
        Awaitility.await().atMost(Duration.ofMinutes(1L)).until(() -> {
            ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
            Assertions.assertThat((int)((BrokerData)clusterInfo.getBrokerAddrTable().get(master1With3Replicas.getBrokerConfig().getBrokerName())).getBrokerAddrs().size()).isEqualTo(2);
            Assertions.assertThat((int)((BrokerData)clusterInfo.getBrokerAddrTable().get(master2With3Replicas.getBrokerConfig().getBrokerName())).getBrokerAddrs().size()).isEqualTo(2);
            Assertions.assertThat((int)((BrokerData)clusterInfo.getBrokerAddrTable().get(master3With3Replicas.getBrokerConfig().getBrokerName())).getBrokerAddrs().size()).isEqualTo(2);
            return true;
        });
        SlaveBrokerIT.createAndAddSlave(1, brokerContainer1, master3With3Replicas);
        SlaveBrokerIT.createAndAddSlave(1, brokerContainer2, master1With3Replicas);
        SlaveBrokerIT.createAndAddSlave(1, brokerContainer3, master2With3Replicas);
        Awaitility.await().atMost(Duration.ofMinutes(1L)).until(() -> {
            ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
            return ((BrokerData)clusterInfo.getBrokerAddrTable().get(master1With3Replicas.getBrokerConfig().getBrokerName())).getBrokerAddrs().size() == 3 && ((BrokerData)clusterInfo.getBrokerAddrTable().get(master2With3Replicas.getBrokerConfig().getBrokerName())).getBrokerAddrs().size() == 3 && ((BrokerData)clusterInfo.getBrokerAddrTable().get(master2With3Replicas.getBrokerConfig().getBrokerName())).getBrokerAddrs().size() == 3;
        });
    }

    @Test
    public void reAddSlaveBroker_ConnectionCheck() throws Exception {
        Awaitility.await().atMost(100L, TimeUnit.SECONDS).until(() -> ((DefaultMessageStore)master3With3Replicas.getMessageStore()).getHaService().getConnectionCount().get() == 2);
        SlaveBrokerIT.removeSlaveBroker(1, brokerContainer1, master3With3Replicas);
        SlaveBrokerIT.createAndAddSlave(1, brokerContainer1, master3With3Replicas);
        Awaitility.await().atMost(100L, TimeUnit.SECONDS).until(() -> ((DefaultMessageStore)master3With3Replicas.getMessageStore()).getHaService().getConnectionCount().get() == 2);
        Awaitility.await().atMost(100L, TimeUnit.SECONDS).until(() -> ((DefaultMessageStore)master3With3Replicas.getMessageStore()).getHaService().inSyncReplicasNums(0L) == 3);
        Thread.sleep(101000L);
    }
}

