/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.container;

import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.container.InnerSalveBrokerController;
import org.apache.rocketmq.test.container.ContainerIntegrationTestBase;
import org.awaitility.Awaitility;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class PushMultipleReplicasIT
extends ContainerIntegrationTestBase {
    private static DefaultMQProducer producer;
    private static final String TOPIC;
    private static final String REDIRECT_TOPIC;
    private static final String CONSUMER_GROUP;
    private static final int MESSAGE_COUNT = 32;

    @BeforeClass
    public static void beforeClass() throws Throwable {
        PushMultipleReplicasIT.createTopicTo(master1With3Replicas, TOPIC, 1, 1);
        producer = PushMultipleReplicasIT.createProducer(PushMultipleReplicasIT.class.getSimpleName() + "_PRODUCER");
        producer.setSendMsgTimeout(15000);
        producer.start();
        for (int i = 0; i < 32; ++i) {
            producer.send(new Message(TOPIC, Integer.toString(i).getBytes()));
        }
        PushMultipleReplicasIT.createTopicTo(master3With3Replicas, REDIRECT_TOPIC, 1, 1);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        producer.shutdown();
    }

    @Test
    public void consumeMessageFromSlave_PushConsumer() throws MQClientException {
        Awaitility.await().atMost(Duration.ofMinutes(1L)).until(() -> {
            InnerSalveBrokerController slaveBroker = (InnerSalveBrokerController)brokerContainer2.getSlaveBrokers().iterator().next();
            return slaveBroker.getTopicConfigManager().selectTopicConfig(TOPIC) != null;
        });
        PushMultipleReplicasIT.isolateBroker(master1With3Replicas);
        DefaultMQPushConsumer pushConsumer = PushMultipleReplicasIT.createPushConsumer(CONSUMER_GROUP);
        pushConsumer.subscribe(TOPIC, "*");
        pushConsumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        AtomicInteger receivedMsgCount = new AtomicInteger(0);
        pushConsumer.registerMessageListener((msgs, context) -> {
            receivedMsgCount.addAndGet(msgs.size());
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        });
        pushConsumer.start();
        Awaitility.await().atMost(Duration.ofMinutes(5L)).until(() -> receivedMsgCount.get() >= 32);
        Awaitility.await().atMost(Duration.ofMinutes(1L)).until(() -> {
            pushConsumer.getDefaultMQPushConsumerImpl().persistConsumerOffset();
            Map slaveOffsetTable = null;
            for (InnerSalveBrokerController slave : brokerContainer2.getSlaveBrokers()) {
                if (!slave.getBrokerConfig().getBrokerName().equals(master1With3Replicas.getBrokerConfig().getBrokerName())) continue;
                slaveOffsetTable = slave.getConsumerOffsetManager().queryOffset(CONSUMER_GROUP, TOPIC);
            }
            if (slaveOffsetTable != null) {
                long totalOffset = 0L;
                for (Long offset : slaveOffsetTable.values()) {
                    totalOffset += offset.longValue();
                }
                return totalOffset >= 32L;
            }
            return false;
        });
        pushConsumer.shutdown();
        PushMultipleReplicasIT.cancelIsolatedBroker(master1With3Replicas);
        PushMultipleReplicasIT.awaitUntilSlaveOK();
    }

    static {
        TOPIC = PushMultipleReplicasIT.class.getSimpleName() + "_TOPIC";
        REDIRECT_TOPIC = PushMultipleReplicasIT.class.getSimpleName() + "_REDIRECT_TOPIC";
        CONSUMER_GROUP = PushMultipleReplicasIT.class.getSimpleName() + "_Consumer";
    }
}

