/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.container;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.test.container.ContainerIntegrationTestBase;
import org.assertj.core.api.Java6Assertions;
import org.awaitility.Awaitility;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class GetMaxOffsetFromSlaveIT
extends ContainerIntegrationTestBase {
    private static DefaultMQProducer mqProducer;
    private static final String MSG = "Hello RocketMQ ";
    private static final byte[] MESSAGE_BODY;

    @BeforeClass
    public static void beforeClass() throws MQClientException {
        mqProducer = GetMaxOffsetFromSlaveIT.createProducer(GetMaxOffsetFromSlaveIT.class.getSimpleName() + "_Producer");
        mqProducer.start();
    }

    @AfterClass
    public static void afterClass() {
        if (mqProducer != null) {
            mqProducer.shutdown();
        }
    }

    @Test
    public void testGetMaxOffsetFromSlave() throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        GetMaxOffsetFromSlaveIT.awaitUntilSlaveOK();
        mqProducer.getDefaultMQProducerImpl().getmQClientFactory().updateTopicRouteInfoFromNameServer("SEND_MESSAGE_TEST_TOPIC_THREE_REPLICAS");
        for (int i = 0; i < 100; ++i) {
            Message msg = new Message("SEND_MESSAGE_TEST_TOPIC_THREE_REPLICAS", MESSAGE_BODY);
            SendResult sendResult = mqProducer.send(msg, 10000L);
            Java6Assertions.assertThat((Comparable)sendResult.getSendStatus()).isEqualTo((Object)SendStatus.SEND_OK);
        }
        HashMap<Integer, Long> maxOffsetMap = new HashMap<Integer, Long>();
        TopicPublishInfo publishInfo = (TopicPublishInfo)mqProducer.getDefaultMQProducerImpl().getTopicPublishInfoTable().get("SEND_MESSAGE_TEST_TOPIC_THREE_REPLICAS");
        Java6Assertions.assertThat((Object)publishInfo).isNotNull();
        for (MessageQueue mq : publishInfo.getMessageQueueList()) {
            maxOffsetMap.put(mq.getQueueId(), mqProducer.getDefaultMQProducerImpl().maxOffset(new MessageQueue("SEND_MESSAGE_TEST_TOPIC_THREE_REPLICAS", master3With3Replicas.getBrokerConfig().getBrokerName(), mq.getQueueId())));
        }
        GetMaxOffsetFromSlaveIT.isolateBroker(master3With3Replicas);
        mqProducer.getDefaultMQProducerImpl().getmQClientFactory().updateTopicRouteInfoFromNameServer("SEND_MESSAGE_TEST_TOPIC_THREE_REPLICAS");
        Java6Assertions.assertThat((String)mqProducer.getDefaultMQProducerImpl().getmQClientFactory().findBrokerAddressInPublish(master3With3Replicas.getBrokerConfig().getBrokerName())).isNotNull();
        for (MessageQueue mq : publishInfo.getMessageQueueList()) {
            Java6Assertions.assertThat((long)mqProducer.getDefaultMQProducerImpl().maxOffset(new MessageQueue("SEND_MESSAGE_TEST_TOPIC_THREE_REPLICAS", master3With3Replicas.getBrokerConfig().getBrokerName(), mq.getQueueId()))).isEqualTo(maxOffsetMap.get(mq.getQueueId()));
        }
        GetMaxOffsetFromSlaveIT.cancelIsolatedBroker(master3With3Replicas);
        Awaitility.await().atMost(100L, TimeUnit.SECONDS).until(() -> ((DefaultMessageStore)master3With3Replicas.getMessageStore()).getHaService().getConnectionCount().get() == 2);
    }

    static {
        MESSAGE_BODY = MSG.getBytes(StandardCharsets.UTF_8);
    }
}

