/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.container;

import java.time.Duration;
import org.apache.rocketmq.container.InnerSalveBrokerController;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.test.container.ContainerIntegrationTestBase;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class BrokerFailoverIT
extends ContainerIntegrationTestBase {
    @Test
    public void testBrokerFailoverWithoutCompatible() {
        BrokerFailoverIT.changeCompatibleMode(false);
        BrokerFailoverIT.awaitUntilSlaveOK();
        this.testBrokerFailover(false);
    }

    @Test
    public void testBrokerFailoverWithCompatible() {
        BrokerFailoverIT.changeCompatibleMode(true);
        BrokerFailoverIT.awaitUntilSlaveOK();
        this.testBrokerFailover(true);
    }

    private void testBrokerFailover(final boolean compatibleMode) {
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> master1With3Replicas.getMessageStore().getAliveReplicaNumInGroup() == 3 && master2With3Replicas.getMessageStore().getAliveReplicaNumInGroup() == 3 && master3With3Replicas.getMessageStore().getAliveReplicaNumInGroup() == 3);
        InnerSalveBrokerController targetSlave = BrokerFailoverIT.getSlaveFromContainerByName(brokerContainer2, master1With3Replicas.getBrokerConfig().getBrokerName());
        Assertions.assertThat((Object)targetSlave).isNotNull();
        brokerContainer1.registerClientRPCHook(new RPCHook(){

            public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
                if (request.getCode() == (compatibleMode ? 322 : 904)) {
                    request.setCode(-1);
                }
            }

            public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {
            }
        });
        InnerSalveBrokerController finalTargetSlave = targetSlave;
        Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> finalTargetSlave.getMessageStore().getAliveReplicaNumInGroup() == 2 && master2With3Replicas.getMessageStore().getAliveReplicaNumInGroup() == 2 && master3With3Replicas.getMessageStore().getAliveReplicaNumInGroup() == 2);
        brokerContainer1.clearClientRPCHook();
        Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> master1With3Replicas.getMessageStore().getAliveReplicaNumInGroup() == 3 && master2With3Replicas.getMessageStore().getAliveReplicaNumInGroup() == 3 && master3With3Replicas.getMessageStore().getAliveReplicaNumInGroup() == 3);
    }
}

