/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.transaction;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQTransactionalProducer;
import org.apache.rocketmq.test.factory.MQMessageFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.MQWait;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TransactionalMsgIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(TransactionalMsgIT.class);
    private RMQTransactionalProducer producer = null;
    private RMQNormalConsumer consumer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = TransactionalMsgIT.initTopic();
        logger.info(String.format("use topic: %s;", this.topic));
        this.producer = TransactionalMsgIT.getTransactionalProducer(NAMESRV_ADDR, this.topic, new TransactionListenerImpl());
        this.consumer = TransactionalMsgIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQNormalListener());
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testMessageVisibility() throws Exception {
        Thread.sleep(3000L);
        int msgSize = 120;
        List msgs = MQMessageFactory.getMsg((String)this.topic, (int)msgSize);
        for (int i = 0; i < msgSize; ++i) {
            this.producer.send(msgs.get(i), TransactionalMsgIT.getTransactionHandle(i));
        }
        boolean recvAll = MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{this.consumer.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
    }

    static Pair<Boolean, LocalTransactionState> getTransactionHandle(int msgIndex) {
        switch (msgIndex % 5) {
            case 0: {
                return new Pair((Object)true, (Object)LocalTransactionState.COMMIT_MESSAGE);
            }
            case 1: {
                return new Pair((Object)true, (Object)LocalTransactionState.ROLLBACK_MESSAGE);
            }
            case 2: {
                return new Pair((Object)false, (Object)LocalTransactionState.COMMIT_MESSAGE);
            }
            case 3: {
                return new Pair((Object)false, (Object)LocalTransactionState.ROLLBACK_MESSAGE);
            }
        }
        return new Pair((Object)false, (Object)LocalTransactionState.UNKNOW);
    }

    private static class TransactionListenerImpl
    implements TransactionListener {
        ConcurrentHashMap<String, LocalTransactionState> checkStatus = new ConcurrentHashMap();

        private TransactionListenerImpl() {
        }

        public LocalTransactionState executeLocalTransaction(Message msg, Object arg) {
            Pair transactionHandle = (Pair)arg;
            if (((Boolean)transactionHandle.getObject1()).booleanValue()) {
                return (LocalTransactionState)transactionHandle.getObject2();
            }
            this.checkStatus.put(msg.getTransactionId(), (LocalTransactionState)transactionHandle.getObject2());
            return LocalTransactionState.UNKNOW;
        }

        public LocalTransactionState checkLocalTransaction(MessageExt msg) {
            LocalTransactionState state = this.checkStatus.get(msg.getTransactionId());
            if (state == null) {
                return LocalTransactionState.UNKNOW;
            }
            return state;
        }
    }
}

