/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.querymsg;

import com.google.common.truth.Truth;
import java.util.List;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.factory.MQMessageFactory;
import org.apache.rocketmq.test.util.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryMsgByKeyIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(QueryMsgByKeyIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = QueryMsgByKeyIT.initTopic();
        logger.info(String.format("use topic: %s;", this.topic));
        this.producer = QueryMsgByKeyIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        QueryMsgByKeyIT.shutdown();
    }

    @Test
    public void testQueryMsg() {
        int msgSize = 20;
        String key = "jueyin";
        long begin = System.currentTimeMillis();
        List msgs = MQMessageFactory.getKeyMsg((String)this.topic, (String)key, (int)msgSize);
        this.producer.send(msgs);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        List queryMsgs = null;
        try {
            TestUtils.waitForMoment((long)1500L);
            queryMsgs = this.producer.getProducer().queryMessage(this.topic, key, msgSize, begin - 5000L, System.currentTimeMillis() + 5000L).getMessageList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Truth.assertThat(queryMsgs).isNotNull();
        Truth.assertThat((Integer)queryMsgs.size()).isEqualTo((Object)msgSize);
    }

    @Test
    public void testQueryMax() {
        int msgSize = 500;
        int max = 192;
        String key = "jueyin";
        long begin = System.currentTimeMillis();
        List msgs = MQMessageFactory.getKeyMsg((String)this.topic, (String)key, (int)msgSize);
        this.producer.send(msgs);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        List queryMsgs = null;
        try {
            queryMsgs = this.producer.getProducer().queryMessage(this.topic, key, msgSize, begin - 15000L, System.currentTimeMillis() + 15000L).getMessageList();
            int i = 3;
            while (queryMsgs == null || queryMsgs.size() != 3) {
                queryMsgs = this.producer.getProducer().queryMessage(this.topic, key, msgSize, begin - 15000L, System.currentTimeMillis() + 15000L).getMessageList();
                TestUtils.waitForMoment((long)1000L);
                if (--i != 0 && (queryMsgs == null || queryMsgs.size() != max)) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Truth.assertThat(queryMsgs).isNotNull();
        Truth.assertThat((Integer)queryMsgs.size()).isEqualTo((Object)max);
    }

    @Test(expected=MQClientException.class)
    public void testQueryMsgWithSameHash1() throws Exception {
        int msgSize = 1;
        String topicA = "AaTopic";
        String keyA = "Aa";
        String topicB = "BBTopic";
        String keyB = "BB";
        QueryMsgByKeyIT.initTopicWithName(topicA);
        QueryMsgByKeyIT.initTopicWithName(topicB);
        RMQNormalProducer producerA = QueryMsgByKeyIT.getProducer(NAMESRV_ADDR, topicA);
        RMQNormalProducer producerB = QueryMsgByKeyIT.getProducer(NAMESRV_ADDR, topicB);
        List msgA = MQMessageFactory.getKeyMsg((String)topicA, (String)keyA, (int)msgSize);
        List msgB = MQMessageFactory.getKeyMsg((String)topicB, (String)keyB, (int)msgSize);
        producerA.send(msgA);
        producerB.send(msgB);
        long begin = System.currentTimeMillis() - 500000L;
        long end = System.currentTimeMillis() + 500000L;
        producerA.getProducer().queryMessage(topicA, keyB, msgSize * 10, begin, end).getMessageList();
    }

    @Test
    public void testQueryMsgWithSameHash2() throws Exception {
        int msgSize = 1;
        String topicA = "AaAaTopic";
        String keyA = "Aa";
        String topicB = "BBBBTopic";
        String keyB = "Aa";
        QueryMsgByKeyIT.initTopicWithName(topicA);
        QueryMsgByKeyIT.initTopicWithName(topicB);
        RMQNormalProducer producerA = QueryMsgByKeyIT.getProducer(NAMESRV_ADDR, topicA);
        RMQNormalProducer producerB = QueryMsgByKeyIT.getProducer(NAMESRV_ADDR, topicB);
        List msgA = MQMessageFactory.getKeyMsg((String)topicA, (String)keyA, (int)msgSize);
        List msgB = MQMessageFactory.getKeyMsg((String)topicB, (String)keyB, (int)msgSize);
        producerA.send(msgA);
        producerB.send(msgB);
        long begin = System.currentTimeMillis() - 500000L;
        long end = System.currentTimeMillis() + 500000L;
        List list = producerA.getProducer().queryMessage(topicA, keyA, msgSize * 10, begin, end).getMessageList();
        Truth.assertThat((Iterable)list).isNotNull();
        Truth.assertThat((Integer)list.size()).isEqualTo((Object)1);
    }
}

