/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.querymsg;

import com.google.common.truth.Truth;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.producer.querymsg.QueryMsgByKeyIT;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryMsgByIdExceptionIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(QueryMsgByKeyIT.class);
    private static RMQNormalProducer producer = null;
    private static String topic = null;

    @BeforeClass
    public static void setUp() {
        topic = QueryMsgByIdExceptionIT.initTopic();
        logger.info(String.format("use topic: %s;", topic));
        producer = QueryMsgByIdExceptionIT.getProducer(NAMESRV_ADDR, topic);
    }

    @AfterClass
    public static void tearDown() {
        QueryMsgByIdExceptionIT.shutdown();
    }

    @Test
    public void testQueryMsgByErrorMsgId() {
        producer.clearMsg();
        int msgSize = 20;
        String errorMsgId = "errorMsgId";
        producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)producer.getAllUndupMsgBody().size());
        MessageExt queryMsg = null;
        try {
            queryMsg = producer.getProducer().viewMessage(errorMsgId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Truth.assertThat(queryMsg).isNull();
    }

    @Test
    public void testQueryMsgByNullMsgId() {
        producer.clearMsg();
        int msgSize = 20;
        String errorMsgId = null;
        producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)producer.getAllUndupMsgBody().size());
        MessageExt queryMsg = null;
        try {
            queryMsg = producer.getProducer().viewMessage(errorMsgId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Truth.assertThat(queryMsg).isNull();
    }
}

