/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.order;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.order.RMQOrderListener;
import org.apache.rocketmq.test.message.MessageQueueMsg;
import org.apache.rocketmq.test.util.MQWait;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OrderMsgRebalanceIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(OrderMsgRebalanceIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = OrderMsgRebalanceIT.initTopic();
        logger.info(String.format("use topic: %s !", this.topic));
        this.producer = OrderMsgRebalanceIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testTwoConsumersBalance() {
        int msgSize = 10;
        RMQNormalConsumer consumer1 = OrderMsgRebalanceIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQOrderListener());
        RMQNormalConsumer consumer2 = OrderMsgRebalanceIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQOrderListener());
        TestUtils.waitForSeconds((long)5L);
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        boolean recvAll = MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        boolean balance = VerifyUtils.verifyBalance((int)this.producer.getAllMsgBody().size(), (int[])new int[]{VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllUndupMsgBody()).size(), VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllUndupMsgBody()).size()});
        Truth.assertThat((Boolean)balance).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer1.getListener()).getMsgs())).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer2.getListener()).getMsgs())).isEqualTo((Object)true);
    }

    @Test
    public void testFourConsumerBalance() {
        int msgSize = 20;
        RMQNormalConsumer consumer1 = OrderMsgRebalanceIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQOrderListener());
        RMQNormalConsumer consumer2 = OrderMsgRebalanceIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQOrderListener());
        RMQNormalConsumer consumer3 = OrderMsgRebalanceIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQOrderListener());
        RMQNormalConsumer consumer4 = OrderMsgRebalanceIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQOrderListener());
        TestUtils.waitForSeconds((long)5L);
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        boolean recvAll = MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener(), consumer3.getListener(), consumer4.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        boolean balance = VerifyUtils.verifyBalance((int)this.producer.getAllMsgBody().size(), (int[])new int[]{VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllUndupMsgBody()).size(), VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllUndupMsgBody()).size(), VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer3.getListener().getAllUndupMsgBody()).size(), VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer4.getListener().getAllUndupMsgBody()).size()});
        logger.info(String.format("consumer1:%s;consumer2:%s;consumer3:%s,consumer4:%s", consumer1.getListener().getAllMsgBody().size(), consumer2.getListener().getAllMsgBody().size(), consumer3.getListener().getAllMsgBody().size(), consumer4.getListener().getAllMsgBody().size()));
        Truth.assertThat((Boolean)balance).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer1.getListener()).getMsgs())).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer2.getListener()).getMsgs())).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer3.getListener()).getMsgs())).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer4.getListener()).getMsgs())).isEqualTo((Object)true);
    }
}

