/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.order;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.balance.NormalMsgStaticBalanceIT;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.order.RMQOrderListener;
import org.apache.rocketmq.test.message.MessageQueueMsg;
import org.apache.rocketmq.test.util.MQWait;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OrderMsgDynamicRebalanceIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(NormalMsgStaticBalanceIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = OrderMsgDynamicRebalanceIT.initTopic();
        logger.info(String.format("use topic: %s !", this.topic));
        this.producer = OrderMsgDynamicRebalanceIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testTwoConsumerAndCrashOne() {
        int msgSize = 10;
        RMQNormalConsumer consumer1 = OrderMsgDynamicRebalanceIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQOrderListener("1"));
        RMQNormalConsumer consumer2 = OrderMsgDynamicRebalanceIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQOrderListener("2"));
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        MQWait.waitConsumeAll((int)30000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        consumer2.shutdown();
        mqMsgs = new MessageQueueMsg(mqs, msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        boolean recvAll = MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer1.getListener()).getMsgs())).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer2.getListener()).getMsgs())).isEqualTo((Object)true);
    }

    @Test
    public void testThreeConsumerAndCrashOne() {
        int msgSize = 10;
        RMQNormalConsumer consumer1 = OrderMsgDynamicRebalanceIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQOrderListener("1"));
        RMQNormalConsumer consumer2 = OrderMsgDynamicRebalanceIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQOrderListener("2"));
        RMQNormalConsumer consumer3 = OrderMsgDynamicRebalanceIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQOrderListener("3"));
        List mqs = this.producer.getMessageQueue();
        MessageQueueMsg mqMsgs = new MessageQueueMsg(mqs, msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener(), consumer3.getListener()});
        consumer3.shutdown();
        mqMsgs = new MessageQueueMsg(mqs, msgSize);
        this.producer.send(mqMsgs.getMsgsWithMQ());
        boolean recvAll = MQWait.waitConsumeAll((int)30000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener(), consumer3.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer1.getListener()).getMsgs())).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer2.getListener()).getMsgs())).isEqualTo((Object)true);
        Truth.assertThat((Boolean)VerifyUtils.verifyOrder((Collection)((RMQOrderListener)consumer3.getListener()).getMsgs())).isEqualTo((Object)true);
    }
}

